/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.ejb;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EntityBean;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import oracle.toplink.ejb.EJBWrapperPolicy;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.OptimisticLockException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.localization.ExceptionLocalization;
import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.Call;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ReadAllQuery;
import oracle.toplink.queryframework.ReadObjectQuery;
import oracle.toplink.tools.sessionconfiguration.XMLSessionConfigLoader;
import oracle.toplink.tools.sessionmanagement.SessionManager;

public class EJBDataStore {
    protected Class beanClass;
    protected String sessionName = "default";
    protected XMLSessionConfigLoader xmlSessionConfigLoader;
    protected Session session;
    protected Descriptor descriptor;

    public Object create(Object object) throws CreateException {
        try {
            UnitOfWork unitOfWork = this.getActiveUnitOfWork();
            if (unitOfWork == null) {
                throw ValidationException.ejbMustBeInTransaction(object);
            }
            unitOfWork.log(1, "ejb", "EJB_create", object);
            unitOfWork.assignSequenceNumber(object);
            if (unitOfWork.checkExistence(object) != null) {
                throw new DuplicateKeyException();
            }
            unitOfWork.registerNewContainerBean(object);
        }
        catch (Exception exception) {
            throw new CreateException(ExceptionLocalization.buildMessage("create_insertion_failed", null) + "\n" + Helper.printStackTraceToString(exception));
        }
        return this.getWrapperPolicy().buildPrimaryKeyFromBean(object, this.getSession());
    }

    public Object create(EntityBean entityBean) throws CreateException {
        return this.create((Object)entityBean);
    }

    public Vector extractPrimaryKeyVector(Vector vector) {
        Vector<Object> vector2 = new Vector<Object>(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            vector2.addElement(this.getWrapperPolicy().buildPrimaryKeyFromBean(enumeration.nextElement(), this.getSession()));
        }
        return vector2;
    }

    public Enumeration findAll() throws FinderException {
        return this.findAll(new ReadAllQuery(this.getBeanClass()));
    }

    public Collection ejb20FindAll() throws FinderException {
        return this.ejb20FindAll(new ReadAllQuery(this.getBeanClass()));
    }

    public Enumeration findAll(Expression expression) throws FinderException {
        return this.findAll(new ReadAllQuery(this.getBeanClass(), expression));
    }

    public Collection ejb20FindAll(Expression expression) throws FinderException {
        return this.ejb20FindAll(new ReadAllQuery(this.getBeanClass(), expression));
    }

    public Enumeration findAll(Call call) throws FinderException {
        return this.findAll(new ReadAllQuery(this.getBeanClass(), call));
    }

    public Collection ejb20FindAll(Call call) throws FinderException {
        return this.ejb20FindAll(new ReadAllQuery(this.getBeanClass(), call));
    }

    public Enumeration findAll(ReadAllQuery readAllQuery) throws FinderException {
        return this.extractPrimaryKeyVector(this.findAllObjects(readAllQuery)).elements();
    }

    public Collection ejb20FindAll(ReadAllQuery readAllQuery) throws FinderException {
        return this.extractPrimaryKeyVector(this.findAllObjects(readAllQuery));
    }

    public Enumeration findAllByNamedQuery(String string, Vector vector) throws FinderException {
        return this.extractPrimaryKeyVector(this.findAllObjectsByNamedQuery(string, vector)).elements();
    }

    public Collection ejb20FindAllByNamedQuery(String string, Vector vector) throws FinderException {
        return this.extractPrimaryKeyVector(this.findAllObjectsByNamedQuery(string, vector));
    }

    public Vector findAllObjects(ReadAllQuery readAllQuery) throws FinderException {
        Session session = this.getActiveSession();
        session.log(1, "ejb", "EJB_find_all", readAllQuery);
        readAllQuery.setReferenceClass(this.getBeanClass());
        readAllQuery.setDescriptor(this.getDescriptor());
        readAllQuery.setShouldUseWrapperPolicy(false);
        Vector vector = null;
        try {
            vector = (Vector)session.executeQuery(readAllQuery);
        }
        catch (Exception exception) {
            throw new FinderException(ExceptionLocalization.buildMessage("finder_query_failed", null) + "\n" + Helper.printStackTraceToString(exception));
        }
        return vector;
    }

    public Vector findAllObjectsByNamedQuery(String string, Vector vector) throws FinderException {
        Session session = this.getActiveSession();
        session.log(1, "ejb", "EJB_find_all_by_name", string);
        Vector vector2 = null;
        try {
            vector2 = (Vector)session.executeQuery(string, this.getBeanClass(), vector);
        }
        catch (Exception exception) {
            throw new FinderException(ExceptionLocalization.buildMessage("finder_query_failed", null) + "\n" + Helper.printStackTraceToString(exception));
        }
        return vector2;
    }

    public Object findByPrimaryKey(Object object) throws FinderException {
        Object object2 = this.getWrapperPolicy().buildBeanFromPrimaryKey(object, this.getSession());
        this.findObject(new ReadObjectQuery(object2));
        return object;
    }

    public Object findObject(ReadObjectQuery readObjectQuery) throws FinderException {
        Session session = this.getActiveSession();
        session.log(1, "ejb", "EJB_find_one", readObjectQuery);
        readObjectQuery.setReferenceClass(this.getBeanClass());
        readObjectQuery.setDescriptor(this.getDescriptor());
        readObjectQuery.setShouldUseWrapperPolicy(false);
        Object object = null;
        try {
            object = session.executeQuery(readObjectQuery);
        }
        catch (Exception exception) {
            throw new FinderException(ExceptionLocalization.buildMessage("finder_query_failed", null) + "\n" + Helper.printStackTraceToString(exception));
        }
        if (object == null) {
            throw new ObjectNotFoundException();
        }
        return object;
    }

    public Object findObjectByNamedQuery(String string, Vector vector) throws FinderException {
        Session session = this.getActiveSession();
        session.log(1, "ejb", "EJB_find_one_by_name", string);
        Object object = null;
        try {
            object = session.executeQuery(string, this.getBeanClass(), vector);
        }
        catch (Exception exception) {
            throw new FinderException(ExceptionLocalization.buildMessage("finder_query_failed", null) + "\n" + Helper.printStackTraceToString(exception));
        }
        if (object == null) {
            throw new ObjectNotFoundException();
        }
        return object;
    }

    public Object findOne(Expression expression) throws FinderException {
        return this.findOne(new ReadObjectQuery(this.getBeanClass(), expression));
    }

    public Object findOne(Call call) throws FinderException {
        return this.findOne(new ReadObjectQuery(this.getBeanClass(), call));
    }

    public Object findOne(ReadObjectQuery readObjectQuery) throws FinderException {
        Object object = this.findObject(readObjectQuery);
        return this.getWrapperPolicy().buildPrimaryKeyFromBean(object, this.getSession());
    }

    public Object findOneByNamedQuery(String string, Vector vector) throws FinderException {
        Object object = this.findObjectByNamedQuery(string, vector);
        return this.getWrapperPolicy().buildPrimaryKeyFromBean(object, this.getSession());
    }

    public Session getActiveSession() {
        return (Session)this.getSession().getActiveSession();
    }

    public UnitOfWork getActiveUnitOfWork() {
        UnitOfWork unitOfWork = (UnitOfWork)this.getSession().getActiveUnitOfWork();
        if (unitOfWork == null) {
            return null;
        }
        unitOfWork.setShouldNewObjectsBeCached(true);
        return unitOfWork;
    }

    public Class getBeanClass() {
        return this.beanClass;
    }

    public Descriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = this.getSession().getDescriptor(this.getBeanClass());
        }
        return this.descriptor;
    }

    public Session getSession() {
        if (this.session == null) {
            this.session = SessionManager.getManager().getSession(this.xmlSessionConfigLoader, this.getSessionName(), PrivilegedAccessController.getClassLoaderForClass(this.getBeanClass()), true, false, false);
        }
        return this.session;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public XMLSessionConfigLoader getXMLSessionConfigLoader() {
        return this.xmlSessionConfigLoader;
    }

    public EJBWrapperPolicy getWrapperPolicy() {
        return (EJBWrapperPolicy)this.getDescriptor().getWrapperPolicy();
    }

    public void load(Object object) {
        Object object2;
        Session session = this.getActiveSession();
        session.log(1, "ejb", "EJB_load");
        Vector vector = this.getDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(object, session);
        Object object3 = session.getIdentityMapAccessorInstance().getFromIdentityMap(vector, this.getDescriptor().getJavaClass(), this.getDescriptor());
        if (object3 == null) {
            object2 = new ReadObjectQuery();
            object2.setSelectionObject(object);
            object2.setShouldUseWrapperPolicy(false);
            object3 = session.executeQuery((DatabaseQuery)object2);
        }
        if (object3 == null) {
            object2 = new Object[]{object};
            throw ValidationException.ejbContainerExceptionRaised((Exception)new ObjectNotFoundException(ExceptionLocalization.buildMessage("bean_not_found_on_database", object2)));
        }
        object2 = object3;
        if (session.isUnitOfWork()) {
            UnitOfWork unitOfWork = (UnitOfWork)session;
            object2 = unitOfWork.getContainerUnitOfWork().registerExistingObject(object3);
            unitOfWork.getContainerBeans().put(object, object3);
        }
        this.getDescriptor().getObjectBuilder().copyInto(object2, object);
    }

    public void remove(Object object) throws RemoveException {
        try {
            Object[] objectArray;
            UnitOfWork unitOfWork = this.getActiveUnitOfWork();
            if (unitOfWork == null) {
                throw ValidationException.ejbMustBeInTransaction(object);
            }
            unitOfWork.log(1, "ejb", "EJB_remove", object);
            Vector vector = this.getDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(object, this.session);
            Object object2 = this.session.getIdentityMapAccessorInstance().getFromIdentityMap(vector, this.getDescriptor().getJavaClass(), this.getDescriptor());
            if (object2 == null) {
                objectArray = new ReadObjectQuery();
                objectArray.setSelectionObject(object);
                objectArray.setShouldUseWrapperPolicy(false);
                object2 = unitOfWork.executeQuery((DatabaseQuery)objectArray);
            }
            if (object2 == null) {
                objectArray = new Object[]{object};
                throw ValidationException.ejbContainerExceptionRaised((Exception)new ObjectNotFoundException(ExceptionLocalization.buildMessage("bean_not_found_on_database", objectArray)));
            }
            unitOfWork.deleteObject(object2);
        }
        catch (Exception exception) {
            throw new RemoveException(ExceptionLocalization.buildMessage("remove_deletion_failed", null) + "\n" + exception);
        }
    }

    public void remove(EntityBean entityBean) throws RemoveException {
        this.remove((Object)entityBean);
    }

    public void setBeanClass(Class clazz) {
        this.beanClass = clazz;
    }

    protected void setDescriptor(Descriptor descriptor) {
        this.descriptor = descriptor;
    }

    public void setSession(oracle.toplink.sessions.Session session) {
        this.session = (Session)session;
    }

    public void setSessionName(String string) {
        this.sessionName = string;
    }

    public void setXMLSessionConfigLoader(XMLSessionConfigLoader xMLSessionConfigLoader) {
        this.xmlSessionConfigLoader = xMLSessionConfigLoader;
    }

    public void store(Object object) throws DatabaseException, OptimisticLockException {
        UnitOfWork unitOfWork = this.getActiveUnitOfWork();
        unitOfWork.log(1, "ejb", "EJB_store", object);
    }

    public void store(EntityBean entityBean) throws DatabaseException, OptimisticLockException {
        this.store((Object)entityBean);
    }
}

