/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.eis.adapters.aq;

import javax.resource.ResourceException;
import javax.resource.cci.IndexedRecord;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.Record;
import oracle.AQ.AQDequeueOption;
import oracle.AQ.AQEnqueueOption;
import oracle.toplink.eis.EISAccessor;
import oracle.toplink.eis.EISDOMRecord;
import oracle.toplink.eis.EISException;
import oracle.toplink.eis.EISPlatform;
import oracle.toplink.eis.interactions.EISInteraction;
import oracle.toplink.internal.eis.adapters.aq.AQDequeueInteractionSpec;
import oracle.toplink.internal.eis.adapters.aq.AQEnqueueInteractionSpec;
import oracle.toplink.internal.eis.adapters.aq.AQInteractionSpec;
import oracle.toplink.ox.record.DOMRecord;
import oracle.toplink.publicinterface.DatabaseRow;
import org.w3c.dom.Element;

public class AQPlatform
extends EISPlatform {
    public static String QUEUE = "queue";
    public static String SCHEMA = "schema";
    public static String QUEUE_OPERATION = "operation";
    public static String ENQUEUE = "enqueue";
    public static String DEQUEUE = "dequeue";
    public static String ENQUEUE_OPTIONS = "enqueue-options";
    public static String DEQUEUE_OPTIONS = "dequeue-options";

    public AQPlatform() {
        this.setShouldConvertDataToStrings(true);
        this.setIsMappedRecordSupported(false);
        this.setIsIndexedRecordSupported(true);
        this.setIsDOMRecordSupported(true);
        this.setSupportsLocalTransactions(true);
        this.setRequiresAutoCommit(true);
    }

    public InteractionSpec buildInteractionSpec(EISInteraction eISInteraction) {
        InteractionSpec interactionSpec = eISInteraction.getInteractionSpec();
        if (interactionSpec == null) {
            AQInteractionSpec aQInteractionSpec;
            if (eISInteraction.getProperty(QUEUE_OPERATION) == null) {
                throw EISException.resourceException(new ResourceException(QUEUE_OPERATION + " properties must be set."), eISInteraction, null, null);
            }
            if (eISInteraction.getProperty(QUEUE_OPERATION).equals(ENQUEUE)) {
                aQInteractionSpec = new AQEnqueueInteractionSpec();
                AQEnqueueOption aQEnqueueOption = (AQEnqueueOption)eISInteraction.getProperty(ENQUEUE_OPTIONS);
                if (aQEnqueueOption != null) {
                    ((AQEnqueueInteractionSpec)aQInteractionSpec).setOptions(aQEnqueueOption);
                }
            } else {
                aQInteractionSpec = new AQDequeueInteractionSpec();
                AQDequeueOption aQDequeueOption = (AQDequeueOption)eISInteraction.getProperty(DEQUEUE_OPTIONS);
                if (aQDequeueOption != null) {
                    ((AQDequeueInteractionSpec)aQInteractionSpec).setOptions(aQDequeueOption);
                }
            }
            aQInteractionSpec.setQueue((String)eISInteraction.getProperty(QUEUE));
            aQInteractionSpec.setSchema((String)eISInteraction.getProperty(SCHEMA));
            interactionSpec = aQInteractionSpec;
        }
        return interactionSpec;
    }

    public Record createDOMRecord(String string, EISAccessor eISAccessor) {
        try {
            return eISAccessor.getRecordFactory().createIndexedRecord(string);
        }
        catch (ResourceException resourceException) {
            throw EISException.resourceException(resourceException, eISAccessor, null);
        }
    }

    public void setDOMInRecord(Element element, Record record, EISInteraction eISInteraction, EISAccessor eISAccessor) {
        IndexedRecord indexedRecord = (IndexedRecord)record;
        indexedRecord.add((Object)new DOMRecord(element).transformToXML());
    }

    public DatabaseRow createDatabaseRowFromDOMRecord(Record record, EISInteraction eISInteraction, EISAccessor eISAccessor) {
        EISDOMRecord eISDOMRecord = new EISDOMRecord();
        IndexedRecord indexedRecord = (IndexedRecord)record;
        if (indexedRecord.size() == 0) {
            return null;
        }
        byte[] byArray = (byte[])indexedRecord.get(0);
        eISDOMRecord.transformFromXML(new String(byArray));
        return eISDOMRecord;
    }
}

