/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.eis;

import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.ConnectionSpec;
import oracle.toplink.eis.EISAccessor;
import oracle.toplink.eis.EISConnectionSpec;
import oracle.toplink.eis.EISPlatform;
import oracle.toplink.internal.databaseaccess.Accessor;
import oracle.toplink.internal.databaseaccess.Platform;
import oracle.toplink.sessions.DatasourceLogin;

public class EISLogin
extends DatasourceLogin {
    public EISLogin() {
        this(new EISPlatform());
    }

    public EISLogin(Platform platform) {
        super(platform);
        this.connector = new EISConnectionSpec();
    }

    public Accessor buildAccessor() {
        return new EISAccessor();
    }

    public Object connectToDatasource(Accessor accessor) {
        return this.getConnectionSpec().connectToDataSource((EISAccessor)accessor, this.getProperties());
    }

    public void setPassword(String string) {
        if (string != null) {
            this.setProperty("password", string);
        } else {
            this.removeProperty("password");
        }
    }

    public String getConnectionFactoryURL() {
        if (this.getConnectionSpec().getName() == null || this.getConnectionSpec().getName().size() == 0) {
            return null;
        }
        return this.getConnectionSpec().getName().get(0);
    }

    public void setConnectionFactoryURL(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        this.getConnectionSpec().setName(string);
    }

    public EISConnectionSpec getConnectionSpec() {
        return (EISConnectionSpec)this.getConnector();
    }

    public void setConnectionSpec(EISConnectionSpec eISConnectionSpec) {
        this.setConnector(eISConnectionSpec);
    }

    public void configureConnectionSpec(String string) {
        this.setConnectionSpec(new EISConnectionSpec(string));
    }

    public void configureConnectionSpec(ConnectionFactory connectionFactory) {
        EISConnectionSpec eISConnectionSpec = new EISConnectionSpec();
        eISConnectionSpec.setConnectionFactory(connectionFactory);
        this.setConnectionSpec(eISConnectionSpec);
    }

    public void configureConnectionSpec(String string, ConnectionSpec connectionSpec) {
        EISConnectionSpec eISConnectionSpec = new EISConnectionSpec(string);
        eISConnectionSpec.setConnectionSpec(connectionSpec);
        this.setConnectionSpec(eISConnectionSpec);
    }

    public void configureConnectionSpec(ConnectionFactory connectionFactory, ConnectionSpec connectionSpec) {
        EISConnectionSpec eISConnectionSpec = new EISConnectionSpec();
        eISConnectionSpec.setConnectionFactory(connectionFactory);
        eISConnectionSpec.setConnectionSpec(connectionSpec);
        this.setConnectionSpec(eISConnectionSpec);
    }
}

