/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.descriptors.changetracking;

import java.util.Iterator;
import java.util.Vector;
import oracle.toplink.descriptors.changetracking.ChangeTracker;
import oracle.toplink.descriptors.changetracking.ObjectChangeTrackingPolicy;
import oracle.toplink.internal.descriptors.ObjectBuilder;
import oracle.toplink.internal.descriptors.changetracking.AggregateAttributeChangeListener;
import oracle.toplink.internal.descriptors.changetracking.AttributeChangeListener;
import oracle.toplink.internal.descriptors.changetracking.ObjectChangeListener;
import oracle.toplink.internal.helper.IdentityHashtable;
import oracle.toplink.internal.sessions.ChangeRecord;
import oracle.toplink.internal.sessions.ObjectChangeSet;
import oracle.toplink.internal.sessions.UnitOfWorkChangeSet;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;

public class AttributeChangeTrackingPolicy
extends ObjectChangeTrackingPolicy {
    public ObjectChangeSet createObjectChangeSet(Object object, Object object2, UnitOfWorkChangeSet unitOfWorkChangeSet, boolean bl, Session session, Descriptor descriptor) {
        ObjectChangeSet objectChangeSet;
        if (!bl) {
            objectChangeSet = ((AttributeChangeListener)((ChangeTracker)object).getTopLinkPropertyChangeListener()).getObjectChangeSet();
            if (objectChangeSet != null) {
                if (objectChangeSet.getUOWChangeSet() != unitOfWorkChangeSet) {
                    objectChangeSet = unitOfWorkChangeSet.mergeObjectChanges(objectChangeSet, (UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet());
                }
                if (objectChangeSet.hasDeferredAttributes()) {
                    Iterator iterator = objectChangeSet.getDeferredSet().iterator();
                    while (iterator.hasNext()) {
                        DatabaseMapping databaseMapping = descriptor.getMappingForAttributeName((String)iterator.next());
                        databaseMapping.calculateDeferredChanges((ChangeRecord)objectChangeSet.getChangesForAttributeNamed(databaseMapping.getAttributeName()), session);
                    }
                }
            } else {
                objectChangeSet = descriptor.getObjectBuilder().createObjectChangeSet(object, unitOfWorkChangeSet, bl, session);
            }
        } else {
            objectChangeSet = descriptor.getObjectBuilder().createObjectChangeSet(object, unitOfWorkChangeSet, bl, session);
            Vector vector = descriptor.getMappings();
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                DatabaseMapping databaseMapping = (DatabaseMapping)vector.get(i);
                objectChangeSet.addChange(databaseMapping.compareForChange(object, null, objectChangeSet, session));
            }
        }
        if (descriptor.usesOptimisticLocking() && objectChangeSet.getPrimaryKeys() != null) {
            objectChangeSet.setWriteLockValue(descriptor.getOptimisticLockingPolicy().getWriteLockValue(object, objectChangeSet.getPrimaryKeys(), session));
        }
        return objectChangeSet;
    }

    public boolean isAttributeChangeTrackingPolicy() {
        return true;
    }

    public void updateWithChanges(Object object, ObjectChangeSet objectChangeSet, UnitOfWork unitOfWork, Descriptor descriptor) {
        this.clearChanges(object, unitOfWork, descriptor);
    }

    public void revertChanges(Object object, Descriptor descriptor, UnitOfWork unitOfWork, IdentityHashtable identityHashtable) {
        ObjectChangeListener objectChangeListener = (ObjectChangeListener)((ChangeTracker)object).getTopLinkPropertyChangeListener();
        if (objectChangeListener != null) {
            objectChangeListener.revertChanges();
        } else {
            this.setChangeListener(object, unitOfWork, descriptor);
        }
    }

    public void setAggregateChangeListener(Object object, Object object2, UnitOfWork unitOfWork, Descriptor descriptor, String string) {
        ((ChangeTracker)object2).setTopLinkPropertyChangeListener(new AggregateAttributeChangeListener(descriptor, unitOfWork, (AttributeChangeListener)((ChangeTracker)object).getTopLinkPropertyChangeListener(), string, object2));
    }

    public void setChangeListener(Object object, UnitOfWork unitOfWork, Descriptor descriptor) {
        ((ChangeTracker)object).setTopLinkPropertyChangeListener(new AttributeChangeListener(descriptor, unitOfWork, object));
    }

    public void setChangeSetOnListener(ObjectChangeSet objectChangeSet, Object object) {
        ((AttributeChangeListener)((ChangeTracker)object).getTopLinkPropertyChangeListener()).setObjectChangeSet(objectChangeSet);
    }

    public Object buildBackupClone(Object object, ObjectBuilder objectBuilder, UnitOfWork unitOfWork) {
        return object;
    }
}

