/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.descriptors;

import java.sql.Timestamp;
import java.util.Vector;
import oracle.toplink.descriptors.VersionLockingPolicy;
import oracle.toplink.exceptions.OptimisticLockException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.expressions.ExpressionBuilder;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.sessions.ObjectChangeSet;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.ModifyQuery;

public class TimestampLockingPolicy
extends VersionLockingPolicy {
    protected int retrieveTimeFrom;
    public static final int SERVER_TIME = 1;
    public static final int LOCAL_TIME = 2;

    public TimestampLockingPolicy() {
        this.useServerTime();
    }

    public TimestampLockingPolicy(String string) {
        super(string);
        this.useServerTime();
    }

    public TimestampLockingPolicy(DatabaseField databaseField) {
        super(databaseField);
        this.useServerTime();
    }

    protected Class getDefaultLockingFieldType() {
        return ClassConstants.TIMESTAMP;
    }

    public Object getBaseValue() {
        return new Timestamp(0L);
    }

    protected Object getInitialWriteValue(Session session) {
        if (this.usesLocalTime()) {
            return new Timestamp(System.currentTimeMillis());
        }
        if (this.usesServerTime()) {
            Session session2 = session.getSessionForClass(this.getDescriptor().getJavaClass());
            while (session2.isUnitOfWork()) {
                session2 = ((UnitOfWork)session2).getParent().getSessionForClass(this.getDescriptor().getJavaClass());
            }
            return session2.getDatasourceLogin().getDatasourcePlatform().getTimestampFromServer(session, session2.getName());
        }
        return null;
    }

    public Object getNewLockValue(ModifyQuery modifyQuery) {
        return this.getInitialWriteValue(modifyQuery.getSession());
    }

    public Object getValueToPutInCache(DatabaseRow databaseRow, Session session) {
        if (this.isStoredInCache()) {
            return session.getDatasourcePlatform().convertObject(databaseRow.get(this.getWriteLockField()), ClassConstants.TIMESTAMP);
        }
        return null;
    }

    public int getVersionDifference(Object object, Object object2, Vector vector, Session session) {
        Timestamp timestamp = (Timestamp)object;
        if (timestamp == null) {
            return 0;
        }
        Timestamp timestamp2 = this.isStoredInCache() ? (Timestamp)session.getIdentityMapAccessorInstance().getWriteLockValue(vector, object2.getClass(), this.getDescriptor()) : (Timestamp)this.lockValueFromObject(object2);
        if (timestamp2 != null && !timestamp.after(timestamp2)) {
            return 0;
        }
        return 2;
    }

    public Object getWriteLockValue(Object object, Vector vector, Session session) {
        Timestamp timestamp = null;
        if (this.isStoredInCache()) {
            timestamp = (Timestamp)session.getIdentityMapAccessorInstance().getWriteLockValue(vector, object.getClass(), this.getDescriptor());
        } else {
            Object object2 = this.lockValueFromObject(object);
            if (object2 != null) {
                if (object2 instanceof Timestamp) {
                    timestamp = (Timestamp)this.lockValueFromObject(object);
                } else {
                    throw OptimisticLockException.needToMapJavaSqlTimestampWhenStoredInObject();
                }
            }
        }
        return timestamp;
    }

    public Expression getWriteLockUpdateExpression(ExpressionBuilder expressionBuilder) {
        return expressionBuilder.value(this.getInitialWriteValue(expressionBuilder.getSession()));
    }

    protected Number incrementWriteLockValue(Number number) {
        return null;
    }

    public boolean isChildWriteLockValueGreater(Session session, Vector vector, Class clazz, ObjectChangeSet objectChangeSet) {
        if (this.isStoredInCache()) {
            Timestamp timestamp = (Timestamp)objectChangeSet.getWriteLockValue();
            Timestamp timestamp2 = (Timestamp)session.getIdentityMapAccessorInstance().getWriteLockValue(vector, clazz, this.getDescriptor());
            if (timestamp != null && (timestamp2 == null || timestamp2.before(timestamp))) {
                return true;
            }
        }
        return false;
    }

    public boolean isChildWriteLockValueGreater(UnitOfWork unitOfWork, Vector vector, Class clazz) {
        if (this.isStoredInCache()) {
            Timestamp timestamp = (Timestamp)unitOfWork.getIdentityMapAccessorInstance().getWriteLockValue(vector, clazz, this.getDescriptor());
            Timestamp timestamp2 = (Timestamp)unitOfWork.getParent().getIdentityMapAccessorInstance().getWriteLockValue(vector, clazz, this.getDescriptor());
            if (timestamp != null && (timestamp2 == null || timestamp2.before(timestamp))) {
                return true;
            }
        }
        return false;
    }

    public boolean isNewerVersion(Object object, Object object2, Vector vector, Session session) {
        Timestamp timestamp = (Timestamp)object;
        Timestamp timestamp2 = this.isStoredInCache() ? (Timestamp)session.getIdentityMapAccessorInstance().getWriteLockValue(vector, object2.getClass(), this.getDescriptor()) : (Timestamp)this.lockValueFromObject(object2);
        return timestamp2 == null || timestamp.after(timestamp2);
    }

    public boolean isNewerVersion(DatabaseRow databaseRow, Object object, Vector vector, Session session) {
        Timestamp timestamp = (Timestamp)session.getDatasourcePlatform().convertObject(databaseRow.get(this.getWriteLockField()), ClassConstants.TIMESTAMP);
        Timestamp timestamp2 = this.isStoredInCache() ? (Timestamp)session.getIdentityMapAccessorInstance().getWriteLockValue(vector, object.getClass(), this.getDescriptor()) : (Timestamp)this.lockValueFromObject(object);
        return timestamp2 == null || timestamp.after(timestamp2);
    }

    public void setUsesServerTime(boolean bl) {
        if (bl) {
            this.useServerTime();
        } else {
            this.useLocalTime();
        }
    }

    public void useLocalTime() {
        this.retrieveTimeFrom = 2;
    }

    public void useServerTime() {
        this.retrieveTimeFrom = 1;
    }

    public boolean usesLocalTime() {
        return this.retrieveTimeFrom == 2;
    }

    public boolean usesServerTime() {
        return this.retrieveTimeFrom == 1;
    }
}

