/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.descriptors;

import java.io.Serializable;
import oracle.toplink.descriptors.PessimisticLockingPolicy;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.internal.descriptors.CMPLifeCycleListener;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.UpdateObjectQuery;

public class CMPPolicy
implements Serializable {
    public static boolean OPTIMIZE_PESSIMISTIC_CMP = false;
    protected int forceUpdate = 0;
    protected int updateAllFields = 0;
    protected PessimisticLockingPolicy pessimisticLockingPolicy;
    protected CMPLifeCycleListener lifeCycleListener;
    protected Class mappedClass;
    protected Descriptor descriptor;
    protected int modificationDeferralLevel = 2;
    public static final int NONE = 0;
    public static final int UPDATE_MODIFICATIONS = 1;
    public static final int ALL_MODIFICATIONS = 2;
    protected int nonDeferredCreateTime = 0;
    public static final int UNDEFINED = 0;
    public static final int AFTER_EJBCREATE = 1;
    public static final int AFTER_EJBPOSTCREATE = 2;

    public void postInsert(Object object, Session session) {
        if (this.getLifeCycleListener() != null) {
            this.getLifeCycleListener().postInsert(object, session);
        }
    }

    public void invokeEJBLoad(Object object, Session session) {
        if (this.getLifeCycleListener() != null) {
            this.getLifeCycleListener().invokeEJBLoad(object, session);
        }
    }

    public void invokeEJBStore(Object object, Session session) {
        if (this.getLifeCycleListener() != null) {
            this.getLifeCycleListener().invokeEJBStore(object, session);
        }
    }

    public CMPLifeCycleListener getLifeCycleListener() {
        return this.lifeCycleListener;
    }

    public void setLifeCycleListener(CMPLifeCycleListener cMPLifeCycleListener) {
        this.lifeCycleListener = cMPLifeCycleListener;
    }

    public int getNonDeferredCreateTime() {
        return this.nonDeferredCreateTime;
    }

    public PessimisticLockingPolicy getPessimisticLockingPolicy() {
        return this.pessimisticLockingPolicy;
    }

    public void setDeferModificationsUntilCommit(int n) {
        this.modificationDeferralLevel = n;
    }

    public void setMappedClass(Class clazz) {
        this.mappedClass = clazz;
    }

    public Class getMappedClass() {
        return this.mappedClass;
    }

    public void setNonDeferredCreateTime(int n) {
        this.nonDeferredCreateTime = n;
    }

    public void setPessimisticLockingPolicy(PessimisticLockingPolicy pessimisticLockingPolicy) {
        this.pessimisticLockingPolicy = pessimisticLockingPolicy;
    }

    public boolean hasPessimisticLockingPolicy() {
        return this.pessimisticLockingPolicy != null;
    }

    public int getDeferModificationsUntilCommit() {
        return this.modificationDeferralLevel;
    }

    public boolean getForceUpdate() {
        return this.forceUpdate == 1;
    }

    public void setForceUpdate(boolean bl) {
        this.forceUpdate = bl ? 1 : -1;
    }

    public boolean getUpdateAllFields() {
        return this.updateAllFields == 1;
    }

    public void setUpdateAllFields(boolean bl) {
        this.updateAllFields = bl ? 1 : -1;
    }

    public int internalGetForceUpdate() {
        return this.forceUpdate;
    }

    public int internalGetUpdateAllFields() {
        return this.updateAllFields;
    }

    public void internalSetForceUpdate(int n) {
        this.forceUpdate = n;
    }

    public void internalSetUpdateAllFields(int n) {
        this.updateAllFields = n;
    }

    public void initialize(Descriptor descriptor, Session session) throws DescriptorException {
        if (this.getUpdateAllFields() && !descriptor.getQueryManager().hasUpdateQuery()) {
            descriptor.getQueryManager().setUpdateQuery(new UpdateObjectQuery());
        }
        if (this.getForceUpdate() && !this.getUpdateAllFields()) {
            throw DescriptorException.updateAllFieldsNotSet(descriptor);
        }
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor descriptor) {
        this.descriptor = descriptor;
    }

    public boolean isCMP3Policy() {
        return false;
    }
}

