/*
 * Decompiled with CFR 0.152.
 */
package Introduction;

import Introduction.BulletinNotes;
import Introduction.Etudiant;
import Introduction.Fichier;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;

public class CursusSwing
extends JFrame {
    private String urlPhoto = "/Users/VotreCompte/Photos/Inconnu.jpg";
    private String periode;
    private String[] listeMatieres;
    private JComboBox choixPeriode;
    private JButton fermerBtn;
    private ButtonGroup groupeBtn;
    private JLabel info;
    private JLabel labelNom;
    private JLabel labelPeriode;
    private JLabel labelPhoto;
    private JLabel labelPrenom;
    private JLabel labelTitre;
    private JTextField nomAsaisir;
    private JTextField prenomAsaisir;
    private JButton rechercherBtn;
    private JSeparator separationTitre;
    private JButton validerBtn;

    public CursusSwing() {
        this.initComponents();
        this.setBounds(100, 100, 450, 500);
        this.info.setText("  Cr\u00e9er : Tous les champs doivent \u00eatre renseign\u00e9s !");
    }

    private void initComponents() {
        this.groupeBtn = new ButtonGroup();
        this.labelTitre = new JLabel();
        this.separationTitre = new JSeparator();
        this.labelNom = new JLabel();
        this.nomAsaisir = new JTextField();
        this.labelPrenom = new JLabel();
        this.prenomAsaisir = new JTextField();
        this.labelPeriode = new JLabel();
        this.choixPeriode = new JComboBox();
        this.labelPhoto = new JLabel();
        this.rechercherBtn = new JButton();
        this.info = new JLabel();
        this.validerBtn = new JButton();
        this.fermerBtn = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Gestion des \u00c9tudiants");
        this.setCursor(new Cursor(0));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                CursusSwing.this.formMouseEntered(evt);
            }
        });
        this.labelTitre.setFont(new Font("Arial", 0, 18));
        this.labelTitre.setHorizontalAlignment(0);
        this.labelTitre.setText("\u00c9tudiant  ");
        this.labelNom.setText("Nom :");
        this.nomAsaisir.setDragEnabled(false);
        this.nomAsaisir.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                CursusSwing.this.nomAsaisirMouseEntered(evt);
            }
        });
        this.labelPrenom.setText("Pr\u00e9nom :");
        this.prenomAsaisir.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                CursusSwing.this.prenomAsaisirMouseEntered(evt);
            }
        });
        this.labelPeriode.setText("P\u00e9riode :");
        this.choixPeriode.setModel(new DefaultComboBoxModel<String>(new String[]{"Quel semestre ?", "Semestre 1", "Semestre 2", "Semestre 3", "Semestre 4"}));
        this.choixPeriode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CursusSwing.this.choixPeriodeActionPerformed(evt);
            }
        });
        this.labelPhoto.setText("Photo :");
        this.rechercherBtn.setText("Rechercher");
        this.rechercherBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CursusSwing.this.rechercherBtnActionPerformed(evt);
            }
        });
        this.rechercherBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                CursusSwing.this.rechercherBtnMouseEntered(evt);
            }
        });
        this.info.setBackground(new Color(250, 250, 250));
        this.info.setFont(new Font("Arial", 2, 13));
        this.info.setForeground(new Color(120, 120, 120));
        this.info.setText(" info :");
        this.info.setBorder(BorderFactory.createEtchedBorder());
        this.info.setOpaque(true);
        this.validerBtn.setText("Valider");
        this.validerBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CursusSwing.this.validerBtnActionPerformed(evt);
            }
        });
        this.validerBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                CursusSwing.this.validerBtnMouseEntered(evt);
            }
        });
        this.fermerBtn.setText("Fermer");
        this.fermerBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CursusSwing.this.fermerBtnActionPerformed(evt);
            }
        });
        this.fermerBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                CursusSwing.this.fermerBtnMouseEntered(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(this.separationTitre, -1, 472, Short.MAX_VALUE).add(layout.createSequentialGroup().add(35, 35, 35).add(layout.createParallelGroup(1).add(this.labelPrenom, -2, 79, -2).add(this.labelPeriode, -2, 71, -2).add(this.labelPhoto, -2, 60, -2).add(this.labelNom, -1, 105, Short.MAX_VALUE)).addPreferredGap(0).add(layout.createParallelGroup(1).add(this.prenomAsaisir, -2, 163, -2).add(this.rechercherBtn).add(this.choixPeriode, -2, 193, -2).add(this.nomAsaisir, -2, 166, -2)).add(129, 129, 129)).add(2, layout.createSequentialGroup().add(89, 89, 89).add(this.validerBtn).add(74, 74, 74).add(this.fermerBtn).add(143, 143, 143)).add(2, layout.createSequentialGroup().add(3, 3, 3).add(this.info, -1, 449, Short.MAX_VALUE).addContainerGap()).add(layout.createSequentialGroup().add(119, 119, 119).add(this.labelTitre, -2, 197, -2).addContainerGap(156, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(28, 28, 28).add(this.labelTitre).addPreferredGap(1).add(this.separationTitre, -2, 10, -2).add(26, 26, 26).add(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(107, 107, 107).add(this.rechercherBtn)).add(layout.createSequentialGroup().add(layout.createParallelGroup(3).add(this.labelNom, -2, 28, -2).add(this.nomAsaisir, -2, -1, -2)).addPreferredGap(0).add(this.prenomAsaisir, -2, -1, -2).addPreferredGap(0).add(this.choixPeriode, -2, 28, -2)).add(layout.createSequentialGroup().add(36, 36, 36).add(this.labelPrenom, -2, 28, -2).addPreferredGap(0).add(this.labelPeriode, -2, 28, -2).addPreferredGap(0).add(this.labelPhoto, -2, 29, -2))).add(51, 51, 51).add(layout.createParallelGroup(3).add(this.validerBtn).add(this.fermerBtn)).add(45, 45, 45).add(this.info, -2, 37, -2).addContainerGap(52, Short.MAX_VALUE)));
        this.pack();
    }

    private void choixPeriodeActionPerformed(ActionEvent evt) {
        this.periode = (String)this.choixPeriode.getSelectedItem();
        this.rechercherMatiere(this.periode);
    }

    private void rechercherMatiere(String quelSemestre) {
        Fichier fichierTxt = new Fichier();
        this.listeMatieres = new String[5];
        String[] tousLesmots = new String[6];
        if (fichierTxt.ouvrir("/Users/VotreCompte/Ressources/Ressources.txt", "R")) {
            do {
                if (!(tousLesmots = fichierTxt.lire())[0].equalsIgnoreCase(quelSemestre)) continue;
                for (int i = 1; i < tousLesmots.length; ++i) {
                    this.listeMatieres[i - 1] = tousLesmots[i];
                }
                break;
            } while (tousLesmots[0] != null);
            fichierTxt.fermer();
        }
    }

    private void rechercherBtnActionPerformed(ActionEvent evt) {
        JFileChooser fichierArechercher = new JFileChooser();
        int etatRetour = fichierArechercher.showOpenDialog(this);
        if (etatRetour == 0) {
            File fichierPhoto = fichierArechercher.getSelectedFile();
            this.urlPhoto = fichierPhoto.toString();
        }
    }

    private void validerBtnActionPerformed(ActionEvent evt) {
        String nom = this.nomAsaisir.getText();
        String prenom = this.prenomAsaisir.getText();
        double[] moyenne = new double[this.listeMatieres.length];
        for (int i = 0; i < moyenne.length; ++i) {
            moyenne[i] = 0.0;
        }
        Etudiant eleve = new Etudiant(nom, prenom, this.urlPhoto, this.listeMatieres, this.periode, moyenne);
        BulletinNotes bn = new BulletinNotes(eleve);
    }

    private void fermerBtnActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void nomAsaisirMouseEntered(MouseEvent evt) {
        this.info.setText("  Info : Saisir le nom de l'\u00e9tudiant");
    }

    private void prenomAsaisirMouseEntered(MouseEvent evt) {
        this.info.setText("  Info : Saisir le pr\u00e9nom de l'\u00e9tudiant");
    }

    private void rechercherBtnMouseEntered(MouseEvent evt) {
        this.info.setText("  Info : Rechercher la photo de l'\u00e9tudiant");
    }

    private void validerBtnMouseEntered(MouseEvent evt) {
        this.info.setText("  Info : Afficher le bulletin de notes de l'\u00e9tudiant");
    }

    private void fermerBtnMouseEntered(MouseEvent evt) {
        this.info.setText("  Info : Quitter l'application ");
    }

    private void formMouseEntered(MouseEvent evt) {
        this.info.setText("  Info : Tous les champs doivent \u00eatre renseign\u00e9s !");
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new CursusSwing().setVisible(true);
            }
        });
    }
}

