/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.xml;

import java.io.File;
import java.io.FileFilter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.xml.DefaultFileNameNormalizer;
import oracle.toplink.xml.FileListEnumerator;
import oracle.toplink.xml.FileNameNormalizer;
import oracle.toplink.xml.XMLDataStoreException;
import oracle.toplink.xml.XMLFileAccessorFilePolicy;

public class DefaultXMLFileAccessorFilePolicy
implements XMLFileAccessorFilePolicy {
    private File baseDirectory;
    private String fileNameExtension;
    public static String DEFAULT_FILE_NAME_EXTENSION = ".xml";
    private boolean createsDirectoriesAsNeeded;
    private FileNameNormalizer fileNameNormalizer;

    public DefaultXMLFileAccessorFilePolicy() {
        this.initialize();
    }

    public void createFileSource(String string) throws XMLDataStoreException {
        this.createFileSource(this.buildDocumentDirectoryUnchecked(string));
    }

    public void dropFileSource(String string) throws XMLDataStoreException {
        this.dropFileSource(this.buildDocumentDirectoryUnchecked(string));
    }

    public Enumeration getAllFiles(String string) throws XMLDataStoreException {
        return new FileListEnumerator(this.listFiles(this.buildDocumentDirectory(string), this.buildExtensionFileFilter()));
    }

    public File getFile(String string, DatabaseRow databaseRow, Vector vector) throws XMLDataStoreException {
        return this.buildFile(this.buildDocumentDirectory(string), this.buildFileName(databaseRow, vector));
    }

    public void validateConfiguration() throws XMLDataStoreException {
        this.checkDirectory(this.getBaseDirectory());
    }

    protected File buildDefaultBaseDirectory() {
        return this.tempDirectory();
    }

    protected boolean buildDefaultCreatesDirectoriesAsNeeded() {
        return false;
    }

    protected String buildDefaultFileNameExtension() {
        return DEFAULT_FILE_NAME_EXTENSION;
    }

    protected FileNameNormalizer buildDefaultFileNameNormalizer() {
        return new DefaultFileNameNormalizer();
    }

    protected File buildDirectory(String string) {
        return new File(string);
    }

    protected File buildDocumentDirectory(String string) throws XMLDataStoreException {
        File file = this.buildDocumentDirectoryUnchecked(string);
        this.checkDocumentDirectory(file);
        return file;
    }

    protected File buildDocumentDirectoryUnchecked(String string) throws XMLDataStoreException {
        return this.buildFile(this.getBaseDirectory(), string);
    }

    protected FileFilter buildExtensionFileFilter() {
        return this.buildExtensionFileFilter(this.getFileNameExtension());
    }

    protected FileFilter buildExtensionFileFilter(String string) {
        return new ExtensionFileFilter(string);
    }

    protected File buildFile(File file, String string) {
        return new File(file, this.normalizeFileName(string));
    }

    protected String buildFileName(DatabaseRow databaseRow, Vector vector) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        Enumeration enumeration = this.extractPrimaryKeyValues(databaseRow, vector);
        while (enumeration.hasMoreElements()) {
            printWriter.print(enumeration.nextElement());
        }
        printWriter.write(this.getFileNameExtension());
        return stringWriter.toString();
    }

    protected void checkDirectory(File file) throws XMLDataStoreException {
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw XMLDataStoreException.notADirectory(file);
            }
        } else if (this.createsDirectoriesAsNeeded()) {
            if (!file.mkdirs()) {
                throw XMLDataStoreException.directoryCouldNotBeCreated(file);
            }
        } else {
            throw XMLDataStoreException.directoryNotFound(file);
        }
    }

    protected void checkDocumentDirectory(File file) throws XMLDataStoreException {
        this.checkDirectory(file);
    }

    protected void createFileSource(File file) throws XMLDataStoreException {
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw XMLDataStoreException.notADirectory(file);
            }
        } else if (!file.mkdirs()) {
            throw XMLDataStoreException.directoryCouldNotBeCreated(file);
        }
    }

    public boolean createsDirectoriesAsNeeded() {
        return this.createsDirectoriesAsNeeded;
    }

    protected void dropDirectory(File file) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                this.dropDirectory(file2);
                continue;
            }
            file2.delete();
        }
        file.delete();
    }

    protected void dropFileSource(File file) throws XMLDataStoreException {
        if (file.exists()) {
            if (file.isDirectory()) {
                this.dropDirectory(file);
            } else {
                throw XMLDataStoreException.notADirectory(file);
            }
        }
    }

    protected Enumeration extractPrimaryKeyValues(DatabaseRow databaseRow, Vector vector) {
        Vector<Object> vector2 = new Vector<Object>(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            vector2.addElement(databaseRow.get((DatabaseField)enumeration.nextElement()));
        }
        return vector2.elements();
    }

    public File getBaseDirectory() {
        return this.baseDirectory;
    }

    public String getFileNameExtension() {
        return this.fileNameExtension;
    }

    public FileNameNormalizer getFileNameNormalizer() {
        return this.fileNameNormalizer;
    }

    protected void initialize() {
        this.setBaseDirectory(this.buildDefaultBaseDirectory());
        this.setFileNameExtension(this.buildDefaultFileNameExtension());
        this.setCreatesDirectoriesAsNeeded(this.buildDefaultCreatesDirectoriesAsNeeded());
        this.setFileNameNormalizer(this.buildDefaultFileNameNormalizer());
    }

    protected File[] listFiles(File file, FileFilter fileFilter) throws XMLDataStoreException {
        return file.listFiles(fileFilter);
    }

    protected String normalizeFileName(String string) {
        return this.getFileNameNormalizer().normalize(string);
    }

    public void setBaseDirectory(File file) {
        this.baseDirectory = file;
    }

    public void setBaseDirectoryName(String string) {
        this.setBaseDirectory(this.buildDirectory(string));
    }

    public void setCreatesDirectoriesAsNeeded(boolean bl) {
        this.createsDirectoriesAsNeeded = bl;
    }

    public void setFileNameExtension(String string) {
        this.fileNameExtension = string;
    }

    public void setFileNameNormalizer(FileNameNormalizer fileNameNormalizer) {
        this.fileNameNormalizer = fileNameNormalizer;
    }

    protected File tempDirectory() {
        return this.buildDirectory(Helper.tempDirectory());
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.write(Helper.getShortClassName(this));
        printWriter.write("(");
        this.toString(printWriter);
        printWriter.write(")");
        return stringWriter.toString();
    }

    protected void toString(PrintWriter printWriter) {
        printWriter.print(this.getBaseDirectory());
    }

    protected class ExtensionFileFilter
    implements FileFilter {
        protected String fileNameExtension;

        public ExtensionFileFilter(String string) {
            this.fileNameExtension = string;
        }

        public boolean accept(File file) {
            return this.fileIsValid(file) && file.getName().endsWith(this.fileNameExtension);
        }

        protected boolean fileIsValid(File file) {
            return file.isFile();
        }
    }
}

