/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.xml;

import oracle.toplink.xml.FileNameNormalizer;
import oracle.toplink.xml.tools.EncodedWord;

public class DefaultFileNameNormalizer
implements FileNameNormalizer {
    private String invalidFileNameCharacters;
    public static String DEFAULT_INVALID_FILE_NAME_CHARACTERS = "\\/:*?\"<>|&";
    private int maxInvalidFileNameChar;

    public DefaultFileNameNormalizer() {
        this.initialize();
    }

    public String normalize(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 20);
        for (int i = 0; i < string.length(); ++i) {
            this.normalizeFileNameCharOn(string.charAt(i), stringBuffer);
        }
        return EncodedWord.encode(stringBuffer.toString());
    }

    protected void normalizeFileNameCharOn(char c, StringBuffer stringBuffer) {
        if (this.charIsInvalidForAFileName(c)) {
            this.normalizeInvalidFileNameCharOn(c, stringBuffer);
        } else {
            stringBuffer.append(c);
        }
    }

    protected boolean charIsInvalidForAFileName(int n) {
        return n <= this.maxInvalidFileNameChar && this.invalidFileNameCharacters.indexOf(n) >= 0;
    }

    protected void normalizeInvalidFileNameCharOn(char c, StringBuffer stringBuffer) {
        stringBuffer.append("&#x");
        stringBuffer.append(Integer.toString(c, 16));
        stringBuffer.append(';');
    }

    public String getInvalidFileNameCharacters() {
        return this.invalidFileNameCharacters;
    }

    public void setInvalidFileNameCharacters(String string) {
        this.invalidFileNameCharacters = string;
        this.calculateMaxInvalidFileNameChar();
    }

    protected void initialize() {
        this.setInvalidFileNameCharacters(this.buildDefaultInvalidFileNameCharacters());
    }

    protected String buildDefaultInvalidFileNameCharacters() {
        return DEFAULT_INVALID_FILE_NAME_CHARACTERS;
    }

    private void calculateMaxInvalidFileNameChar() {
        if (this.invalidFileNameCharacters == null) {
            throw new NullPointerException();
        }
        this.maxInvalidFileNameChar = 0;
        for (int i = 0; i < this.invalidFileNameCharacters.length(); ++i) {
            char c = this.invalidFileNameCharacters.charAt(i);
            if (this.maxInvalidFileNameChar >= c) continue;
            this.maxInvalidFileNameChar = c;
        }
    }
}

