/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.xml;

import java.util.Enumeration;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.ConversionManager;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.platform.xml.XMLPlatform;
import oracle.toplink.platform.xml.XMLPlatformException;
import oracle.toplink.platform.xml.XMLPlatformFactory;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.sdk.SDKFieldValue;
import oracle.toplink.xml.XMLDataStoreException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DatabaseRowToXMLTranslator {
    protected boolean collectionContainsNonNullElements(SDKFieldValue sDKFieldValue) {
        Enumeration enumeration = sDKFieldValue.getElements().elements();
        while (enumeration.hasMoreElements()) {
            if (enumeration.nextElement() == null) continue;
            return true;
        }
        return false;
    }

    protected boolean rowIsAllNulls(DatabaseRow databaseRow) {
        Enumeration enumeration = databaseRow.elements();
        while (enumeration.hasMoreElements()) {
            if (enumeration.nextElement() == null) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return Helper.getShortClassName(this);
    }

    public Element createDOM(String string, DatabaseRow databaseRow) throws XMLDataStoreException {
        try {
            XMLPlatform xMLPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
            Document document = xMLPlatform.createDocument();
            return this.buildRootElement(string, document, databaseRow);
        }
        catch (XMLPlatformException xMLPlatformException) {
            throw XMLDataStoreException.generalException(xMLPlatformException);
        }
    }

    protected Node buildSDKFieldValueElement(Document document, Node node, DatabaseField databaseField, SDKFieldValue sDKFieldValue) throws XMLDataStoreException {
        if (sDKFieldValue.getElementDataTypeName() == null || sDKFieldValue.getElementDataTypeName().length() == 0) {
            throw XMLDataStoreException.elementDataTypeNameIsRequired(sDKFieldValue.getElements());
        }
        if (sDKFieldValue.isDirectCollection()) {
            return this.buildDirectCollectionElement(document, node, databaseField, sDKFieldValue);
        }
        return this.buildNestedRowElement(document, node, databaseField, sDKFieldValue);
    }

    protected Node buildDirectCollectionElement(Document document, Node node, DatabaseField databaseField, SDKFieldValue sDKFieldValue) throws XMLDataStoreException {
        String string = databaseField.getName();
        Element element = document.createElement(string);
        DatabaseField databaseField2 = new DatabaseField(sDKFieldValue.getElementDataTypeName(), "");
        Enumeration enumeration = sDKFieldValue.getElements().elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e == null) continue;
            if (e instanceof String) {
                element.appendChild(this.buildSimpleTextElement(document, node, databaseField2, (String)e));
                continue;
            }
            throw XMLDataStoreException.invalidFieldValue(string, sDKFieldValue);
        }
        return element;
    }

    protected Element buildRootElement(String string, Document document, DatabaseRow databaseRow) throws XMLDataStoreException {
        Element element = document.createElement(string);
        this.addFieldsToElementFromRow(document, element, databaseRow, string);
        return element;
    }

    protected void addFieldsToElementFromRow(Document document, Node node, DatabaseRow databaseRow, String string) throws XMLDataStoreException {
        for (int i = 0; i < databaseRow.getFields().size(); ++i) {
            Object e;
            DatabaseField databaseField = (DatabaseField)databaseRow.getFields().elementAt(i);
            Node node2 = this.buildElementFromField(document, node, databaseField, e = databaseRow.getValues().elementAt(i));
            if (node2 == null) continue;
            node.appendChild(node2);
        }
    }

    protected Node buildElementFromField(Document document, Node node, DatabaseField databaseField, Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof SDKFieldValue) {
            if (this.collectionContainsNonNullElements((SDKFieldValue)object)) {
                return this.buildSDKFieldValueElement(document, node, databaseField, (SDKFieldValue)object);
            }
            return null;
        }
        return this.buildSimpleTextElement(document, node, databaseField, object);
    }

    protected Node buildSimpleTextElement(Document document, Node node, DatabaseField databaseField, Object object) {
        Node node2 = null;
        String string = (String)ConversionManager.getDefaultManager().convertObject(object, ClassConstants.STRING);
        if (databaseField.getName().length() > 1) {
            if (databaseField.getName().charAt(0) == '@') {
                ((Element)node).setAttribute(databaseField.getName().substring(1, databaseField.getName().length()), string);
                return null;
            }
            node2 = document.createElement(databaseField.getName());
        }
        Text text = document.createTextNode(string);
        node2.appendChild(text);
        return node2;
    }

    protected Node buildNestedRowElement(Document document, Node node, DatabaseField databaseField, SDKFieldValue sDKFieldValue) throws XMLDataStoreException {
        String string = databaseField.getName();
        Element element = null;
        Enumeration enumeration = sDKFieldValue.getElements().elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e instanceof DatabaseRow) {
                DatabaseRow databaseRow = (DatabaseRow)e;
                if (element != null) {
                    node.appendChild(element);
                }
                element = document.createElement(string);
                if (this.rowIsAllNulls(databaseRow)) continue;
                this.addFieldsToElementFromRow(document, element, databaseRow, string);
                continue;
            }
            throw XMLDataStoreException.invalidFieldValue(string, e);
        }
        if (element == null) {
            return document.createElement(string);
        }
        return element;
    }
}

