/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.tools.workbench.expressions;

import oracle.toplink.expressions.Expression;
import oracle.toplink.internal.expressions.FunctionExpression;
import oracle.toplink.internal.expressions.QueryKeyExpression;
import oracle.toplink.tools.workbench.expressions.BasicExpressionRepresentation;
import oracle.toplink.tools.workbench.expressions.QueryableArgumentRepresentation;

public final class UnaryExpressionRepresentation
extends BasicExpressionRepresentation {
    public static final String IS_NULL = "Is Null";
    public static final String NOT_NULL = "Not Null";

    private UnaryExpressionRepresentation() {
    }

    UnaryExpressionRepresentation(String string) {
        super(string);
    }

    public boolean isUnaryExpression() {
        return true;
    }

    public Expression convertToRuntime(Expression expression) {
        Expression expression2 = this.getFirstArgument().convertToRuntime(expression);
        if (this.getOperatorType() == IS_NULL) {
            return expression2.isNull();
        }
        return expression2.notNull();
    }

    public BasicExpressionRepresentation convertFromRuntimeDirectly(Expression expression) {
        Expression expression2 = ((FunctionExpression)expression).getBaseExpression();
        this.setFirstArgument(QueryableArgumentRepresentation.convertFromRuntime((QueryKeyExpression)expression2));
        return this;
    }

    public String convertToRuntimeString(String string) {
        String string2 = this.getFirstArgument().convertToRuntimeString(string);
        String string3 = this.getOperatorType() == IS_NULL ? "isNull" : "notNull";
        return string2 + "." + string3 + "()";
    }
}

