/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.tools.sessionconfiguration;

import java.util.Hashtable;
import oracle.toplink.exceptions.SessionLoaderException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.ox.XMLContext;
import oracle.toplink.ox.XMLUnmarshaller;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.tools.sessionconfiguration.TopLinkSessionsFactory;
import oracle.toplink.tools.sessionconfiguration.WASTopLinkEntityResolver;
import oracle.toplink.tools.sessionconfiguration.XMLSessionConfigLoader;
import oracle.toplink.tools.sessionconfiguration.model.TopLinkSessions;
import oracle.toplink.tools.sessionmanagement.SessionManager;
import org.w3c.dom.Document;

public class WASXMLSessionConfigLoader
extends XMLSessionConfigLoader {
    private Session m_loadedSession;

    public WASXMLSessionConfigLoader() {
        this("meta-inf/toplink-ejb-jar.xml");
    }

    public WASXMLSessionConfigLoader(String string) {
        super(string);
        this.m_entityResolver = new WASTopLinkEntityResolver();
    }

    public Session getLoadedSession() {
        return this.m_loadedSession;
    }

    public boolean load(SessionManager sessionManager, ClassLoader classLoader) {
        Document document = this.loadDocument(classLoader);
        if (document.getDocumentElement().getTagName().equals("toplink-sessions")) {
            if (this.getExceptionStore().isEmpty()) {
                XMLContext xMLContext = new XMLContext(m_project);
                XMLUnmarshaller xMLUnmarshaller = xMLContext.createUnmarshaller();
                TopLinkSessions topLinkSessions = (TopLinkSessions)xMLUnmarshaller.unmarshal(document);
                Hashtable hashtable = TopLinkSessionsFactory.getFactory().buildTopLinkSessions(topLinkSessions, classLoader);
                this.m_loadedSession = (Session)hashtable.elements().nextElement();
                if (sessionManager.getSessions().get(this.m_loadedSession.getName()) == null) {
                    this.m_loadedSession.getDatasourcePlatform().getConversionManager().setLoader(classLoader);
                    sessionManager.addSession(this.m_loadedSession);
                } else {
                    this.m_loadedSession = (Session)sessionManager.getSessions().get(this.m_loadedSession.getName());
                }
                return true;
            }
            throw SessionLoaderException.finalException(this.getExceptionStore());
        }
        return false;
    }

    protected Document loadDocument(ClassLoader classLoader) {
        try {
            return super.loadDocument(classLoader);
        }
        catch (ValidationException validationException) {
            try {
                this.m_resourceName = "META-INF/toplink-ejb-jar.xml";
                return super.loadDocument(classLoader);
            }
            catch (ValidationException validationException2) {
                if (validationException2.getErrorCode() == 7095) {
                    throw ValidationException.noTopLinkEjbJarXMLFound();
                }
                throw validationException2;
            }
        }
    }
}

