/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.tools.schemaframework;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.sequencing.Sequence;
import oracle.toplink.sequencing.TableSequence;
import oracle.toplink.sessions.DatabaseSession;
import oracle.toplink.sessions.Session;
import oracle.toplink.tools.schemaframework.SchemaManager;
import oracle.toplink.tools.schemaframework.TableDefinition;

public class TableCreator {
    protected Vector tableDefinitions;
    protected String name;

    public TableCreator() {
        this(new Vector());
    }

    public TableCreator(Vector vector) {
        this.tableDefinitions = vector;
    }

    public void addTableDefinition(TableDefinition tableDefinition) {
        this.tableDefinitions.addElement(tableDefinition);
    }

    public void addTableDefinitions(Collection collection) {
        this.tableDefinitions.addAll(collection);
    }

    public void createConstraints(DatabaseSession databaseSession) {
        this.createConstraints(databaseSession, new SchemaManager(databaseSession));
    }

    public void createConstraints(DatabaseSession databaseSession, SchemaManager schemaManager) {
        Enumeration enumeration = this.getTableDefinitions().elements();
        while (enumeration.hasMoreElements()) {
            schemaManager.buildFieldTypes((TableDefinition)enumeration.nextElement());
        }
        enumeration = this.getTableDefinitions().elements();
        while (enumeration.hasMoreElements()) {
            schemaManager.createConstraints((TableDefinition)enumeration.nextElement());
        }
    }

    public void createTables(DatabaseSession databaseSession) {
        this.createTables(databaseSession, new SchemaManager(databaseSession));
    }

    public void createTables(DatabaseSession databaseSession, SchemaManager schemaManager) {
        Object object = this.getTableDefinitions().elements();
        while (object.hasMoreElements()) {
            schemaManager.buildFieldTypes((TableDefinition)object.nextElement());
        }
        object = this.getSequenceTableName(databaseSession);
        Enumeration enumeration = this.getTableDefinitions().elements();
        while (enumeration.hasMoreElements()) {
            TableDefinition tableDefinition = (TableDefinition)enumeration.nextElement();
            if (tableDefinition.getName().equals(object)) continue;
            schemaManager.createObject(tableDefinition);
        }
        enumeration = this.getTableDefinitions().elements();
        while (enumeration.hasMoreElements()) {
            schemaManager.createConstraints((TableDefinition)enumeration.nextElement());
        }
        schemaManager.createSequences();
    }

    public void dropConstraints(DatabaseSession databaseSession) {
        this.dropConstraints(databaseSession, new SchemaManager(databaseSession));
    }

    public void dropConstraints(DatabaseSession databaseSession, SchemaManager schemaManager) {
        Enumeration enumeration = this.getTableDefinitions().elements();
        while (enumeration.hasMoreElements()) {
            schemaManager.buildFieldTypes((TableDefinition)enumeration.nextElement());
        }
        enumeration = this.getTableDefinitions().elements();
        while (enumeration.hasMoreElements()) {
            try {
                schemaManager.dropConstraints((TableDefinition)enumeration.nextElement());
            }
            catch (DatabaseException databaseException) {}
        }
    }

    public void dropTables(DatabaseSession databaseSession) {
        this.dropTables(databaseSession, new SchemaManager(databaseSession));
    }

    public void dropTables(DatabaseSession databaseSession, SchemaManager schemaManager) {
        Object object = this.getTableDefinitions().elements();
        while (object.hasMoreElements()) {
            schemaManager.buildFieldTypes((TableDefinition)object.nextElement());
        }
        object = this.getTableDefinitions().elements();
        while (object.hasMoreElements()) {
            try {
                schemaManager.dropConstraints((TableDefinition)object.nextElement());
            }
            catch (DatabaseException databaseException) {}
        }
        object = this.getSequenceTableName(databaseSession);
        Enumeration enumeration = this.getTableDefinitions().elements();
        while (enumeration.hasMoreElements()) {
            TableDefinition tableDefinition = (TableDefinition)enumeration.nextElement();
            if (tableDefinition.getName().equals(object)) continue;
            schemaManager.dropObject(tableDefinition);
        }
    }

    public String getName() {
        return this.name;
    }

    public Vector getTableDefinitions() {
        return this.tableDefinitions;
    }

    public void replaceTables(DatabaseSession databaseSession) {
        this.replaceTables(databaseSession, new SchemaManager(databaseSession));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceTables(DatabaseSession databaseSession, SchemaManager schemaManager) {
        Object object;
        Enumeration enumeration = this.getTableDefinitions().elements();
        while (enumeration.hasMoreElements()) {
            schemaManager.buildFieldTypes((TableDefinition)enumeration.nextElement());
        }
        boolean bl = databaseSession.getSessionLog().shouldLogExceptionStackTrace();
        if (bl) {
            databaseSession.getSessionLog().setShouldLogExceptionStackTrace(false);
        }
        try {
            object = this.getTableDefinitions().elements();
            while (object.hasMoreElements()) {
                try {
                    schemaManager.dropConstraints((TableDefinition)object.nextElement());
                }
                catch (DatabaseException databaseException) {}
            }
        }
        finally {
            if (bl) {
                databaseSession.getSessionLog().setShouldLogExceptionStackTrace(true);
            }
        }
        object = this.getSequenceTableName(databaseSession);
        Enumeration enumeration2 = this.getTableDefinitions().elements();
        while (enumeration2.hasMoreElements()) {
            TableDefinition tableDefinition = (TableDefinition)enumeration2.nextElement();
            if (tableDefinition.getName().equals(object)) continue;
            schemaManager.replaceObject(tableDefinition);
        }
        enumeration2 = this.getTableDefinitions().elements();
        while (enumeration2.hasMoreElements()) {
            schemaManager.createConstraints((TableDefinition)enumeration2.nextElement());
        }
        schemaManager.createSequences();
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setTableDefinitions(Vector vector) {
        this.tableDefinitions = vector;
    }

    protected String getSequenceTableName(Session session) {
        Sequence sequence;
        String string = null;
        if (session.getProject().usesSequencing() && (sequence = session.getLogin().getDefaultSequence()) instanceof TableSequence) {
            string = ((TableSequence)sequence).getTableName();
        }
        return string;
    }
}

