/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.tools.schemaframework;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;

public class PopulationManager {
    protected Hashtable registeredObjects = new Hashtable();
    protected static PopulationManager defaultManager;

    public void addAllObjectsForAbstractClass(Class clazz, Session session, Vector vector) {
        Descriptor descriptor = session.getDescriptor(clazz);
        this.addAllObjectsForClass(clazz, vector);
        Enumeration enumeration = descriptor.getInheritancePolicy().getChildDescriptors().elements();
        while (enumeration.hasMoreElements()) {
            this.addAllObjectsForAbstractClass(((Descriptor)enumeration.nextElement()).getJavaClass(), session, vector);
        }
    }

    public void addAllObjectsForAbstractClass(Class clazz, oracle.toplink.sessions.Session session, Vector vector) {
        this.addAllObjectsForAbstractClass(clazz, (Session)session, vector);
    }

    public void addAllObjectsForClass(Class clazz, Vector vector) {
        if (!this.getRegisteredObjects().containsKey(clazz)) {
            return;
        }
        Enumeration enumeration = ((Hashtable)this.getRegisteredObjects().get(clazz)).elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
    }

    public boolean containsObject(Class clazz, String string) {
        return this.getRegisteredObjects().containsKey(clazz) && ((Hashtable)this.getRegisteredObjects().get(clazz)).containsKey(string);
    }

    public boolean containsObject(Object object, String string) {
        return this.containsObject(object.getClass(), string);
    }

    public Vector getAllClasses() {
        Vector vector = new Vector();
        Enumeration enumeration = this.getRegisteredObjects().keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }

    public Vector getAllObjects() {
        Vector vector = new Vector();
        Enumeration enumeration = this.getAllClasses().elements();
        while (enumeration.hasMoreElements()) {
            Class clazz = (Class)enumeration.nextElement();
            this.addAllObjectsForClass(clazz, vector);
        }
        return vector;
    }

    public Vector getAllObjectsForAbstractClass(Class clazz) {
        Vector vector = new Vector();
        return vector;
    }

    public Vector getAllObjectsForAbstractClass(Class clazz, Session session) {
        Descriptor descriptor = session.getDescriptor(clazz);
        Vector vector = new Vector();
        this.addAllObjectsForClass(clazz, vector);
        if (descriptor.hasInheritance()) {
            Enumeration enumeration = descriptor.getInheritancePolicy().getChildDescriptors().elements();
            while (enumeration.hasMoreElements()) {
                this.addAllObjectsForClass(((Descriptor)enumeration.nextElement()).getJavaClass(), vector);
            }
        }
        return vector;
    }

    public Vector getAllObjectsForClass(Class clazz) {
        Vector vector = new Vector();
        this.addAllObjectsForClass(clazz, vector);
        return vector;
    }

    public static PopulationManager getDefaultManager() {
        if (defaultManager == null) {
            defaultManager = new PopulationManager();
        }
        return defaultManager;
    }

    public Object getObject(Class clazz, String string) {
        if (!this.getRegisteredObjects().containsKey(clazz)) {
            return null;
        }
        return ((Hashtable)this.getRegisteredObjects().get(clazz)).get(string);
    }

    public Hashtable getRegisteredObjects() {
        return this.registeredObjects;
    }

    public Object registerObject(Class clazz, Object object, String string) {
        if (!this.getRegisteredObjects().containsKey(clazz)) {
            this.getRegisteredObjects().put(clazz, new Hashtable());
        }
        ((Hashtable)this.getRegisteredObjects().get(clazz)).put(string, object);
        return object;
    }

    public Object registerObject(Object object, String string) {
        if (!this.getRegisteredObjects().containsKey(object.getClass())) {
            this.getRegisteredObjects().put(object.getClass(), new Hashtable());
        }
        ((Hashtable)this.getRegisteredObjects().get(object.getClass())).put(string, object);
        return object;
    }

    public void removeObject(Class clazz, String string) {
        if (this.getRegisteredObjects().containsKey(clazz)) {
            ((Hashtable)this.getRegisteredObjects().get(clazz)).remove(string);
        }
    }

    public Object removeObject(Object object, String string) {
        this.removeObject(object.getClass(), string);
        return object;
    }

    public static void resetDefaultManager() {
        defaultManager = null;
    }

    public static void setDefaultManager(PopulationManager populationManager) {
        defaultManager = populationManager;
    }

    public void setRegisteredObjects(Hashtable hashtable) {
        this.registeredObjects = hashtable;
    }
}

