/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.tools.schemaframework;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.databaseaccess.FieldTypeDefinition;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.tools.schemaframework.TableDefinition;

public class FieldDefinition
implements Serializable,
Cloneable {
    protected String name;
    protected Class type;
    protected String typeName;
    protected int size;
    protected int subSize;
    protected boolean shouldAllowNull;
    protected boolean isIdentity;
    protected boolean isPrimaryKey;
    protected boolean isUnique;
    protected String additional;
    protected String constraint;
    protected String foreignKeyFieldName;

    public FieldDefinition() {
        this.name = "";
        this.size = 0;
        this.subSize = 0;
        this.shouldAllowNull = true;
        this.isIdentity = false;
        this.isPrimaryKey = false;
        this.isUnique = false;
    }

    public FieldDefinition(String string, Class clazz) {
        this.name = string;
        this.type = clazz;
        this.size = 0;
        this.subSize = 0;
        this.shouldAllowNull = true;
        this.isIdentity = false;
        this.isPrimaryKey = false;
        this.isUnique = false;
    }

    public FieldDefinition(String string, Class clazz, int n) {
        this();
        this.name = string;
        this.type = clazz;
        this.size = n;
    }

    public FieldDefinition(String string, Class clazz, int n, int n2) {
        this();
        this.name = string;
        this.type = clazz;
        this.size = n;
        this.subSize = n2;
    }

    public FieldDefinition(String string, String string2) {
        this();
        this.name = string;
        this.typeName = string2;
    }

    public void appendDBString(Writer writer, Session session, TableDefinition tableDefinition) throws ValidationException {
        FieldTypeDefinition fieldTypeDefinition;
        if (this.getType() != null) {
            fieldTypeDefinition = session.getPlatform().getFieldTypeDefinition(this.getType());
            if (fieldTypeDefinition == null) {
                throw ValidationException.javaTypeIsNotAValidDatabaseType(this.getType());
            }
        } else {
            fieldTypeDefinition = new FieldTypeDefinition(this.getTypeName());
        }
        try {
            writer.write(this.getName());
            writer.write(" ");
            writer.write(fieldTypeDefinition.getName());
            if (fieldTypeDefinition.isSizeAllowed() && (this.getSize() != 0 || fieldTypeDefinition.isSizeRequired())) {
                writer.write("(");
                if (this.getSize() == 0) {
                    writer.write(new Integer(fieldTypeDefinition.getDefaultSize()).toString());
                } else {
                    writer.write(new Integer(this.getSize()).toString());
                }
                if (this.getSubSize() != 0) {
                    writer.write(",");
                    writer.write(new Integer(this.getSubSize()).toString());
                } else if (fieldTypeDefinition.getDefaultSubSize() != 0) {
                    writer.write(",");
                    writer.write(new Integer(fieldTypeDefinition.getDefaultSubSize()).toString());
                }
                writer.write(")");
            }
            if (this.isUnique() && session.getPlatform().supportsPrimaryKeyConstraint()) {
                writer.write(" UNIQUE");
            }
            if (this.isIdentity()) {
                String string = tableDefinition.getFullName() + '.' + this.getName();
                session.getPlatform().printFieldIdentityClause(writer, session, string);
            }
            if (this.shouldAllowNull() && fieldTypeDefinition.shouldAllowNull()) {
                session.getPlatform().printFieldNullClause(writer);
            } else {
                session.getPlatform().printFieldNotNullClause(writer);
            }
            if (this.getConstraint() != null) {
                writer.write(" " + this.getConstraint());
            }
            if (this.getAdditional() != null) {
                writer.write(" " + this.getAdditional());
            }
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    public void appendTypeString(Writer writer, Session session) throws ValidationException {
        FieldTypeDefinition fieldTypeDefinition;
        if (this.getType() != null) {
            fieldTypeDefinition = session.getPlatform().getFieldTypeDefinition(this.getType());
            if (fieldTypeDefinition == null) {
                throw ValidationException.javaTypeIsNotAValidDatabaseType(this.getType());
            }
        } else {
            fieldTypeDefinition = new FieldTypeDefinition(this.getTypeName());
        }
        try {
            writer.write(this.getName());
            writer.write(" ");
            writer.write(fieldTypeDefinition.getName());
            if (fieldTypeDefinition.isSizeAllowed() && (this.getSize() != 0 || fieldTypeDefinition.isSizeRequired())) {
                writer.write("(");
                if (this.getSize() == 0) {
                    writer.write(new Integer(fieldTypeDefinition.getDefaultSize()).toString());
                } else {
                    writer.write(new Integer(this.getSize()).toString());
                }
                if (this.getSubSize() != 0) {
                    writer.write(",");
                    writer.write(new Integer(this.getSubSize()).toString());
                } else if (fieldTypeDefinition.getDefaultSubSize() != 0) {
                    writer.write(",");
                    writer.write(new Integer(fieldTypeDefinition.getDefaultSubSize()).toString());
                }
                writer.write(")");
            }
            if (this.getAdditional() != null) {
                writer.write(" " + this.getAdditional());
            }
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String getAdditional() {
        return this.additional;
    }

    public String getConstraint() {
        return this.constraint;
    }

    public String getForeignKeyFieldName() {
        return this.foreignKeyFieldName;
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return this.size;
    }

    public int getSubSize() {
        return this.subSize;
    }

    public Class getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean isIdentity() {
        return this.isIdentity;
    }

    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    public void setAdditional(String string) {
        this.additional = string;
    }

    public void setConstraint(String string) {
        this.constraint = string;
    }

    public void setForeignKeyFieldName(String string) {
        this.foreignKeyFieldName = string;
    }

    public void setIsIdentity(boolean bl) {
        this.isIdentity = bl;
        if (bl) {
            this.setShouldAllowNull(false);
        }
    }

    public void setIsPrimaryKey(boolean bl) {
        this.isPrimaryKey = bl;
        if (bl) {
            this.setShouldAllowNull(false);
        }
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setShouldAllowNull(boolean bl) {
        this.shouldAllowNull = bl;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public void setSubSize(int n) {
        this.subSize = n;
    }

    public void setType(Class clazz) {
        this.type = clazz;
    }

    public void setTypeName(String string) {
        this.typeName = string;
    }

    public void setUnique(boolean bl) {
        this.isUnique = bl;
    }

    public boolean shouldAllowNull() {
        return this.shouldAllowNull;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "(" + this.getName() + "(" + this.getType() + "))";
    }
}

