/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.tools.schemaframework;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.eis.EISDescriptor;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.internal.descriptors.MethodBasedFieldTransformation;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.ConversionManager;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.DatabaseTable;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.sessions.DatabaseSessionImpl;
import oracle.toplink.logging.AbstractSessionLog;
import oracle.toplink.mappings.AggregateCollectionMapping;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.mappings.DirectCollectionMapping;
import oracle.toplink.mappings.DirectMapMapping;
import oracle.toplink.mappings.ManyToManyMapping;
import oracle.toplink.mappings.TransformationMapping;
import oracle.toplink.mappings.TypeConversionMapping;
import oracle.toplink.objectrelational.ObjectRelationalDescriptor;
import oracle.toplink.ox.XMLDescriptor;
import oracle.toplink.publicinterface.DatabaseSession;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.sessions.Project;
import oracle.toplink.threetier.ServerSession;
import oracle.toplink.tools.schemaframework.FieldDefinition;
import oracle.toplink.tools.schemaframework.TableCreator;
import oracle.toplink.tools.schemaframework.TableDefinition;

public class DefaultTableGenerator {
    Project project = null;
    private Map tableMap = null;
    private Map fieldMap = null;
    static /* synthetic */ Class array$Ljava$lang$Byte;
    static /* synthetic */ Class array$Ljava$lang$Character;

    public DefaultTableGenerator(Project project) {
        this.project = project;
        this.tableMap = new HashMap();
        this.fieldMap = new HashMap();
    }

    public TableCreator generateDefaultTableCreator() {
        Descriptor descriptor;
        TableCreator tableCreator = new TableCreator();
        Iterator<Object> iterator = this.project.getDescriptors().values().iterator();
        while (iterator.hasNext()) {
            descriptor = (Descriptor)iterator.next();
            if (descriptor instanceof XMLDescriptor || descriptor instanceof EISDescriptor || descriptor instanceof ObjectRelationalDescriptor) {
                AbstractSessionLog.getLog().log(6, "relational_descriptor_support_only", null, true);
                return tableCreator;
            }
            if (descriptor.isAggregateDescriptor()) continue;
            this.initTableSchema(descriptor);
        }
        iterator = this.project.getOrderedDescriptors().iterator();
        while (iterator.hasNext()) {
            descriptor = (Descriptor)iterator.next();
            if (descriptor.isAggregateDescriptor()) continue;
            this.postInitTableSchema(descriptor);
        }
        tableCreator.addTableDefinitions(this.tableMap.values());
        return tableCreator;
    }

    public TableCreator generateFilteredDefaultTableCreator(Session session) throws DatabaseException {
        TableCreator tableCreator = this.generateDefaultTableCreator();
        try {
            Connection connection = null;
            if (session.isServerSession()) {
                connection = ((ServerSession)session).getDefaultConnectionPool().acquireConnection().getConnection();
            } else if (session.isDatabaseSession()) {
                connection = ((DatabaseSession)session).getAccessor().getConnection();
            }
            if (connection == null) {
                return tableCreator;
            }
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ResultSet resultSet = databaseMetaData.getTables(null, databaseMetaData.getUserName(), null, new String[]{"TABLE"});
            ArrayList<String> arrayList = new ArrayList<String>();
            while (resultSet.next()) {
                arrayList.add(resultSet.getString("TABLE_NAME"));
            }
            resultSet.close();
            ArrayList<TableDefinition> arrayList2 = new ArrayList<TableDefinition>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            Iterator iterator = tableCreator.getTableDefinitions().iterator();
            while (iterator.hasNext()) {
                TableDefinition tableDefinition = (TableDefinition)iterator.next();
                if (!arrayList.contains(tableDefinition.getFullName())) continue;
                arrayList2.add(tableDefinition);
                arrayList3.add(tableDefinition.getFullName());
            }
            if (!arrayList3.isEmpty()) {
                session.getSessionLog().log(1, "skip_create_existing_tables", arrayList3);
                tableCreator.getTableDefinitions().removeAll(arrayList2);
            }
        }
        catch (SQLException sQLException) {
            throw DatabaseException.errorRetrieveDbMetadataThroughJDBCConnection();
        }
        return tableCreator;
    }

    protected void initTableSchema(Descriptor descriptor) {
        TableDefinition tableDefinition = null;
        DatabaseTable databaseTable = null;
        Iterator iterator = descriptor.getTables().iterator();
        while (iterator.hasNext()) {
            databaseTable = (DatabaseTable)iterator.next();
            tableDefinition = this.getTableDefFromDBTable(databaseTable);
        }
        Iterator iterator2 = descriptor.getFields().iterator();
        DatabaseField databaseField = null;
        while (iterator2.hasNext()) {
            databaseField = (DatabaseField)iterator2.next();
            boolean bl = false;
            bl = descriptor.getPrimaryKeyFields().contains(databaseField);
            Map map = (Map)descriptor.getAdditionalTablePrimaryKeyFields().get(databaseField.getTable());
            if (map != null) {
                bl = bl || map.containsValue(databaseField);
            }
            FieldDefinition fieldDefinition = this.getFieldDefFromDBField(databaseField, bl);
            tableDefinition = (TableDefinition)this.tableMap.get(databaseField.getTableName());
            if (tableDefinition.getFields().contains(fieldDefinition)) continue;
            tableDefinition.addField(fieldDefinition);
        }
    }

    private void postInitTableSchema(Descriptor descriptor) {
        Iterator iterator = descriptor.getMappings().iterator();
        while (iterator.hasNext()) {
            DatabaseMapping databaseMapping = (DatabaseMapping)iterator.next();
            if (databaseMapping.isManyToManyMapping()) {
                this.buildRelationTableDefinition((ManyToManyMapping)databaseMapping);
                continue;
            }
            if (databaseMapping.isDirectCollectionMapping()) {
                this.buildDirectCollectionTableDefinition((DirectCollectionMapping)databaseMapping, descriptor);
                continue;
            }
            if (databaseMapping.isTypeConversionMapping()) {
                this.resetFieldTypeForLOB((TypeConversionMapping)databaseMapping);
                continue;
            }
            if (databaseMapping.isSerializedObjectMapping()) {
                this.getFieldDefFromDBField(databaseMapping.getField(), false).setType(array$Ljava$lang$Byte == null ? DefaultTableGenerator.class$("[Ljava.lang.Byte;") : array$Ljava$lang$Byte);
                continue;
            }
            if (databaseMapping.isAggregateCollectionMapping()) {
                this.addForeignkeyFieldToAggregateTargetTable((AggregateCollectionMapping)databaseMapping);
                continue;
            }
            if (!databaseMapping.isTransformationMapping()) continue;
            this.resetTransformedFieldType((TransformationMapping)databaseMapping);
        }
    }

    private void buildRelationTableDefinition(ManyToManyMapping manyToManyMapping) {
        TableDefinition tableDefinition = (TableDefinition)this.tableMap.get(manyToManyMapping.getRelationTableName());
        if (tableDefinition != null) {
            return;
        }
        tableDefinition = this.initTableDefFromDBTable(manyToManyMapping.getRelationTable());
        DatabaseField databaseField = null;
        Vector vector = manyToManyMapping.getSourceRelationKeyFields();
        for (int i = 0; i < vector.size(); ++i) {
            databaseField = this.resolveDatabaseField((DatabaseField)vector.get(i), (DatabaseField)manyToManyMapping.getSourceKeyFields().get(i));
            this.setFieldToRelationTable(databaseField, tableDefinition);
        }
        Vector vector2 = manyToManyMapping.getTargetRelationKeyFields();
        for (int i = 0; i < vector2.size(); ++i) {
            databaseField = this.resolveDatabaseField((DatabaseField)vector2.get(i), (DatabaseField)manyToManyMapping.getTargetKeyFields().get(i));
            this.setFieldToRelationTable(databaseField, tableDefinition);
        }
    }

    private void buildDirectCollectionTableDefinition(DirectCollectionMapping directCollectionMapping, Descriptor descriptor) {
        TableDefinition tableDefinition = this.getTableDefFromDBTable(directCollectionMapping.getReferenceTable());
        DatabaseField databaseField = null;
        Vector vector = directCollectionMapping.getReferenceKeyFields();
        for (int i = 0; i < vector.size(); ++i) {
            databaseField = this.resolveDatabaseField((DatabaseField)vector.get(i), (DatabaseField)directCollectionMapping.getSourceKeyFields().get(i));
            tableDefinition.addField(this.getDirectCollectionReferenceKeyFieldDefFromDBField(databaseField));
        }
        tableDefinition.addField(this.getFieldDefFromDBField(directCollectionMapping.getDirectField(), false));
        if (directCollectionMapping.isDirectMapMapping()) {
            databaseField = ((DirectMapMapping)directCollectionMapping).getDirectKeyField();
            tableDefinition.addField(this.getFieldDefFromDBField(databaseField, false));
        }
    }

    private void resetFieldTypeForLOB(TypeConversionMapping typeConversionMapping) {
        if (typeConversionMapping.getFieldClassificationName().equals("java.sql.Blob")) {
            this.getFieldDefFromDBField(typeConversionMapping.getField(), false).setType(array$Ljava$lang$Byte == null ? (array$Ljava$lang$Byte = DefaultTableGenerator.class$("[Ljava.lang.Byte;")) : array$Ljava$lang$Byte);
        } else if (typeConversionMapping.getFieldClassificationName().equals("java.sql.Clob")) {
            this.getFieldDefFromDBField(typeConversionMapping.getField(), false).setType(array$Ljava$lang$Character == null ? (array$Ljava$lang$Character = DefaultTableGenerator.class$("[Ljava.lang.Character;")) : array$Ljava$lang$Character);
        }
    }

    private void addForeignkeyFieldToAggregateTargetTable(AggregateCollectionMapping aggregateCollectionMapping) {
        Iterator iterator = aggregateCollectionMapping.getTargetForeignKeyFields().iterator();
        while (iterator.hasNext()) {
            DatabaseField databaseField = (DatabaseField)iterator.next();
            TableDefinition tableDefinition = this.getTableDefFromDBTable(databaseField.getTable());
            tableDefinition.addField(this.getFieldDefFromDBField(databaseField, false));
        }
    }

    private TableDefinition getTableDefFromDBTable(DatabaseTable databaseTable) {
        TableDefinition tableDefinition = (TableDefinition)this.tableMap.get(databaseTable.getName());
        if (tableDefinition == null) {
            tableDefinition = this.initTableDefFromDBTable(databaseTable);
        }
        return tableDefinition;
    }

    private TableDefinition initTableDefFromDBTable(DatabaseTable databaseTable) {
        TableDefinition tableDefinition = new TableDefinition();
        tableDefinition.setName(databaseTable.getName());
        tableDefinition.setQualifier(databaseTable.getTableQualifier());
        this.tableMap.put(databaseTable.getName(), tableDefinition);
        return tableDefinition;
    }

    private DatabaseField resolveDatabaseField(DatabaseField databaseField, DatabaseField databaseField2) {
        DatabaseField databaseField3 = new DatabaseField();
        databaseField3.setName(databaseField.getName());
        databaseField3.setType(this.getFieldDefFromDBField(databaseField2, true).getType());
        return databaseField3;
    }

    private FieldDefinition getFieldDefFromDBField(DatabaseField databaseField, boolean bl) {
        FieldDefinition fieldDefinition = (FieldDefinition)this.fieldMap.get(databaseField);
        if (fieldDefinition == null) {
            fieldDefinition = new FieldDefinition();
            fieldDefinition.setName(databaseField.getName());
            Class clazz = databaseField.getType();
            if (clazz == null || !clazz.isPrimitive() && new DatabaseSessionImpl(this.project).getPlatform().getFieldTypeDefinition(clazz) == null) {
                AbstractSessionLog.getLog().log(1, "field_type_set_to_java_lang_string", databaseField.getQualifiedName(), clazz);
                if (clazz == ClassConstants.UTILDATE || clazz == ClassConstants.CALENDAR) {
                    fieldDefinition.setType(ClassConstants.TIMESTAMP);
                } else if (clazz == ClassConstants.APBYTE) {
                    fieldDefinition.setType(ClassConstants.ABYTE);
                } else if (clazz == ClassConstants.NUMBER) {
                    fieldDefinition.setType(ClassConstants.INTEGER);
                    fieldDefinition.setSize(10);
                } else {
                    fieldDefinition.setType(ClassConstants.STRING);
                }
            } else {
                fieldDefinition.setType(ConversionManager.getObjectClass(clazz));
            }
            fieldDefinition.setIsPrimaryKey(bl);
            this.fieldMap.put(databaseField, fieldDefinition);
        }
        return fieldDefinition;
    }

    private FieldDefinition getDirectCollectionReferenceKeyFieldDefFromDBField(DatabaseField databaseField) {
        FieldDefinition fieldDefinition = (FieldDefinition)this.getFieldDefFromDBField(databaseField, true).clone();
        fieldDefinition.setIsPrimaryKey(false);
        return fieldDefinition;
    }

    private void setFieldToRelationTable(DatabaseField databaseField, TableDefinition tableDefinition) {
        FieldDefinition fieldDefinition = this.getFieldDefFromDBField(databaseField, false);
        FieldDefinition fieldDefinition2 = (FieldDefinition)fieldDefinition.clone();
        fieldDefinition2.setIsPrimaryKey(false);
        fieldDefinition2.setShouldAllowNull(true);
        tableDefinition.addField(fieldDefinition2);
    }

    private void resetTransformedFieldType(TransformationMapping transformationMapping) {
        Iterator iterator = transformationMapping.getFieldTransformations().iterator();
        while (iterator.hasNext()) {
            MethodBasedFieldTransformation methodBasedFieldTransformation = (MethodBasedFieldTransformation)iterator.next();
            try {
                Class<?> clazz = Helper.getDeclaredMethod(transformationMapping.getDescriptor().getJavaClass(), methodBasedFieldTransformation.getMethodName(), null).getReturnType();
                this.getFieldDefFromDBField(methodBasedFieldTransformation.getField(), false).setType(clazz);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

