/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.tools.profiler;

import java.util.Hashtable;
import oracle.toplink.queryframework.DeleteObjectQuery;
import oracle.toplink.queryframework.ReadAllQuery;
import oracle.toplink.queryframework.ReadObjectQuery;
import oracle.toplink.queryframework.WriteObjectQuery;

public class QueryMonitor {
    public static Hashtable cacheHits = new Hashtable();
    public static Hashtable cacheMisses = new Hashtable();
    public static long dumpTime = System.currentTimeMillis();
    public static Boolean shouldMonitor;

    public static boolean shouldMonitor() {
        if (shouldMonitor == null) {
            shouldMonitor = Boolean.FALSE;
            String string = System.getProperty("oracle.toplink.querymonitor");
            if (string != null && string.toUpperCase().equals("TRUE")) {
                shouldMonitor = Boolean.TRUE;
            }
        }
        return shouldMonitor;
    }

    public static void checkDumpTime() {
        if (System.currentTimeMillis() - dumpTime > 100000L) {
            dumpTime = System.currentTimeMillis();
            System.out.println("Cache Hits:" + cacheHits);
            System.out.println("Cache Misses:" + cacheMisses);
        }
    }

    public static void incrementReadObjectHits(ReadObjectQuery readObjectQuery) {
        QueryMonitor.checkDumpTime();
        String string = readObjectQuery.getReferenceClass().getName() + "-findByPrimaryKey";
        Number number = (Number)cacheHits.get(string);
        if (number == null) {
            number = new Integer(0);
        }
        number = new Integer(number.intValue() + 1);
        cacheHits.put(string, number);
    }

    public static void incrementReadObjectMisses(ReadObjectQuery readObjectQuery) {
        QueryMonitor.checkDumpTime();
        String string = readObjectQuery.getReferenceClass().getName() + "-findByPrimaryKey";
        Number number = (Number)cacheMisses.get(string);
        if (number == null) {
            number = new Integer(0);
        }
        number = new Integer(number.intValue() + 1);
        cacheMisses.put(string, number);
    }

    public static void incrementReadAllHits(ReadAllQuery readAllQuery) {
        QueryMonitor.checkDumpTime();
        String string = readAllQuery.getReferenceClass().getName();
        string = readAllQuery.getName() == null ? string + "-findAll" : string + "-" + readAllQuery.getName();
        Number number = (Number)cacheHits.get(string);
        if (number == null) {
            number = new Integer(0);
        }
        number = new Integer(number.intValue() + 1);
        cacheHits.put(string, number);
    }

    public static void incrementReadAllMisses(ReadAllQuery readAllQuery) {
        QueryMonitor.checkDumpTime();
        String string = readAllQuery.getReferenceClass().getName();
        string = readAllQuery.getName() == null ? string + "-findAll" : string + "-" + readAllQuery.getName();
        Number number = (Number)cacheMisses.get(string);
        if (number == null) {
            number = new Integer(0);
        }
        number = new Integer(number.intValue() + 1);
        cacheMisses.put(string, number);
    }

    public static void incrementInsert(WriteObjectQuery writeObjectQuery) {
        QueryMonitor.checkDumpTime();
        String string = writeObjectQuery.getReferenceClass().getName() + "-insert";
        Number number = (Number)cacheMisses.get(string);
        if (number == null) {
            number = new Integer(0);
        }
        number = new Integer(number.intValue() + 1);
        cacheMisses.put(string, number);
    }

    public static void incrementUpdate(WriteObjectQuery writeObjectQuery) {
        QueryMonitor.checkDumpTime();
        String string = writeObjectQuery.getReferenceClass().getName() + "-update";
        Number number = (Number)cacheMisses.get(string);
        if (number == null) {
            number = new Integer(0);
        }
        number = new Integer(number.intValue() + 1);
        cacheMisses.put(string, number);
    }

    public static void incrementDelete(DeleteObjectQuery deleteObjectQuery) {
        QueryMonitor.checkDumpTime();
        String string = deleteObjectQuery.getReferenceClass().getName() + "-delete";
        Number number = (Number)cacheMisses.get(string);
        if (number == null) {
            number = new Integer(0);
        }
        number = new Integer(number.intValue() + 1);
        cacheMisses.put(string, number);
    }
}

