/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.tools.ejbjar;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.util.Hashtable;
import oracle.toplink.exceptions.EJBJarXMLException;
import oracle.toplink.internal.localization.ExceptionLocalization;
import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.platform.xml.XMLPlatform;
import oracle.toplink.platform.xml.XMLPlatformFactory;
import oracle.toplink.tools.ejbjar.XMLManager;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLParser {
    private static boolean allowNonEjb_2_0_DocType = false;
    static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final int OLD_VALIDATION = -2;
    public static final int NONVALIDATING = 0;
    public static final int SCHEMA_VALIDATION = 3;
    public static final int DTD_VALIDATION = 2;

    public static void allowNonEjb_2_0_DocType() {
        allowNonEjb_2_0_DocType = true;
    }

    public static void doNotAllowNonEjb_2_0_DocType() {
        allowNonEjb_2_0_DocType = false;
    }

    public static Document parseXML(String string) throws IOException, EJBJarXMLException {
        return XMLParser.parseXML(string, true);
    }

    public static Document parseXML(String string, boolean bl) throws IOException, EJBJarXMLException {
        File file = new File(string);
        if (file.exists()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            Document document = XMLParser.parseXML(new InputSource(new InputStreamReader((InputStream)fileInputStream, "UTF-8")), bl);
            fileInputStream.close();
            return document;
        }
        throw new FileNotFoundException(string);
    }

    public static Document parseXML(String string, int n) throws IOException, EJBJarXMLException {
        File file = new File(string);
        if (file.exists()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            Document document = XMLParser.parseXML(new InputSource(new InputStreamReader((InputStream)fileInputStream, "UTF-8")), n);
            fileInputStream.close();
            return document;
        }
        throw new FileNotFoundException(string);
    }

    public static Document parseXML(InputSource inputSource) throws IOException, EJBJarXMLException {
        return XMLParser.parseXML(inputSource, true);
    }

    public static Document parseXML(InputSource inputSource, boolean bl) throws IOException, EJBJarXMLException {
        return XMLParser.parseXML(inputSource, -2);
    }

    public static Document parseXML(InputSource inputSource, int n) throws IOException, EJBJarXMLException {
        Object object;
        if (inputSource == null) {
            throw new IOException(ExceptionLocalization.buildMessage("input_source_not_found", null));
        }
        XMLPlatform xMLPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
        oracle.toplink.platform.xml.XMLParser xMLParser = xMLPlatform.newXMLParser();
        xMLParser.setNamespaceAware(true);
        if (n == 3 || n == 2 || n == 0) {
            xMLParser.setValidationMode(n);
        } else if (n == -2) {
            object = System.getProperty("toplink.ejbjar.schemavalidation");
            if (object != null && ((String)object).equalsIgnoreCase("true")) {
                xMLParser.setValidationMode(3);
            } else {
                xMLParser.setValidationMode(2);
            }
        }
        object = new CustomDefaultHandler(n);
        xMLParser.setErrorHandler((ErrorHandler)object);
        xMLParser.setEntityResolver((EntityResolver)object);
        Document document = xMLParser.parse(inputSource);
        if (!allowNonEjb_2_0_DocType && !XMLParser.isEJB20DocType(document)) {
            throw EJBJarXMLException.nonEJB_2_0_DocType();
        }
        return document;
    }

    public static boolean isEJB20DocType(Document document) {
        DocumentType documentType = document.getDoctype();
        if (documentType == null) {
            String string = document.getDocumentElement().getAttribute("xmlns");
            if (string == null) {
                return false;
            }
            return string.equals("http://java.sun.com/xml/ns/j2ee");
        }
        return documentType.getPublicId().equals("-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN");
    }

    public static void main(String[] stringArray) {
        XMLParser xMLParser = new XMLParser();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        URL uRL = xMLParser.getClass().getResource("ejb-jar_2_0.dtd");
        if (uRL != null) {
            hashtable.put("http://java.sun.com/dtd/ejb-jar_2_0.dtd", uRL.toString());
            System.out.println("Put hashTable");
        } else {
            System.out.println("Man! could not put hashTable");
        }
        try {
            URL uRL2 = xMLParser.getClass().getResource("ejb-jar.xml");
            Document document = XMLParser.parseXML(uRL2.getFile());
        }
        catch (Exception exception) {
            System.out.println("Error - AJ " + exception.getMessage());
        }
    }

    static class CustomDefaultHandler
    extends DefaultHandler {
        private int validationMode;

        public CustomDefaultHandler(int n) {
            this.validationMode = n;
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException {
            if (this.validationMode == 0) {
                return new InputSource(new StringReader(""));
            }
            InputStream inputStream = PrivilegedAccessController.getClassLoaderForClass(this.getClass()).getResourceAsStream(XMLManager.EJB_JAR_DTD_2_0_LOCAL_RESOURCE);
            if (allowNonEjb_2_0_DocType) {
                inputStream = PrivilegedAccessController.getClassLoaderForClass(this.getClass()).getResourceAsStream(XMLManager.EJB_JAR_1_1_DTD_FILE_NAME);
            }
            if (inputStream != null) {
                return new InputSource(inputStream);
            }
            return null;
        }
    }
}

