/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.tools.ejb11;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import oracle.toplink.tools.ejb11.CMPBeanDefinition;
import oracle.toplink.tools.ejb11.DDDefinition;
import oracle.toplink.tools.ejb11.DDProjectDefinition;
import oracle.toplink.tools.ejb11.EJBXmlBeanDefinition;
import oracle.toplink.tools.ejb11.EJBXmlEntityBeanDefinition;
import oracle.toplink.tools.ejb11.EJBXmlWebLogicBeanDefinition;
import oracle.toplink.tools.ejb11.ProjectDefinition;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import weblogic.apache.xerces.dom.DocumentImpl;
import weblogic.apache.xerces.dom.DocumentTypeImpl;
import weblogic.apache.xml.serialize.OutputFormat;
import weblogic.apache.xml.serialize.XMLSerializer;

public class EJBXmlGenerator {
    private static String EJB_XML_FILE_NAME = "ejb-jar.xml";
    private static String EJB_DOCTYPE_DESC = "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN";
    private static String EJB_DOCTYPE_URL = "http://java.sun.com/j2ee/dtds/ejb-jar_1_1.dtd";
    private static String EJB_ROOT_ELEMENT = "ejb-jar";
    private static String EJB_ENTERPRISE_BEANS = "enterprise-beans";
    private static String EJB_ASSEMBLY_DESCRIPTOR = "assembly-descriptor";
    private static String WL_XML_FILE_NAME = "weblogic-ejb-jar.xml";
    private static String WL_DOCTYPE_DESC = "-//BEA Systems, Inc.//DTD WebLogic 6.0.0 EJB//EN";
    private static String WL_DOCTYPE_URL = "http://www.bea.com/servers/wls600/dtd/weblogic-ejb-jar.dtd";
    private static String WL_ROOT_ELEMENT = "weblogic-ejb-jar";

    public static void generateDDs(DDProjectDefinition dDProjectDefinition, Vector vector) throws IOException {
        int n = vector.size();
        ProjectDefinition projectDefinition = dDProjectDefinition.getProjectDefinition();
        Vector<EJBXmlEntityBeanDefinition> vector2 = new Vector<EJBXmlEntityBeanDefinition>(n);
        Vector<EJBXmlWebLogicBeanDefinition> vector3 = new Vector<EJBXmlWebLogicBeanDefinition>(n);
        Vector<CMPBeanDefinition> vector4 = new Vector<CMPBeanDefinition>(n);
        for (int i = 0; i < n; ++i) {
            DDDefinition dDDefinition = (DDDefinition)vector.elementAt(i);
            CMPBeanDefinition cMPBeanDefinition = dDDefinition.getCMPBeanDefinition();
            cMPBeanDefinition.setProject(projectDefinition);
            vector4.insertElementAt(cMPBeanDefinition, i);
            EJBXmlEntityBeanDefinition eJBXmlEntityBeanDefinition = dDDefinition.getEJBBeanDefinition();
            vector2.insertElementAt(eJBXmlEntityBeanDefinition, i);
            EJBXmlWebLogicBeanDefinition eJBXmlWebLogicBeanDefinition = dDDefinition.getWeblogicBeanDefinition();
            vector3.insertElementAt(eJBXmlWebLogicBeanDefinition, i);
        }
        EJBXmlGenerator.generateXMLFiles(vector2, vector3, vector4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateEJBFile(Vector vector) throws IOException {
        EJBXmlBeanDefinition eJBXmlBeanDefinition;
        DocumentTypeImpl documentTypeImpl = new DocumentTypeImpl(null, "", EJB_DOCTYPE_DESC, EJB_DOCTYPE_URL);
        DocumentImpl documentImpl = new DocumentImpl((DocumentType)documentTypeImpl);
        Element element = documentImpl.createElement(EJB_ROOT_ELEMENT);
        documentImpl.appendChild(element);
        Element element2 = documentImpl.createElement(EJB_ENTERPRISE_BEANS);
        element.appendChild(element2);
        for (int i = 0; i < vector.size(); ++i) {
            EJBXmlBeanDefinition eJBXmlBeanDefinition2 = (EJBXmlBeanDefinition)vector.elementAt(i);
            eJBXmlBeanDefinition2.storeBeanProperties(element2, (Document)documentImpl);
        }
        Element element3 = documentImpl.createElement(EJB_ASSEMBLY_DESCRIPTOR);
        element.appendChild(element3);
        for (int i = 0; i < vector.size(); ++i) {
            eJBXmlBeanDefinition = (EJBXmlBeanDefinition)vector.elementAt(i);
            eJBXmlBeanDefinition.storeAssemblyProperties(element3, (Document)documentImpl);
        }
        OutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(EJB_XML_FILE_NAME);
            eJBXmlBeanDefinition = new XMLSerializer(outputStream, new OutputFormat("xml", null, true));
            eJBXmlBeanDefinition.serialize((Document)documentImpl);
        }
        finally {
            outputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateTopCmpFile(CMPBeanDefinition cMPBeanDefinition, String string) throws IOException {
        OutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(string);
            XMLSerializer xMLSerializer = new XMLSerializer(outputStream, new OutputFormat("xml", null, true));
            xMLSerializer.serialize(cMPBeanDefinition.storeProperties());
        }
        finally {
            outputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateWebLogicFile(Vector vector) throws IOException {
        EJBXmlWebLogicBeanDefinition eJBXmlWebLogicBeanDefinition;
        DocumentTypeImpl documentTypeImpl = new DocumentTypeImpl(null, "", WL_DOCTYPE_DESC, WL_DOCTYPE_URL);
        DocumentImpl documentImpl = new DocumentImpl((DocumentType)documentTypeImpl);
        Element element = documentImpl.createElement(WL_ROOT_ELEMENT);
        documentImpl.appendChild(element);
        for (int i = 0; i < vector.size(); ++i) {
            eJBXmlWebLogicBeanDefinition = (EJBXmlWebLogicBeanDefinition)vector.elementAt(i);
            eJBXmlWebLogicBeanDefinition.storeProperties(element, (Document)documentImpl);
        }
        OutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(WL_XML_FILE_NAME);
            eJBXmlWebLogicBeanDefinition = new XMLSerializer(outputStream, new OutputFormat("xml", null, true));
            eJBXmlWebLogicBeanDefinition.serialize((Document)documentImpl);
        }
        finally {
            outputStream.close();
        }
    }

    public static void generateXMLFiles(Vector vector, Vector vector2, Vector vector3) throws IOException {
        int n = vector.size();
        if (vector2.size() != n || vector3.size() != n) {
            throw new IOException("Bean definition vector arguments are of different sizes");
        }
        EJBXmlGenerator.generateEJBFile(vector);
        EJBXmlGenerator.generateWebLogicFile(vector2);
        for (int i = 0; i < n; ++i) {
            EJBXmlWebLogicBeanDefinition eJBXmlWebLogicBeanDefinition = (EJBXmlWebLogicBeanDefinition)vector2.elementAt(i);
            String string = eJBXmlWebLogicBeanDefinition.getEjbName();
            CMPBeanDefinition cMPBeanDefinition = null;
            for (int j = 0; j < n && (cMPBeanDefinition = (CMPBeanDefinition)vector3.elementAt(j)).getEjbName() != string; ++j) {
            }
            if (cMPBeanDefinition.getEjbName() != string) {
                throw new IOException("Missing TopLink bean definition for " + string);
            }
            EJBXmlGenerator.generateTopCmpFile(cMPBeanDefinition, eJBXmlWebLogicBeanDefinition.topLinkBeanFileName());
        }
    }
}

