/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.tools.codegen;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.tools.codegen.ClassDefinition;

public class CodeGenerator {
    protected Writer output = new StringWriter();
    protected ClassDefinition currentClass;
    protected boolean useUnicode = true;

    public CodeGenerator() {
    }

    public CodeGenerator(boolean bl) {
        this();
        this.useUnicode = bl;
    }

    public void cr() {
        this.write(Helper.cr());
    }

    public ClassDefinition getCurrentClass() {
        return this.currentClass;
    }

    public Writer getOutput() {
        return this.output;
    }

    public void setCurrentClass(ClassDefinition classDefinition) {
        this.currentClass = classDefinition;
    }

    public void setOutput(Writer writer) {
        this.output = writer;
    }

    public void tab() {
        this.write("\t");
    }

    public void tab(int n) {
        for (int i = 0; i < n; ++i) {
            this.tab();
        }
    }

    public String toString() {
        return this.getOutput().toString();
    }

    public void write(Object object) {
        try {
            if (!this.useUnicode) {
                this.getOutput().write(String.valueOf(object));
            } else {
                String string = String.valueOf(object);
                StringBuffer stringBuffer = new StringBuffer(string.length() * 4);
                block7: for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (c < '\u007f') {
                        stringBuffer.append(c);
                        continue;
                    }
                    String string2 = Long.toHexString(c).toUpperCase();
                    switch (string2.length()) {
                        case 1: {
                            stringBuffer.append("\\u000" + string2);
                            continue block7;
                        }
                        case 2: {
                            stringBuffer.append("\\u00" + string2);
                            continue block7;
                        }
                        case 3: {
                            stringBuffer.append("\\u0" + string2);
                            continue block7;
                        }
                        default: {
                            stringBuffer.append("\\u" + string2);
                        }
                    }
                }
                this.getOutput().write(stringBuffer.toString());
            }
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    public void writeln(Object object) {
        this.write(object);
        this.cr();
    }

    public void writeType(String string) {
        int n;
        String string2 = string;
        if (this.getCurrentClass() != null && (n = string.lastIndexOf(46)) != -1) {
            String string3 = string.substring(n);
            if (this.getCurrentClass().getImports().contains(string3)) {
                string2 = string.substring(n, string.length());
            }
        }
        this.write(string2);
    }
}

