/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.sessions.entitymanager;

import java.util.HashMap;
import java.util.Map;
import oracle.toplink.sessions.entitymanager.EntityManagerFactory;
import oracle.toplink.sessions.entitymanager.spi.EntityManagerFactoryProvider;

public class Persistence {
    public static final String PROVIDER_NAME = "javax.persistence.provider";

    public static EntityManagerFactory createEntityManagerFactory(Map map) {
        String string = (String)map.get(PROVIDER_NAME);
        if (string == null) {
            string = System.getProperty(PROVIDER_NAME);
        }
        if (string == null) {
            return null;
        }
        try {
            EntityManagerFactoryProvider entityManagerFactoryProvider = (EntityManagerFactoryProvider)Class.forName(string).newInstance();
            return entityManagerFactoryProvider.createEntityManagerFactory(map);
        }
        catch (Exception exception) {
            throw new RuntimeException("Exception while instaniating provider " + string, exception);
        }
    }

    public static EntityManagerFactory createEntityManagerFactory() {
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        String string = System.getProperty(PROVIDER_NAME);
        if (string != null) {
            hashMap.put(PROVIDER_NAME, string);
        }
        return Persistence.createEntityManagerFactory(hashMap);
    }
}

