/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.sequencing;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Vector;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.databaseaccess.Accessor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.sequencing.Sequence;

public abstract class StandardSequence
extends Sequence {
    public StandardSequence() {
    }

    public StandardSequence(String string) {
        super(string);
    }

    public StandardSequence(String string, int n) {
        super(string, n);
    }

    public void onConnect() {
    }

    public void onDisconnect() {
    }

    protected abstract Number updateAndSelectSequence(Accessor var1, Session var2, String var3, int var4);

    public abstract boolean shouldAcquireValueAfterInsert();

    public abstract boolean shouldUseTransaction();

    public Object getGeneratedValue(Accessor accessor, Session session, String string) {
        if (this.shouldUsePreallocation()) {
            return null;
        }
        Number number = this.updateAndSelectSequence(accessor, session, string, 1);
        if (number == null) {
            throw DatabaseException.errorPreallocatingSequenceNumbers();
        }
        return number;
    }

    public Vector getGeneratedVector(Accessor accessor, Session session, String string, int n) {
        if (this.shouldUsePreallocation()) {
            Number number = this.updateAndSelectSequence(accessor, session, string, n);
            if (number == null) {
                throw DatabaseException.errorPreallocatingSequenceNumbers();
            }
            return this.createVector(number, string, n);
        }
        return null;
    }

    public boolean shouldOverrideExistingValue(String string, Object object) {
        if (this.shouldAcquireValueAfterInsert()) {
            return true;
        }
        return object instanceof BigDecimal ? ((BigDecimal)object).signum() <= 0 : (object instanceof BigInteger ? ((BigInteger)object).signum() <= 0 : object instanceof Number && ((Number)object).longValue() <= 0L);
    }

    protected Vector createVector(Number number, String string, int n) {
        BigDecimal bigDecimal = new BigDecimal(1.0);
        BigDecimal bigDecimal2 = number instanceof BigDecimal ? (BigDecimal)number : new BigDecimal(number.doubleValue());
        Vector<BigDecimal> vector = new Vector<BigDecimal>(n);
        if ((bigDecimal2 = bigDecimal2.subtract(new BigDecimal((double)n))).doubleValue() < -1.0) {
            throw ValidationException.sequenceSetupIncorrectly(string);
        }
        for (int i = n; i > 0; --i) {
            bigDecimal2 = bigDecimal2.add(bigDecimal);
            vector.addElement(bigDecimal2);
        }
        return vector;
    }
}

