/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.sdk;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.exceptions.OptimisticLockException;
import oracle.toplink.internal.descriptors.ObjectBuilder;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.identitymaps.CacheKey;
import oracle.toplink.internal.queryframework.ContainerPolicy;
import oracle.toplink.internal.sessions.ChangeRecord;
import oracle.toplink.internal.sessions.MergeManager;
import oracle.toplink.internal.sessions.ObjectChangeSet;
import oracle.toplink.internal.sessions.UnitOfWorkChangeSet;
import oracle.toplink.mappings.CollectionMapping;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.DeleteAllQuery;
import oracle.toplink.queryframework.DeleteObjectQuery;
import oracle.toplink.queryframework.InsertObjectQuery;
import oracle.toplink.queryframework.ReadAllQuery;
import oracle.toplink.queryframework.WriteObjectQuery;
import oracle.toplink.sdk.SDKCall;
import oracle.toplink.sdk.SDKCollectionMapping;
import oracle.toplink.sdk.SDKCollectionMappingHelper;
import oracle.toplink.sdk.SDKDescriptorException;
import oracle.toplink.sdk.SDKFieldValue;
import oracle.toplink.sessions.DatabaseRecord;

public class SDKObjectCollectionMapping
extends CollectionMapping
implements SDKCollectionMapping {
    protected transient Vector sourceForeignKeyFields;
    protected transient Vector targetKeyFields;
    protected transient Hashtable sourceForeignKeysToTargetKeys = new Hashtable(2);
    protected DatabaseField field;
    protected String referenceDataTypeName = "";

    public SDKObjectCollectionMapping() {
        this.sourceForeignKeyFields = new Vector(1);
        this.targetKeyFields = new Vector(1);
    }

    public void addAscendingOrdering(String string) {
        SDKDescriptorException.unsupported("query result ordering", this);
    }

    public void addDescendingOrdering(String string) {
        SDKDescriptorException.unsupported("query result ordering", this);
    }

    protected void addSourceForeignKeyField(DatabaseField databaseField, DatabaseField databaseField2) {
        this.getSourceForeignKeyFields().addElement(databaseField);
        this.getTargetKeyFields().addElement(databaseField2);
    }

    public void addSourceForeignKeyFieldName(String string, String string2) {
        this.addSourceForeignKeyField(new DatabaseField(string), new DatabaseField(string2));
    }

    public Object buildAddedElementFromChangeSet(Object object, MergeManager mergeManager) {
        ObjectChangeSet objectChangeSet = (ObjectChangeSet)object;
        if (this.shouldMergeCascadeParts(mergeManager)) {
            Object object2 = null;
            object2 = mergeManager.shouldMergeChangesIntoDistributedCache() ? objectChangeSet.getTargetVersionOfSourceObject(mergeManager.getSession(), true) : objectChangeSet.getUnitOfWorkClone();
            mergeManager.mergeChanges(object2, objectChangeSet);
        }
        return this.buildElementFromChangeSet(object, mergeManager);
    }

    public Object buildChangeSet(Object object, ObjectChangeSet objectChangeSet, Session session) {
        ObjectBuilder objectBuilder = session.getDescriptor(object).getObjectBuilder();
        return objectBuilder.createObjectChangeSet(object, (UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet(), session);
    }

    protected Object buildElementFromChangeSet(Object object, MergeManager mergeManager) {
        return ((ObjectChangeSet)object).getTargetVersionOfSourceObject(mergeManager.getSession());
    }

    public Object buildElementFromElement(Object object, MergeManager mergeManager) {
        if (this.shouldMergeCascadeParts(mergeManager)) {
            Object object2;
            ObjectChangeSet objectChangeSet = null;
            if (mergeManager.getSession().isUnitOfWork() && (object2 = (UnitOfWorkChangeSet)((UnitOfWork)mergeManager.getSession()).getUnitOfWorkChangeSet()) != null) {
                objectChangeSet = (ObjectChangeSet)((UnitOfWorkChangeSet)object2).getObjectChangeSetForClone(object);
            }
            object2 = mergeManager.getObjectToMerge(object);
            mergeManager.mergeChanges(object2, objectChangeSet);
        }
        return mergeManager.getTargetVersionOfSourceObject(object);
    }

    public Object buildRemovedElementFromChangeSet(Object object, MergeManager mergeManager) {
        ObjectChangeSet objectChangeSet = (ObjectChangeSet)object;
        if (!mergeManager.shouldMergeChangesIntoDistributedCache()) {
            mergeManager.registerRemovedNewObjectIfRequired(objectChangeSet.getUnitOfWorkClone());
        }
        return this.buildElementFromChangeSet(object, mergeManager);
    }

    public Object clone() {
        SDKObjectCollectionMapping sDKObjectCollectionMapping = (SDKObjectCollectionMapping)super.clone();
        sDKObjectCollectionMapping.setSourceForeignKeysToTargetKeys((Hashtable)this.getSourceForeignKeysToTargetKeys().clone());
        return sDKObjectCollectionMapping;
    }

    protected Vector collectFields() {
        Vector<DatabaseField> vector = new Vector<DatabaseField>(1);
        vector.addElement(this.getField());
        return vector;
    }

    public boolean compareElements(Object object, Object object2, Session session) {
        Vector vector;
        CacheKey cacheKey;
        Vector vector2 = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(object, session);
        CacheKey cacheKey2 = new CacheKey(vector2);
        if (!cacheKey2.equals(cacheKey = new CacheKey(vector = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(object2, session)))) {
            return false;
        }
        if (this.isPrivateOwned()) {
            return session.compareObjects(object, object2);
        }
        return true;
    }

    public boolean compareElementsForChange(Object object, Object object2, Session session) {
        return object == object2;
    }

    public ChangeRecord compareForChange(Object object, Object object2, ObjectChangeSet objectChangeSet, Session session) {
        if (this.getAttributeValueFromObject(object) != null && !this.isAttributeValueInstantiated(object)) {
            return null;
        }
        return new SDKCollectionMappingHelper(this).compareForChange(object, object2, objectChangeSet, session);
    }

    public boolean compareObjects(Object object, Object object2, Session session) {
        return new SDKCollectionMappingHelper(this).compareObjects(object, object2, session);
    }

    protected void deleteAll(DeleteObjectQuery deleteObjectQuery, Object object) throws DatabaseException {
        ((DeleteAllQuery)this.getDeleteAllQuery()).executeDeleteAll(deleteObjectQuery.getSession().getSessionForClass(this.getReferenceClass()), deleteObjectQuery.getTranslationRow(), this.getContainerPolicy().vectorFor(object, deleteObjectQuery.getSession()));
    }

    protected void deleteReferenceObjectsLeftOnDatabase(DeleteObjectQuery deleteObjectQuery) throws DatabaseException, OptimisticLockException {
        Object object = this.readPrivateOwnedForObject(deleteObjectQuery);
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object2 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object2)) {
            deleteObjectQuery.getSession().deleteObject(containerPolicy.next(object2, deleteObjectQuery.getSession()));
        }
    }

    public Vector extractForeignKeyRows(DatabaseRow databaseRow, Session session) {
        Object object = databaseRow.get(this.getField());
        if (object == null || !(object instanceof SDKFieldValue)) {
            return new Vector();
        }
        return this.getDescriptor().buildNestedRowsFromFieldValue(object, session);
    }

    protected DatabaseRow extractKeyRowFromReferenceObject(Object object, Session session) {
        DatabaseRecord databaseRecord = new DatabaseRecord(this.getSourceForeignKeysToTargetKeys().size());
        Enumeration enumeration = this.getSourceForeignKeysToTargetKeys().keys();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
            if (object == null) {
                databaseRecord.put(databaseField, (Object)null);
                continue;
            }
            DatabaseField databaseField2 = (DatabaseField)this.getSourceForeignKeysToTargetKeys().get(databaseField);
            databaseRecord.put(databaseField, this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(object, databaseField2, session));
        }
        return databaseRecord;
    }

    public DatabaseField getField() {
        return this.field;
    }

    public String getFieldName() {
        return this.getField().getName();
    }

    public Vector getOrderedForeignKeyFields() {
        Vector<DatabaseField> vector = new Vector<DatabaseField>(this.getReferenceDescriptor().getPrimaryKeyFields().size());
        Iterator iterator = this.getReferenceDescriptor().getPrimaryKeyFields().iterator();
        while (iterator.hasNext()) {
            DatabaseField databaseField = (DatabaseField)iterator.next();
            boolean bl = false;
            Enumeration enumeration = this.getSourceForeignKeysToTargetKeys().keys();
            while (enumeration.hasMoreElements()) {
                DatabaseField databaseField2 = (DatabaseField)enumeration.nextElement();
                if (!this.getSourceForeignKeysToTargetKeys().get(databaseField2).equals(databaseField)) continue;
                bl = true;
                vector.addElement(databaseField2);
                break;
            }
            if (bl) continue;
            throw SDKDescriptorException.missingForeignKeyTranslation(this, databaseField);
        }
        return vector;
    }

    public String getReferenceDataTypeName() {
        return this.referenceDataTypeName;
    }

    public Vector getSourceForeignKeyFields() {
        return this.sourceForeignKeyFields;
    }

    protected Hashtable getSourceForeignKeysToTargetKeys() {
        return this.sourceForeignKeysToTargetKeys;
    }

    public Vector getTargetKeyFields() {
        return this.targetKeyFields;
    }

    public boolean hasConstraintDependency() {
        return true;
    }

    public void initialize(Session session) throws DescriptorException {
        super.initialize(session);
        if (!this.isTargetKeySpecified()) {
            this.setTargetKeyFields(new Vector(this.getReferenceDescriptor().getPrimaryKeyFields()));
        }
        this.initializeSourceForeignKeysToTargetKeys();
        if (this.getField() == null) {
            throw DescriptorException.fieldNameNotSetInMapping(this);
        }
        this.getDescriptor().buildField(this.getField());
        if (!this.hasCustomSelectionQuery()) {
            throw SDKDescriptorException.customSelectionQueryRequired(this);
        }
    }

    protected void initializeSourceForeignKeysToTargetKeys() throws DescriptorException {
        if (this.getSourceForeignKeyFields().size() != this.getTargetKeyFields().size()) {
            throw DescriptorException.sizeMismatchOfForeignKeys(this);
        }
        Enumeration enumeration = this.getTargetKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            this.getReferenceDescriptor().buildField((DatabaseField)enumeration.nextElement());
        }
        enumeration = this.getSourceForeignKeyFields().elements();
        Enumeration enumeration2 = this.getTargetKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            this.getSourceForeignKeysToTargetKeys().put(enumeration.nextElement(), enumeration2.nextElement());
        }
    }

    protected boolean isTargetKeySpecified() {
        return !this.getTargetKeyFields().isEmpty();
    }

    public boolean mapKeyHasChanged(Object object, Session session) {
        return !this.getContainerPolicy().compareKeys(object, session);
    }

    public void mergeChangesIntoObject(Object object, ChangeRecord changeRecord, Object object2, MergeManager mergeManager) {
        new SDKCollectionMappingHelper(this).mergeChangesIntoObject(object, changeRecord, object2, mergeManager);
    }

    public void mergeIntoObject(Object object, boolean bl, Object object2, MergeManager mergeManager) {
        if (bl && mergeManager.shouldMergeWorkingCopyIntoOriginal() && !this.isAttributeValueInstantiated(object2)) {
            this.setAttributeValueInObject(object, this.getIndirectionPolicy().getOriginalIndirectionObject(this.getAttributeValueFromObject(object2), mergeManager.getSession()));
            return;
        }
        if (!this.shouldMergeCascadeReference(mergeManager)) {
            return;
        }
        if (mergeManager.shouldRefreshRemoteObject() && this.shouldMergeCascadeParts(mergeManager) && this.usesIndirection()) {
            this.mergeRemoteValueHolder(object, object2, mergeManager);
            return;
        }
        if (mergeManager.shouldMergeOriginalIntoWorkingCopy() ? !this.isAttributeValueInstantiated(object) : !this.isAttributeValueInstantiated(object2)) {
            return;
        }
        new SDKCollectionMappingHelper(this).mergeIntoObject(object, bl, object2, mergeManager);
    }

    public void postDelete(DeleteObjectQuery deleteObjectQuery) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(deleteObjectQuery)) {
            return;
        }
        Object object = this.getRealCollectionAttributeValueFromObject(deleteObjectQuery.getObject(), deleteObjectQuery.getSession());
        if (this.hasCustomDeleteAllQuery()) {
            this.deleteAll(deleteObjectQuery, object);
        } else {
            ContainerPolicy containerPolicy = this.getContainerPolicy();
            Object object2 = containerPolicy.iteratorFor(object);
            while (containerPolicy.hasNext(object2)) {
                DeleteObjectQuery deleteObjectQuery2 = new DeleteObjectQuery();
                deleteObjectQuery2.setObject(containerPolicy.next(object2, deleteObjectQuery.getSession()));
                deleteObjectQuery2.setCascadePolicy(deleteObjectQuery.getCascadePolicy());
                deleteObjectQuery.getSession().executeQuery(deleteObjectQuery2);
            }
            if (!deleteObjectQuery.getSession().isUnitOfWork()) {
                this.deleteReferenceObjectsLeftOnDatabase(deleteObjectQuery);
            }
        }
    }

    public void preInsert(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(writeObjectQuery)) {
            return;
        }
        if (writeObjectQuery.shouldCascadeOnlyDependentParts()) {
            return;
        }
        Object object = this.getRealCollectionAttributeValueFromObject(writeObjectQuery.getObject(), writeObjectQuery.getSession());
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object2 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object2)) {
            UnitOfWorkChangeSet unitOfWorkChangeSet;
            WriteObjectQuery writeObjectQuery2;
            Object object3 = containerPolicy.next(object2, writeObjectQuery.getSession());
            if (this.isPrivateOwned()) {
                writeObjectQuery2 = new InsertObjectQuery();
                writeObjectQuery2.setObject(object3);
                writeObjectQuery2.setCascadePolicy(writeObjectQuery.getCascadePolicy());
                writeObjectQuery.getSession().executeQuery(writeObjectQuery2);
                continue;
            }
            if (writeObjectQuery.getSession().getCommitManager().isCommitInPreModify(object3)) continue;
            writeObjectQuery2 = new WriteObjectQuery();
            if (writeObjectQuery.getSession().isUnitOfWork() && (unitOfWorkChangeSet = (UnitOfWorkChangeSet)((UnitOfWork)writeObjectQuery.getSession()).getUnitOfWorkChangeSet()) != null) {
                writeObjectQuery2.setObjectChangeSet((ObjectChangeSet)unitOfWorkChangeSet.getObjectChangeSetForClone(object3));
            }
            writeObjectQuery2.setObject(object3);
            writeObjectQuery2.setCascadePolicy(writeObjectQuery.getCascadePolicy());
            writeObjectQuery.getSession().executeQuery(writeObjectQuery2);
        }
    }

    public void preUpdate(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(writeObjectQuery)) {
            return;
        }
        if (!this.isAttributeValueInstantiated(writeObjectQuery.getObject())) {
            return;
        }
        Object object = this.getRealCollectionAttributeValueFromObject(writeObjectQuery.getObject(), writeObjectQuery.getSession());
        Object object2 = this.readPrivateOwnedForObject(writeObjectQuery);
        this.compareObjectsAndWrite(object2, object, writeObjectQuery);
    }

    protected void setField(DatabaseField databaseField) {
        this.field = databaseField;
    }

    public void setFieldName(String string) {
        this.setField(new DatabaseField(string));
    }

    public void setReferenceDataTypeName(String string) {
        this.referenceDataTypeName = string;
    }

    public void setSelectionCall(SDKCall sDKCall) {
        ReadAllQuery readAllQuery = new ReadAllQuery();
        readAllQuery.setCall(sDKCall);
        this.setCustomSelectionQuery(readAllQuery);
    }

    public void setSourceForeignKeyFieldName(String string) {
        this.getSourceForeignKeyFields().addElement(new DatabaseField(string));
    }

    public void setSourceForeignKeyFieldNames(String[] stringArray, String[] stringArray2) {
        if (stringArray.length != stringArray2.length) {
            throw DescriptorException.sizeMismatchOfForeignKeys(this);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.addSourceForeignKeyFieldName(stringArray[i], stringArray2[i]);
        }
    }

    protected void setSourceForeignKeyFields(Vector vector) {
        this.sourceForeignKeyFields = vector;
    }

    protected void setSourceForeignKeysToTargetKeys(Hashtable hashtable) {
        this.sourceForeignKeysToTargetKeys = hashtable;
    }

    protected void setTargetKeyFields(Vector vector) {
        this.targetKeyFields = vector;
    }

    public void setUsesBatchReading(boolean bl) {
        SDKDescriptorException.unsupported("batch reading", this);
    }

    public void simpleAddToCollectionChangeRecord(Object object, Object object2, ObjectChangeSet objectChangeSet, Session session) {
        new SDKCollectionMappingHelper(this).simpleAddToCollectionChangeRecord(object, object2, objectChangeSet, session);
    }

    public void simpleRemoveFromCollectionChangeRecord(Object object, Object object2, ObjectChangeSet objectChangeSet, Session session) {
        new SDKCollectionMappingHelper(this).simpleRemoveFromCollectionChangeRecord(object, object2, objectChangeSet, session);
    }

    public void writeFromObjectIntoRow(Object object, DatabaseRow databaseRow, Session session) {
        if (this.isReadOnly()) {
            return;
        }
        DatabaseRow databaseRow2 = this.getIndirectionPolicy().extractReferenceRow(this.getAttributeValueFromObject(object));
        if (databaseRow2 != null) {
            databaseRow.put(this.getField(), databaseRow2.get(this.getField()));
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object2 = this.getRealCollectionAttributeValueFromObject(object, session);
        Vector<DatabaseRow> vector = new Vector<DatabaseRow>(containerPolicy.sizeFor(object2));
        Object object3 = containerPolicy.iteratorFor(object2);
        while (containerPolicy.hasNext(object3)) {
            Object object4 = containerPolicy.next(object3, session);
            DatabaseRow databaseRow3 = this.extractKeyRowFromReferenceObject(object4, session);
            vector.addElement(databaseRow3);
        }
        object3 = null;
        if (!vector.isEmpty()) {
            object3 = this.getDescriptor().buildFieldValueFromForeignKeys(vector, this.getReferenceDataTypeName(), session);
        }
        databaseRow.put(this.getField(), object3);
    }

    public void writeFromObjectIntoRowForShallowInsert(Object object, DatabaseRow databaseRow, Session session) {
        if (this.isReadOnly()) {
            return;
        }
        databaseRow.put(this.getField(), (Object)null);
    }

    public void writeFromObjectIntoRowForShallowInsertWithChangeRecord(ChangeRecord changeRecord, DatabaseRow databaseRow, Session session) {
        if (this.isReadOnly()) {
            return;
        }
        databaseRow.put(this.getField(), (Object)null);
    }

    public void writeFromObjectIntoRowForUpdate(WriteObjectQuery writeObjectQuery, DatabaseRow databaseRow) throws DescriptorException {
        Object object;
        Object object2;
        if (!this.isAttributeValueInstantiated(writeObjectQuery.getObject())) {
            return;
        }
        Session session = writeObjectQuery.getSession();
        if (session.isUnitOfWork() && this.compareObjectsWithoutPrivateOwned(object2 = this.getRealCollectionAttributeValueFromObject(writeObjectQuery.getObject(), session), object = this.getRealCollectionAttributeValueFromObject(writeObjectQuery.getBackupClone(), session), session)) {
            return;
        }
        this.writeFromObjectIntoRow(writeObjectQuery.getObject(), databaseRow, session);
    }

    public void writeFromObjectIntoRowWithChangeRecord(ChangeRecord changeRecord, DatabaseRow databaseRow, Session session) {
        Object object = ((ObjectChangeSet)changeRecord.getOwner()).getUnitOfWorkClone();
        this.writeFromObjectIntoRow(object, databaseRow, session);
    }

    public void writeInsertFieldsIntoRow(DatabaseRow databaseRow, Session session) {
        if (this.isReadOnly()) {
            return;
        }
        databaseRow.put(this.getField(), (Object)null);
    }

    public boolean isAggregateCollectionMapping() {
        return true;
    }
}

