/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.remote.rmi.wls;

import java.rmi.RemoteException;
import java.rmi.server.ObjID;
import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.exceptions.CommunicationException;
import oracle.toplink.internal.helper.IdentityHashtable;
import oracle.toplink.internal.remote.ConnectToSessionCommand;
import oracle.toplink.internal.remote.RemoteCommand;
import oracle.toplink.internal.remote.RemoteConnection;
import oracle.toplink.internal.remote.RemoteCursoredStream;
import oracle.toplink.internal.remote.RemoteScrollableCursor;
import oracle.toplink.internal.remote.RemoteUnitOfWork;
import oracle.toplink.internal.remote.RemoteValueHolder;
import oracle.toplink.internal.remote.Transporter;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.queryframework.CursoredStreamPolicy;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.queryframework.ReadQuery;
import oracle.toplink.queryframework.ScrollableCursorPolicy;
import oracle.toplink.remote.DistributedSession;
import oracle.toplink.remote.RemoteSession;
import oracle.toplink.remote.rmi.wls.RMIRemoteSessionController;
import oracle.toplink.sessions.Login;
import oracle.toplink.sessions.Session;

public class RMIConnection
extends RemoteConnection {
    RMIRemoteSessionController remoteSessionController;

    public RMIConnection(RMIRemoteSessionController rMIRemoteSessionController) {
        this.remoteSessionController = rMIRemoteSessionController;
    }

    public void processCommand(RemoteCommand remoteCommand) {
        try {
            Transporter transporter = new Transporter();
            transporter.setObject(remoteCommand);
            transporter = this.getRemoteSessionController().processCommand(transporter);
            if (!transporter.wasOperationSuccessful()) {
                throw transporter.getException();
            }
        }
        catch (RemoteException remoteException) {
            throw CommunicationException.errorInInvocation(remoteException);
        }
    }

    public void addRemoteControllerForSynchronization(Object object) throws Exception {
        ConnectToSessionCommand connectToSessionCommand = new ConnectToSessionCommand();
        connectToSessionCommand.setRemoteConnection(new RMIConnection((RMIRemoteSessionController)object));
        this.processCommand(connectToSessionCommand);
    }

    public void beginTransaction() {
        try {
            Transporter transporter = this.getRemoteSessionController().beginTransaction();
            if (!transporter.wasOperationSuccessful()) {
                throw transporter.getException();
            }
        }
        catch (RemoteException remoteException) {
            throw CommunicationException.errorInInvocation(remoteException);
        }
    }

    public RemoteUnitOfWork commitRootUnitOfWork(RemoteUnitOfWork remoteUnitOfWork) {
        try {
            Transporter transporter = this.getRemoteSessionController().commitRootUnitOfWork(new Transporter(remoteUnitOfWork));
            if (!transporter.wasOperationSuccessful()) {
                throw transporter.getException();
            }
            return (RemoteUnitOfWork)transporter.getObject();
        }
        catch (RemoteException remoteException) {
            throw CommunicationException.errorInInvocation(remoteException);
        }
    }

    public void commitTransaction() {
        try {
            Transporter transporter = this.getRemoteSessionController().commitTransaction();
            if (!transporter.wasOperationSuccessful()) {
                throw transporter.getException();
            }
        }
        catch (RemoteException remoteException) {
            throw CommunicationException.errorInInvocation(remoteException);
        }
    }

    public Session createRemoteSession() {
        return new RemoteSession(this);
    }

    public void cursoredStreamClose(ObjID objID) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().cursoredStreamClose(new Transporter(objID));
        }
        catch (RemoteException remoteException) {
            throw CommunicationException.errorInInvocation(remoteException);
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
    }

    public Vector cursoredStreamNextPage(RemoteCursoredStream remoteCursoredStream, ReadQuery readQuery, RemoteSession remoteSession, int n) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().cursoredStreamNextPage(new Transporter(remoteCursoredStream.getID()), n);
        }
        catch (RemoteException remoteException) {
            throw CommunicationException.errorInInvocation(remoteException);
        }
        if (transporter == null) {
            return null;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        Vector<Object> vector = (Vector<Object>)transporter.getObject();
        if (vector == null) {
            this.cursoredStreamClose(remoteCursoredStream.getID());
            return null;
        }
        Vector<Object> vector2 = vector;
        if (readQuery.isReadAllQuery() && !readQuery.isReportQuery()) {
            vector2 = new Vector<Object>(vector.size());
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Object object = remoteSession.getObjectCorrespondingTo(enumeration.nextElement(), transporter.getObjectDescriptors(), new IdentityHashtable(), (ObjectLevelReadQuery)readQuery);
                vector2.addElement(object);
            }
        }
        return vector2;
    }

    public int cursoredStreamSize(ObjID objID) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().cursoredStreamSize(new Transporter(objID));
        }
        catch (RemoteException remoteException) {
            throw CommunicationException.errorInInvocation(remoteException);
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Integer)transporter.getObject();
    }

    public RemoteCursoredStream cursorSelectObjects(CursoredStreamPolicy cursoredStreamPolicy, DistributedSession distributedSession) {
        try {
            Transporter transporter = this.getRemoteSessionController().cursorSelectObjects(new Transporter(cursoredStreamPolicy));
            if (!transporter.wasOperationSuccessful()) {
                throw transporter.getException();
            }
            RemoteCursoredStream remoteCursoredStream = (RemoteCursoredStream)transporter.getObject();
            remoteCursoredStream.setSession((RemoteSession)distributedSession);
            remoteCursoredStream.setPolicy(cursoredStreamPolicy);
            if (cursoredStreamPolicy.getQuery().isReadAllQuery() && !cursoredStreamPolicy.getQuery().isReportQuery()) {
                this.fixObjectReferences(transporter, (ObjectLevelReadQuery)cursoredStreamPolicy.getQuery(), (RemoteSession)distributedSession);
            }
            return remoteCursoredStream;
        }
        catch (RemoteException remoteException) {
            throw CommunicationException.errorInInvocation(remoteException);
        }
    }

    public RemoteScrollableCursor cursorSelectObjects(ScrollableCursorPolicy scrollableCursorPolicy, DistributedSession distributedSession) {
        try {
            Transporter transporter = this.getRemoteSessionController().cursorSelectObjects(new Transporter(scrollableCursorPolicy));
            if (!transporter.wasOperationSuccessful()) {
                throw transporter.getException();
            }
            RemoteScrollableCursor remoteScrollableCursor = (RemoteScrollableCursor)transporter.getObject();
            remoteScrollableCursor.setSession((RemoteSession)distributedSession);
            remoteScrollableCursor.setPolicy(scrollableCursorPolicy);
            return remoteScrollableCursor;
        }
        catch (RemoteException remoteException) {
            throw CommunicationException.errorInInvocation(remoteException);
        }
    }

    public void fixObjectReferences(Transporter transporter, ObjectLevelReadQuery objectLevelReadQuery, RemoteSession remoteSession) {
        RemoteCursoredStream remoteCursoredStream = (RemoteCursoredStream)transporter.getObject();
        Vector vector = remoteCursoredStream.getObjectCollection();
        if (objectLevelReadQuery.isReadAllQuery() && !objectLevelReadQuery.isReportQuery()) {
            Vector<Object> vector2 = new Vector<Object>(vector.size());
            IdentityHashtable identityHashtable = new IdentityHashtable(vector.size() + 1);
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                vector2.addElement(remoteSession.getObjectCorrespondingTo(e, transporter.getObjectDescriptors(), identityHashtable, objectLevelReadQuery));
            }
            remoteCursoredStream.setObjectCollection(vector2);
        }
    }

    public Vector getDefaultReadOnlyClasses() {
        try {
            Transporter transporter = this.getRemoteSessionController().getDefaultReadOnlyClasses();
            if (!transporter.wasOperationSuccessful()) {
                throw transporter.getException();
            }
            return (Vector)transporter.getObject();
        }
        catch (RemoteException remoteException) {
            throw CommunicationException.errorInInvocation(remoteException);
        }
    }

    public Descriptor getDescriptor(Class clazz) {
        try {
            Transporter transporter = this.getRemoteSessionController().getDescriptor(new Transporter(clazz));
            if (!transporter.wasOperationSuccessful()) {
                throw transporter.getException();
            }
            return (Descriptor)transporter.getObject();
        }
        catch (RemoteException remoteException) {
            throw CommunicationException.errorInInvocation(remoteException);
        }
    }

    public Login getLogin() {
        try {
            Transporter transporter = this.getRemoteSessionController().getLogin();
            if (!transporter.wasOperationSuccessful()) {
                throw transporter.getException();
            }
            return (Login)transporter.getObject();
        }
        catch (RemoteException remoteException) {
            throw CommunicationException.errorInInvocation(remoteException);
        }
    }

    public RMIRemoteSessionController getRemoteSessionController() {
        return this.remoteSessionController;
    }

    public Object getSequenceNumberNamed(Object object) {
        try {
            Transporter transporter = this.getRemoteSessionController().getSequenceNumberNamed(new Transporter(object));
            Object object2 = transporter.getObject();
            if (!transporter.wasOperationSuccessful()) {
                throw transporter.getException();
            }
            return object2;
        }
        catch (RemoteException remoteException) {
            throw CommunicationException.errorInInvocation(remoteException);
        }
    }

    public void initializeIdentityMapsOnServerSession() {
        try {
            Transporter transporter = this.getRemoteSessionController().initializeIdentityMapsOnServerSession();
            if (!transporter.wasOperationSuccessful()) {
                throw transporter.getException();
            }
        }
        catch (RemoteException remoteException) {
            throw CommunicationException.errorInInvocation(remoteException);
        }
    }

    public Transporter instantiateRemoteValueHolderOnServer(RemoteValueHolder remoteValueHolder) {
        try {
            Transporter transporter = this.getRemoteSessionController().instantiateRemoteValueHolderOnServer(new Transporter(remoteValueHolder));
            if (!transporter.wasOperationSuccessful()) {
                throw transporter.getException();
            }
            return transporter;
        }
        catch (RemoteException remoteException) {
            throw CommunicationException.errorInInvocation(remoteException);
        }
    }

    public Transporter remoteExecute(DatabaseQuery databaseQuery) {
        try {
            Transporter transporter = this.getRemoteSessionController().executeQuery(new Transporter(databaseQuery));
            if (!transporter.wasOperationSuccessful()) {
                throw transporter.getException();
            }
            return transporter;
        }
        catch (RemoteException remoteException) {
            throw CommunicationException.errorInInvocation(remoteException);
        }
    }

    public Transporter remoteExecuteNamedQuery(String string, Class clazz, Vector vector) {
        try {
            Transporter transporter = this.getRemoteSessionController().executeNamedQuery(new Transporter(string), new Transporter(clazz), new Transporter(vector));
            if (!transporter.wasOperationSuccessful()) {
                throw transporter.getException();
            }
            return transporter;
        }
        catch (RemoteException remoteException) {
            throw CommunicationException.errorInInvocation(remoteException);
        }
    }

    public void rollbackTransaction() {
        try {
            Transporter transporter = this.getRemoteSessionController().rollbackTransaction();
            if (!transporter.wasOperationSuccessful()) {
                throw transporter.getException();
            }
        }
        catch (RemoteException remoteException) {
            throw CommunicationException.errorInInvocation(remoteException);
        }
    }

    public boolean scrollableCursorAbsolute(ObjID objID, int n) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().scrollableCursorAbsolute(new Transporter(objID), n);
        }
        catch (RemoteException remoteException) {
            throw CommunicationException.errorInInvocation(remoteException);
        }
        if (transporter == null) {
            return false;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Boolean)transporter.getObject();
    }

    public void scrollableCursorAfterLast(ObjID objID) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().scrollableCursorAfterLast(new Transporter(objID));
        }
        catch (RemoteException remoteException) {
            throw CommunicationException.errorInInvocation(remoteException);
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
    }

    public void scrollableCursorBeforeFirst(ObjID objID) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().scrollableCursorBeforeFirst(new Transporter(objID));
        }
        catch (RemoteException remoteException) {
            throw CommunicationException.errorInInvocation(remoteException);
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
    }

    public void scrollableCursorClose(ObjID objID) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().scrollableCursorClose(new Transporter(objID));
        }
        catch (RemoteException remoteException) {
            throw CommunicationException.errorInInvocation(remoteException);
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
    }

    public int scrollableCursorCurrentIndex(ObjID objID) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().scrollableCursorAfterLast(new Transporter(objID));
        }
        catch (RemoteException remoteException) {
            throw CommunicationException.errorInInvocation(remoteException);
        }
        if (transporter == null) {
            return -1;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Integer)transporter.getObject();
    }

    public boolean scrollableCursorFirst(ObjID objID) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().scrollableCursorFirst(new Transporter(objID));
        }
        catch (RemoteException remoteException) {
            throw CommunicationException.errorInInvocation(remoteException);
        }
        if (transporter == null) {
            return false;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Boolean)transporter.getObject();
    }

    public boolean scrollableCursorIsAfterLast(ObjID objID) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().scrollableCursorIsAfterLast(new Transporter(objID));
        }
        catch (RemoteException remoteException) {
            throw CommunicationException.errorInInvocation(remoteException);
        }
        if (transporter == null) {
            return false;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Boolean)transporter.getObject();
    }

    public boolean scrollableCursorIsBeforeFirst(ObjID objID) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().scrollableCursorIsBeforeFirst(new Transporter(objID));
        }
        catch (RemoteException remoteException) {
            throw CommunicationException.errorInInvocation(remoteException);
        }
        if (transporter == null) {
            return false;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Boolean)transporter.getObject();
    }

    public boolean scrollableCursorIsFirst(ObjID objID) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().scrollableCursorIsFirst(new Transporter(objID));
        }
        catch (RemoteException remoteException) {
            throw CommunicationException.errorInInvocation(remoteException);
        }
        if (transporter == null) {
            return false;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Boolean)transporter.getObject();
    }

    public boolean scrollableCursorIsLast(ObjID objID) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().scrollableCursorIsLast(new Transporter(objID));
        }
        catch (RemoteException remoteException) {
            throw CommunicationException.errorInInvocation(remoteException);
        }
        if (transporter == null) {
            return false;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Boolean)transporter.getObject();
    }

    public boolean scrollableCursorLast(ObjID objID) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().scrollableCursorLast(new Transporter(objID));
        }
        catch (RemoteException remoteException) {
            throw CommunicationException.errorInInvocation(remoteException);
        }
        if (transporter == null) {
            return false;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Boolean)transporter.getObject();
    }

    public Object scrollableCursorNextObject(ObjID objID, ReadQuery readQuery, RemoteSession remoteSession) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().scrollableCursorNextObject(new Transporter(objID));
        }
        catch (RemoteException remoteException) {
            throw CommunicationException.errorInInvocation(remoteException);
        }
        if (transporter == null) {
            return null;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        Object object = transporter.getObject();
        if (object == null) {
            return null;
        }
        if (readQuery.isReadAllQuery() && !readQuery.isReportQuery()) {
            object = remoteSession.getObjectCorrespondingTo(object, transporter.getObjectDescriptors(), new IdentityHashtable(), (ObjectLevelReadQuery)readQuery);
        }
        return object;
    }

    public Object scrollableCursorPreviousObject(ObjID objID, ReadQuery readQuery, RemoteSession remoteSession) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().scrollableCursorPreviousObject(new Transporter(objID));
        }
        catch (RemoteException remoteException) {
            throw CommunicationException.errorInInvocation(remoteException);
        }
        if (transporter == null) {
            return null;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        Object object = transporter.getObject();
        if (object == null) {
            return null;
        }
        if (readQuery.isReadAllQuery() && !readQuery.isReportQuery()) {
            object = remoteSession.getObjectCorrespondingTo(object, transporter.getObjectDescriptors(), new IdentityHashtable(), (ObjectLevelReadQuery)readQuery);
        }
        return object;
    }

    public boolean scrollableCursorRelative(ObjID objID, int n) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().scrollableCursorRelative(new Transporter(objID), n);
        }
        catch (RemoteException remoteException) {
            throw CommunicationException.errorInInvocation(remoteException);
        }
        if (transporter == null) {
            return false;
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Boolean)transporter.getObject();
    }

    public int scrollableCursorSize(ObjID objID) {
        Transporter transporter = null;
        try {
            transporter = this.getRemoteSessionController().scrollableCursorSize(new Transporter(objID));
        }
        catch (RemoteException remoteException) {
            throw CommunicationException.errorInInvocation(remoteException);
        }
        if (!transporter.wasOperationSuccessful()) {
            throw transporter.getException();
        }
        return (Integer)transporter.getObject();
    }

    public void setRemoteSessionController(RMIRemoteSessionController rMIRemoteSessionController) {
        this.remoteSessionController = rMIRemoteSessionController;
    }
}

