/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.remote;

import java.util.Vector;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.helper.IdentityHashtable;
import oracle.toplink.internal.identitymaps.IdentityMapManager;
import oracle.toplink.internal.queryframework.ContainerPolicy;
import oracle.toplink.internal.remote.RemoteConnection;
import oracle.toplink.internal.remote.RemoteCursoredStream;
import oracle.toplink.internal.remote.RemoteScrollableCursor;
import oracle.toplink.internal.remote.RemoteValueHolder;
import oracle.toplink.internal.remote.Transporter;
import oracle.toplink.internal.sessions.AbstractSession;
import oracle.toplink.internal.sessions.DistributedSessionIdentityMapAccessor;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.CursoredStreamPolicy;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.queryframework.ScrollableCursorPolicy;
import oracle.toplink.sessions.Project;

public abstract class DistributedSession
extends AbstractSession {
    protected transient RemoteConnection remoteConnection;

    protected DistributedSession(int n) {
    }

    public DistributedSession(RemoteConnection remoteConnection) {
        this.remoteConnection = remoteConnection;
        this.project = new Project();
    }

    public abstract UnitOfWork acquireUnitOfWork();

    public void beginTransaction() {
        this.getTransactionMutex().acquire();
        this.getRemoteConnection().beginTransaction();
    }

    public void commitTransaction() {
        this.getRemoteConnection().commitTransaction();
        this.getTransactionMutex().release();
    }

    public RemoteCursoredStream cursorSelectObjects(CursoredStreamPolicy cursoredStreamPolicy) {
        return this.getRemoteConnection().cursorSelectObjects(cursoredStreamPolicy, this);
    }

    public RemoteScrollableCursor cursorSelectObjects(ScrollableCursorPolicy scrollableCursorPolicy) {
        return this.getRemoteConnection().cursorSelectObjects(scrollableCursorPolicy, this);
    }

    public Object executeQuery(String string) throws DatabaseException {
        return this.executeQuery(string, new Vector(1));
    }

    public Object executeQuery(String string, Class clazz) throws DatabaseException {
        return this.executeQuery(string, clazz, new Vector(1));
    }

    public Object executeQuery(String string, Class clazz, Vector vector) throws DatabaseException {
        Transporter transporter = this.getRemoteConnection().remoteExecuteNamedQuery(string, clazz, vector);
        transporter.getQuery().setSession(this);
        return transporter.getQuery().extractRemoteResult(transporter);
    }

    public Object executeQuery(String string, Vector vector) throws DatabaseException {
        if (this.containsQuery(string)) {
            return super.executeQuery(string, vector);
        }
        return this.executeQuery(string, null, vector);
    }

    public abstract Object executeQuery(DatabaseQuery var1);

    public Object executeQuery(DatabaseQuery databaseQuery, DatabaseRow databaseRow) {
        databaseQuery.setTranslationRow(databaseRow);
        return this.executeQuery(databaseQuery);
    }

    public Vector getDefaultReadOnlyClasses() {
        Vector vector = this.getRemoteConnection().getDefaultReadOnlyClasses();
        return vector;
    }

    public Descriptor getDescriptor(Class clazz) {
        Descriptor descriptor = (Descriptor)this.getDescriptors().get(clazz);
        if (descriptor == null) {
            descriptor = this.getRemoteConnection().getDescriptor(clazz);
            if (descriptor == null) {
                return null;
            }
            this.getDescriptors().put(clazz, descriptor);
            descriptor.remoteInitialization(this);
        }
        return descriptor;
    }

    public Descriptor getDescriptorCorrespondingTo(Descriptor descriptor) {
        return (Descriptor)this.getDescriptors().get(descriptor.getJavaClass());
    }

    public abstract Object getObjectCorrespondingTo(Object var1, IdentityHashtable var2, IdentityHashtable var3, ObjectLevelReadQuery var4);

    public abstract Object getObjectsCorrespondingToAll(Object var1, IdentityHashtable var2, IdentityHashtable var3, ObjectLevelReadQuery var4, ContainerPolicy var5);

    public RemoteConnection getRemoteConnection() {
        return this.remoteConnection;
    }

    public boolean hasCorrespondingDescriptor(Descriptor descriptor) {
        return this.getDescriptors().containsKey(descriptor.getJavaClass());
    }

    public void initializeIdentityMapAccessor() {
        this.identityMapAccessor = new DistributedSessionIdentityMapAccessor(this, new IdentityMapManager(this));
    }

    public abstract Object instantiateRemoteValueHolderOnServer(RemoteValueHolder var1);

    public boolean isDistributedSession() {
        return true;
    }

    public boolean isRemoteSession() {
        return false;
    }

    public void privilegedAddDescriptor(Descriptor descriptor) {
        this.getDescriptors().put(descriptor.getJavaClass(), descriptor);
    }

    public void rollbackTransaction() {
        this.getRemoteConnection().rollbackTransaction();
        this.getTransactionMutex().release();
    }

    protected void setRemoteConnection(RemoteConnection remoteConnection) {
        this.remoteConnection = remoteConnection;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "()";
    }

    public void release() {
        this.remoteConnection.release();
    }
}

