/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.remote;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import oracle.toplink.exceptions.SynchronizationException;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.remote.AbstractClusteringService;

public abstract class AbstractJNDIClusteringService
extends AbstractClusteringService {
    protected Context localContext;
    protected String userName;
    protected String password;
    protected Hashtable contextProperties;

    public AbstractJNDIClusteringService(oracle.toplink.sessions.Session session) {
        this(DEFAULT_MULTICAST_GROUP, DEFAULT_MULTICAST_PORT, session);
    }

    public AbstractJNDIClusteringService(String string, int n, oracle.toplink.sessions.Session session) {
        super(string, n, session);
    }

    public Context getLocalContext() {
        if (this.localContext == null) {
            ((Session)this.getSession()).log(1, "propagation", "getting_local_initial_context");
            this.localContext = this.getContext(this.getInitialContextProperties());
        }
        return this.localContext;
    }

    public Context getContext(String string) {
        try {
            Hashtable<String, String> hashtable = new Hashtable<String, String>(2);
            hashtable.put("java.naming.provider.url", string);
            return new InitialContext(hashtable);
        }
        catch (NamingException namingException) {
            this.getSession().handleException(SynchronizationException.errorLookingUpController(string, namingException));
            return null;
        }
    }

    public Context getContext(Hashtable hashtable) {
        try {
            return new InitialContext(hashtable);
        }
        catch (NamingException namingException) {
            this.getSession().handleException(SynchronizationException.errorLookingUpController(hashtable.toString(), namingException));
            return null;
        }
    }

    public void setContext(Context context) {
        this.localContext = context;
    }

    public void setLocalHostURL(String string) {
        this.localHostURL = string;
        this.getInitialContextProperties().put("java.naming.provider.url", string);
    }

    public Hashtable getInitialContextProperties() {
        if (this.contextProperties == null) {
            this.contextProperties = new Hashtable(2);
        }
        return this.contextProperties;
    }

    public void setInitialContextProperties(Hashtable hashtable) {
        this.contextProperties = hashtable;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String string) {
        this.userName = string;
        this.getInitialContextProperties().put("java.naming.security.principal", string);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
        this.getInitialContextProperties().put("java.naming.security.credentials", string);
    }

    public void setInitialContextFactoryName(String string) {
        this.getInitialContextProperties().put("java.naming.factory.initial", string);
    }
}

