/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.remote;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.rmi.RemoteException;
import java.rmi.server.UID;
import oracle.toplink.exceptions.SynchronizationException;
import oracle.toplink.internal.remote.ConnectToSessionCommand;
import oracle.toplink.internal.remote.RemoteConnection;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.remote.DistributedSessionReconnectPolicy;
import oracle.toplink.remote.SessionAnnouncement;

public abstract class AbstractClusteringService
extends Thread {
    protected boolean stopListening = false;
    protected int multicastPort;
    protected int timeToLive = 2;
    protected int announcementDelay = 0;
    protected MulticastSocket communicationSocket;
    protected String multicastGroupAddress;
    protected Object dispatcher;
    protected String localHostURL;
    protected oracle.toplink.sessions.Session session;
    protected static int DEFAULT_RECV_BUFFER_SIZE = 128;
    protected static String DEFAULT_MULTICAST_GROUP = "226.18.6.18";
    protected static int DEFAULT_MULTICAST_PORT = 6018;
    protected String sessionId;
    protected DistributedSessionReconnectPolicy reconnectionPolicy;
    protected String applicationName;

    public AbstractClusteringService(oracle.toplink.sessions.Session session) {
        this(DEFAULT_MULTICAST_GROUP, DEFAULT_MULTICAST_PORT, session);
    }

    public AbstractClusteringService(String string, int n, oracle.toplink.sessions.Session session) {
        this.multicastPort = n;
        this.multicastGroupAddress = string;
        this.session = session;
        this.reconnectionPolicy = new DistributedSessionReconnectPolicy();
    }

    public void initialize() {
        this.stopListening();
        if (this.getCommunicationSocket() != null) {
            this.getCommunicationSocket().close();
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.communicationSocket = null;
        this.start();
    }

    public void run() {
        ((Session)this.getSession()).log(1, "propagation", "initializing_local_discovery_communication_socket");
        this.getCommunicationSocket();
        this.setSessionId(this.buildSessionId());
        ((Session)this.getSession()).log(1, "propagation", "place_local_remote_session_dispatcher_into_naming_service");
        this.registerDispatcher();
        this.getSession().getCacheSynchronizationManager().setSessionRemoteConnection(this.getLocalRemoteConnection());
        ((Session)this.getSession()).log(1, "propagation", "connecting_to_other_sessions");
        try {
            AbstractClusteringService.sleep(this.getAnnouncementDelay());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.announceSession(this.getSessionId());
        ((Session)this.getSession()).log(1, "propagation", "done");
        this.listen();
    }

    public abstract void registerDispatcher();

    public abstract void deregisterDispatcher();

    public abstract RemoteConnection createRemoteConnection(String var1, String var2);

    public void setMulticastPort(int n) {
        this.multicastPort = n;
    }

    public int getMulticastPort() {
        return this.multicastPort;
    }

    public DistributedSessionReconnectPolicy getReconnectPolicy() {
        return this.reconnectionPolicy;
    }

    public void setReconnectPolicy(DistributedSessionReconnectPolicy distributedSessionReconnectPolicy) {
        this.reconnectionPolicy = distributedSessionReconnectPolicy;
    }

    public void setLocalHostURL(String string) {
        this.localHostURL = string;
    }

    public void setTimeToLive(int n) {
        this.timeToLive = n;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public abstract MulticastSocket getCommunicationSocket();

    public String getMulticastGroupAddress() {
        return this.multicastGroupAddress;
    }

    public void setMulticastGroupAddress(String string) {
        this.multicastGroupAddress = string;
    }

    public abstract Object getDispatcher() throws RemoteException;

    public abstract RemoteConnection getLocalRemoteConnection();

    public oracle.toplink.sessions.Session getSession() {
        return this.session;
    }

    public void setDispatcher(Object object) {
        this.dispatcher = object;
    }

    public String getLocalHostURL() {
        return this.localHostURL;
    }

    public void connectBackToRemote(RemoteConnection remoteConnection) throws Exception {
        ConnectToSessionCommand connectToSessionCommand = new ConnectToSessionCommand();
        connectToSessionCommand.setRemoteConnection(this.getLocalRemoteConnection());
        remoteConnection.processCommand(connectToSessionCommand);
    }

    public String buildSessionId() {
        String string = new UID().toString();
        try {
            string = string + InetAddress.getLocalHost().getHostAddress().replace('.', '-') + "-";
        }
        catch (IOException iOException) {
            this.getSession().handleException(SynchronizationException.errorLookingUpLocalHost(iOException));
        }
        string = string + System.identityHashCode(this.getSession());
        return string.replace(':', '-');
    }

    public void announceSession(String string) {
        SessionAnnouncement sessionAnnouncement = new SessionAnnouncement(string, this.getLocalHostURL(), this.getApplicationName() == null ? "" : this.getApplicationName());
        byte[] byArray = sessionAnnouncement.toBytes();
        try {
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, InetAddress.getByName(this.getMulticastGroupAddress()), this.getMulticastPort());
            this.getCommunicationSocket().send(datagramPacket);
        }
        catch (Exception exception) {
            SynchronizationException synchronizationException = SynchronizationException.errorNotifyingCluster(exception);
            this.getSession().handleException(synchronizationException);
        }
        ((Session)this.getSession()).log(2, "propagation", "announcement_sent_from", this.getSessionId());
    }

    public void listen() {
        this.stopListening = false;
        byte[] byArray = new byte[DEFAULT_RECV_BUFFER_SIZE];
        while (!this.stopListening) {
            SessionAnnouncement sessionAnnouncement;
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
            try {
                this.getCommunicationSocket().receive(datagramPacket);
            }
            catch (IOException iOException) {
                if (!this.stopListening) {
                    this.getSession().handleException(SynchronizationException.errorReceivingAnnouncement(this.getSessionId(), iOException));
                }
                return;
            }
            try {
                sessionAnnouncement = new SessionAnnouncement(datagramPacket.getData());
            }
            catch (SynchronizationException synchronizationException) {
                ((Session)this.getSession()).log(6, "propagation", "corrupted_session_announcement", this.getSessionId());
                continue;
            }
            if (this.getSessionId().equals(sessionAnnouncement.getSessionId())) continue;
            this.receivedAnnouncement(sessionAnnouncement.getSessionId(), sessionAnnouncement.getJNDIHostURL(), sessionAnnouncement.getApplicationName());
        }
    }

    public void receivedAnnouncement(String string, String string2, String string3) {
        ((Session)this.getSession()).log(2, "propagation", "announcement_received_from", string);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        stringBuffer.append(string3);
        RemoteConnection remoteConnection = this.createRemoteConnection(string, stringBuffer.toString());
        this.getSession().getCacheSynchronizationManager().addRemoteConnection(remoteConnection);
    }

    public RemoteConnection reconnect(RemoteConnection remoteConnection) {
        return this.getReconnectPolicy().reconnect(remoteConnection);
    }

    public void setSessionId(String string) {
        this.sessionId = string;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void stopListening() {
        this.stopListening = true;
        if (this.getCommunicationSocket() != null) {
            this.getCommunicationSocket().close();
        }
    }

    public void setSession(oracle.toplink.sessions.Session session) {
        this.session = session;
    }

    public void setAnnouncementDelay(int n) {
        this.announcementDelay = n;
    }

    public void setApplicationName(String string) {
        this.applicationName = string;
    }

    public int getAnnouncementDelay() {
        return this.announcementDelay;
    }

    public String getApplicationName() {
        return this.applicationName;
    }
}

