/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.queryframework;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.OptimisticLockException;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.expressions.ExpressionBuilder;
import oracle.toplink.internal.descriptors.OptimisticLockingPolicy;
import oracle.toplink.internal.queryframework.ExpressionQueryMechanism;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.InMemoryQueryIndirectionPolicy;
import oracle.toplink.queryframework.ModifyQuery;
import oracle.toplink.sessions.IdentityMapAccessor;

public class UpdateAllQuery
extends ModifyQuery {
    public static final int NO_CACHE = 0;
    public static final int INVALIDATE_CACHE = 1;
    private Class m_referenceClass;
    protected HashMap m_updateClauses;
    private int m_cacheUsage = 1;
    protected ExpressionBuilder m_builder;
    private boolean shouldDeferExecutionInUOW;

    public UpdateAllQuery() {
        this.m_updateClauses = new HashMap();
        this.shouldDeferExecutionInUOW = true;
    }

    public UpdateAllQuery(Class clazz) {
        this();
        this.setReferenceClass(clazz);
    }

    public UpdateAllQuery(Class clazz, Expression expression) {
        this();
        this.setReferenceClass(clazz);
        this.setSelectionCriteria(expression);
    }

    public UpdateAllQuery(Class clazz, ExpressionBuilder expressionBuilder) {
        this.setReferenceClass(clazz);
        this.setExpressionBuilder(expressionBuilder);
    }

    public void addUpdate(Expression expression, Object object) {
        this.addUpdate(expression, expression.getBuilder().value(object));
    }

    public void addUpdate(String string, Object object) {
        this.addUpdate(this.getExpressionBuilder().get(string), this.getExpressionBuilder().value(object));
    }

    public void addUpdate(Expression expression, Expression expression2) {
        if (expression2 == null) {
            this.addUpdate(expression, (Object)null);
        } else {
            expression2.getBuilder().setSession(this.getSession());
            expression.getBuilder().setSession(this.getSession());
            expression2.getBuilder().setQueryClass(this.getReferenceClass());
            expression.getBuilder().setQueryClass(this.getReferenceClass());
            this.m_updateClauses.put(expression, expression2);
        }
    }

    protected void clonedQueryExecutionComplete(DatabaseQuery databaseQuery, Session session) {
        super.clonedQueryExecutionComplete(databaseQuery, session);
        if (session.isUnitOfWork()) {
            ((UnitOfWork)session).storeUpdateAllQuery(databaseQuery);
        }
    }

    public Object executeInUnitOfWork(UnitOfWork unitOfWork, DatabaseRow databaseRow) throws DatabaseException, OptimisticLockException {
        if (unitOfWork.isNestedUnitOfWork()) {
            throw ValidationException.nestedUOWNotSupportedForUpdateAllQuery();
        }
        if (this.shouldDeferExecutionInUOW()) {
            unitOfWork.storeDeferredUpdateAllQuery(this, databaseRow);
            return null;
        }
        return super.executeInUnitOfWork(unitOfWork, databaseRow);
    }

    public Object executeDatabaseQuery() throws DatabaseException {
        Integer n = this.getQueryMechanism().updateAll();
        this.mergeChangesIntoSharedCache();
        return n;
    }

    public int getCacheUsage() {
        return this.m_cacheUsage;
    }

    public ExpressionBuilder getExpressionBuilder() {
        if (this.m_builder == null) {
            this.initializeBuilder();
        }
        return this.m_builder;
    }

    public Class getReferenceClass() {
        return this.m_referenceClass;
    }

    public String getReferenceClassName() {
        return this.getReferenceClass().getName();
    }

    public HashMap getUpdateClauses() {
        return this.m_updateClauses;
    }

    protected void initializeBuilder() {
        ExpressionBuilder expressionBuilder = ((ExpressionQueryMechanism)this.getQueryMechanism()).getExpressionBuilder();
        if (expressionBuilder == null) {
            if (this.m_updateClauses.isEmpty()) {
                this.m_builder = new ExpressionBuilder(this.getReferenceClass());
            } else {
                Iterator iterator = this.m_updateClauses.keySet().iterator();
                Expression expression = (Expression)iterator.next();
                this.m_builder = expression.getBuilder();
            }
        } else {
            this.m_builder = expressionBuilder;
        }
        this.m_builder.setSession(this.getSession());
    }

    protected void invalidateCache() {
        if (this.getSelectionCriteria() == null) {
            this.getSession().getIdentityMapAccessor().invalidateClass(this.getReferenceClass());
        } else {
            IdentityMapAccessor identityMapAccessor = this.getSession().getIdentityMapAccessor();
            Vector vector = identityMapAccessor.getAllFromIdentityMap(this.getSelectionCriteria(), this.getSelectionCriteria().getBuilder().getQueryClass(), this.getTranslationRow(), new InMemoryQueryIndirectionPolicy());
            identityMapAccessor.invalidateObjects(vector);
        }
    }

    public boolean isUpdateAllQuery() {
        return true;
    }

    public void mergeChangesIntoSharedCache() {
        if (this.shouldInvalidateCache()) {
            this.invalidateCache();
        }
    }

    protected void prepare() throws QueryException {
        ExpressionBuilder expressionBuilder;
        Expression expression;
        Descriptor descriptor;
        super.prepare();
        Class clazz = this.getReferenceClass();
        if (clazz == null) {
            throw QueryException.referenceClassMissing(this);
        }
        if (this.getDescriptor() == null) {
            descriptor = this.getSession().getDescriptor(clazz);
            if (descriptor == null) {
                throw QueryException.descriptorIsMissing(clazz, this);
            }
            this.setDescriptor(descriptor);
        }
        if ((descriptor = this.getDescriptor()).isAggregateDescriptor()) {
            throw QueryException.aggregateObjectCannotBeDeletedOrWritten(descriptor, this);
        }
        if (descriptor.hasInheritance() && descriptor.getTables().size() > 1) {
            throw QueryException.inheritanceWithMultipleTablesNotSupported();
        }
        if (this.getUpdateClauses().isEmpty()) {
            throw QueryException.updateStatementsNotSpecified();
        }
        OptimisticLockingPolicy optimisticLockingPolicy = descriptor.getOptimisticLockingPolicy();
        if (optimisticLockingPolicy != null && (expression = optimisticLockingPolicy.getWriteLockUpdateExpression(expressionBuilder = this.getExpressionBuilder())) != null) {
            Expression expression2 = expressionBuilder.getField(optimisticLockingPolicy.getWriteLockField().getName());
            this.addUpdate(expression2, expression);
        }
        this.getQueryMechanism().prepareUpdateAll();
    }

    public void setCacheUsage(int n) {
        this.m_cacheUsage = n;
    }

    public void setExpressionBuilder(ExpressionBuilder expressionBuilder) {
        this.m_builder = expressionBuilder;
    }

    public void setReferenceClass(Class clazz) {
        if (this.m_referenceClass != clazz) {
            this.setIsPrepared(false);
        }
        this.m_referenceClass = clazz;
    }

    public void setShouldDeferExecutionInUOW(boolean bl) {
        this.shouldDeferExecutionInUOW = bl;
    }

    public boolean shouldDeferExecutionInUOW() {
        return this.shouldDeferExecutionInUOW;
    }

    protected boolean shouldInvalidateCache() {
        return this.m_cacheUsage == 1;
    }
}

