/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.queryframework;

import java.util.List;
import java.util.Vector;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.expressions.ExpressionBuilder;
import oracle.toplink.internal.descriptors.ObjectBuilder;
import oracle.toplink.internal.helper.IdentityHashtable;
import oracle.toplink.internal.helper.InvalidObject;
import oracle.toplink.internal.indirection.ProxyIndirectionPolicy;
import oracle.toplink.internal.remote.RemoteSessionController;
import oracle.toplink.internal.remote.Transporter;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.DescriptorQueryManager;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.Call;
import oracle.toplink.queryframework.ComplexQueryResult;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.queryframework.QueryByExamplePolicy;
import oracle.toplink.remote.RemoteSession;
import oracle.toplink.tools.profiler.QueryMonitor;

public class ReadObjectQuery
extends ObjectLevelReadQuery {
    protected transient Object selectionObject;
    protected Vector selectionKey;
    protected boolean shouldLoadResultIntoSelectionObject = false;

    public ReadObjectQuery() {
    }

    public ReadObjectQuery(Class clazz) {
        this();
        this.setReferenceClass(clazz);
    }

    public ReadObjectQuery(Class clazz, Expression expression) {
        this();
        this.setReferenceClass(clazz);
        this.setSelectionCriteria(expression);
    }

    public ReadObjectQuery(Class clazz, ExpressionBuilder expressionBuilder) {
        this();
        this.defaultBuilder = expressionBuilder;
        this.setReferenceClass(clazz);
    }

    public ReadObjectQuery(Class clazz, Call call) {
        this();
        this.setReferenceClass(clazz);
        this.setCall(call);
    }

    public ReadObjectQuery(Call call) {
        this();
        this.setCall(call);
    }

    public ReadObjectQuery(Object object) {
        this();
        this.setSelectionObject(object);
    }

    public ReadObjectQuery(Object object, QueryByExamplePolicy queryByExamplePolicy) {
        this();
        this.setExampleObject(object);
        this.setQueryByExamplePolicy(queryByExamplePolicy);
    }

    public ReadObjectQuery(ExpressionBuilder expressionBuilder) {
        this();
        this.defaultBuilder = expressionBuilder;
    }

    public void cacheResult(Object object) {
        Object object2 = object;
        if (this.shouldUseWrapperPolicy()) {
            object2 = this.getSession().wrapObject(object);
        }
        this.setTemporaryCachedQueryResults(object2);
    }

    public void checkCache() {
        this.setCacheUsage(2);
    }

    public void checkCacheByExactPrimaryKey() {
        this.setCacheUsage(1);
    }

    public void checkCacheByPrimaryKey() {
        this.setCacheUsage(2);
    }

    public void checkCacheThenDatabase() {
        this.setCacheUsage(3);
    }

    public void checkDescriptor(Session session) throws QueryException {
        if (this.getReferenceClass() == null) {
            throw QueryException.referenceClassMissing(this);
        }
        if (this.getDescriptor() == null) {
            Descriptor descriptor = this.getSelectionObject() != null && session.getProject().hasProxyIndirection() ? session.getDescriptor(this.getSelectionObject()) : session.getDescriptor(this.getReferenceClass());
            if (descriptor == null) {
                throw QueryException.descriptorIsMissing(this.getReferenceClass(), this);
            }
            this.setDescriptor(descriptor);
        }
    }

    protected Object checkEarlyReturnImpl(Session session, DatabaseRow databaseRow) {
        if (!(!this.shouldMaintainCache() || this.shouldRefreshIdentityMapResult() || session.isRemoteSession() && (this.shouldRefreshRemoteIdentityMapResult() || this.getDescriptor().shouldDisableCacheHitsOnRemote()) || this.shouldCheckDescriptorForCacheUsage() && this.getDescriptor().shouldDisableCacheHits() || this.getDescriptor().isDescriptorForInterface() || !this.shouldCheckCache())) {
            Object object = this.getQueryMechanism().checkCacheForObject(databaseRow, session);
            if (object == InvalidObject.instance) {
                return object;
            }
            if (object != null) {
                if (this.shouldLoadResultIntoSelectionObject()) {
                    ObjectBuilder objectBuilder = this.getDescriptor().getObjectBuilder();
                    objectBuilder.copyInto(object, this.getSelectionObject());
                    session.getIdentityMapAccessorInstance().putInIdentityMap(this.getSelectionObject());
                    object = this.getSelectionObject();
                }
                if (this.isLockQuery() && session.isUnitOfWork() && !((UnitOfWork)session).isPessimisticLocked(object)) {
                    if (QueryMonitor.shouldMonitor()) {
                        QueryMonitor.incrementReadObjectMisses(this);
                    }
                    return null;
                }
                if (QueryMonitor.shouldMonitor()) {
                    QueryMonitor.incrementReadObjectHits(this);
                }
            } else if (QueryMonitor.shouldMonitor()) {
                QueryMonitor.incrementReadObjectMisses(this);
            }
            if (this.shouldUseWrapperPolicy()) {
                object = this.getDescriptor().getObjectBuilder().wrapObject(object, session);
            }
            return object;
        }
        if (QueryMonitor.shouldMonitor()) {
            QueryMonitor.incrementReadObjectMisses(this);
        }
        return null;
    }

    protected DatabaseQuery checkForCustomQuery(Session session, DatabaseRow databaseRow) {
        this.checkDescriptor(session);
        if (this.isCustomQueryUsed() == null) {
            DescriptorQueryManager descriptorQueryManager;
            if (!(this.isUserDefined() || this.isCallQuery() || !(descriptorQueryManager = this.getDescriptor().getQueryManager()).hasReadObjectQuery() || this.hasJoinedAttributes() && !this.getJoinedAttributeExpressions().isEmpty() || this.hasPartialAttributeExpressions() || this.hasAsOfClause() || this.hasNonDefaultFetchGroup() || this.getHintString() != null || !this.wasDefaultLockMode() || !this.shouldIgnoreBindAllParameters())) {
                DatabaseRow databaseRow2;
                if (this.getSelectionKey() != null || this.getSelectionObject() != null) {
                    this.setIsCustomQueryUsed(true);
                } else if (this.getSelectionCriteria() != null && (databaseRow2 = this.getDescriptor().getObjectBuilder().extractPrimaryKeyRowFromExpression(this.getSelectionCriteria(), databaseRow, session)) != null) {
                    this.setIsCustomQueryUsed(true);
                }
            }
            if (this.isCustomQueryUsed() == null) {
                this.setIsCustomQueryUsed(false);
            }
        }
        if (this.isCustomQueryUsed().booleanValue()) {
            return this.getDescriptor().getQueryManager().getReadObjectQuery();
        }
        return null;
    }

    protected Object conformResult(Object object, UnitOfWork unitOfWork, DatabaseRow databaseRow, boolean bl) {
        Object object2;
        Object object3 = null;
        object3 = bl ? object : this.getDescriptor().getObjectBuilder().unwrapObject(object, unitOfWork.getParent());
        Expression expression = null;
        if (this.getSelectionCriteria() != null && this.getSelectionKey() == null && this.getSelectionObject() == null) {
            expression = (Expression)this.getSelectionCriteria().clone();
            expression.getBuilder().setSession(unitOfWork);
            expression.getBuilder().setQueryClass(this.getReferenceClass());
        }
        if ((object2 = this.conformIndividualResult(object3, unitOfWork, databaseRow, expression, null, bl)) == null) {
            return object2;
        }
        if (this.shouldUseWrapperPolicy()) {
            return this.getDescriptor().getObjectBuilder().wrapObject(object2, unitOfWork);
        }
        return object2;
    }

    public void dontLoadResultIntoSelectionObject() {
        this.setShouldLoadResultIntoSelectionObject(false);
    }

    public Object execute(Session session, DatabaseRow databaseRow) throws DatabaseException {
        if (this.shouldCacheQueryResults()) {
            Object object;
            if (this.shouldConformResultsInUnitOfWork()) {
                throw QueryException.cannotConformAndCacheQueryResults(this);
            }
            if (this.isPrepared() && (object = this.getQueryResults(session, databaseRow, true)) != null) {
                if (session.isUnitOfWork()) {
                    object = ((UnitOfWork)session).registerExistingObject(object);
                }
                return object;
            }
        }
        return super.execute(session, databaseRow);
    }

    protected Object executeObjectLevelReadQuery() throws DatabaseException {
        Object object;
        if (this.getDescriptor().isDescriptorForInterface()) {
            Object object2 = this.getDescriptor().getInterfacePolicy().selectOneObjectUsingMultipleTableSubclassRead(this);
            this.setExecutionTime(System.currentTimeMillis());
            return object2;
        }
        DatabaseRow databaseRow = null;
        if (this.isOneToManyJoinQuery()) {
            object = this.getQueryMechanism().selectAllRows();
            if (object.size() > 0) {
                databaseRow = (DatabaseRow)object.get(0);
            }
            this.setDataResults((List)object);
        } else {
            databaseRow = this.getQueryMechanism().selectOneRow();
        }
        this.setExecutionTime(System.currentTimeMillis());
        object = null;
        if (this.getSession().isUnitOfWork()) {
            object = this.registerResultInUnitOfWork(databaseRow, (UnitOfWork)this.getSession(), this.getTranslationRow(), true);
        } else if (databaseRow != null) {
            object = this.buildObject(databaseRow);
        }
        if (this.shouldIncludeData()) {
            ComplexQueryResult complexQueryResult = new ComplexQueryResult();
            complexQueryResult.setResult(object);
            complexQueryResult.setData(databaseRow);
            return complexQueryResult;
        }
        return object;
    }

    public Object extractRemoteResult(Transporter transporter) {
        return ((RemoteSession)this.getSession()).getObjectCorrespondingTo(transporter.getObject(), transporter.getObjectDescriptors(), new IdentityHashtable(), this);
    }

    public Vector getSelectionKey() {
        return this.selectionKey;
    }

    public Object getSelectionObject() {
        return this.selectionObject;
    }

    public boolean isReadObjectQuery() {
        return true;
    }

    public void loadResultIntoSelectionObject() {
        this.setShouldLoadResultIntoSelectionObject(true);
    }

    protected void prepare() throws QueryException {
        super.prepare();
        if (this.getSelectionKey() != null || this.getSelectionObject() != null) {
            this.setSelectionCriteria(this.getDescriptor().getObjectBuilder().getPrimaryKeyExpression());
            if (!this.shouldPrepare()) {
                if (this.getSelectionKey() != null) {
                    this.setTranslationRow(this.getDescriptor().getObjectBuilder().buildRowFromPrimaryKeyValues(this.getSelectionKey(), this.getSession()));
                } else {
                    this.setTranslationRow(this.getDescriptor().getObjectBuilder().buildRowForTranslation(this.getSelectionObject(), this.getSession()));
                }
            }
        }
        if (this.getDescriptor().isDescriptorForInterface()) {
            return;
        }
        if (this.isOneToManyJoinQuery()) {
            this.getQueryMechanism().prepareSelectAllRows();
        } else {
            this.getQueryMechanism().prepareSelectOneRow();
        }
    }

    protected void prepareCustomQuery(DatabaseQuery databaseQuery) {
        ReadObjectQuery readObjectQuery = (ReadObjectQuery)databaseQuery;
        readObjectQuery.setShouldRefreshIdentityMapResult(this.shouldRefreshIdentityMapResult());
        readObjectQuery.setCascadePolicy(this.getCascadePolicy());
        readObjectQuery.setShouldMaintainCache(this.shouldMaintainCache());
        readObjectQuery.setShouldUseWrapperPolicy(this.shouldUseWrapperPolicy());
        readObjectQuery.setQueryId(this.getQueryId());
        readObjectQuery.setExecutionTime(this.getExecutionTime());
        readObjectQuery.setShouldLoadResultIntoSelectionObject(this.shouldLoadResultIntoSelectionObject());
        if (this.getSelectionObject() != null) {
            readObjectQuery.setSelectionObject(this.getSelectionObject());
        } else if (this.getSelectionKey() != null) {
            readObjectQuery.setSelectionKey(this.getSelectionKey());
        } else {
            DatabaseRow databaseRow = databaseQuery.getDescriptor().getObjectBuilder().extractPrimaryKeyRowFromExpression(this.getSelectionCriteria(), databaseQuery.getTranslationRow(), readObjectQuery.getSession());
            readObjectQuery.setTranslationRow(databaseRow);
        }
    }

    public void prepareForExecution() throws QueryException {
        super.prepareForExecution();
        if (this.shouldPrepare()) {
            if (this.getSelectionKey() != null) {
                this.setTranslationRow(this.getDescriptor().getObjectBuilder().buildRowFromPrimaryKeyValues(this.getSelectionKey(), this.getSession()));
            } else if (this.getSelectionObject() != null) {
                this.setTranslationRow(this.getDescriptor().getObjectBuilder().buildRowForTranslation(this.getSelectionObject(), this.getSession()));
            }
        }
    }

    protected void prePrepare() throws QueryException {
        super.prePrepare();
        if (this.getSelectionObject() != null && this.getSession().getProject().hasProxyIndirection()) {
            this.setSelectionObject(ProxyIndirectionPolicy.getValueFromProxy(this.getSelectionObject()));
        }
    }

    public Object registerResultInUnitOfWork(Object object, UnitOfWork unitOfWork, DatabaseRow databaseRow, boolean bl) {
        if (object == null) {
            return null;
        }
        if (this.shouldConformResultsInUnitOfWork() || this.getDescriptor().shouldAlwaysConformResultsInUnitOfWork()) {
            return this.conformResult(object, unitOfWork, databaseRow, bl);
        }
        Object object2 = null;
        object2 = bl ? this.buildObject((DatabaseRow)object) : this.registerIndividualResult(object, unitOfWork);
        if (this.shouldUseWrapperPolicy()) {
            object2 = this.getDescriptor().getObjectBuilder().wrapObject(object2, unitOfWork);
        }
        return object2;
    }

    protected Object remoteExecute() {
        Object object;
        this.checkDescriptor(this.session);
        if (this.getSelectionObject() != null) {
            this.setSelectionKey(this.getDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(this.getSelectionObject(), this.session));
        }
        if ((object = this.checkEarlyReturn(this.getSession(), this.getTranslationRow())) != null || this.shouldCheckCacheOnly()) {
            return object;
        }
        return super.remoteExecute();
    }

    public IdentityHashtable replaceValueHoldersIn(Object object, RemoteSessionController remoteSessionController) {
        return remoteSessionController.replaceValueHoldersIn(object);
    }

    public void setCheckCache(boolean bl) {
        if (bl) {
            this.setCacheUsage(2);
        } else {
            this.setCacheUsage(0);
        }
    }

    public void setSelectionKey(Vector vector) {
        this.selectionKey = vector;
    }

    public void setSelectionObject(Object object) {
        if (object == null) {
            throw QueryException.selectionObjectCannotBeNull(this);
        }
        this.setSelectionKey(null);
        if (this.selectionObject == null || this.selectionObject.getClass() != object.getClass()) {
            this.setIsPrepared(false);
        }
        this.setReferenceClass(object.getClass());
        this.selectionObject = object;
    }

    public void setShouldLoadResultIntoSelectionObject(boolean bl) {
        this.shouldLoadResultIntoSelectionObject = bl;
    }

    public void setSingletonSelectionKey(Object object) {
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(object);
        this.setSelectionKey(vector);
    }

    public boolean shouldCheckCache() {
        return this.getCacheUsage() != 0;
    }

    public boolean shouldCheckCacheByExactPrimaryKey() {
        return this.getCacheUsage() == 1;
    }

    public boolean shouldCheckCacheByPrimaryKey() {
        return this.getCacheUsage() == 2 || this.getCacheUsage() == -1;
    }

    public boolean shouldCheckCacheThenDatabase() {
        return this.getCacheUsage() == 3;
    }

    public boolean shouldLoadResultIntoSelectionObject() {
        return this.shouldLoadResultIntoSelectionObject;
    }

    protected boolean hasNonDefaultFetchGroup() {
        return this.getDescriptor().hasFetchGroupManager() && (this.getFetchGroup() != null || this.getFetchGroupName() != null || !this.shouldUseDefaultFetchGroup());
    }
}

