/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.queryframework;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.security.PrivilegedAccessController;

public class QueryByExamplePolicy
implements Serializable {
    public Map valuesToExclude = new HashMap();
    public Map attributesToAlwaysInclude = new HashMap();
    public Map specialOperations = new HashMap();
    public boolean shouldUseEqualityForNulls = true;

    public QueryByExamplePolicy() {
        this.valuesToExclude = new HashMap(10);
        this.attributesToAlwaysInclude = new HashMap(5);
        this.specialOperations = new HashMap(5);
        this.excludeDefaultPrimitiveValues();
    }

    public void addSpecialOperation(Class clazz, String string) {
        this.getSpecialOperations().put(clazz, string);
    }

    public void alwaysIncludeAttribute(Class clazz, String string) {
        Vector<String> vector = (Vector<String>)this.getAttributesToAlwaysInclude().get(clazz);
        if (vector == null) {
            vector = new Vector<String>(3);
        }
        vector.addElement(string);
        this.getAttributesToAlwaysInclude().put(clazz, vector);
    }

    public Expression completeExpression(Expression expression, Object object, Class clazz) {
        String string = this.getOperation(object.getClass());
        if (string == null) {
            return expression.equal(object);
        }
        Class[] classArray = new Class[]{clazz};
        Object[] objectArray = new Object[]{object};
        try {
            Method method = Helper.getDeclaredMethod(ClassConstants.Expression_Class, string, classArray);
            if (method == null) {
                throw QueryException.methodDoesNotExistOnExpression(string, classArray);
            }
            expression = (Expression)PrivilegedAccessController.invokeMethod(method, expression, objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Class clazz2 = clazz.getSuperclass();
            if (clazz2 != null) {
                return this.completeExpression(expression, object, clazz2);
            }
            throw QueryException.methodDoesNotExistOnExpression(string, classArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw QueryException.methodDoesNotExistOnExpression(string, classArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw QueryException.methodDoesNotExistOnExpression(string, classArray);
        }
        return expression;
    }

    public Expression completeExpressionForNull(Expression expression) {
        if (this.shouldUseEqualityForNulls()) {
            return expression.isNull();
        }
        return expression.notNull();
    }

    public void excludeDefaultPrimitiveValues() {
        this.excludeValue(0);
        this.excludeValue(0.0);
        this.excludeValue(false);
        this.excludeValue((short)0);
        this.excludeValue('\u0000');
        this.excludeValue(0L);
        this.excludeValue((byte)0);
        this.excludeValue(0.0f);
        this.excludeValue(new String(""));
    }

    public void excludeValue(byte by) {
        this.excludeValue(new Byte(by));
    }

    public void excludeValue(char c) {
        this.excludeValue(new Character(c));
    }

    public void excludeValue(double d) {
        this.excludeValue(new Double(d));
    }

    public void excludeValue(float f) {
        this.excludeValue(new Float(f));
    }

    public void excludeValue(int n) {
        this.excludeValue(new Integer(n));
    }

    public void excludeValue(long l) {
        this.excludeValue(new Long(l));
    }

    public void excludeValue(Object object) {
        this.valuesToExclude.put(object, object);
    }

    public void excludeValue(short s) {
        this.excludeValue(new Short(s));
    }

    public void excludeValue(boolean bl) {
        this.excludeValue(new Boolean(bl));
    }

    public Map getAttributesToAlwaysInclude() {
        return this.attributesToAlwaysInclude;
    }

    public String getOperation(Class clazz) {
        String string = (String)this.getSpecialOperations().get(clazz);
        if (string != null && !string.equals("equal")) {
            return string;
        }
        return null;
    }

    public Map getSpecialOperations() {
        return this.specialOperations;
    }

    public Map getValuesToExclude() {
        return this.valuesToExclude;
    }

    public void includeAllValues() {
        this.setValuesToExclude(new HashMap(5));
    }

    public boolean isAlwaysIncluded(Class clazz, String string) {
        Vector vector = (Vector)this.getAttributesToAlwaysInclude().get(clazz);
        if (vector != null) {
            return vector.contains(string);
        }
        return false;
    }

    public boolean isExcludedValue(Object object) {
        return this.getValuesToExclude().containsKey(object);
    }

    public void removeFromValuesToExclude(Object object) {
        this.getValuesToExclude().remove(object);
    }

    public void setAttributesToAlwaysInclude(Map map) {
        this.attributesToAlwaysInclude = map;
    }

    public void setShouldUseEqualityForNulls(boolean bl) {
        this.shouldUseEqualityForNulls = bl;
    }

    public void setSpecialOperations(Map map) {
        this.specialOperations = map;
    }

    public void setValuesToExclude(Map map) {
        this.valuesToExclude = map;
    }

    public boolean shouldIncludeInQuery(Class clazz, String string, Object object) {
        if (object == null) {
            return this.isAlwaysIncluded(clazz, string);
        }
        if (this.isExcludedValue(object)) {
            return this.isAlwaysIncluded(clazz, string);
        }
        return true;
    }

    public boolean shouldUseEqualityForNulls() {
        return this.shouldUseEqualityForNulls;
    }
}

