/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.queryframework;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.QueryRedirector;
import oracle.toplink.sessions.Record;
import oracle.toplink.sessions.Session;

public class MethodBaseQueryRedirector
implements QueryRedirector {
    protected Class methodClass;
    protected String methodClassName;
    protected String methodName;
    protected transient Method method;

    public MethodBaseQueryRedirector() {
    }

    public MethodBaseQueryRedirector(Class clazz, String string) {
        this.methodClass = clazz;
        this.methodName = string;
    }

    protected Method getMethod() {
        return this.method;
    }

    public Class getMethodClass() {
        return this.methodClass;
    }

    public String getMethodClassName() {
        if (this.methodClassName == null && this.methodClass != null) {
            this.methodClassName = this.methodClass.getName();
        }
        return this.methodClassName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    protected void initializeMethod(DatabaseQuery databaseQuery) throws QueryException {
        if (this.getMethodName() == null || this.getMethodClass() == null) {
            throw QueryException.redirectionClassOrMethodNotSet(databaseQuery);
        }
        Class[] classArray = new Class[]{ClassConstants.SessionsSession_Class, ClassConstants.Vector_class};
        try {
            this.setMethod(Helper.getDeclaredMethod(this.getMethodClass(), this.getMethodName(), classArray));
        }
        catch (Exception exception) {
            classArray = new Class[]{ClassConstants.DatabaseQuery_Class, ClassConstants.DatabaseRow_Class, ClassConstants.SessionsSession_Class};
            try {
                this.setMethod(Helper.getDeclaredMethod(this.getMethodClass(), this.getMethodName(), classArray));
            }
            catch (Exception exception2) {
                classArray = new Class[]{ClassConstants.DatabaseQuery_Class, ClassConstants.Record_Class, ClassConstants.SessionsSession_Class};
                try {
                    this.setMethod(Helper.getDeclaredMethod(this.getMethodClass(), this.getMethodName(), classArray));
                }
                catch (Exception exception3) {
                    throw QueryException.redirectionMethodNotDefinedCorrectly(this.getMethodClass(), this.getMethodName(), exception3, databaseQuery);
                }
            }
        }
        if (!Modifier.isStatic(this.getMethod().getModifiers())) {
            throw QueryException.redirectionMethodNotDefinedCorrectly(this.getMethodClass(), this.getMethodName(), null, databaseQuery);
        }
    }

    public Object invokeQuery(DatabaseQuery databaseQuery, Record record, Session session) {
        if (this.getMethod() == null) {
            this.initializeMethod(databaseQuery);
        }
        Object object = null;
        if (this.getMethod().getParameterTypes().length == 3) {
            Object[] objectArray = new Object[]{databaseQuery, record, session};
            try {
                object = PrivilegedAccessController.invokeMethod(this.getMethod(), null, objectArray);
            }
            catch (Exception exception) {
                throw QueryException.redirectionMethodError(exception, databaseQuery);
            }
        }
        Object[] objectArray = new Object[]{session, ((DatabaseRow)record).getValues()};
        try {
            object = PrivilegedAccessController.invokeMethod(this.getMethod(), null, objectArray);
        }
        catch (Exception exception) {
            throw QueryException.redirectionMethodError(exception, databaseQuery);
        }
        return object;
    }

    protected void setMethod(Method method) {
        this.method = method;
    }

    public void setMethodClass(Class clazz) {
        this.methodClass = clazz;
    }

    public void setMethodClassName(String string) {
        this.methodClassName = string;
    }

    public void setMethodName(String string) {
        this.methodName = string;
    }
}

