/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.queryframework;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import oracle.toplink.internal.databaseaccess.Accessor;
import oracle.toplink.internal.databaseaccess.DatabaseAccessor;
import oracle.toplink.internal.parsing.ejbql.EJBQLCallQueryMechanism;
import oracle.toplink.internal.parsing.ejbql.EJBQLParserFactory;
import oracle.toplink.internal.queryframework.DatabaseQueryMechanism;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.Call;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ObjectLevelReadQuery;

public class EJBQLCall
implements Serializable,
Call {
    protected DatabaseQuery query;
    protected String ejbqlString;
    protected boolean isParsed;

    public EJBQLCall() {
    }

    public EJBQLCall(String string) {
        this();
        this.ejbqlString = string;
    }

    public DatabaseQueryMechanism buildNewQueryMechanism(DatabaseQuery databaseQuery) {
        return new EJBQLCallQueryMechanism(databaseQuery, this);
    }

    public DatabaseQueryMechanism buildQueryMechanism(DatabaseQuery databaseQuery, DatabaseQueryMechanism databaseQueryMechanism) {
        return this.buildNewQueryMechanism(databaseQuery);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String getCallString() {
        return this.getEjbqlString();
    }

    public String getEjbqlString() {
        return this.ejbqlString;
    }

    private boolean getIsParsed() {
        return this.isParsed;
    }

    public DatabaseQuery getQuery() {
        return this.query;
    }

    public String getLogString(Accessor accessor) {
        return this.getSQLString();
    }

    public String getSQLString() {
        return null;
    }

    public boolean isEJBQLCall() {
        return true;
    }

    public boolean isFinished() {
        return true;
    }

    public boolean isParsed() {
        return this.getIsParsed();
    }

    public void populateQuery(Session session) {
        if (!this.isParsed()) {
            new EJBQLParserFactory().populateQuery(this.getEjbqlString(), (ObjectLevelReadQuery)this.getQuery(), session);
            this.setIsParsed(true);
        }
    }

    public PreparedStatement prepareStatement(DatabaseAccessor databaseAccessor, DatabaseRow databaseRow, Session session) throws SQLException {
        return null;
    }

    public void setEjbqlString(String string) {
        this.ejbqlString = string;
    }

    public void setIsParsed(boolean bl) {
        this.isParsed = bl;
    }

    public void setQuery(DatabaseQuery databaseQuery) {
        this.query = databaseQuery;
    }

    public void translate(DatabaseRow databaseRow, DatabaseRow databaseRow2, Session session) {
    }
}

