/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.publicinterface;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.descriptors.AllFieldsLockingPolicy;
import oracle.toplink.descriptors.CMPPolicy;
import oracle.toplink.descriptors.ChangedFieldsLockingPolicy;
import oracle.toplink.descriptors.FetchGroupManager;
import oracle.toplink.descriptors.FieldsLockingPolicy;
import oracle.toplink.descriptors.InterfacePolicy;
import oracle.toplink.descriptors.ReturningPolicy;
import oracle.toplink.descriptors.SelectedFieldsLockingPolicy;
import oracle.toplink.descriptors.TimestampLockingPolicy;
import oracle.toplink.descriptors.VersionLockingPolicy;
import oracle.toplink.descriptors.WrapperPolicy;
import oracle.toplink.descriptors.changetracking.DeferredChangeDetectionPolicy;
import oracle.toplink.descriptors.changetracking.ObjectChangePolicy;
import oracle.toplink.descriptors.copying.CloneCopyPolicy;
import oracle.toplink.descriptors.copying.CopyPolicy;
import oracle.toplink.descriptors.copying.InstantiationCopyPolicy;
import oracle.toplink.descriptors.invalidation.CacheInvalidationPolicy;
import oracle.toplink.descriptors.invalidation.NoExpiryCacheInvalidationPolicy;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.expressions.ExpressionBuilder;
import oracle.toplink.history.HistoryPolicy;
import oracle.toplink.internal.databaseaccess.DatabaseCall;
import oracle.toplink.internal.databaseaccess.DatasourcePlatform;
import oracle.toplink.internal.databaseaccess.Platform;
import oracle.toplink.internal.descriptors.CascadeLockingPolicy;
import oracle.toplink.internal.descriptors.InstantiationPolicy;
import oracle.toplink.internal.descriptors.ObjectBuilder;
import oracle.toplink.internal.descriptors.OptimisticLockingPolicy;
import oracle.toplink.internal.expressions.SQLStatement;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.DatabaseTable;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.helper.MappingCompare;
import oracle.toplink.internal.helper.NonSynchronizedVector;
import oracle.toplink.internal.helper.TOPSort;
import oracle.toplink.internal.identitymaps.IdentityMap;
import oracle.toplink.internal.indirection.ProxyIndirectionPolicy;
import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.mappings.AggregateMapping;
import oracle.toplink.mappings.AggregateObjectMapping;
import oracle.toplink.mappings.Association;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.mappings.DirectToFieldMapping;
import oracle.toplink.mappings.ForeignReferenceMapping;
import oracle.toplink.mappings.foundation.AbstractDirectMapping;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.DescriptorEvent;
import oracle.toplink.publicinterface.DescriptorEventManager;
import oracle.toplink.publicinterface.DescriptorQueryManager;
import oracle.toplink.publicinterface.InheritancePolicy;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.FetchGroup;
import oracle.toplink.querykeys.DirectQueryKey;
import oracle.toplink.querykeys.QueryKey;
import oracle.toplink.remote.DistributedSession;

public class Descriptor
implements Cloneable,
Serializable {
    protected Class javaClass;
    protected String javaClassName;
    protected Vector tables = NonSynchronizedVector.newInstance(3);
    protected transient DatabaseTable defaultTable;
    protected List primaryKeyFields;
    protected transient Map additionalTablePrimaryKeyFields;
    protected transient Vector multipleTableInsertOrder;
    protected transient Map multipleTableForeignKeys;
    protected transient Vector fields;
    protected transient Vector allFields;
    protected Vector mappings = NonSynchronizedVector.newInstance();
    protected List lockableMappings;
    protected Map queryKeys;
    protected Class identityMapClass;
    protected Class remoteIdentityMapClass = null;
    protected int identityMapSize = 100;
    protected int remoteIdentityMapSize = -1;
    protected String sequenceNumberName;
    protected DatabaseField sequenceNumberField;
    protected transient String sessionName;
    protected boolean shouldAlwaysRefreshCache = false;
    protected boolean shouldOnlyRefreshCacheIfNewerVersion = false;
    protected boolean shouldDisableCacheHits = false;
    protected transient Vector constraintDependencies;
    protected transient String amendmentMethodName;
    protected transient Class amendmentClass;
    protected transient String amendmentClassName;
    protected boolean shouldAlwaysRefreshCacheOnRemote = false;
    protected boolean shouldDisableCacheHitsOnRemote = false;
    protected String alias;
    protected boolean shouldBeReadOnly = false;
    protected boolean shouldAlwaysConformResultsInUnitOfWork = false;
    protected boolean isIsolated = false;
    protected boolean shouldRegisterResultsInUnitOfWork = true;
    protected DescriptorEventManager eventManager;
    protected DescriptorQueryManager queryManager;
    protected ObjectBuilder objectBuilder;
    protected CopyPolicy copyPolicy;
    protected InstantiationPolicy instantiationPolicy;
    protected InheritancePolicy inheritancePolicy;
    protected InterfacePolicy interfacePolicy;
    protected OptimisticLockingPolicy optimisticLockingPolicy;
    protected Vector cascadeLockingPolicies;
    protected WrapperPolicy wrapperPolicy;
    protected ObjectChangePolicy changePolicy;
    protected ReturningPolicy returningPolicy;
    protected HistoryPolicy historyPolicy;
    protected CMPPolicy cmpPolicy;
    protected FetchGroupManager fetchGroupManager;
    protected Map properties;
    protected transient int initializationStage = 0;
    protected transient int interfaceInitializationStage = 0;
    protected static final int UNINITIALIZED = 0;
    protected static final int PREINITIALIZED = 1;
    protected static final int INITIALIZED = 2;
    protected static final int POST_INITIALIZED = 3;
    protected static final int ERROR = -1;
    protected int descriptorType = 0;
    protected static final int NORMAL = 0;
    protected static final int INTERFACE = 1;
    protected static final int AGGREGATE = 2;
    protected static final int AGGREGATE_COLLECTION = 3;
    protected boolean shouldOrderMappings = true;
    protected CacheInvalidationPolicy cacheInvalidationPolicy = null;
    protected boolean shouldAcquireCascadedLocks = false;
    protected boolean hasSimplePrimaryKey = false;
    protected int cacheSynchronizationType = 1;
    public static final int UNDEFINED_OBJECT_CHANGE_BEHAVIOR = 0;
    public static final int SEND_OBJECT_CHANGES = 1;
    public static final int INVALIDATE_CHANGED_OBJECTS = 2;
    public static final int SEND_NEW_OBJECTS_WITH_CHANGES = 3;
    public static final int DO_NOT_SEND_CHANGES = 4;
    protected int unitOfWorkCacheIsolationLevel = 1;
    public static final int USE_SESSION_CACHE_AFTER_TRANSACTION = 0;
    public static final int ISOLATE_NEW_DATA_AFTER_TRANSACTION = 1;
    public static final int ISOLATE_CACHE_AFTER_TRANSACTION = 2;
    public static final int ISOLATE_CACHE_ALWAYS = 3;
    static /* synthetic */ Class class$oracle$toplink$publicinterface$Descriptor;
    static /* synthetic */ Class class$oracle$toplink$descriptors$ClassDescriptor;

    public Descriptor() {
        this.primaryKeyFields = new ArrayList(2);
        this.fields = NonSynchronizedVector.newInstance();
        this.allFields = NonSynchronizedVector.newInstance();
        this.constraintDependencies = NonSynchronizedVector.newInstance(2);
        this.multipleTableForeignKeys = new HashMap(5);
        this.queryKeys = new HashMap(5);
        this.identityMapClass = IdentityMap.getDefaultIdentityMapClass();
        this.objectBuilder = new ObjectBuilder(this);
        this.cascadeLockingPolicies = NonSynchronizedVector.newInstance();
    }

    public void addAbstractQueryKey(String string) {
        QueryKey queryKey = new QueryKey();
        queryKey.setName(string);
        this.addQueryKey(queryKey);
    }

    public void addCascadeLockingPolicy(CascadeLockingPolicy cascadeLockingPolicy) {
        this.cascadeLockingPolicies.add(cascadeLockingPolicy);
        if (this.usesOptimisticLocking() && this.getOptimisticLockingPolicy().isCascaded()) {
            return;
        }
        if (this.isInitialized(2)) {
            Enumeration enumeration = this.getMappings().elements();
            while (enumeration.hasMoreElements()) {
                this.prepareCascadeLockingPolicy((DatabaseMapping)enumeration.nextElement());
            }
        }
    }

    public void addConstraintDependencies(Class clazz) {
        this.getConstraintDependencies().addElement(clazz);
    }

    public DatabaseMapping addDirectMapping(String string, String string2) {
        DirectToFieldMapping directToFieldMapping = new DirectToFieldMapping();
        directToFieldMapping.setAttributeName(string);
        directToFieldMapping.setFieldName(string2);
        return this.addMapping(directToFieldMapping);
    }

    public DatabaseMapping addDirectMapping(String string, String string2, String string3, String string4) {
        DirectToFieldMapping directToFieldMapping = new DirectToFieldMapping();
        directToFieldMapping.setAttributeName(string);
        directToFieldMapping.setSetMethodName(string3);
        directToFieldMapping.setGetMethodName(string2);
        directToFieldMapping.setFieldName(string4);
        return this.addMapping(directToFieldMapping);
    }

    public void addDirectQueryKey(String string, String string2) {
        DirectQueryKey directQueryKey = new DirectQueryKey();
        DatabaseField databaseField = new DatabaseField(string2);
        directQueryKey.setName(string);
        directQueryKey.setField(databaseField);
        this.getQueryKeys().put(string, directQueryKey);
    }

    public DatabaseMapping addMapping(DatabaseMapping databaseMapping) {
        if (databaseMapping.getDescriptor() == null) {
            databaseMapping.setDescriptor(this);
        }
        this.getMappings().addElement(databaseMapping);
        return databaseMapping;
    }

    protected void validateMappingType(DatabaseMapping databaseMapping) {
        if (!databaseMapping.isRelationalMapping()) {
            throw DescriptorException.invalidMappingType(databaseMapping);
        }
    }

    public void addMultipleTableForeignKeyFieldName(String string, String string2) throws DescriptorException {
        this.addMultipleTableForeignKeys(string, string2, true);
    }

    protected void addMultipleTableForeignKeys(String string, String string2, boolean bl) throws DescriptorException {
        DatabaseField databaseField = new DatabaseField(string);
        DatabaseField databaseField2 = new DatabaseField(string2);
        if (!databaseField.hasTableName() || !databaseField2.hasTableName()) {
            throw DescriptorException.multipleTablePrimaryKeyMustBeFullyQualified(this);
        }
        DatabaseTable databaseTable = databaseField.getTable();
        DatabaseTable databaseTable2 = databaseField2.getTable();
        this.setAdditionalTablePrimaryKeyFields(databaseTable2, databaseField, databaseField2);
        if (bl) {
            this.getMultipleTableForeignKeys().put(databaseTable, databaseTable2);
        }
    }

    public void addMultipleTablePrimaryKeyFieldName(String string, String string2) throws DescriptorException {
        this.addMultipleTableForeignKeys(string, string2, false);
    }

    public void addPrimaryKeyFieldName(String string) {
        this.getPrimaryKeyFields().add(new DatabaseField(string));
    }

    public void addPrimaryKeyField(DatabaseField databaseField) {
        this.getPrimaryKeyFields().add(databaseField);
    }

    public void addQueryKey(QueryKey queryKey) {
        this.getQueryKeys().put(queryKey.getName(), queryKey);
    }

    public void addTableName(String string) {
        this.getTables().addElement(new DatabaseTable(string));
    }

    public void adjustMultipleTableInsertOrder() {
        if (this.getMultipleTableInsertOrder() == null || this.getMultipleTableInsertOrder().isEmpty()) {
            this.setMultipleTableInsertOrder((Vector)this.getTables().clone());
            this.checkMultipleTableForeignKeys(false);
        } else {
            if (this.getMultipleTableInsertOrder().size() != this.getTables().size()) {
                throw DescriptorException.multipleTableInsertOrderMismatch(this);
            }
            this.checkMultipleTableForeignKeys(true);
        }
    }

    public void alwaysConformResultsInUnitOfWork() {
        this.setShouldAlwaysConformResultsInUnitOfWork(true);
    }

    public void alwaysRefreshCache() {
        this.setShouldAlwaysRefreshCache(true);
    }

    public void alwaysRefreshCacheOnRemote() {
        this.setShouldAlwaysRefreshCacheOnRemote(true);
    }

    public void applyAmendmentMethod() {
        this.applyAmendmentMethod(null);
    }

    public void applyAmendmentMethod(DescriptorEvent descriptorEvent) {
        if (this.getAmendmentClass() == null || this.getAmendmentMethodName() == null) {
            return;
        }
        Method method = null;
        Class[] classArray = new Class[]{class$oracle$toplink$publicinterface$Descriptor == null ? (class$oracle$toplink$publicinterface$Descriptor = Descriptor.class$("oracle.toplink.publicinterface.Descriptor")) : class$oracle$toplink$publicinterface$Descriptor};
        try {
            method = Helper.getDeclaredMethod(this.getAmendmentClass(), this.getAmendmentMethodName(), classArray);
        }
        catch (Exception exception) {
            classArray[0] = class$oracle$toplink$descriptors$ClassDescriptor == null ? (class$oracle$toplink$descriptors$ClassDescriptor = Descriptor.class$("oracle.toplink.descriptors.ClassDescriptor")) : class$oracle$toplink$descriptors$ClassDescriptor;
            try {
                method = Helper.getDeclaredMethod(this.getAmendmentClass(), this.getAmendmentMethodName(), classArray);
            }
            catch (Exception exception2) {
                throw DescriptorException.invalidAmendmentMethod(this.getAmendmentClass(), this.getAmendmentMethodName(), exception2, this);
            }
        }
        Object[] objectArray = new Object[]{this};
        try {
            PrivilegedAccessController.invokeMethod(method, null, objectArray);
        }
        catch (Exception exception) {
            throw DescriptorException.errorOccuredInAmendmentMethod(this.getAmendmentClass(), this.getAmendmentMethodName(), exception, this);
        }
    }

    public boolean arePrimaryKeyFields(Vector vector) {
        if (vector.size() != this.getPrimaryKeyFields().size()) {
            return false;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
            if (this.getPrimaryKeyFields().contains(databaseField)) continue;
            return false;
        }
        return true;
    }

    public DatabaseCall buildCallFromStatement(SQLStatement sQLStatement, Session session) {
        return sQLStatement.buildCall(session);
    }

    public Vector buildDirectValuesFromFieldValue(Object object) throws DatabaseException {
        throw DescriptorException.normalDescriptorsDoNotSupportNonRelationalExtensions(this);
    }

    public DatabaseField buildField(String string) {
        DatabaseField databaseField = new DatabaseField(string);
        DatabaseTable databaseTable = databaseField.hasTableName() ? this.getTable(databaseField.getTableName()) : (this.getDefaultTable() != null ? this.getDefaultTable() : this.getTable(this.getTableName()));
        databaseField.setTable(databaseTable);
        return databaseField;
    }

    public void buildField(DatabaseField databaseField) {
        DatabaseTable databaseTable = databaseField.hasTableName() ? this.getTable(databaseField.getTableName()) : this.getDefaultTable();
        databaseField.setTable(databaseTable);
    }

    public Object buildFieldValueFromDirectValues(Vector vector, String string, Session session) throws DatabaseException {
        throw DescriptorException.normalDescriptorsDoNotSupportNonRelationalExtensions(this);
    }

    public Object buildFieldValueFromForeignKeys(Vector vector, String string, Session session) throws DatabaseException {
        throw DescriptorException.normalDescriptorsDoNotSupportNonRelationalExtensions(this);
    }

    public Object buildFieldValueFromNestedRow(DatabaseRow databaseRow, Session session) throws DatabaseException {
        throw DescriptorException.normalDescriptorsDoNotSupportNonRelationalExtensions(this);
    }

    public Object buildFieldValueFromNestedRows(Vector vector, String string, Session session) throws DatabaseException {
        throw DescriptorException.normalDescriptorsDoNotSupportNonRelationalExtensions(this);
    }

    public DatabaseRow buildNestedRowFromFieldValue(Object object) throws DatabaseException {
        throw DescriptorException.normalDescriptorsDoNotSupportNonRelationalExtensions(this);
    }

    public Vector buildNestedRowsFromFieldValue(Object object, Session session) throws DatabaseException {
        throw DescriptorException.normalDescriptorsDoNotSupportNonRelationalExtensions(this);
    }

    protected void checkDatabase(Session session) {
        if (session.getIntegrityChecker().shouldCheckDatabase()) {
            Enumeration enumeration = this.getTables().elements();
            while (enumeration.hasMoreElements()) {
                DatabaseTable databaseTable = (DatabaseTable)enumeration.nextElement();
                if (session.getIntegrityChecker().checkTable(databaseTable, session)) {
                    Cloneable cloneable;
                    Vector<Object> vector = new Vector<Object>();
                    Vector vector2 = session.getAccessor().getColumnInfo(null, null, databaseTable.getName(), null, session);
                    Enumeration enumeration2 = vector2.elements();
                    while (enumeration2.hasMoreElements()) {
                        cloneable = (DatabaseRow)enumeration2.nextElement();
                        vector.addElement(((DatabaseRow)cloneable).get("COLUMN_NAME"));
                    }
                    enumeration2 = this.getFields().elements();
                    while (enumeration2.hasMoreElements()) {
                        cloneable = (DatabaseField)enumeration2.nextElement();
                        if (!((DatabaseField)cloneable).getTable().equals(databaseTable) || vector.contains(((DatabaseField)cloneable).getName())) continue;
                        session.getIntegrityChecker().handleError(DescriptorException.fieldIsNotPresentInDatabase(this, databaseTable.getName(), ((DatabaseField)cloneable).getName()));
                    }
                    continue;
                }
                session.getIntegrityChecker().handleError(DescriptorException.tableIsNotPresentInDatabase(this));
            }
        }
    }

    public void checkInheritanceTreeAggregateSettings(Session session, AggregateMapping aggregateMapping) throws DescriptorException {
        if (!this.hasInheritance()) {
            return;
        }
        if (this.isChildDescriptor()) {
            Class clazz = this.getInheritancePolicy().getParentClass();
            if (clazz == this.getJavaClass()) {
                throw DescriptorException.parentClassIsSelf(this);
            }
            session.getDescriptor(clazz).checkInheritanceTreeAggregateSettings(session, aggregateMapping);
        } else {
            this.checkInheritanceTreeAggregateSettingsForChildren(session, aggregateMapping);
        }
    }

    private void checkInheritanceTreeAggregateSettingsForChildren(Session session, AggregateMapping aggregateMapping) throws DescriptorException {
        if (!this.isAggregateDescriptor()) {
            session.getIntegrityChecker().handleError(DescriptorException.referenceDescriptorIsNotAggregate(this.getJavaClass().getName(), aggregateMapping));
        }
        Enumeration enumeration = this.getInheritancePolicy().getChildDescriptors().elements();
        while (enumeration.hasMoreElements()) {
            Descriptor descriptor = (Descriptor)enumeration.nextElement();
            descriptor.checkInheritanceTreeAggregateSettingsForChildren(session, aggregateMapping);
        }
    }

    protected void checkMultipleTableForeignKeys(boolean bl) {
        Map map = this.getMultipleTableForeignKeys();
        for (int i = 0; i < map.size(); ++i) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                DatabaseTable databaseTable = (DatabaseTable)iterator.next();
                DatabaseTable databaseTable2 = (DatabaseTable)map.get(databaseTable);
                if (this.getMultipleTableInsertOrder().indexOf(databaseTable) == -1) {
                    throw DescriptorException.illegalTableNameInMultipleTableForeignKeyField(this, databaseTable);
                }
                if (this.getMultipleTableInsertOrder().indexOf(databaseTable2) == -1) {
                    throw DescriptorException.illegalTableNameInMultipleTableForeignKeyField(this, databaseTable2);
                }
                int n = this.getTables().indexOf(databaseTable);
                int n2 = this.getTables().indexOf(databaseTable2);
                if (n2 >= n) continue;
                if (bl) {
                    this.toggleAdditionalTablePrimaryKeyFields(databaseTable2, databaseTable);
                    continue;
                }
                int n3 = this.getMultipleTableInsertOrder().indexOf(databaseTable);
                int n4 = this.getMultipleTableInsertOrder().indexOf(databaseTable2);
                if (n4 >= n3) continue;
                this.toggleAdditionalTablePrimaryKeyFields(databaseTable2, databaseTable);
                this.getMultipleTableInsertOrder().removeElementAt(n4);
                this.getMultipleTableInsertOrder().insertElementAt(databaseTable2, n3);
            }
        }
    }

    public Object clone() {
        Object object;
        ArrayList<DatabaseField> arrayList;
        Descriptor descriptor = null;
        try {
            descriptor = (Descriptor)super.clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
        Object object2 = this.getMappings().elements();
        while (object2.hasMoreElements()) {
            arrayList = (DatabaseMapping)((DatabaseMapping)object2.nextElement()).clone();
            ((DatabaseMapping)((Object)arrayList)).setDescriptor(descriptor);
            ((Vector)nonSynchronizedVector).addElement(arrayList);
        }
        descriptor.setMappings(nonSynchronizedVector);
        object2 = new HashMap(this.getQueryKeys().size() + 2);
        arrayList = this.getQueryKeys().values().iterator();
        while (arrayList.hasNext()) {
            object = (QueryKey)((QueryKey)arrayList.next()).clone();
            ((QueryKey)object).setDescriptor(descriptor);
            object2.put(((QueryKey)object).getName(), object);
        }
        descriptor.setQueryKeys((Map)object2);
        arrayList = new ArrayList<DatabaseField>(this.getPrimaryKeyFields().size());
        object = this.getPrimaryKeyFields();
        for (int i = 0; i < object.size(); ++i) {
            DatabaseField databaseField = (DatabaseField)((DatabaseField)object.get(i)).clone();
            arrayList.add(databaseField);
        }
        descriptor.setPrimaryKeyFields(arrayList);
        descriptor.setFields(NonSynchronizedVector.newInstance());
        if (descriptor.hasInheritance()) {
            descriptor.setInheritancePolicy((InheritancePolicy)this.getInheritancePolicy().clone());
            descriptor.getInheritancePolicy().setDescriptor(descriptor);
        }
        if (descriptor.hasReturningPolicy()) {
            descriptor.setReturningPolicy((ReturningPolicy)this.getReturningPolicy().clone());
            descriptor.getReturningPolicy().setDescriptor(descriptor);
        }
        descriptor.setObjectBuilder((ObjectBuilder)this.getObjectBuilder().clone());
        descriptor.getObjectBuilder().setDescriptor(descriptor);
        descriptor.setEventManager((DescriptorEventManager)this.getEventManager().clone());
        descriptor.getEventManager().setDescriptor(descriptor);
        descriptor.setQueryManager((DescriptorQueryManager)this.getQueryManager().clone());
        descriptor.getQueryManager().setDescriptor(descriptor);
        if (this.hasFetchGroupManager()) {
            descriptor.setFetchGroupManager((FetchGroupManager)this.getFetchGroupManager().clone());
        }
        descriptor.setIsIsolated(this.isIsolated());
        descriptor.setInstantiationPolicy((InstantiationPolicy)this.getInstantiationPolicy().clone());
        descriptor.setCopyPolicy((CopyPolicy)this.getCopyPolicy().clone());
        if (this.getOptimisticLockingPolicy() != null) {
            descriptor.setOptimisticLockingPolicy((OptimisticLockingPolicy)this.getOptimisticLockingPolicy().clone());
        }
        descriptor.setObjectChangePolicy(this.getObjectChangePolicy());
        return descriptor;
    }

    public void createCopyPolicy(String string) {
        if (string.equals("clone")) {
            this.useCloneCopyPolicy();
            return;
        }
        if (string.equals("constructor")) {
            this.useInstantiationCopyPolicy();
            return;
        }
    }

    public void createInstantiationPolicy(String string) {
        if (string.equals("static method")) {
            return;
        }
        if (string.equals("constructor")) {
            this.useDefaultConstructorInstantiationPolicy();
            return;
        }
        if (string.equals("factory")) {
            return;
        }
    }

    public void descriptorIsAggregate() {
        this.setDescriptorType(2);
    }

    public void descriptorIsAggregateCollection() {
        this.setDescriptorType(3);
    }

    public void descriptorIsForInterface() {
        this.setDescriptorType(1);
    }

    public void descriptorIsNormal() {
        this.setDescriptorType(0);
    }

    public void disableCacheHits() {
        this.setShouldDisableCacheHits(true);
    }

    public void disableCacheHitsOnRemote() {
        this.setShouldDisableCacheHitsOnRemote(true);
    }

    public void dontAlwaysConformResultsInUnitOfWork() {
        this.setShouldAlwaysConformResultsInUnitOfWork(false);
    }

    public void dontAlwaysRefreshCache() {
        this.setShouldAlwaysRefreshCache(false);
    }

    public void dontAlwaysRefreshCacheOnRemote() {
        this.setShouldAlwaysRefreshCacheOnRemote(false);
    }

    public void dontDisableCacheHits() {
        this.setShouldDisableCacheHits(false);
    }

    public void dontDisableCacheHitsOnRemote() {
        this.setShouldDisableCacheHitsOnRemote(false);
    }

    public void dontOnlyRefreshCacheIfNewerVersion() {
        this.setShouldOnlyRefreshCacheIfNewerVersion(false);
    }

    protected DatabaseTable extractDefaultTable() {
        if (this.getTables().isEmpty()) {
            return this.getInheritancePolicy().getParentDescriptor().extractDefaultTable();
        }
        return (DatabaseTable)this.getTables().firstElement();
    }

    public Map getAdditionalTablePrimaryKeyFields() {
        if (this.additionalTablePrimaryKeyFields == null) {
            this.additionalTablePrimaryKeyFields = new HashMap(5);
        }
        return this.additionalTablePrimaryKeyFields;
    }

    public String getAlias() {
        if (this.alias == null && this.getJavaClassName() != null) {
            this.alias = Helper.getShortClassName(this.getJavaClassName());
        }
        return this.alias;
    }

    public Vector getAllFields() {
        return this.allFields;
    }

    public Class getAmendmentClass() {
        return this.amendmentClass;
    }

    public String getAmendmentClassName() {
        if (this.amendmentClassName == null && this.amendmentClass != null) {
            this.amendmentClassName = this.amendmentClass.getName();
        }
        return this.amendmentClassName;
    }

    public String getAmendmentMethodName() {
        return this.amendmentMethodName;
    }

    public ObjectChangePolicy getObjectChangePolicy() {
        if (this.changePolicy == null) {
            this.changePolicy = new DeferredChangeDetectionPolicy();
        }
        return this.changePolicy;
    }

    public HistoryPolicy getHistoryPolicy() {
        return this.historyPolicy;
    }

    public CacheInvalidationPolicy getCacheInvalidationPolicy() {
        if (this.cacheInvalidationPolicy == null) {
            this.cacheInvalidationPolicy = new NoExpiryCacheInvalidationPolicy();
        }
        return this.cacheInvalidationPolicy;
    }

    public int getCacheSynchronizationType() {
        return this.cacheSynchronizationType;
    }

    public Vector getCascadeLockingPolicies() {
        return this.cascadeLockingPolicies;
    }

    public Vector getConstraintDependencies() {
        return this.constraintDependencies;
    }

    public CopyPolicy getCopyPolicy() {
        if (this.copyPolicy == null) {
            this.setCopyPolicy(new InstantiationCopyPolicy());
        }
        return this.copyPolicy;
    }

    public DatabaseTable getDefaultTable() {
        return this.defaultTable;
    }

    public int getDescriptorType() {
        return this.descriptorType;
    }

    public String getDescriptorTypeValue() {
        if (this.isAggregateCollectionDescriptor()) {
            return "Aggregate collection";
        }
        if (this.isAggregateDescriptor()) {
            return "Aggregate";
        }
        if (this.isDescriptorForInterface()) {
            return "Interface";
        }
        return "Normal";
    }

    public DescriptorEventManager getEventManager() {
        if (this.eventManager == null) {
            this.setEventManager(new oracle.toplink.descriptors.DescriptorEventManager());
        }
        return this.eventManager;
    }

    public Vector getFields() {
        return this.fields;
    }

    public Class getIdentityMapClass() {
        return this.identityMapClass;
    }

    public int getIdentityMapSize() {
        return this.identityMapSize;
    }

    public InheritancePolicy getInheritancePolicy() {
        if (this.inheritancePolicy == null) {
            this.setInheritancePolicy(new oracle.toplink.descriptors.InheritancePolicy(this));
        }
        return this.inheritancePolicy;
    }

    public InheritancePolicy getInheritancePolicyOrNull() {
        return this.inheritancePolicy;
    }

    public InstantiationPolicy getInstantiationPolicy() {
        if (this.instantiationPolicy == null) {
            this.setInstantiationPolicy(new InstantiationPolicy());
        }
        return this.instantiationPolicy;
    }

    public InterfacePolicy getInterfacePolicy() {
        if (this.interfacePolicy == null) {
            this.setInterfacePolicy(new InterfacePolicy(this));
        }
        return this.interfacePolicy;
    }

    public InterfacePolicy getInterfacePolicyOrNull() {
        return this.interfacePolicy;
    }

    public Class getJavaClass() {
        return this.javaClass;
    }

    public String getJavaClassName() {
        if (this.javaClassName == null && this.javaClass != null) {
            this.javaClassName = this.javaClass.getName();
        }
        return this.javaClassName;
    }

    public List getLockableMappings() {
        if (this.lockableMappings == null) {
            this.lockableMappings = new ArrayList();
        }
        return this.lockableMappings;
    }

    public DatabaseMapping getMappingForAttributeName(String string) {
        Enumeration enumeration = this.mappings.elements();
        while (enumeration.hasMoreElements()) {
            DatabaseMapping databaseMapping = (DatabaseMapping)enumeration.nextElement();
            if (databaseMapping.getAttributeName() == null || !databaseMapping.getAttributeName().equals(string)) continue;
            return databaseMapping;
        }
        return null;
    }

    public DatabaseMapping removeMappingForAttributeName(String string) {
        DatabaseMapping databaseMapping = this.getMappingForAttributeName(string);
        this.getMappings().remove(databaseMapping);
        return databaseMapping;
    }

    public Vector getMappings() {
        return this.mappings;
    }

    public Vector getMultipleTableForeignKeyAssociations() {
        Vector<Association> vector = new Vector<Association>(this.getAdditionalTablePrimaryKeyFields().size() * 2);
        Iterator iterator = this.getAdditionalTablePrimaryKeyFields().values().iterator();
        while (iterator.hasNext()) {
            Map map = (Map)iterator.next();
            Iterator iterator2 = map.keySet().iterator();
            while (iterator2.hasNext()) {
                DatabaseField databaseField = (DatabaseField)iterator2.next();
                if (!this.getMultipleTableForeignKeys().containsKey(databaseField.getTable())) continue;
                Association association = new Association(databaseField.getQualifiedName(), ((DatabaseField)map.get(databaseField)).getQualifiedName());
                vector.addElement(association);
            }
        }
        return vector;
    }

    public Map getMultipleTableForeignKeys() {
        return this.multipleTableForeignKeys;
    }

    public Vector getMultipleTableInsertOrder() throws DescriptorException {
        return this.multipleTableInsertOrder;
    }

    public Vector getMultipleTablePrimaryKeyAssociations() {
        Vector<Association> vector = new Vector<Association>(this.getAdditionalTablePrimaryKeyFields().size() * 2);
        Iterator iterator = this.getAdditionalTablePrimaryKeyFields().values().iterator();
        while (iterator.hasNext()) {
            Map map = (Map)iterator.next();
            Iterator iterator2 = map.keySet().iterator();
            while (iterator2.hasNext()) {
                DatabaseField databaseField = (DatabaseField)iterator2.next();
                if (this.getMultipleTableForeignKeys().containsKey(databaseField.getTable())) continue;
                Association association = new Association(databaseField.getQualifiedName(), ((DatabaseField)map.get(databaseField)).getQualifiedName());
                vector.addElement(association);
            }
        }
        return vector;
    }

    public ObjectBuilder getObjectBuilder() {
        return this.objectBuilder;
    }

    public OptimisticLockingPolicy getOptimisticLockingPolicy() {
        return this.optimisticLockingPolicy;
    }

    public Vector getPrimaryKeyFieldNames() {
        Vector<String> vector = new Vector<String>(this.getPrimaryKeyFields().size());
        List list = this.getPrimaryKeyFields();
        for (int i = 0; i < list.size(); ++i) {
            vector.addElement(((DatabaseField)list.get(i)).getQualifiedName());
        }
        return vector;
    }

    public List getPrimaryKeyFields() {
        return this.primaryKeyFields;
    }

    public Map getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap(5);
        }
        return this.properties;
    }

    public Object getProperty(String string) {
        return this.getProperties().get(string);
    }

    public QueryKey getQueryKeyNamed(String string) {
        return (QueryKey)this.getQueryKeys().get(string);
    }

    public Map getQueryKeys() {
        return this.queryKeys;
    }

    public DescriptorQueryManager getQueryManager() {
        if (this.queryManager == null) {
            this.setQueryManager(new oracle.toplink.descriptors.DescriptorQueryManager());
        }
        return this.queryManager;
    }

    public Class getRemoteIdentityMapClass() {
        if (this.remoteIdentityMapClass == null) {
            this.remoteIdentityMapClass = this.getIdentityMapClass();
        }
        return this.remoteIdentityMapClass;
    }

    public int getRemoteIdentityMapSize() {
        if (this.remoteIdentityMapSize == -1) {
            this.remoteIdentityMapSize = this.getIdentityMapSize();
        }
        return this.remoteIdentityMapSize;
    }

    public ReturningPolicy getReturningPolicy() {
        return this.returningPolicy;
    }

    public DatabaseField getSequenceNumberField() {
        return this.sequenceNumberField;
    }

    public String getSequenceNumberFieldName() {
        if (this.getSequenceNumberField() == null) {
            return null;
        }
        return this.getSequenceNumberField().getQualifiedName();
    }

    public String getSequenceNumberName() {
        return this.sequenceNumberName;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public DatabaseTable getTable(String string) throws DescriptorException {
        if (this.getTables().isEmpty()) {
            return null;
        }
        Enumeration enumeration = this.getTables().elements();
        while (enumeration.hasMoreElements()) {
            String string2;
            DatabaseTable databaseTable = (DatabaseTable)enumeration.nextElement();
            if (string.indexOf(32) != -1 && (string2 = databaseTable.getName()).substring(1, string2.length() - 1).equals(string)) {
                return databaseTable;
            }
            if (!databaseTable.getName().equals(string)) continue;
            return databaseTable;
        }
        if (this.isAggregateDescriptor()) {
            return this.getDefaultTable();
        }
        throw DescriptorException.tableNotPresent(string, this);
    }

    public String getTableName() {
        if (this.getTables().isEmpty()) {
            return null;
        }
        return ((DatabaseTable)this.getTables().firstElement()).getName();
    }

    public Vector getTableNames() {
        Vector<String> vector = new Vector<String>(this.getTables().size());
        Enumeration enumeration = this.getTables().elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(((DatabaseTable)enumeration.nextElement()).getQualifiedName());
        }
        return vector;
    }

    public Vector getTables() {
        return this.tables;
    }

    public DatabaseField getTypedField(DatabaseField databaseField) {
        DatabaseField databaseField2;
        boolean bl = this.hasMultipleTables() && !databaseField.hasTableName();
        DatabaseField databaseField3 = null;
        for (int i = 0; i < this.getFields().size(); ++i) {
            DatabaseField databaseField4 = (DatabaseField)this.getFields().elementAt(i);
            if (!databaseField.equals(databaseField4) || databaseField4.getType() == null) continue;
            databaseField3 = databaseField4;
            if (!bl || databaseField4.getTable().equals(this.getDefaultTable())) break;
        }
        if (databaseField3 == null && this.hasReturningPolicy() && (databaseField2 = this.getReturningPolicy().getField(databaseField)) != null && databaseField2.getType() != null) {
            databaseField3 = databaseField2;
        }
        if (databaseField3 != null) {
            databaseField3 = (DatabaseField)databaseField3.clone();
            if (!databaseField.hasTableName()) {
                databaseField3.setTableName("");
            }
        }
        return databaseField3;
    }

    public WrapperPolicy getWrapperPolicy() {
        return this.wrapperPolicy;
    }

    public boolean hasDependencyOnParts() {
        Enumeration enumeration = this.getMappings().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseMapping databaseMapping = (DatabaseMapping)enumeration.nextElement();
            if (!databaseMapping.hasDependency()) continue;
            return true;
        }
        return false;
    }

    public boolean hasInheritance() {
        return this.inheritancePolicy != null;
    }

    public boolean hasInterfacePolicy() {
        return this.interfacePolicy != null;
    }

    public boolean hasMultipleTables() {
        return this.getTables().size() > 1;
    }

    public boolean hasPrivatelyOwnedParts() {
        Enumeration enumeration = this.getMappings().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseMapping databaseMapping = (DatabaseMapping)enumeration.nextElement();
            if (!databaseMapping.isPrivateOwned()) continue;
            return true;
        }
        return false;
    }

    public boolean hasQueryKeyOrMapping(String string) {
        return this.getQueryKeys().containsKey(string) || this.getObjectBuilder().getMappingForAttributeName(string) != null;
    }

    public boolean hasReturningPolicy() {
        return this.returningPolicy != null;
    }

    public boolean hasWrapperPolicy() {
        return this.getWrapperPolicy() != null;
    }

    public void initialize(Session session) throws DescriptorException {
        Descriptor descriptor;
        int n;
        Object object;
        Object object2;
        if (this.shouldBeReadOnly() && !session.getDefaultReadOnlyClasses().contains(this.getJavaClass())) {
            session.getDefaultReadOnlyClasses().add(this.getJavaClass());
        }
        if (this.getHistoryPolicy() != null) {
            session.getProject().setHasGenericHistorySupport(true);
        }
        if (this.isIsolated()) {
            session.getProject().setHasIsolatedClasses(true);
        }
        if (!this.hasCMPPolicy() || this.getCMPPolicy().isCMP3Policy()) {
            session.getProject().setIsPureCMP2Project(false);
        }
        if (this.isInitialized(2) || this.isInvalid()) {
            return;
        }
        this.setInitializationStage(2);
        if (this.isChildDescriptor()) {
            this.getInheritancePolicy().getParentDescriptor().initialize(session);
            if (this.getInheritancePolicy().getParentDescriptor().isIsolated()) {
                this.setIsIsolated(true);
            }
        }
        if (this.shouldOrderMappings()) {
            object2 = this.getMappings();
            object = new Object[((Vector)object2).size()];
            for (n = 0; n < ((Vector)object2).size(); ++n) {
                object[n] = ((Vector)object2).elementAt(n);
            }
            TOPSort.quicksort((Object[])object, new MappingCompare());
            object2 = NonSynchronizedVector.newInstance(((Object)object).length);
            for (n = 0; n < ((Object)object).length; ++n) {
                ((Vector)object2).addElement(object[n]);
            }
            this.setMappings((Vector)object2);
        }
        object2 = this.getMappings().elements();
        while (object2.hasMoreElements()) {
            object = (DatabaseMapping)object2.nextElement();
            this.validateMappingType((DatabaseMapping)object);
            ((DatabaseMapping)object).initialize(session);
            if (((DatabaseMapping)object).isAggregateObjectMapping() || ((DatabaseMapping)object).isForeignReferenceMapping() && !((DatabaseMapping)object).isDirectCollectionMapping() && !((ForeignReferenceMapping)object).usesIndirection()) {
                this.getLockableMappings().add(object);
            }
            if (((DatabaseMapping)object).isForeignReferenceMapping() && ((ForeignReferenceMapping)object).getIndirectionPolicy() instanceof ProxyIndirectionPolicy) {
                session.getProject().setHasProxyIndirection(true);
            }
            if (this.usesOptimisticLocking() && this.getOptimisticLockingPolicy().isCascaded() || this.hasCascadeLockingPolicies()) {
                this.prepareCascadeLockingPolicy((DatabaseMapping)object);
            }
            Helper.addAllUniqueToVector(this.getFields(), ((DatabaseMapping)object).getFields());
        }
        if (!this.isAggregateDescriptor() && !this.isChildDescriptor() && this.usesOptimisticLocking()) {
            this.getOptimisticLockingPolicy().initializeProperties();
        }
        object2 = this.getQueryKeys().values().iterator();
        while (object2.hasNext()) {
            object = (QueryKey)object2.next();
            ((QueryKey)object).initialize(this);
        }
        if (this.hasInheritance()) {
            this.getInheritancePolicy().initialize(session);
            if (this.getInheritancePolicy().isChildDescriptor()) {
                object2 = this.getInheritancePolicy().getParentDescriptor().getMappings().iterator();
                while (object2.hasNext()) {
                    object = (DatabaseMapping)object2.next();
                    if (!((DatabaseMapping)object).isAggregateObjectMapping() && (!((DatabaseMapping)object).isForeignReferenceMapping() || ((DatabaseMapping)object).isDirectCollectionMapping() || ((ForeignReferenceMapping)object).usesIndirection())) continue;
                    this.getLockableMappings().add(object);
                }
            }
        }
        if (this.hasInheritance() && this.shouldOrderMappings()) {
            object2 = this.getMappings();
            object = new Object[((Vector)object2).size()];
            for (n = 0; n < ((Vector)object2).size(); ++n) {
                object[n] = ((Vector)object2).elementAt(n);
            }
            TOPSort.quicksort((Object[])object, new MappingCompare());
            object2 = NonSynchronizedVector.newInstance(((Object)object).length);
            for (n = 0; n < ((Object)object).length; ++n) {
                ((Vector)object2).addElement(object[n]);
            }
            this.setMappings((Vector)object2);
        }
        this.setAllFields((Vector)this.getFields().clone());
        this.getObjectBuilder().initialize(session);
        if (this.shouldOrderMappings()) {
            for (int i = this.getObjectBuilder().getPrimaryKeyMappings().size() - 1; i >= 0; --i) {
                object = (DatabaseMapping)this.getObjectBuilder().getPrimaryKeyMappings().get(i);
                if (object == null || !((DatabaseMapping)object).isDirectToFieldMapping()) continue;
                this.getMappings().remove(object);
                this.getMappings().add(0, object);
                DatabaseField databaseField = ((AbstractDirectMapping)object).getField();
                this.getFields().remove(databaseField);
                this.getFields().add(0, databaseField);
                this.getAllFields().remove(databaseField);
                this.getAllFields().add(0, databaseField);
            }
        }
        if (this.usesOptimisticLocking() && !this.isChildDescriptor()) {
            this.getOptimisticLockingPolicy().initialize(session);
        }
        if (this.hasInterfacePolicy()) {
            this.interfaceInitialization(session);
        }
        if (this.hasWrapperPolicy()) {
            this.getWrapperPolicy().initialize(session);
        }
        if (this.hasReturningPolicy()) {
            this.getReturningPolicy().initialize(session);
        }
        this.getQueryManager().initialize(session);
        this.getEventManager().initialize(session);
        this.getCopyPolicy().initialize(session);
        this.getInstantiationPolicy().initialize(session);
        if (this.getHistoryPolicy() != null) {
            this.getHistoryPolicy().initialize(session);
        } else if (this.hasInheritance() && (descriptor = this.getInheritancePolicy().getParentDescriptor()) != null && descriptor.getHistoryPolicy() != null) {
            this.setHistoryPolicy((HistoryPolicy)descriptor.getHistoryPolicy().clone());
        }
        if (this.getCMPPolicy() != null) {
            this.getCMPPolicy().initialize(this, session);
        }
        if (this.hasFetchGroupManager() && !Helper.classImplementsInterface(this.javaClass, ClassConstants.FetchGroupTracker_class)) {
            session.getIntegrityChecker().handleError(DescriptorException.needToImplementFetchGroupTracker(this.javaClass, this));
        }
    }

    public void initializeAggregateInheritancePolicy(Session session) {
        Descriptor descriptor = session.getDescriptor(this.getInheritancePolicy().getParentClass());
        descriptor.getInheritancePolicy().addChildDescriptor(this);
    }

    public void initializeMultipleTablePrimaryKeyFields() {
        int n = this.getTables().size() - 1;
        if (this.hasInheritance() && this.getInheritancePolicy().isChildDescriptor()) {
            n = this.getTables().size() - this.getInheritancePolicy().getParentDescriptor().getTables().size();
        }
        if (n < 1) {
            return;
        }
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        Expression expression = this.getQueryManager().getMultipleTableJoinExpression();
        for (int i = this.getTables().size() - n; i < this.getTables().size(); ++i) {
            Expression expression2;
            Cloneable cloneable;
            Cloneable cloneable2;
            Object object;
            Object object2;
            DatabaseTable databaseTable = (DatabaseTable)this.getTables().elementAt(i);
            Map map = (Map)this.getAdditionalTablePrimaryKeyFields().get(databaseTable);
            if (map != null) {
                if (this.getQueryManager().hasCustomMultipleTableJoinExpression()) continue;
                object2 = map.keySet().iterator();
                while (object2.hasNext()) {
                    object = (DatabaseField)object2.next();
                    DatabaseField databaseField = (DatabaseField)map.get(object);
                    cloneable2 = ((DatabaseField)object).getTable();
                    cloneable = databaseField.getTable();
                    if (!this.getFields().contains(object)) {
                        this.getFields().addElement(object);
                    }
                    if (!this.getFields().contains(databaseField)) {
                        this.getFields().addElement(databaseField);
                    }
                    expression2 = expressionBuilder.getField(databaseField).equal(expressionBuilder.getField((DatabaseField)object));
                    expression = expression2.and(expression);
                }
                continue;
            }
            object2 = new HashMap(this.getPrimaryKeyFields().size() + 1);
            this.getAdditionalTablePrimaryKeyFields().put(databaseTable, object2);
            object = this.getPrimaryKeyFields();
            for (int j = 0; j < object.size(); ++j) {
                cloneable2 = (DatabaseField)object.get(j);
                cloneable = (DatabaseField)((DatabaseField)cloneable2).clone();
                ((DatabaseField)cloneable).setTable(databaseTable);
                object2.put(cloneable2, cloneable);
                this.getFields().addElement(cloneable);
                if (this.getQueryManager().hasCustomMultipleTableJoinExpression()) continue;
                expression2 = expressionBuilder.getField((DatabaseField)cloneable).equal(expressionBuilder.getField((DatabaseField)cloneable2));
                expression = expression2.and(expression);
            }
        }
        if (expression != null) {
            this.getQueryManager().setInternalMultipleTableJoinExpression(expression);
        }
    }

    protected void initializeProperties(Session session) throws DescriptorException {
        if (!this.isAggregateDescriptor()) {
            if (!this.isChildDescriptor()) {
                List list = (List)((ArrayList)this.getPrimaryKeyFields()).clone();
                for (int i = 0; i < list.size(); ++i) {
                    DatabaseField databaseField = (DatabaseField)list.get(i);
                    this.initializePrimaryKey(databaseField);
                }
            }
            if (this.getSequenceNumberField() != null) {
                this.buildField(this.getSequenceNumberField());
            }
        }
        this.setSessionName(session.getName());
    }

    protected void initializePrimaryKey(DatabaseField databaseField) {
        this.buildField(databaseField);
        if (!databaseField.getTable().equals(this.getDefaultTable())) {
            this.getPrimaryKeyFields().remove(databaseField);
        }
    }

    public void interfaceInitialization(Session session) throws DescriptorException {
        if (this.isInterfaceInitialized(2)) {
            return;
        }
        this.setInterfaceInitializationStage(2);
        if (this.isInterfaceChildDescriptor()) {
            Enumeration enumeration = this.getInterfacePolicy().getParentInterfaces().elements();
            while (enumeration.hasMoreElements()) {
                Class clazz = (Class)enumeration.nextElement();
                Descriptor descriptor = session.getDescriptor(clazz);
                descriptor.interfaceInitialization(session);
                if (this.isDescriptorForInterface()) {
                    this.setQueryKeys(Helper.concatenateMaps(this.getQueryKeys(), descriptor.getQueryKeys()));
                } else {
                    Iterator iterator = descriptor.getQueryKeys().keySet().iterator();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        if (this.hasQueryKeyOrMapping(string)) continue;
                        session.getIntegrityChecker().handleError(DescriptorException.childDoesNotDefineAbstractQueryKeyOfParent(this, descriptor, string));
                    }
                }
                if (descriptor != this) continue;
                return;
            }
        }
        this.getInterfacePolicy().initialize(session);
    }

    public boolean isAggregateCollectionDescriptor() {
        return this.getDescriptorType() == 3;
    }

    public boolean isAggregateDescriptor() {
        return this.getDescriptorType() == 2;
    }

    public boolean isChildDescriptor() {
        return this.hasInheritance() && this.getInheritancePolicy().isChildDescriptor();
    }

    public boolean isDescriptorForInterface() {
        return this.getDescriptorType() == 1;
    }

    public boolean isFullyInitialized() {
        return this.initializationStage == 3;
    }

    protected boolean isInitialized(int n) {
        return this.initializationStage >= n;
    }

    public boolean isInterfaceChildDescriptor() {
        return this.hasInterfacePolicy() && this.getInterfacePolicy().isInterfaceChildDescriptor();
    }

    protected boolean isInterfaceInitialized(int n) {
        return this.interfaceInitializationStage >= n;
    }

    protected boolean isInvalid() {
        return this.initializationStage == -1;
    }

    public boolean isIsolated() {
        return this.isIsolated;
    }

    public boolean isMultipleTableDescriptor() {
        return this.getTables().size() > 1;
    }

    public boolean isPrimaryKeySetAfterInsert(Session session) {
        return this.usesSequenceNumbers() && session.getSequencing().shouldAcquireValueAfterInsert(this.getJavaClass()) || this.hasReturningPolicy() && this.getReturningPolicy().isUsedToSetPrimaryKey();
    }

    public void onlyRefreshCacheIfNewerVersion() {
        this.setShouldOnlyRefreshCacheIfNewerVersion(true);
    }

    public void postInitialize(Session session) throws DescriptorException {
        int n;
        Cloneable cloneable;
        Enumeration enumeration;
        if (this.isInitialized(3) || this.isInvalid()) {
            return;
        }
        this.setInitializationStage(3);
        if (this.hasInheritance()) {
            enumeration = this.getInheritancePolicy().getChildDescriptors().elements();
            while (enumeration.hasMoreElements()) {
                ((Descriptor)enumeration.nextElement()).postInitialize(session);
            }
        }
        enumeration = this.getMappings().elements();
        while (enumeration.hasMoreElements()) {
            cloneable = (DatabaseMapping)enumeration.nextElement();
            ((DatabaseMapping)cloneable).postInitialize(session);
            if (this.shouldAcquireCascadedLocks()) continue;
            if (cloneable instanceof ForeignReferenceMapping && !((ForeignReferenceMapping)cloneable).usesIndirection()) {
                this.setShouldAcquireCascadedLocks(true);
            }
            if (!(cloneable instanceof AggregateObjectMapping) || !((AggregateObjectMapping)cloneable).getDescriptor().shouldAcquireCascadedLocks()) continue;
            this.setShouldAcquireCascadedLocks(true);
        }
        if (this.hasInheritance()) {
            this.getInheritancePolicy().postInitialize(session);
        }
        for (n = this.getPrimaryKeyFields().size() - 1; n >= 0; --n) {
            cloneable = (DatabaseField)this.getPrimaryKeyFields().get(n);
            int n2 = this.getFields().indexOf(cloneable);
            if (n2 == -1) continue;
            cloneable = (DatabaseField)this.getFields().get(n2);
            this.getPrimaryKeyFields().set(n, cloneable);
        }
        for (n = 0; n < this.getFields().size(); ++n) {
            cloneable = (DatabaseField)this.getFields().elementAt(n);
            DatabaseMapping databaseMapping = this.getObjectBuilder().getMappingForField((DatabaseField)cloneable);
            if (databaseMapping != null && !databaseMapping.isAggregateMapping()) {
                ((DatabaseField)cloneable).setType(databaseMapping.getFieldClassification((DatabaseField)cloneable));
            }
            ((DatabaseField)cloneable).setIndex(n);
        }
        this.validateAfterInitialization(session);
        this.checkDatabase(session);
    }

    public void preInitialize(Session session) throws DescriptorException {
        Object object;
        Object object2;
        this.getObjectChangePolicy().initialize(session, this);
        if (this.isInitialized(1)) {
            return;
        }
        this.setInitializationStage(1);
        Iterator iterator = this.getTables().iterator();
        while (iterator.hasNext()) {
            object2 = (DatabaseTable)iterator.next();
            if (((DatabaseTable)object2).getName().indexOf(32) == -1) continue;
            object = ((DatasourcePlatform)session.getDatasourcePlatform()).getIdentifierQuoteCharacter();
            if (((DatabaseTable)object2).getName().indexOf((String)object) != -1) continue;
            ((DatabaseTable)object2).setName((String)object + ((DatabaseTable)object2).getName() + (String)object);
        }
        object2 = this.getMappings().elements();
        while (object2.hasMoreElements()) {
            try {
                object = (DatabaseMapping)object2.nextElement();
                ((DatabaseMapping)object).preInitialize(session);
            }
            catch (DescriptorException descriptorException) {
                session.getIntegrityChecker().handleError(descriptorException);
            }
        }
        this.validateBeforeInitialization(session);
        this.preInitializeInheritancePolicy(session);
        if (this.getDefaultTable() == null) {
            this.setDefaultTable(this.extractDefaultTable());
        }
        if (this.hasInheritance()) {
            this.getInheritancePolicy().preInitialize(session);
        }
        this.verifyTableQualifiers(session.getDatasourcePlatform());
        this.initializeProperties(session);
        if (!this.isAggregateDescriptor()) {
            this.adjustMultipleTableInsertOrder();
            this.initializeMultipleTablePrimaryKeyFields();
        }
        if (this.hasInterfacePolicy()) {
            this.preInterfaceInitialization(session);
        }
        this.getQueryManager().preInitialize(session);
    }

    protected void prepareCascadeLockingPolicy(DatabaseMapping databaseMapping) {
        if (databaseMapping.isPrivateOwned() && databaseMapping.isForeignReferenceMapping()) {
            if (databaseMapping.isCascadedLockingSupported()) {
                if (((ForeignReferenceMapping)databaseMapping).hasCustomSelectionQuery()) {
                    throw ValidationException.unsupportedCascadeLockingMappingWithCustomQuery(databaseMapping);
                }
                if (this.isAggregateDescriptor() || this.isAggregateCollectionDescriptor()) {
                    throw ValidationException.unsupportedCascadeLockingDescriptor(this);
                }
                databaseMapping.prepareCascadeLockingPolicy();
            } else {
                throw ValidationException.unsupportedCascadeLockingMapping(databaseMapping);
            }
        }
    }

    protected void preInitializeInheritancePolicy(Session session) throws DescriptorException {
        if (this.isChildDescriptor() && this.requiresInitialization()) {
            if (this.getInheritancePolicy().getParentClass().equals(this.getJavaClass())) {
                this.setInterfaceInitializationStage(-1);
                throw DescriptorException.parentClassIsSelf(this);
            }
            Descriptor descriptor = session.getDescriptor(this.getInheritancePolicy().getParentClass());
            descriptor.getInheritancePolicy().addChildDescriptor(this);
            this.getInheritancePolicy().setParentDescriptor(descriptor);
            descriptor.preInitialize(session);
        }
    }

    public void preInterfaceInitialization(Session session) throws DescriptorException {
        if (this.isInterfaceInitialized(1)) {
            return;
        }
        this.setInterfaceInitializationStage(1);
        if (this.isInterfaceChildDescriptor()) {
            Enumeration enumeration = this.getInterfacePolicy().getParentInterfaces().elements();
            while (enumeration.hasMoreElements()) {
                Class clazz = (Class)enumeration.nextElement();
                Descriptor descriptor = session.getDescriptor(clazz);
                if (descriptor == null || descriptor.getJavaClass() == this.getJavaClass() || descriptor.getInterfacePolicy().usesImplementorDescriptor()) {
                    session.getProject().getDescriptors().put(clazz, this);
                    session.clearLastDescriptorAccessed();
                    continue;
                }
                if (!descriptor.isDescriptorForInterface()) {
                    throw DescriptorException.descriptorForInterfaceIsMissing(clazz.getName());
                }
                descriptor.preInterfaceInitialization(session);
                descriptor.getInterfacePolicy().addChildDescriptor(this);
                this.getInterfacePolicy().addParentDescriptor(descriptor);
            }
        }
    }

    public void rehashFieldDependancies(Session session) {
        this.getObjectBuilder().rehashFieldDependancies(session);
        Enumeration enumeration = this.getMappings().elements();
        while (enumeration.hasMoreElements()) {
            ((DatabaseMapping)enumeration.nextElement()).rehashFieldDependancies(session);
        }
    }

    public void reInitializeJoinedAttributes() {
        if (!this.isInitialized(3)) {
            return;
        }
        this.getObjectBuilder().initializeJoinedAttributes();
        if (this.hasInheritance()) {
            Vector vector = this.getInheritancePolicy().getChildDescriptors();
            for (int i = 0; i < vector.size(); ++i) {
                InheritancePolicy inheritancePolicy = (InheritancePolicy)vector.elementAt(0);
                inheritancePolicy.getDescriptor().reInitializeJoinedAttributes();
            }
        }
    }

    public void remoteInitialization(DistributedSession distributedSession) {
        Enumeration enumeration = this.getMappings().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseMapping databaseMapping = (DatabaseMapping)enumeration.nextElement();
            databaseMapping.remoteInitialization(distributedSession);
        }
        this.getEventManager().remoteInitialization(distributedSession);
        this.getInstantiationPolicy().initialize(distributedSession);
        this.getCopyPolicy().initialize(distributedSession);
        if (this.hasInheritance()) {
            this.getInheritancePolicy().remoteInitialization(distributedSession);
        }
    }

    public void removeProperty(String string) {
        this.getProperties().remove(string);
    }

    public boolean requiresInitialization() {
        return !this.isAggregateDescriptor() && !this.isDescriptorForInterface();
    }

    protected void selfValidationAfterInitialization(Session session) throws DescriptorException {
        if ((!this.hasInheritance() || !this.getInheritancePolicy().shouldReadSubclasses() && !Modifier.isAbstract(this.getJavaClass().getModifiers())) && session.getIntegrityChecker().shouldCheckInstantiationPolicy()) {
            this.getInstantiationPolicy().buildNewInstance();
        }
        if (this.hasReturningPolicy()) {
            this.getReturningPolicy().validationAfterDescriptorInitialization(session);
        }
        this.getObjectBuilder().validate(session);
    }

    protected void selfValidationBeforeInitialization(Session session) throws DescriptorException {
        if (this.isChildDescriptor()) {
            Descriptor descriptor = session.getDescriptor(this.getInheritancePolicy().getParentClass());
            if (descriptor == null) {
                session.getIntegrityChecker().handleError(DescriptorException.parentDescriptorNotSpecified(this.getInheritancePolicy().getParentClass().getName(), this));
            }
        } else if (this.getTables().isEmpty() && !this.isAggregateDescriptor()) {
            session.getIntegrityChecker().handleError(DescriptorException.tableNotSpecified(this));
        }
        if (!this.isChildDescriptor() && !this.isAggregateDescriptor() && this.getPrimaryKeyFieldNames().isEmpty()) {
            session.getIntegrityChecker().handleError(DescriptorException.primaryKeyFieldsNotSepcified(this));
        }
        if (this.getIdentityMapClass() == ClassConstants.NoIdentityMap_Class && this.getQueryManager().getDoesExistQuery().shouldCheckCacheForDoesExist()) {
            session.getIntegrityChecker().handleError(DescriptorException.identityMapNotSpecified(this));
        }
        if (this.getSequenceNumberName() != null && this.getSequenceNumberField() == null || this.getSequenceNumberName() == null && this.getSequenceNumberField() != null) {
            session.getIntegrityChecker().handleError(DescriptorException.sequenceNumberPropertyNotSpecified(this));
        }
    }

    protected void setAdditionalTablePrimaryKeyFields(DatabaseTable databaseTable, DatabaseField databaseField, DatabaseField databaseField2) {
        HashMap<DatabaseField, DatabaseField> hashMap = (HashMap<DatabaseField, DatabaseField>)this.getAdditionalTablePrimaryKeyFields().get(databaseTable);
        if (hashMap == null) {
            hashMap = new HashMap<DatabaseField, DatabaseField>(2);
            this.getAdditionalTablePrimaryKeyFields().put(databaseTable, hashMap);
        }
        hashMap.put(databaseField, databaseField2);
    }

    protected void toggleAdditionalTablePrimaryKeyFields(DatabaseTable databaseTable, DatabaseTable databaseTable2) {
        Map map = (Map)this.getAdditionalTablePrimaryKeyFields().get(databaseTable);
        if (map != null) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                DatabaseField databaseField = (DatabaseField)iterator.next();
                DatabaseField databaseField2 = (DatabaseField)map.get(databaseField);
                this.setAdditionalTablePrimaryKeyFields(databaseTable2, databaseField2, databaseField);
            }
            map.clear();
        }
    }

    protected void setAdditionalTablePrimaryKeyFields(Map map) {
        this.additionalTablePrimaryKeyFields = map;
    }

    public void setAlias(String string) {
        this.alias = string;
    }

    protected void setAllFields(Vector vector) {
        this.allFields = vector;
    }

    public void setAmendmentClass(Class clazz) {
        this.amendmentClass = clazz;
    }

    public void setAmendmentClassName(String string) {
        this.amendmentClassName = string;
    }

    public void setAmendmentMethodName(String string) {
        this.amendmentMethodName = string;
    }

    public void setCacheSynchronizationType(int n) {
        if (!this.isIsolated) {
            this.cacheSynchronizationType = n;
        }
    }

    public void setObjectChangePolicy(ObjectChangePolicy objectChangePolicy) {
        this.changePolicy = objectChangePolicy;
    }

    public void setHistoryPolicy(HistoryPolicy historyPolicy) {
        this.historyPolicy = historyPolicy;
        if (historyPolicy != null) {
            historyPolicy.setDescriptor(this);
        }
    }

    public void setCacheInvalidationPolicy(CacheInvalidationPolicy cacheInvalidationPolicy) {
        this.cacheInvalidationPolicy = cacheInvalidationPolicy;
    }

    public void setConstraintDependencies(Vector vector) {
        this.constraintDependencies = vector;
    }

    public void setCopyPolicy(CopyPolicy copyPolicy) {
        this.copyPolicy = copyPolicy;
        if (copyPolicy != null) {
            copyPolicy.setDescriptor(this);
        }
    }

    public void setDefaultTable(DatabaseTable databaseTable) {
        this.defaultTable = databaseTable;
    }

    public void setDefaultTableName(String string) {
        this.setDefaultTable(new DatabaseTable(string));
    }

    public void setDescriptorType(int n) {
        this.descriptorType = n;
    }

    public void setDescriptorTypeValue(String string) {
        if (string.equals("Aggregate collection")) {
            this.descriptorIsAggregateCollection();
        } else if (string.equals("Aggregate")) {
            this.descriptorIsAggregate();
        } else if (string.equals("Interface")) {
            this.descriptorIsForInterface();
        } else {
            this.descriptorIsNormal();
        }
    }

    public void setEventManager(DescriptorEventManager descriptorEventManager) {
        this.eventManager = descriptorEventManager;
        if (descriptorEventManager != null) {
            descriptorEventManager.setDescriptor(this);
        }
    }

    public void setExistenceChecking(String string) throws DescriptorException {
        this.getQueryManager().setExistenceCheck(string);
    }

    public void setFields(Vector vector) {
        this.fields = vector;
    }

    public void setIdentityMapClass(Class clazz) {
        this.identityMapClass = clazz;
    }

    public void setIdentityMapSize(int n) {
        this.identityMapSize = n;
    }

    public void setInheritancePolicy(InheritancePolicy inheritancePolicy) {
        this.inheritancePolicy = inheritancePolicy;
        if (inheritancePolicy != null) {
            inheritancePolicy.setDescriptor(this);
        }
    }

    public void setReturningPolicy(ReturningPolicy returningPolicy) {
        this.returningPolicy = returningPolicy;
        if (returningPolicy != null) {
            returningPolicy.setDescriptor(this);
        }
    }

    protected void setInitializationStage(int n) {
        this.initializationStage = n;
    }

    public void setInstantiationPolicy(InstantiationPolicy instantiationPolicy) {
        this.instantiationPolicy = instantiationPolicy;
        if (instantiationPolicy != null) {
            instantiationPolicy.setDescriptor(this);
        }
    }

    protected void setInterfaceInitializationStage(int n) {
        this.interfaceInitializationStage = n;
    }

    public void setInterfacePolicy(InterfacePolicy interfacePolicy) {
        this.interfacePolicy = interfacePolicy;
        if (interfacePolicy != null) {
            interfacePolicy.setDescriptor(this);
        }
    }

    public void setIsIsolated(boolean bl) {
        this.isIsolated = bl;
        if (bl) {
            this.cacheSynchronizationType = 4;
        }
    }

    public boolean shouldIsolateObjectsInUnitOfWork() {
        return this.getUnitOfWorkCacheIsolationLevel() == 3;
    }

    public boolean shouldIsolateObjectsInUnitOfWorkEarlyTransaction() {
        return this.getUnitOfWorkCacheIsolationLevel() == 2;
    }

    public boolean shouldUseSessionCacheInUnitOfWorkEarlyTransaction() {
        return this.getUnitOfWorkCacheIsolationLevel() == 0;
    }

    public int getUnitOfWorkCacheIsolationLevel() {
        return this.unitOfWorkCacheIsolationLevel;
    }

    public void setUnitOfWorkCacheIsolationLevel(int n) {
        this.unitOfWorkCacheIsolationLevel = n;
    }

    public void setJavaClass(Class clazz) {
        this.javaClass = clazz;
    }

    public void setJavaClassName(String string) {
        this.javaClassName = string;
    }

    public void setJavaInterface(Class clazz) {
        this.javaClass = clazz;
        this.descriptorIsForInterface();
    }

    public void setJavaInterfaceName(String string) {
        this.javaClassName = string;
        this.descriptorIsForInterface();
    }

    public void setLockableMappings(ArrayList arrayList) {
        this.lockableMappings = arrayList;
    }

    public void setMappings(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            DatabaseMapping databaseMapping = (DatabaseMapping)enumeration.nextElement();
            if (databaseMapping.getDescriptor() != null) continue;
            databaseMapping.setDescriptor(this);
        }
        this.mappings = vector;
    }

    public void setMultipleTableForeignKeyFieldNames(Vector vector) throws DescriptorException {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Association association = (Association)enumeration.nextElement();
            this.addMultipleTableForeignKeys((String)association.getKey(), (String)association.getValue(), true);
        }
    }

    protected void setMultipleTableForeignKeys(Map map) {
        this.multipleTableForeignKeys = map;
    }

    public void setMultipleTableInsertOrder(Vector vector) {
        this.multipleTableInsertOrder = vector;
    }

    public void setMultipleTablePrimaryKeyFieldNames(Vector vector) throws DescriptorException {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Association association = (Association)enumeration.nextElement();
            this.addMultipleTableForeignKeys((String)association.getKey(), (String)association.getValue(), true);
        }
    }

    protected void setObjectBuilder(ObjectBuilder objectBuilder) {
        this.objectBuilder = objectBuilder;
    }

    public void setOptimisticLockingPolicy(OptimisticLockingPolicy optimisticLockingPolicy) {
        this.optimisticLockingPolicy = optimisticLockingPolicy;
        if (optimisticLockingPolicy != null) {
            optimisticLockingPolicy.setDescriptor(this);
        }
    }

    public void setPrimaryKeyFieldName(String string) {
        this.addPrimaryKeyFieldName(string);
    }

    public void setPrimaryKeyFieldNames(Vector vector) {
        this.setPrimaryKeyFields(new ArrayList(vector.size()));
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.addPrimaryKeyFieldName((String)enumeration.nextElement());
        }
    }

    public void setPrimaryKeyFields(List list) {
        this.primaryKeyFields = list;
    }

    public void setProperties(Map map) {
        this.properties = map;
    }

    public void setProperty(String string, Object object) {
        this.getProperties().put(string, object);
    }

    public void setQueryKeys(Map map) {
        this.queryKeys = map;
    }

    public void setQueryManager(DescriptorQueryManager descriptorQueryManager) {
        this.queryManager = descriptorQueryManager;
        if (descriptorQueryManager != null) {
            descriptorQueryManager.setDescriptor(this);
        }
    }

    public void setRemoteIdentityMapClass(Class clazz) {
        this.remoteIdentityMapClass = clazz;
    }

    public void setRemoteIdentityMapSize(int n) {
        this.remoteIdentityMapSize = n;
    }

    public void setSequenceNumberField(DatabaseField databaseField) {
        this.sequenceNumberField = databaseField;
    }

    public void setSequenceNumberFieldName(String string) {
        if (string == null) {
            this.setSequenceNumberField(null);
        } else {
            this.setSequenceNumberField(new DatabaseField(string));
        }
    }

    public void setSequenceNumberName(String string) {
        this.sequenceNumberName = string;
    }

    protected void setSessionName(String string) {
        this.sessionName = string;
    }

    public void setShouldAlwaysConformResultsInUnitOfWork(boolean bl) {
        this.shouldAlwaysConformResultsInUnitOfWork = bl;
    }

    public void setShouldAlwaysRefreshCache(boolean bl) {
        this.shouldAlwaysRefreshCache = bl;
    }

    public void setShouldAlwaysRefreshCacheOnRemote(boolean bl) {
        this.shouldAlwaysRefreshCacheOnRemote = bl;
    }

    public void setShouldBeReadOnly(boolean bl) {
        this.shouldBeReadOnly = bl;
    }

    public void setReadOnly() {
        this.setShouldBeReadOnly(true);
    }

    public void setShouldDisableCacheHits(boolean bl) {
        this.shouldDisableCacheHits = bl;
    }

    public void setShouldDisableCacheHitsOnRemote(boolean bl) {
        this.shouldDisableCacheHitsOnRemote = bl;
    }

    public void setShouldOnlyRefreshCacheIfNewerVersion(boolean bl) {
        this.shouldOnlyRefreshCacheIfNewerVersion = bl;
    }

    public void setShouldOrderMappings(boolean bl) {
        this.shouldOrderMappings = bl;
    }

    public void setShouldRegisterResultsInUnitOfWork(boolean bl) {
        this.shouldRegisterResultsInUnitOfWork = bl;
    }

    public void setTableName(String string) throws DescriptorException {
        if (!this.getTables().isEmpty()) {
            throw DescriptorException.onlyOneTableCanBeAddedWithThisMethod(this);
        }
        this.addTableName(string);
    }

    public void setTableNames(Vector vector) {
        this.setTables(NonSynchronizedVector.newInstance(vector.size()));
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.addTableName((String)enumeration.nextElement());
        }
    }

    public void setTableQualifier(String string) {
        Enumeration enumeration = this.getTables().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseTable databaseTable = (DatabaseTable)enumeration.nextElement();
            databaseTable.setTableQualifier(string);
        }
    }

    public void setTables(Vector vector) {
        this.tables = vector;
    }

    public void setWrapperPolicy(WrapperPolicy wrapperPolicy) {
        this.wrapperPolicy = wrapperPolicy;
        if (wrapperPolicy != null) {
            wrapperPolicy.setDescriptor(this);
        }
    }

    public boolean shouldAlwaysConformResultsInUnitOfWork() {
        return this.shouldAlwaysConformResultsInUnitOfWork;
    }

    public boolean shouldAlwaysRefreshCache() {
        return this.shouldAlwaysRefreshCache;
    }

    public boolean shouldAlwaysRefreshCacheOnRemote() {
        return this.shouldAlwaysRefreshCacheOnRemote;
    }

    public boolean shouldBeReadOnly() {
        return this.shouldBeReadOnly;
    }

    public boolean shouldDisableCacheHits() {
        return this.shouldDisableCacheHits;
    }

    public boolean shouldDisableCacheHitsOnRemote() {
        return this.shouldDisableCacheHitsOnRemote;
    }

    public boolean shouldOnlyRefreshCacheIfNewerVersion() {
        return this.shouldOnlyRefreshCacheIfNewerVersion;
    }

    public boolean shouldOrderMappings() {
        return this.shouldOrderMappings;
    }

    public boolean hasSimplePrimaryKey() {
        return this.hasSimplePrimaryKey;
    }

    public void setHasSimplePrimaryKey(boolean bl) {
        this.hasSimplePrimaryKey = bl;
    }

    public boolean shouldAcquireCascadedLocks() {
        return this.shouldAcquireCascadedLocks;
    }

    public void setShouldAcquireCascadedLocks(boolean bl) {
        this.shouldAcquireCascadedLocks = bl;
    }

    public boolean shouldUseCacheIdentityMap() {
        return this.getIdentityMapClass() == ClassConstants.CacheIdentityMap_Class;
    }

    public boolean shouldUseFullIdentityMap() {
        return this.getIdentityMapClass() == ClassConstants.FullIdentityMap_Class;
    }

    public boolean shouldUseHardCacheWeakIdentityMap() {
        return this.getIdentityMapClass() == ClassConstants.HardCacheWeakIdentityMap_Class;
    }

    public boolean shouldUseNoIdentityMap() {
        return this.getIdentityMapClass() == ClassConstants.NoIdentityMap_Class;
    }

    public boolean shouldRegisterResultsInUnitOfWork() {
        return this.shouldRegisterResultsInUnitOfWork;
    }

    public boolean shouldUseRemoteCacheIdentityMap() {
        return this.getRemoteIdentityMapClass() == ClassConstants.CacheIdentityMap_Class;
    }

    public boolean shouldUseRemoteFullIdentityMap() {
        return this.getRemoteIdentityMapClass() == ClassConstants.FullIdentityMap_Class;
    }

    public boolean shouldUseRemoteHardCacheWeakIdentityMap() {
        return this.getRemoteIdentityMapClass() == ClassConstants.HardCacheWeakIdentityMap_Class;
    }

    public boolean shouldUseRemoteNoIdentityMap() {
        return this.getRemoteIdentityMapClass() == ClassConstants.NoIdentityMap_Class;
    }

    public boolean shouldUseRemoteSoftCacheWeakIdentityMap() {
        return this.getRemoteIdentityMapClass() == ClassConstants.SoftCacheWeakIdentityMap_Class;
    }

    public boolean shouldUseRemoteWeakIdentityMap() {
        return this.getRemoteIdentityMapClass() == ClassConstants.WeakIdentityMap_Class;
    }

    public boolean shouldUseSoftCacheWeakIdentityMap() {
        return this.getIdentityMapClass() == ClassConstants.SoftCacheWeakIdentityMap_Class;
    }

    public boolean shouldUseWeakIdentityMap() {
        return this.getIdentityMapClass() == ClassConstants.WeakIdentityMap_Class;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "(" + this.getJavaClassName() + " --> " + this.getTables() + ")";
    }

    public void useAllFieldsLocking() {
        this.setOptimisticLockingPolicy(new AllFieldsLockingPolicy());
    }

    public void useCacheIdentityMap() {
        this.setIdentityMapClass(ClassConstants.CacheIdentityMap_Class);
    }

    public void useChangedFieldsLocking() {
        this.setOptimisticLockingPolicy(new ChangedFieldsLockingPolicy());
    }

    public void useCloneCopyPolicy() {
        this.useCloneCopyPolicy("clone");
    }

    public void useCloneCopyPolicy(String string) {
        CloneCopyPolicy cloneCopyPolicy = new CloneCopyPolicy();
        cloneCopyPolicy.setMethodName(string);
        this.setCopyPolicy(cloneCopyPolicy);
    }

    public void useInstantiationCopyPolicy() {
        this.setCopyPolicy(new InstantiationCopyPolicy());
    }

    public void useDefaultConstructorInstantiationPolicy() {
        this.getInstantiationPolicy().useDefaultConstructorInstantiationPolicy();
    }

    public void useFactoryInstantiationPolicy(Class clazz, String string) {
        this.getInstantiationPolicy().useFactoryInstantiationPolicy(clazz, string);
    }

    public void useFactoryInstantiationPolicy(String string, String string2) {
        this.getInstantiationPolicy().useFactoryInstantiationPolicy(string, string2);
    }

    public void useFactoryInstantiationPolicy(Class clazz, String string, String string2) {
        this.getInstantiationPolicy().useFactoryInstantiationPolicy(clazz, string, string2);
    }

    public void useFactoryInstantiationPolicy(String string, String string2, String string3) {
        this.getInstantiationPolicy().useFactoryInstantiationPolicy(string, string2, string3);
    }

    public void useFactoryInstantiationPolicy(Object object, String string) {
        this.getInstantiationPolicy().useFactoryInstantiationPolicy(object, string);
    }

    public void useFullIdentityMap() {
        this.setIdentityMapClass(ClassConstants.FullIdentityMap_Class);
    }

    public void useHardCacheWeakIdentityMap() {
        this.setIdentityMapClass(ClassConstants.HardCacheWeakIdentityMap_Class);
    }

    public void useMethodInstantiationPolicy(String string) {
        this.getInstantiationPolicy().useMethodInstantiationPolicy(string);
    }

    public void useNoIdentityMap() {
        this.setIdentityMapClass(ClassConstants.NoIdentityMap_Class);
    }

    public void useRemoteCacheIdentityMap() {
        this.setRemoteIdentityMapClass(ClassConstants.CacheIdentityMap_Class);
    }

    public void useRemoteFullIdentityMap() {
        this.setRemoteIdentityMapClass(ClassConstants.FullIdentityMap_Class);
    }

    public void useRemoteHardCacheWeakIdentityMap() {
        this.setRemoteIdentityMapClass(ClassConstants.HardCacheWeakIdentityMap_Class);
    }

    public void useRemoteNoIdentityMap() {
        this.setRemoteIdentityMapClass(ClassConstants.NoIdentityMap_Class);
    }

    public void useRemoteSoftCacheWeakIdentityMap() {
        this.setRemoteIdentityMapClass(ClassConstants.SoftCacheWeakIdentityMap_Class);
    }

    public void useRemoteWeakIdentityMap() {
        this.setRemoteIdentityMapClass(ClassConstants.WeakIdentityMap_Class);
    }

    public void useSelectedFieldsLocking(Vector vector) {
        SelectedFieldsLockingPolicy selectedFieldsLockingPolicy = new SelectedFieldsLockingPolicy();
        selectedFieldsLockingPolicy.setLockFieldNames(vector);
        this.setOptimisticLockingPolicy(selectedFieldsLockingPolicy);
    }

    public boolean usesFieldLocking() {
        return this.usesOptimisticLocking() && this.getOptimisticLockingPolicy() instanceof FieldsLockingPolicy;
    }

    public void useSoftCacheWeakIdentityMap() {
        this.setIdentityMapClass(ClassConstants.SoftCacheWeakIdentityMap_Class);
    }

    public boolean usesOptimisticLocking() {
        return this.optimisticLockingPolicy != null;
    }

    public boolean usesSequenceNumbers() {
        return this.getSequenceNumberField() != null && this.getSequenceNumberName() != null;
    }

    public void useTimestampLocking(String string) {
        this.useTimestampLocking(string, true);
    }

    public void useTimestampLocking(String string, boolean bl) {
        TimestampLockingPolicy timestampLockingPolicy = new TimestampLockingPolicy(string);
        if (bl) {
            timestampLockingPolicy.storeInCache();
        } else {
            timestampLockingPolicy.storeInObject();
        }
        this.setOptimisticLockingPolicy(timestampLockingPolicy);
    }

    public void useVersionLocking(String string) {
        this.useVersionLocking(string, true);
    }

    public void useVersionLocking(String string, boolean bl) {
        VersionLockingPolicy versionLockingPolicy = new VersionLockingPolicy(string);
        if (bl) {
            versionLockingPolicy.storeInCache();
        } else {
            versionLockingPolicy.storeInObject();
        }
        this.setOptimisticLockingPolicy(versionLockingPolicy);
    }

    public void useWeakIdentityMap() {
        this.setIdentityMapClass(ClassConstants.WeakIdentityMap_Class);
    }

    protected void validateAfterInitialization(Session session) {
        this.selfValidationAfterInitialization(session);
        Enumeration enumeration = this.getMappings().elements();
        while (enumeration.hasMoreElements()) {
            ((DatabaseMapping)enumeration.nextElement()).validateAfterInitialization(session);
        }
    }

    protected void validateBeforeInitialization(Session session) {
        this.selfValidationBeforeInitialization(session);
        Enumeration enumeration = this.getMappings().elements();
        while (enumeration.hasMoreElements()) {
            ((DatabaseMapping)enumeration.nextElement()).validateBeforeInitialization(session);
        }
    }

    protected void verifyTableQualifiers(Platform platform) {
        String string = platform.getTableQualifier();
        if (string.length() == 0) {
            return;
        }
        Enumeration enumeration = this.getTables().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseTable databaseTable = (DatabaseTable)enumeration.nextElement();
            if (databaseTable.getTableQualifier().length() != 0) continue;
            databaseTable.setTableQualifier(string);
        }
    }

    public CMPPolicy getCMPPolicy() {
        return this.cmpPolicy;
    }

    public void setCMPPolicy(CMPPolicy cMPPolicy) {
        this.cmpPolicy = cMPPolicy;
        if (this.cmpPolicy != null) {
            this.cmpPolicy.setDescriptor(this);
        }
    }

    public boolean hasPessimisticLockingPolicy() {
        return this.cmpPolicy != null && this.cmpPolicy.hasPessimisticLockingPolicy();
    }

    public FetchGroupManager getFetchGroupManager() {
        return this.fetchGroupManager;
    }

    public void setFetchGroupManager(FetchGroupManager fetchGroupManager) {
        this.fetchGroupManager = fetchGroupManager;
        if (fetchGroupManager != null) {
            fetchGroupManager.setDescriptor(this);
        }
    }

    public boolean isDescriptorForCMP() {
        return this.getCMPPolicy() != null;
    }

    public boolean hasFetchGroupManager() {
        return this.fetchGroupManager != null;
    }

    public boolean hasCascadeLockingPolicies() {
        return !this.cascadeLockingPolicies.isEmpty();
    }

    public boolean hasCMPPolicy() {
        return this.cmpPolicy != null;
    }

    public FetchGroup getDefaultFetchGroup() {
        if (!this.hasFetchGroupManager()) {
            return null;
        }
        return this.getFetchGroupManager().getDefaultFetchGroup();
    }

    public boolean isReturnTypeRequiredForReturningPolicy() {
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

