/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.publicinterface;

import java.io.Serializable;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.sessions.Record;

public class DatabaseRow
implements Record,
Cloneable,
Serializable,
Map {
    protected Vector fields;
    protected Vector values;
    protected DatabaseField lookupField;
    public static NoEntry noEntry = new NoEntry();

    public DatabaseRow() {
        this.fields = new Vector();
        this.values = new Vector();
    }

    public DatabaseRow(int n) {
        this.fields = new Vector(n);
        this.values = new Vector(n);
    }

    public DatabaseRow(Vector vector, Vector vector2) {
        this.fields = vector;
        this.values = vector2;
    }

    public void add(DatabaseField databaseField, Object object) {
        this.getFields().addElement(databaseField);
        this.getValues().addElement(object);
    }

    public void clear() {
        this.fields = new Vector();
        this.values = new Vector();
    }

    public Object clone() {
        try {
            DatabaseRow databaseRow = (DatabaseRow)super.clone();
            databaseRow.setFields((Vector)this.getFields().clone());
            databaseRow.setValues((Vector)this.getValues().clone());
            return databaseRow;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean contains(Object object) {
        return this.containsValue(object);
    }

    public boolean containsKey(Object object) {
        if (object instanceof String) {
            return this.containsKey((String)object);
        }
        if (object instanceof DatabaseField) {
            return this.containsKey((DatabaseField)object);
        }
        return false;
    }

    public boolean containsKey(String string) {
        if (this.lookupField == null) {
            this.lookupField = new DatabaseField(string);
        } else {
            this.lookupField.resetQualifiedName(string);
        }
        return this.containsKey(this.lookupField);
    }

    public boolean containsKey(DatabaseField databaseField) {
        DatabaseField databaseField2;
        int n = databaseField.getIndex();
        if (n >= 0 && n < this.getFields().size() && ((databaseField2 = (DatabaseField)this.getFields().elementAt(n)) == databaseField || databaseField2.equals(databaseField))) {
            return true;
        }
        return this.getFields().contains(databaseField);
    }

    public boolean containsValue(Object object) {
        return this.getValues().contains(object);
    }

    public Enumeration elements() {
        return this.getValues().elements();
    }

    public Set entrySet() {
        int n = this.size();
        HashMap hashMap = new HashMap(n);
        for (int i = 0; i < n; ++i) {
            hashMap.put(this.getFields().elementAt(i), this.getValues().elementAt(i));
        }
        return hashMap.entrySet();
    }

    public Object get(Object object) {
        if (object instanceof String) {
            return this.get((String)object);
        }
        if (object instanceof DatabaseField) {
            return this.get((DatabaseField)object);
        }
        return null;
    }

    public Object get(String string) {
        Object object = this.getIndicatingNoEntry(string);
        if (object == noEntry) {
            return null;
        }
        return object;
    }

    public Object getIndicatingNoEntry(String string) {
        if (this.lookupField == null) {
            this.lookupField = new DatabaseField(string);
        } else {
            this.lookupField.resetQualifiedName(string);
        }
        return this.getIndicatingNoEntry(this.lookupField);
    }

    public Object get(DatabaseField databaseField) {
        Object object = this.getIndicatingNoEntry(databaseField);
        if (object == noEntry) {
            return null;
        }
        return object;
    }

    public Object getValues(DatabaseField databaseField) {
        return this.get(databaseField);
    }

    public Object getValues(String string) {
        return this.get(string);
    }

    public Object getIndicatingNoEntry(DatabaseField databaseField) {
        DatabaseField databaseField2;
        int n = databaseField.index;
        if (n >= 0 && n < this.fields.size() && ((databaseField2 = (DatabaseField)this.fields.elementAt(n)) == databaseField || databaseField2.equals(databaseField))) {
            return this.values.elementAt(n);
        }
        n = this.fields.indexOf(databaseField);
        if (n >= 0) {
            if (n == -1) {
                databaseField.setIndex(n);
            }
            return this.values.elementAt(n);
        }
        return noEntry;
    }

    public DatabaseField getField(DatabaseField databaseField) {
        DatabaseField databaseField2;
        int n = databaseField.getIndex();
        if (n >= 0 && n < this.getFields().size() && ((databaseField2 = (DatabaseField)this.getFields().elementAt(n)) == databaseField || databaseField2.equals(databaseField))) {
            return databaseField2;
        }
        for (n = 0; n < this.getFields().size(); ++n) {
            databaseField2 = (DatabaseField)this.getFields().elementAt(n);
            if (databaseField2 != databaseField && !databaseField2.equals(databaseField)) continue;
            return databaseField2;
        }
        return null;
    }

    public Vector getFields() {
        return this.fields;
    }

    public Vector getValues() {
        return this.values;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Enumeration keys() {
        return this.getFields().elements();
    }

    public Set keySet() {
        return new HashSet(this.getFields());
    }

    public void mergeFrom(DatabaseRow databaseRow) {
        for (int i = 0; i < databaseRow.size(); ++i) {
            this.put(databaseRow.getFields().get(i), databaseRow.getValues().get(i));
        }
    }

    public Object put(Object object, Object object2) throws ValidationException {
        if (object instanceof String) {
            return this.put((String)object, object2);
        }
        if (object instanceof DatabaseField) {
            return this.put((DatabaseField)object, object2);
        }
        throw ValidationException.onlyFieldsAreValidKeysForDatabaseRows();
    }

    public Object put(String string, Object object) {
        return this.put(new DatabaseField(string), object);
    }

    public Object put(DatabaseField databaseField, Object object) {
        int n = this.getFields().indexOf(databaseField);
        if (n >= 0) {
            Object e = this.getValues().elementAt(n);
            this.replaceAt(object, n);
            return e;
        }
        this.add(databaseField, object);
        return null;
    }

    public void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object object) {
        if (object instanceof String) {
            return this.remove((String)object);
        }
        if (object instanceof DatabaseField) {
            return this.remove((DatabaseField)object);
        }
        return null;
    }

    public Object remove(String string) {
        return this.remove(new DatabaseField(string));
    }

    public Object remove(DatabaseField databaseField) {
        int n = this.getFields().indexOf(databaseField);
        if (n >= 0) {
            this.getFields().removeElementAt(n);
            Object e = this.getValues().elementAt(n);
            this.getValues().removeElementAt(n);
            return e;
        }
        return null;
    }

    public void replaceAt(Object object, int n) {
        this.getValues().setElementAt(object, n);
    }

    protected void setFields(Vector vector) {
        this.fields = vector;
    }

    protected void setValues(Vector vector) {
        this.values = vector;
    }

    public int size() {
        return this.getFields().size();
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write(Helper.getShortClassName(this.getClass()));
        stringWriter.write("(");
        for (int i = 0; i < this.getFields().size(); ++i) {
            stringWriter.write(Helper.cr());
            stringWriter.write("\t");
            stringWriter.write(String.valueOf(this.getFields().elementAt(i)));
            stringWriter.write(" => ");
            stringWriter.write(String.valueOf(this.getValues().elementAt(i)));
        }
        stringWriter.write(")");
        return stringWriter.toString();
    }

    public Collection values() {
        return this.getValues();
    }

    public static class NoEntry {
        private NoEntry() {
        }
    }
}

