/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.platform.xml.xdk;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import oracle.toplink.platform.xml.XMLPlatformException;
import oracle.toplink.platform.xml.XMLTransformer;
import oracle.toplink.platform.xml.xdk.XDKPrintDriver;
import oracle.xml.jaxp.JXTransformer;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLDocumentFragment;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLProcessor;
import oracle.xml.parser.v2.XSLStylesheet;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class XDKTransformer
implements XMLTransformer {
    private String encoding;
    private String version;
    private boolean formattedOutput;
    private boolean fragment;

    public XDKTransformer() {
        this.setEncoding("utf-8");
        this.setVersion("1.0");
        this.setFormattedOutput(true);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public boolean isFormattedOutput() {
        return this.formattedOutput;
    }

    public void setFormattedOutput(boolean bl) {
        this.formattedOutput = bl;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public void transform(Node node, OutputStream outputStream) throws XMLPlatformException {
        try {
            XMLNode xMLNode = (XMLNode)node;
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, this.getEncoding());
            this.transform(node, outputStreamWriter);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw XMLPlatformException.xmlPlatformTransformException(unsupportedEncodingException);
        }
    }

    public void transform(Node node, ContentHandler contentHandler) throws XMLPlatformException {
        try {
            XMLNode xMLNode = (XMLNode)node;
            xMLNode.reportSAXEvents(contentHandler);
        }
        catch (SAXException sAXException) {
            throw XMLPlatformException.xmlPlatformTransformException(sAXException);
        }
    }

    public void transform(Node node, Result result) throws XMLPlatformException {
        DOMSource dOMSource = new DOMSource(node);
        this.transform(dOMSource, result);
    }

    public void transform(Node node, Writer writer) throws XMLPlatformException {
        try {
            XMLDocument xMLDocument = node.getNodeType() == 9 ? (XMLDocument)node : (XMLDocument)node.getOwnerDocument();
            if (this.isFragment()) {
                xMLDocument.setEncoding(null);
                xMLDocument.setVersion(null);
            } else {
                xMLDocument.setEncoding(this.getEncoding());
                xMLDocument.setVersion(this.getVersion());
            }
            XMLNode xMLNode = (XMLNode)node;
            PrintWriter printWriter = new PrintWriter(writer);
            XDKPrintDriver xDKPrintDriver = new XDKPrintDriver(printWriter);
            xDKPrintDriver.setFormattedOutput(this.isFormattedOutput());
            xDKPrintDriver.setEncoding(this.getEncoding());
            xDKPrintDriver.print(xMLNode);
            writer.flush();
        }
        catch (IOException iOException) {
            throw XMLPlatformException.xmlPlatformTransformException(iOException);
        }
    }

    public void transform(Source source, Result result) throws XMLPlatformException {
        try {
            JXTransformer jXTransformer = new JXTransformer();
            if (result instanceof StreamResult && this.isFragment()) {
                jXTransformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            if (result instanceof SAXResult && !this.isFragment()) {
                ((SAXResult)result).getHandler().startDocument();
            }
            jXTransformer.transform(source, result);
            if (result instanceof SAXResult && !this.isFragment()) {
                ((SAXResult)result).getHandler().endDocument();
            }
        }
        catch (TransformerException transformerException) {
            throw XMLPlatformException.xmlPlatformTransformException(transformerException);
        }
        catch (SAXException sAXException) {
            throw XMLPlatformException.xmlPlatformTransformException(sAXException);
        }
    }

    public void transform(Document document, Node node, URL uRL) throws XMLPlatformException {
        try {
            XSLProcessor xSLProcessor = new XSLProcessor();
            XSLStylesheet xSLStylesheet = xSLProcessor.newXSLStylesheet(uRL);
            XMLDocument xMLDocument = (XMLDocument)document;
            XMLDocumentFragment xMLDocumentFragment = xSLProcessor.processXSL(xSLStylesheet, xMLDocument);
            node.appendChild((Node)xMLDocumentFragment);
        }
        catch (XSLException xSLException) {
            throw XMLPlatformException.xmlPlatformTransformException((Exception)((Object)xSLException));
        }
    }

    public void setFragment(boolean bl) {
        this.fragment = bl;
    }

    public boolean isFragment() {
        return this.fragment;
    }
}

