/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.platform.xml.xdk;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.StringTokenizer;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.ox.NamespaceResolver;
import oracle.toplink.ox.XMLDescriptor;
import oracle.toplink.platform.xml.XMLNamespaceResolver;
import oracle.toplink.platform.xml.XMLParser;
import oracle.toplink.platform.xml.XMLPlatform;
import oracle.toplink.platform.xml.XMLPlatformException;
import oracle.toplink.platform.xml.XMLSchemaReference;
import oracle.toplink.platform.xml.XMLTransformer;
import oracle.toplink.platform.xml.xdk.XDKNamespaceResolver;
import oracle.toplink.platform.xml.xdk.XDKParser;
import oracle.toplink.platform.xml.xdk.XDKTransformer;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.schema.XSDComplexType;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDValidator;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.parser.v2.XSLException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XDKPlatform
implements XMLPlatform {
    private Method buildSchemaMethod;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$oracle$xml$parser$schema$XSDBuilder;

    public XDKPlatform() {
        try {
            Class[] classArray = new Class[]{class$java$net$URL == null ? (class$java$net$URL = XDKPlatform.class$("java.net.URL")) : class$java$net$URL};
            this.buildSchemaMethod = Helper.getDeclaredMethod(class$oracle$xml$parser$schema$XSDBuilder == null ? (class$oracle$xml$parser$schema$XSDBuilder = XDKPlatform.class$("oracle.xml.parser.schema.XSDBuilder")) : class$oracle$xml$parser$schema$XSDBuilder, "build", classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public Node selectSingleNodeAdvanced(Node node, String string, XMLNamespaceResolver xMLNamespaceResolver) throws XMLPlatformException {
        try {
            XMLNode xMLNode = (XMLNode)node;
            XDKNamespaceResolver xDKNamespaceResolver = new XDKNamespaceResolver(xMLNamespaceResolver);
            return xMLNode.selectSingleNode(string, (NSResolver)xDKNamespaceResolver);
        }
        catch (XSLException xSLException) {
            throw XMLPlatformException.xmlPlatformInvalidXPath((Exception)((Object)xSLException));
        }
    }

    public NodeList selectNodesAdvanced(Node node, String string, XMLNamespaceResolver xMLNamespaceResolver) throws XMLPlatformException {
        try {
            XMLNode xMLNode = (XMLNode)node;
            XDKNamespaceResolver xDKNamespaceResolver = new XDKNamespaceResolver(xMLNamespaceResolver);
            return xMLNode.selectNodes(string, (NSResolver)xDKNamespaceResolver);
        }
        catch (XSLException xSLException) {
            throw XMLPlatformException.xmlPlatformInvalidXPath((Exception)((Object)xSLException));
        }
    }

    public Document createDocument() throws XMLPlatformException {
        return new XMLDocument();
    }

    public Document createDocumentWithPublicIdentifier(String string, String string2, String string3) throws XMLPlatformException {
        try {
            XMLDocument xMLDocument = (XMLDocument)this.createDocument();
            Element element = xMLDocument.createElement(string);
            xMLDocument.appendChild((Node)element);
            xMLDocument.setDoctype(string, string3, string2);
            return xMLDocument;
        }
        catch (Exception exception) {
            throw XMLPlatformException.xmlPlatformCouldNotCreateDocument(exception);
        }
    }

    public Document createDocumentWithSystemIdentifier(String string, String string2) throws XMLPlatformException {
        try {
            if (null == string2) {
                Document document = this.createDocument();
                Element element = document.createElement(string);
                document.appendChild(element);
                return document;
            }
            XMLDocument xMLDocument = (XMLDocument)this.createDocument();
            Element element = xMLDocument.createElement(string);
            xMLDocument.appendChild((Node)element);
            xMLDocument.setDoctype(string, string2, null);
            return xMLDocument;
        }
        catch (Exception exception) {
            throw XMLPlatformException.xmlPlatformCouldNotCreateDocument(exception);
        }
    }

    public boolean isWhitespaceNode(Text text) {
        try {
            String string = text.getNodeValue();
            if (null == string) {
                return false;
            }
            return string.trim().equals("");
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public String resolveNamespacePrefix(Node node, String string) throws XMLPlatformException {
        Node node2;
        Attr attr;
        if (null == string ? null == node.getPrefix() : string.equals(node.getPrefix())) {
            return node.getNamespaceURI();
        }
        if (node.getNodeType() == 1 && null != (attr = (node2 = (Element)node).getAttributeNode("xmlns:" + string))) {
            return attr.getValue();
        }
        node2 = node.getParentNode();
        if (node2.getNodeType() == 1) {
            return this.resolveNamespacePrefix((Element)node2, string);
        }
        return null;
    }

    public XMLParser newXMLParser() {
        return new XDKParser();
    }

    public XMLTransformer newXMLTransformer() {
        return new XDKTransformer();
    }

    public boolean validateDocument(Document document, URL uRL, ErrorHandler errorHandler) throws XMLPlatformException {
        Object[] objectArray;
        XMLSchema xMLSchema = null;
        XSDValidator xSDValidator = null;
        try {
            objectArray = new Object[]{uRL};
            xMLSchema = (XMLSchema)this.buildSchemaMethod.invoke((Object)new XSDBuilder(), objectArray);
            xSDValidator = new XSDValidator();
        }
        catch (Exception exception) {
            throw XMLPlatformException.xmlPlatformErrorResolvingXMLSchema(uRL, exception);
        }
        xSDValidator.setXMLProperty("fixedSchema", (Object)xMLSchema);
        objectArray = new XMLError();
        try {
            xSDValidator.setError((XMLError)objectArray);
        }
        catch (SAXException sAXException) {
            throw XMLPlatformException.xmlPlatformValidationException(sAXException);
        }
        try {
            ((XMLDocument)document).validateContent(xSDValidator, true);
        }
        catch (XMLParseException xMLParseException) {
            // empty catch block
        }
        this.handleErrors((XMLError)objectArray, errorHandler);
        return true;
    }

    public boolean validate(Element element, XMLDescriptor xMLDescriptor, ErrorHandler errorHandler) throws XMLPlatformException {
        XMLSchema xMLSchema;
        Object[] objectArray;
        oracle.toplink.ox.schema.XMLSchemaReference xMLSchemaReference = xMLDescriptor.getSchemaReference();
        NamespaceResolver namespaceResolver = xMLDescriptor.getNamespaceResolver();
        XSDValidator xSDValidator = null;
        try {
            objectArray = new Object[]{xMLSchemaReference.getURL()};
            xMLSchema = (XMLSchema)this.buildSchemaMethod.invoke((Object)new XSDBuilder(), objectArray);
            xSDValidator = new XSDValidator();
        }
        catch (Exception exception) {
            throw XMLPlatformException.xmlPlatformValidationException(exception);
        }
        xSDValidator.setXMLProperty("fixedSchema", (Object)xMLSchema);
        objectArray = this.getNodeFromSchemaReference(xMLSchema, xMLSchemaReference, namespaceResolver);
        if (objectArray == null) {
            xSDValidator.setXMLProperty("ORACLE_XSD_Root_Node", null);
        }
        if (xMLSchemaReference.getType() == 3) {
            if (xMLDescriptor.getDefaultRootElement() != null) {
                xSDValidator.setXMLProperty("ORACLE_XSD_Root_Node", (Object)objectArray);
            } else {
                xSDValidator.setXMLProperty("ORACLE_XSD_Root_Node", (Object)((XSDElement)objectArray).getType());
            }
        } else {
            xSDValidator.setXMLProperty("ORACLE_XSD_Root_Node", (Object)objectArray);
        }
        XMLError xMLError = new XMLError();
        try {
            xSDValidator.setError(xMLError);
        }
        catch (SAXException sAXException) {
            throw XMLPlatformException.xmlPlatformValidationException(sAXException);
        }
        try {
            ((XMLElement)element).validateContent(xSDValidator, true);
        }
        catch (XMLParseException xMLParseException) {
            // empty catch block
        }
        this.handleErrors(xMLError, errorHandler);
        return true;
    }

    private void handleErrors(XMLError xMLError, ErrorHandler errorHandler) {
        try {
            int n = xMLError.getNumMessages();
            for (int i = 0; i < n; ++i) {
                SAXParseException sAXParseException = new SAXParseException(xMLError.getMessage(i), xMLError.getPublicId(i), xMLError.getSystemId(i), xMLError.getLineNumber(i), xMLError.getColumnNumber(i), xMLError.getException(i));
                if (null == errorHandler) {
                    throw sAXParseException;
                }
                errorHandler.fatalError(sAXParseException);
            }
        }
        catch (SAXException sAXException) {
            throw XMLPlatformException.xmlPlatformValidationException(sAXException);
        }
    }

    private XSDNode getNodeFromSchemaReference(XMLSchema xMLSchema, XMLSchemaReference xMLSchemaReference, NamespaceResolver namespaceResolver) {
        if (xMLSchemaReference == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(xMLSchemaReference.getSchemaContext(), "/");
        if (!stringTokenizer.hasMoreTokens()) {
            return null;
        }
        String string = "";
        String string2 = stringTokenizer.nextToken();
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ":");
        if (stringTokenizer2.countTokens() > 1 && (string = namespaceResolver.resolveNamespacePrefix(stringTokenizer2.nextToken())) == null) {
            string = "";
        }
        string2 = stringTokenizer2.nextToken();
        if (xMLSchemaReference.getType() == 2) {
            return xMLSchema.getType(string, string2, 2);
        }
        if (xMLSchemaReference.getType() == 1) {
            return xMLSchema.getType(string, string2, 1);
        }
        XSDElement xSDElement = xMLSchema.getElement(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            if ((xSDElement = this.findChildNode(xSDElement, stringTokenizer.nextToken())) != null) continue;
            return null;
        }
        return xSDElement;
    }

    protected XSDNode findChildNode(XSDElement xSDElement, String string) {
        XSDNode xSDNode = null;
        boolean bl = false;
        XSDNode[] xSDNodeArray = ((XSDComplexType)xSDElement.getType()).getElementSet();
        for (int i = 0; i < xSDNodeArray.length; ++i) {
            xSDNode = xSDNodeArray[i];
            if (!xSDNode.getName().equals(string)) continue;
            bl = true;
            break;
        }
        if (bl) {
            return xSDNode;
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

