/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.platform.xml;

import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class XMLComparer {
    public boolean isNodeEqual(Node node, Node node2) {
        if (node == node2) {
            return true;
        }
        if (null == node || null == node2) {
            return false;
        }
        if (node.getNodeType() != node2.getNodeType()) {
            return false;
        }
        switch (node.getNodeType()) {
            case 2: {
                return this.isAttributeEqual((Attr)node, (Attr)node2);
            }
            case 4: {
                return this.isTextEqual((Text)node, (Text)node2);
            }
            case 8: {
                return this.isCommentEqual((Comment)node, (Comment)node2);
            }
            case 11: {
                return this.isDocumentFragmentEqual((DocumentFragment)node, (DocumentFragment)node2);
            }
            case 9: {
                return this.isDocumentEqual((Document)node, (Document)node2);
            }
            case 10: {
                return this.isDocumentTypeEqual((DocumentType)node, (DocumentType)node2);
            }
            case 1: {
                return this.isElementEqual((Element)node, (Element)node2);
            }
            case 6: {
                return false;
            }
            case 5: {
                return this.isEntityReferenceEqual((EntityReference)node, (EntityReference)node2);
            }
            case 12: {
                return false;
            }
            case 7: {
                return this.isProcessingInstructionEqual((ProcessingInstruction)node, (ProcessingInstruction)node2);
            }
            case 3: {
                return this.isTextEqual((Text)node, (Text)node2);
            }
        }
        return true;
    }

    private boolean isAttributeEqual(Attr attr, Attr attr2) {
        if (!this.isStringEqual(attr.getNamespaceURI(), attr2.getNamespaceURI())) {
            return false;
        }
        if (!this.isStringEqual(attr.getName(), attr2.getName())) {
            return false;
        }
        return this.isStringEqual(attr.getNodeValue(), attr2.getNodeValue());
    }

    private boolean isCommentEqual(Comment comment, Comment comment2) {
        return this.isStringEqual(comment.getNodeValue(), comment2.getNodeValue());
    }

    private boolean isDocumentEqual(Document document, Document document2) {
        Element element;
        if (!this.isDocumentTypeEqual(document.getDoctype(), document2.getDoctype())) {
            return false;
        }
        Element element2 = document.getDocumentElement();
        if (element2 == (element = document2.getDocumentElement())) {
            return true;
        }
        if (null == element2 || null == element) {
            return false;
        }
        return this.isElementEqual(element2, element);
    }

    private boolean isDocumentFragmentEqual(DocumentFragment documentFragment, DocumentFragment documentFragment2) {
        return this.isNodeListEqual(documentFragment.getChildNodes(), documentFragment2.getChildNodes());
    }

    private boolean isDocumentTypeEqual(DocumentType documentType, DocumentType documentType2) {
        if (documentType == documentType2) {
            return true;
        }
        if (null == documentType || null == documentType2) {
            return false;
        }
        if (!this.isStringEqual(documentType.getName(), documentType2.getName())) {
            return false;
        }
        if (!this.isStringEqual(documentType.getPublicId(), documentType2.getPublicId())) {
            return false;
        }
        return this.isStringEqual(documentType.getSystemId(), documentType2.getSystemId());
    }

    private boolean isElementEqual(Element element, Element element2) {
        if (!this.isStringEqual(element.getNamespaceURI(), element2.getNamespaceURI())) {
            return false;
        }
        if (!this.isStringEqual(element.getTagName(), element2.getTagName())) {
            return false;
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        NamedNodeMap namedNodeMap2 = element2.getAttributes();
        int n = namedNodeMap.getLength();
        if (n != namedNodeMap2.getLength()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            Attr attr2 = null == attr.getNamespaceURI() ? (Attr)namedNodeMap2.getNamedItem(attr.getNodeName()) : (Attr)namedNodeMap2.getNamedItemNS(attr.getNamespaceURI(), attr.getLocalName());
            if (null == attr2) {
                return false;
            }
            if (this.isAttributeEqual(attr, attr2)) continue;
            return false;
        }
        return this.isNodeListEqual(element.getChildNodes(), element2.getChildNodes());
    }

    private boolean isEntityReferenceEqual(EntityReference entityReference, EntityReference entityReference2) {
        return this.isStringEqual(entityReference.getNodeName(), entityReference2.getNodeName());
    }

    private boolean isProcessingInstructionEqual(ProcessingInstruction processingInstruction, ProcessingInstruction processingInstruction2) {
        if (!this.isStringEqual(processingInstruction.getTarget(), processingInstruction2.getTarget())) {
            return false;
        }
        return this.isStringEqual(processingInstruction.getData(), processingInstruction2.getData());
    }

    private boolean isTextEqual(Text text, Text text2) {
        return this.isStringEqual(text.getNodeValue(), text2.getNodeValue());
    }

    private boolean isNodeListEqual(NodeList nodeList, NodeList nodeList2) {
        int n = nodeList.getLength();
        if (n != nodeList2.getLength()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.isNodeEqual(nodeList.item(i), nodeList2.item(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isStringEqual(String string, String string2) {
        if (string == string2) {
            return true;
        }
        if (null == string) {
            return false;
        }
        return string.equals(string2);
    }
}

