/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.platform.database.oracle;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.Context;
import javax.sql.DataSource;
import oracle.jdbc.OracleConnection;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.jndi.JNDIConnector;

public class OracleJDBC10_1_0_2ProxyConnector
extends JNDIConnector {
    public OracleJDBC10_1_0_2ProxyConnector() {
    }

    public OracleJDBC10_1_0_2ProxyConnector(Context context, String string) throws ValidationException {
        super(context, string);
    }

    public OracleJDBC10_1_0_2ProxyConnector(String string) {
        super(string);
    }

    public OracleJDBC10_1_0_2ProxyConnector(DataSource dataSource) {
        super(dataSource);
    }

    public Connection connect(Properties properties) throws DatabaseException, ValidationException {
        Connection connection = super.connect(properties);
        String string = properties.getProperty("proxytype");
        if (string != null && string.length() > 0) {
            int n;
            try {
                n = Integer.valueOf(string);
            }
            catch (ClassCastException classCastException) {
                throw ValidationException.oracleJDBC10_1_0_2ProxyConnectorRequiresIntProxytype();
            }
            try {
                ((OracleConnection)connection).openProxySession(n, properties);
            }
            catch (SQLException sQLException) {
                throw DatabaseException.sqlException(sQLException);
            }
            catch (ClassCastException classCastException) {
                throw ValidationException.oracleJDBC10_1_0_2ProxyConnectorRequiresOracleConnection();
            }
            catch (NoSuchMethodError noSuchMethodError) {
                throw ValidationException.oracleJDBC10_1_0_2ProxyConnectorRequiresOracleConnectionVersion();
            }
        }
        return connection;
    }
}

