/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.ox.record;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.namespace.QName;
import oracle.toplink.exceptions.XMLMarshalException;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.ox.UnmarshalXPathEngine;
import oracle.toplink.internal.ox.XMLConversionManager;
import oracle.toplink.internal.ox.XPathEngine;
import oracle.toplink.ox.NamespaceResolver;
import oracle.toplink.ox.XMLField;
import oracle.toplink.ox.record.XMLRecord;
import oracle.toplink.platform.xml.XMLNamespaceResolver;
import oracle.toplink.platform.xml.XMLParser;
import oracle.toplink.platform.xml.XMLPlatform;
import oracle.toplink.platform.xml.XMLPlatformException;
import oracle.toplink.platform.xml.XMLPlatformFactory;
import oracle.toplink.platform.xml.XMLTransformer;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.xml.XMLDataStoreException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMRecord
extends XMLRecord {
    private Element dom;

    public DOMRecord() {
    }

    public DOMRecord(String string) {
        this(string, (NamespaceResolver)null);
    }

    public DOMRecord(String string, NamespaceResolver namespaceResolver) {
        this();
        String string2 = this.resolveNamespace(namespaceResolver, string);
        this.setDOM(this.createNewDocument(string, string2));
    }

    public DOMRecord(String string, Node node) {
        this(string, null, node);
    }

    public DOMRecord(String string, NamespaceResolver namespaceResolver, Node node) {
        this();
        Document document = node instanceof Document ? (Document)node : node.getOwnerDocument();
        String string2 = this.resolveNamespace(namespaceResolver, string);
        Element element = document.createElementNS(string2, string);
        node.appendChild(element);
        this.setDOM(element);
    }

    public DOMRecord(Element element) {
        this();
        this.setDOM(element);
    }

    public DOMRecord(Document document) {
        this();
        this.setDOM(document.getDocumentElement());
    }

    public String getLocalName() {
        String string = this.getDOM().getLocalName();
        if (null != string) {
            return string;
        }
        return this.getDOM().getNodeName();
    }

    public String getNamespaceURI() {
        return this.getDOM().getNamespaceURI();
    }

    public void add(DatabaseField databaseField, Object object) {
        Object object2 = this.convertToNodeValue(object);
        XPathEngine.getInstance().create(this.convertToXMLField(databaseField), this.dom, object2);
    }

    private Object convertToNodeValue(Object object) {
        if (object instanceof Vector) {
            Vector vector = (Vector)object;
            Vector<Object> vector2 = new Vector<Object>(vector.size());
            for (int i = 0; i < vector.size(); ++i) {
                Object e = vector.get(i);
                vector2.add(this.convertToNodeValue(e));
            }
            return vector2;
        }
        if (object instanceof DOMRecord) {
            return ((DOMRecord)object).getDOM();
        }
        return object;
    }

    public void clear() {
        String string = this.getDOM().getTagName();
        this.dom = this.createNewDocument(string, null);
    }

    public Object clone() {
        DOMRecord dOMRecord = (DOMRecord)super.clone();
        if (dOMRecord != null) {
            dOMRecord.setDOM((Element)this.dom.cloneNode(true));
        }
        return dOMRecord;
    }

    public Element createNewDocument(String string) {
        return this.createNewDocument(string, null);
    }

    public Element createNewDocument(String string, String string2) {
        XMLPlatform xMLPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
        Document document = xMLPlatform.createDocument();
        Element element = document.createElementNS(string2, string);
        document.appendChild(element);
        return document.getDocumentElement();
    }

    public Document getDocument() {
        return this.getDOM().getOwnerDocument();
    }

    public boolean containsKey(DatabaseField databaseField) {
        XMLField xMLField = this.convertToXMLField(databaseField);
        NodeList nodeList = UnmarshalXPathEngine.getInstance().selectNodes((Node)this.dom, xMLField, (XMLNamespaceResolver)xMLField.getNamespaceResolver());
        return nodeList.getLength() > 0;
    }

    public boolean contains(Object object) {
        return this.values().contains(object);
    }

    public Object getIndicatingNoEntry(DatabaseField databaseField) {
        XMLField xMLField = this.convertToXMLField(databaseField);
        if (xMLField.isSelfField()) {
            return this;
        }
        Node node = UnmarshalXPathEngine.getInstance().selectSingleNode((Node)this.dom, xMLField, (XMLNamespaceResolver)xMLField.getNamespaceResolver());
        if (null == node) {
            return null;
        }
        if (1 != node.getNodeType()) {
            if (node.getNodeType() == 2) {
                this.getValueFromAttribute((Attr)node, xMLField);
            }
            return this.getValueFromElement((Element)node.getParentNode(), node, xMLField);
        }
        return this.buildNestedRow((Element)node);
    }

    public Object getValues(String string) {
        Object object = this.getValuesIndicatingNoEntry(new XMLField(string));
        if (object == DatabaseRow.noEntry) {
            return null;
        }
        return object;
    }

    public Object getValues(DatabaseField databaseField) {
        Object object = this.getValuesIndicatingNoEntry(databaseField);
        if (object == DatabaseRow.noEntry) {
            return null;
        }
        return object;
    }

    public Object getValuesIndicatingNoEntry(DatabaseField databaseField) {
        XMLField xMLField = this.convertToXMLField(databaseField);
        NodeList nodeList = UnmarshalXPathEngine.getInstance().selectNodes((Node)this.dom, xMLField, (XMLNamespaceResolver)xMLField.getNamespaceResolver());
        if (null == nodeList) {
            return null;
        }
        int n = nodeList.getLength();
        Vector<Object> vector = new Vector<Object>(n);
        if (n == 0) {
            return vector;
        }
        Node node = nodeList.item(0);
        if (node == null || node.getNodeType() != 1) {
            if (xMLField.usesSingleNode() && n == 1) {
                Node node2 = nodeList.item(0);
                if (node2 == null) {
                    vector.add(null);
                } else {
                    Vector<Object> vector2 = new Vector<Object>();
                    String string = node2.getNodeValue();
                    StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                    while (stringTokenizer.hasMoreElements()) {
                        String string2 = stringTokenizer.nextToken();
                        Object object = this.convertValue((Element)node2.getParentNode(), xMLField, string2);
                        vector2.add(object);
                    }
                    return vector2;
                }
            }
            for (int i = 0; i < n; ++i) {
                Node node3 = nodeList.item(i);
                if (node3 == null) {
                    vector.add(null);
                    continue;
                }
                vector.add(this.getValueFromElement((Element)node3.getParentNode(), node3, xMLField));
            }
        } else {
            for (int i = 0; i < n; ++i) {
                vector.add(this.buildNestedRow((Element)nodeList.item(i)));
            }
        }
        return vector;
    }

    private Object getValueFromAttribute(Attr attr, XMLField xMLField) {
        return xMLField.convertValueBasedOnSchemaType(attr.getNodeValue());
    }

    private Object getValueFromElement(Element element, Node node, XMLField xMLField) {
        String string = node.getNodeValue();
        return this.convertValue(element, xMLField, string);
    }

    private Object convertValue(Element element, XMLField xMLField, Object object) {
        String string;
        if (xMLField.isTypedTextField() && element != null && null != (string = element.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type")) && !string.equals("")) {
            QName qName = null;
            int n = string.indexOf(58);
            if (n == -1) {
                qName = new QName(string);
                Class clazz = xMLField.getJavaClass(qName);
                return XMLConversionManager.getDefaultXMLManager().convertObject(object, clazz);
            }
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            XMLPlatform xMLPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
            String string4 = xMLPlatform.resolveNamespacePrefix(element, string2);
            qName = new QName(string4, string3);
            Class clazz = xMLField.getJavaClass(qName);
            return XMLConversionManager.getDefaultXMLManager().convertObject(object, clazz, qName);
        }
        return xMLField.convertValueBasedOnSchemaType(object);
    }

    public XMLRecord buildNestedRow(Element element) {
        DOMRecord dOMRecord = new DOMRecord(element);
        dOMRecord.setUnmarshaller(this.getUnmarshaller());
        dOMRecord.setOwningObject(this.getCurrentObject());
        return dOMRecord;
    }

    public Element getDOM() {
        return this.dom;
    }

    public Object put(DatabaseField databaseField, Object object) {
        Object object2 = this.convertToNodeValue(object);
        NodeList nodeList = null;
        nodeList = object2 instanceof Collection ? XPathEngine.getInstance().replaceCollection(this.convertToXMLField(databaseField), this.dom, (Collection)object2) : XPathEngine.getInstance().replaceValue(this.convertToXMLField(databaseField), this.dom, object2);
        if (nodeList.getLength() == 0) {
            XPathEngine.getInstance().create(this.convertToXMLField(databaseField), this.dom, object2);
        } else if (nodeList.item(0) == this.getDOM()) {
            this.setDOM(this.getDocument().getDocumentElement());
        }
        return nodeList;
    }

    public Object remove(DatabaseField databaseField) {
        return XPathEngine.getInstance().remove(this.convertToXMLField(databaseField), this.dom, true);
    }

    public void replaceAt(Object object, int n) {
        throw XMLMarshalException.operationNotSupported("replaceAt(Object value, int index)");
    }

    public Set entrySet() {
        int n = this.size();
        HashMap hashMap = new HashMap(n);
        Vector vector = this.getFields();
        Vector vector2 = this.getValues();
        for (int i = 0; i < n; ++i) {
            hashMap.put(vector.elementAt(i), vector2.elementAt(i));
        }
        return hashMap.entrySet();
    }

    protected void setFields(Vector vector) throws XMLMarshalException {
        throw XMLMarshalException.operationNotSupported("setField(Vector fields)");
    }

    public Vector getFields() {
        Vector<DatabaseField> vector = new Vector<DatabaseField>(this.getDOM().getChildNodes().getLength());
        for (int i = 0; i < this.getDOM().getChildNodes().getLength(); ++i) {
            vector.add(new DatabaseField(this.getDOM().getChildNodes().item(i).getNodeName()));
        }
        return vector;
    }

    public Vector getValues() {
        Vector<Node> vector = new Vector<Node>(this.getDOM().getChildNodes().getLength());
        for (int i = 0; i < this.getDOM().getChildNodes().getLength(); ++i) {
            vector.add(this.getDOM().getChildNodes().item(i));
        }
        return vector;
    }

    protected void setValues(Vector vector) throws XMLMarshalException {
        throw XMLMarshalException.operationNotSupported("setValues(Vector values)");
    }

    public void setDOM(Element element) {
        this.dom = element;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write(Helper.getShortClassName(this.getClass()));
        stringWriter.write("(");
        this.transformToWriter(stringWriter);
        stringWriter.write(")");
        return stringWriter.toString();
    }

    public Set keySet() {
        HashSet<String> hashSet = new HashSet<String>(this.getDOM().getChildNodes().getLength());
        for (int i = 0; i < this.getDOM().getChildNodes().getLength(); ++i) {
            hashSet.add(this.getDOM().getChildNodes().item(i).getNodeName());
        }
        return hashSet;
    }

    public Collection values() {
        Vector<Node> vector = new Vector<Node>(this.getDOM().getChildNodes().getLength());
        for (int i = 0; i < this.getDOM().getChildNodes().getLength(); ++i) {
            vector.add(this.getDOM().getChildNodes().item(i));
        }
        return vector;
    }

    public int size() {
        return this.getDOM().getAttributes().getLength() + this.getDOM().getChildNodes().getLength();
    }

    public void transformFromXML(String string) {
        StringReader stringReader = new StringReader(string);
        this.transformFromXML(stringReader);
    }

    private String resolveNamespace(NamespaceResolver namespaceResolver, String string) {
        int n = string.indexOf(58);
        if (n < 0) {
            if (namespaceResolver != null) {
                return namespaceResolver.resolveNamespacePrefix("");
            }
            return null;
        }
        if (namespaceResolver == null) {
            throw XMLMarshalException.namespaceResolverNotSpecified(string);
        }
        String string2 = string.substring(0, n);
        String string3 = namespaceResolver.resolveNamespacePrefix(string2);
        if (string3 == null) {
            throw XMLMarshalException.namespaceNotFound(string2);
        }
        return string3;
    }

    public void transformFromXML(Reader reader) {
        try {
            XMLParser xMLParser = XMLPlatformFactory.getInstance().getXMLPlatform().newXMLParser();
            Document document = xMLParser.parse(reader);
            this.setDOM(document.getDocumentElement());
        }
        catch (XMLPlatformException xMLPlatformException) {
            throw XMLDataStoreException.generalException(xMLPlatformException);
        }
    }

    public String transformToXML() {
        StringWriter stringWriter = new StringWriter();
        this.transformToWriter(stringWriter);
        return stringWriter.toString();
    }

    public void transformToWriter(Writer writer) {
        try {
            XMLTransformer xMLTransformer = XMLPlatformFactory.getInstance().getXMLPlatform().newXMLTransformer();
            xMLTransformer.transform((Node)this.getDOM(), writer);
        }
        catch (XMLPlatformException xMLPlatformException) {
            throw XMLDataStoreException.generalException(xMLPlatformException);
        }
    }

    public String resolveNamespacePrefix(String string) {
        XMLPlatform xMLPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
        return xMLPlatform.resolveNamespacePrefix(this.getDOM(), string);
    }
}

