/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.ox.record;

import oracle.toplink.exceptions.XMLMarshalException;
import oracle.toplink.internal.ox.XPathFragment;
import oracle.toplink.ox.NamespaceResolver;
import oracle.toplink.ox.record.MarshalRecord;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ContentHandlerRecord
extends MarshalRecord {
    private ContentHandler contentHandler;
    private String namespaceURI;
    private XPathFragment xPathFragment;
    private AttributesImpl attributes;
    private static final String CDATA = "CDATA";
    protected boolean isStartElementOpen = false;

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public void startDocument(String string, String string2) {
        try {
            this.contentHandler.startDocument();
        }
        catch (SAXException sAXException) {
            throw XMLMarshalException.marshalException(sAXException);
        }
    }

    public void endDocument() {
        try {
            this.contentHandler.endDocument();
        }
        catch (SAXException sAXException) {
            throw XMLMarshalException.marshalException(sAXException);
        }
    }

    public void startPrefixMapping(String string, String string2) {
        try {
            this.contentHandler.startPrefixMapping(string, string2);
        }
        catch (SAXException sAXException) {
            throw XMLMarshalException.marshalException(sAXException);
        }
    }

    public void endPrefixMapping(String string) {
        try {
            this.contentHandler.endPrefixMapping(string);
        }
        catch (SAXException sAXException) {
            throw XMLMarshalException.marshalException(sAXException);
        }
    }

    private void openAndCloseStartElement() {
        try {
            this.contentHandler.startElement(this.namespaceURI, this.xPathFragment.getLocalName(), this.xPathFragment.getShortName(), this.attributes);
        }
        catch (SAXException sAXException) {
            throw XMLMarshalException.marshalException(sAXException);
        }
    }

    public void openStartElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        super.openStartElement(xPathFragment, namespaceResolver);
        if (this.isStartElementOpen) {
            this.openAndCloseStartElement();
        }
        this.isStartElementOpen = true;
        this.namespaceURI = this.resolveNamespacePrefix(xPathFragment, namespaceResolver);
        this.xPathFragment = xPathFragment;
        this.attributes = new AttributesImpl();
    }

    public void element(String string, String string2, String string3) {
        if (this.isStartElementOpen) {
            this.openAndCloseStartElement();
            this.isStartElementOpen = false;
        }
        try {
            this.attributes = new AttributesImpl();
            this.contentHandler.startElement(string, string2, string3, this.attributes);
            this.contentHandler.endElement(string, string2, string3);
        }
        catch (SAXException sAXException) {
            throw XMLMarshalException.marshalException(sAXException);
        }
    }

    public void attribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver, String string) {
        String string2 = this.resolveNamespacePrefix(xPathFragment, namespaceResolver);
        this.attributes.addAttribute(string2, xPathFragment.getLocalName(), xPathFragment.getShortName(), CDATA, string);
    }

    public void attribute(String string, String string2, String string3, String string4) {
        this.attributes.addAttribute(string, string2, string3, CDATA, string4);
    }

    public void closeStartElement() {
    }

    public void endElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        if (this.isStartElementOpen) {
            this.openAndCloseStartElement();
            this.isStartElementOpen = false;
        }
        try {
            String string = this.resolveNamespacePrefix(xPathFragment, namespaceResolver);
            this.contentHandler.endElement(string, xPathFragment.getLocalName(), xPathFragment.getShortName());
            this.isStartElementOpen = false;
        }
        catch (SAXException sAXException) {
            throw XMLMarshalException.marshalException(sAXException);
        }
    }

    public void characters(String string) {
        if (this.isStartElementOpen) {
            this.openAndCloseStartElement();
            this.isStartElementOpen = false;
        }
        try {
            this.contentHandler.characters(string.toCharArray(), 0, string.length());
        }
        catch (SAXException sAXException) {
            throw XMLMarshalException.marshalException(sAXException);
        }
    }

    public String resolveNamespacePrefix(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        String string = super.resolveNamespacePrefix(xPathFragment, namespaceResolver);
        if (string == null) {
            return "";
        }
        return string;
    }

    public String resolveNamespacePrefix(String string) {
        String string2 = super.resolveNamespacePrefix(string);
        if (string2 == null) {
            return "";
        }
        return string2;
    }
}

