/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.mappings;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import oracle.toplink.exceptions.ConversionException;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.exceptions.OptimisticLockException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.expressions.ExpressionBuilder;
import oracle.toplink.history.AsOfClause;
import oracle.toplink.history.HistoryPolicy;
import oracle.toplink.internal.databaseaccess.Platform;
import oracle.toplink.internal.expressions.DataExpression;
import oracle.toplink.internal.expressions.ObjectExpression;
import oracle.toplink.internal.expressions.QueryKeyExpression;
import oracle.toplink.internal.expressions.SQLDeleteStatement;
import oracle.toplink.internal.expressions.SQLInsertStatement;
import oracle.toplink.internal.expressions.SQLModifyStatement;
import oracle.toplink.internal.expressions.SQLStatement;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.DatabaseTable;
import oracle.toplink.internal.helper.NonSynchronizedVector;
import oracle.toplink.internal.identitymaps.CacheKey;
import oracle.toplink.internal.queryframework.ContainerPolicy;
import oracle.toplink.internal.sessions.ObjectChangeSet;
import oracle.toplink.internal.sessions.UnitOfWorkChangeSet;
import oracle.toplink.mappings.CollectionMapping;
import oracle.toplink.mappings.RelationalMapping;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.Call;
import oracle.toplink.queryframework.ComplexQueryResult;
import oracle.toplink.queryframework.DataModifyQuery;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.DeleteObjectQuery;
import oracle.toplink.queryframework.InsertObjectQuery;
import oracle.toplink.queryframework.ObjectLevelModifyQuery;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.queryframework.ReadAllQuery;
import oracle.toplink.queryframework.ReadQuery;
import oracle.toplink.queryframework.WriteObjectQuery;
import oracle.toplink.sessions.DatabaseRecord;

public class ManyToManyMapping
extends CollectionMapping
implements RelationalMapping {
    protected static final String PostInsert = "postInsert";
    protected static final String ObjectRemoved = "objectRemoved";
    protected static final String ObjectAdded = "objectAdded";
    protected transient DatabaseTable relationTable;
    protected transient Vector sourceKeyFields;
    protected transient Vector targetKeyFields;
    protected transient Vector sourceRelationKeyFields;
    protected transient Vector targetRelationKeyFields;
    protected transient DataModifyQuery deleteQuery;
    protected transient boolean hasCustomDeleteQuery = false;
    protected transient DataModifyQuery insertQuery = new DataModifyQuery();
    protected transient boolean hasCustomInsertQuery = false;
    protected HistoryPolicy historyPolicy;

    public ManyToManyMapping() {
        this.deleteQuery = new DataModifyQuery();
        this.sourceRelationKeyFields = NonSynchronizedVector.newInstance(1);
        this.targetRelationKeyFields = NonSynchronizedVector.newInstance(1);
        this.sourceKeyFields = NonSynchronizedVector.newInstance(1);
        this.targetKeyFields = NonSynchronizedVector.newInstance(1);
    }

    public boolean isRelationalMapping() {
        return true;
    }

    public void addSourceRelationKeyFieldName(String string, String string2) {
        this.getSourceRelationKeyFields().addElement(new DatabaseField(string));
        this.getSourceKeyFields().addElement(new DatabaseField(string2));
    }

    public void addTargetRelationKeyFieldName(String string, String string2) {
        this.getTargetRelationKeyFields().addElement(new DatabaseField(string));
        this.getTargetKeyFields().addElement(new DatabaseField(string2));
    }

    public Object clone() {
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)super.clone();
        manyToManyMapping.setTargetKeyFields(this.cloneFields(this.getTargetKeyFields()));
        manyToManyMapping.setSourceKeyFields(this.cloneFields(this.getSourceKeyFields()));
        manyToManyMapping.setTargetRelationKeyFields(this.cloneFields(this.getTargetRelationKeyFields()));
        manyToManyMapping.setSourceRelationKeyFields(this.cloneFields(this.getSourceRelationKeyFields()));
        return manyToManyMapping;
    }

    protected Vector extractKeyFromRelationRow(DatabaseRow databaseRow, Session session) {
        Vector<Object> vector = new Vector<Object>(this.getSourceRelationKeyFields().size());
        for (int i = 0; i < this.getSourceRelationKeyFields().size(); ++i) {
            DatabaseField databaseField = (DatabaseField)this.getSourceRelationKeyFields().elementAt(i);
            DatabaseField databaseField2 = (DatabaseField)this.getSourceKeyFields().elementAt(i);
            Object object = databaseRow.get(databaseField);
            try {
                object = session.getDatasourcePlatform().getConversionManager().convertObject(object, this.getDescriptor().getObjectBuilder().getFieldClassification(databaseField2));
            }
            catch (ConversionException conversionException) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), conversionException);
            }
            vector.addElement(object);
        }
        return vector;
    }

    protected Vector extractPrimaryKeyFromRow(DatabaseRow databaseRow, Session session) {
        Vector<Object> vector = new Vector<Object>(this.getSourceKeyFields().size());
        Enumeration enumeration = this.getSourceKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
            Object object = databaseRow.get(databaseField);
            try {
                object = session.getDatasourcePlatform().getConversionManager().convertObject(object, this.getDescriptor().getObjectBuilder().getFieldClassification(databaseField));
            }
            catch (ConversionException conversionException) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), conversionException);
            }
            vector.addElement(object);
        }
        return vector;
    }

    protected void postPrepareNestedBatchQuery(ReadQuery readQuery, ReadAllQuery readAllQuery) {
        ReadAllQuery readAllQuery2 = (ReadAllQuery)readQuery;
        readAllQuery2.setShouldIncludeData(true);
        Object object = this.getSourceRelationKeyFields().elements();
        while (object.hasMoreElements()) {
            readAllQuery2.getAdditionalFields().addElement(readAllQuery2.getExpressionBuilder().getTable(this.getRelationTable()).getField((DatabaseField)object.nextElement()));
        }
        if (this.getHistoryPolicy() != null) {
            object = readAllQuery2.getExpressionBuilder();
            Expression expression = readQuery.getSelectionCriteria();
            if (readAllQuery.getSession().getAsOfClause() != null) {
                ((DataExpression)object).asOf(readAllQuery.getSession().getAsOfClause());
            } else if (((DataExpression)object).getAsOfClause() == null) {
                ((DataExpression)object).asOf(AsOfClause.NO_CLAUSE);
            }
            expression = expression.and(this.getHistoryPolicy().additionalHistoryExpression((ObjectExpression)object));
            readAllQuery2.setSelectionCriteria(expression);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object extractResultFromBatchQuery(DatabaseQuery databaseQuery, DatabaseRow databaseRow, Session session, DatabaseRow databaseRow2) {
        Hashtable<CacheKey, Object> hashtable = null;
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        DatabaseQuery databaseQuery2 = databaseQuery;
        synchronized (databaseQuery2) {
            hashtable = this.getBatchReadObjects(databaseQuery, session);
            containerPolicy = this.getContainerPolicy();
            if (hashtable == null) {
                ReadAllQuery readAllQuery = (ReadAllQuery)databaseQuery;
                ComplexQueryResult complexQueryResult = (ComplexQueryResult)session.executeQuery((DatabaseQuery)readAllQuery, databaseRow2);
                Object object = complexQueryResult.getResult();
                hashtable = new Hashtable<CacheKey, Object>();
                Enumeration enumeration = ((Vector)complexQueryResult.getData()).elements();
                ContainerPolicy containerPolicy2 = readAllQuery.getContainerPolicy();
                Object object2 = containerPolicy2.iteratorFor(object);
                while (containerPolicy2.hasNext(object2)) {
                    Object object3 = containerPolicy2.next(object2, session);
                    CacheKey cacheKey = new CacheKey(this.extractKeyFromRelationRow((DatabaseRow)enumeration.nextElement(), session));
                    if (!hashtable.containsKey(cacheKey)) {
                        hashtable.put(cacheKey, containerPolicy.containerInstance());
                    }
                    containerPolicy.addInto(object3, hashtable.get(cacheKey), session);
                }
                this.setBatchReadObjects(hashtable, databaseQuery, session);
            }
        }
        databaseQuery2 = hashtable.get(new CacheKey(this.extractPrimaryKeyFromRow(databaseRow, session)));
        if (databaseQuery2 == null) {
            return containerPolicy.containerInstance();
        }
        return databaseQuery2;
    }

    protected DataModifyQuery getDeleteQuery() {
        return this.deleteQuery;
    }

    protected DataModifyQuery getInsertQuery() {
        return this.insertQuery;
    }

    public Expression getJoinCriteria(QueryKeyExpression queryKeyExpression) {
        if (this.getHistoryPolicy() != null) {
            Expression expression = super.getJoinCriteria(queryKeyExpression);
            Expression expression2 = this.getHistoryPolicy().additionalHistoryExpression(queryKeyExpression);
            if (expression != null) {
                return expression.and(expression2);
            }
            if (expression2 != null) {
                return expression2;
            }
            return null;
        }
        return super.getJoinCriteria(queryKeyExpression);
    }

    public HistoryPolicy getHistoryPolicy() {
        return this.historyPolicy;
    }

    public DatabaseTable getRelationTable() {
        return this.relationTable;
    }

    public String getRelationTableName() {
        if (this.relationTable == null) {
            return null;
        }
        return this.relationTable.getName();
    }

    public String getRelationTableQualifiedName() {
        if (this.relationTable == null) {
            return null;
        }
        return this.relationTable.getQualifiedName();
    }

    public Expression getSelectionCriteria() {
        return this.getSelectionQuery().getSelectionCriteria();
    }

    public ReadQuery getSelectionQuery() {
        return this.selectionQuery;
    }

    public Vector getSourceKeyFieldNames() {
        Vector<String> vector = new Vector<String>(this.getSourceKeyFields().size());
        Enumeration enumeration = this.getSourceKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(((DatabaseField)enumeration.nextElement()).getQualifiedName());
        }
        return vector;
    }

    public Vector getSourceKeyFields() {
        return this.sourceKeyFields;
    }

    public Vector getSourceRelationKeyFieldNames() {
        Vector<String> vector = new Vector<String>(this.getSourceRelationKeyFields().size());
        Enumeration enumeration = this.getSourceRelationKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(((DatabaseField)enumeration.nextElement()).getQualifiedName());
        }
        return vector;
    }

    public Vector getSourceRelationKeyFields() {
        return this.sourceRelationKeyFields;
    }

    public Vector getTargetKeyFieldNames() {
        Vector<String> vector = new Vector<String>(this.getTargetKeyFields().size());
        Enumeration enumeration = this.getTargetKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(((DatabaseField)enumeration.nextElement()).getQualifiedName());
        }
        return vector;
    }

    public Vector getTargetKeyFields() {
        return this.targetKeyFields;
    }

    public Vector getTargetRelationKeyFieldNames() {
        Vector<String> vector = new Vector<String>(this.getTargetRelationKeyFields().size());
        Enumeration enumeration = this.getTargetRelationKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(((DatabaseField)enumeration.nextElement()).getQualifiedName());
        }
        return vector;
    }

    public Vector getTargetRelationKeyFields() {
        return this.targetRelationKeyFields;
    }

    protected boolean hasCustomDeleteQuery() {
        return this.hasCustomDeleteQuery;
    }

    protected boolean hasCustomInsertQuery() {
        return this.hasCustomInsertQuery;
    }

    public boolean hasDependency() {
        return this.isPrivateOwned() || !this.isReadOnly();
    }

    public void initialize(Session session) throws DescriptorException {
        super.initialize(session);
        this.initializeRelationTable(session);
        this.initializeSourceRelationKeys(session);
        this.initializeTargetRelationKeys(session);
        if (this.isSingleSourceRelationKeySpecified()) {
            this.initializeSourceKeysWithDefaults(session);
        } else {
            this.initializeSourceKeys(session);
        }
        if (this.isSingleTargetRelationKeySpecified()) {
            this.initializeTargetKeysWithDefaults(session);
        } else {
            this.initializeTargetKeys(session);
        }
        if (this.shouldInitializeSelectionCriteria()) {
            this.initializeSelectionCriteria(session);
        }
        if (!this.getSelectionQuery().hasSessionName()) {
            this.getSelectionQuery().setSessionName(session.getName());
        }
        this.initializeDeleteAllQuery(session);
        this.initializeInsertQuery(session);
        this.initializeDeleteQuery(session);
        if (this.getHistoryPolicy() != null) {
            this.getHistoryPolicy().initialize(session);
        }
    }

    protected void initializeDeleteAllQuery(Session session) {
        if (!this.getDeleteAllQuery().hasSessionName()) {
            this.getDeleteAllQuery().setSessionName(session.getName());
        }
        if (this.hasCustomDeleteAllQuery()) {
            return;
        }
        Expression expression = null;
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        SQLDeleteStatement sQLDeleteStatement = new SQLDeleteStatement();
        for (int i = 0; i < this.getSourceRelationKeyFields().size(); ++i) {
            DatabaseField databaseField = (DatabaseField)this.getSourceRelationKeyFields().elementAt(i);
            DatabaseField databaseField2 = (DatabaseField)this.getSourceKeyFields().elementAt(i);
            Expression expression2 = ((Expression)expressionBuilder).getField(databaseField).equal(expressionBuilder.getParameter(databaseField2));
            expression = expression2.and(expression);
        }
        sQLDeleteStatement.setWhereClause(expression);
        sQLDeleteStatement.setTable(this.getRelationTable());
        this.getDeleteAllQuery().setSQLStatement(sQLDeleteStatement);
    }

    protected void initializeDeleteQuery(Session session) {
        Expression expression;
        Cloneable cloneable;
        if (!this.getDeleteQuery().hasSessionName()) {
            this.getDeleteQuery().setSessionName(session.getName());
        }
        if (this.hasCustomDeleteQuery()) {
            return;
        }
        Expression expression2 = null;
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        Enumeration enumeration = this.getSourceRelationKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            cloneable = (DatabaseField)enumeration.nextElement();
            expression = ((Expression)expressionBuilder).getField((DatabaseField)cloneable).equal(expressionBuilder.getParameter((DatabaseField)cloneable));
            expression2 = expression.and(expression2);
        }
        enumeration = this.getTargetRelationKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            cloneable = (DatabaseField)enumeration.nextElement();
            expression = ((Expression)expressionBuilder).getField((DatabaseField)cloneable).equal(expressionBuilder.getParameter((DatabaseField)cloneable));
            expression2 = expression.and(expression2);
        }
        cloneable = new SQLDeleteStatement();
        ((SQLModifyStatement)cloneable).setTable(this.getRelationTable());
        ((SQLStatement)cloneable).setWhereClause(expression2);
        this.getDeleteQuery().setSQLStatement((SQLStatement)cloneable);
    }

    protected void initializeInsertQuery(Session session) {
        if (!this.getInsertQuery().hasSessionName()) {
            this.getInsertQuery().setSessionName(session.getName());
        }
        if (this.hasCustomInsertQuery()) {
            return;
        }
        SQLInsertStatement sQLInsertStatement = new SQLInsertStatement();
        sQLInsertStatement.setTable(this.getRelationTable());
        DatabaseRecord databaseRecord = new DatabaseRecord();
        Enumeration enumeration = this.getTargetRelationKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            databaseRecord.put((DatabaseField)enumeration.nextElement(), (Object)null);
        }
        enumeration = this.getSourceRelationKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            databaseRecord.put((DatabaseField)enumeration.nextElement(), (Object)null);
        }
        sQLInsertStatement.setModifyRow(databaseRecord);
        this.getInsertQuery().setSQLStatement(sQLInsertStatement);
        this.getInsertQuery().setModifyRow(databaseRecord);
    }

    protected void initializeRelationTable(Session session) throws DescriptorException {
        Platform platform = session.getDatasourcePlatform();
        if (this.getRelationTable() == null || this.getRelationTableName().length() == 0) {
            throw DescriptorException.noRelationTable(this);
        }
        if (platform.getTableQualifier().length() == 0) {
            return;
        }
        if (this.getRelationTable().getTableQualifier().length() == 0) {
            this.getRelationTable().setTableQualifier(platform.getTableQualifier());
        }
    }

    protected void initializeSelectionCriteria(Session session) {
        Expression expression;
        Expression expression2;
        Expression expression3;
        Expression expression4;
        DatabaseField databaseField;
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        Expression expression5 = null;
        Enumeration enumeration = this.getTargetKeyFields().elements();
        Enumeration enumeration2 = this.getTargetRelationKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            databaseField = (DatabaseField)enumeration2.nextElement();
            DatabaseField databaseField2 = (DatabaseField)enumeration.nextElement();
            if (expression5 == null) {
                expression5 = ((Expression)expressionBuilder).getTable(databaseField.getTable());
            }
            expression4 = ((Expression)expressionBuilder).getField(databaseField2);
            expression3 = expression5.getField(databaseField);
            expression2 = expression4.equal(expression3);
            expression = this.getSelectionCriteria();
            expression = expression == null ? expression2 : expression2.and(expression);
            this.setSelectionCriteria(expression);
        }
        enumeration2 = this.getSourceRelationKeyFields().elements();
        Enumeration enumeration3 = this.getSourceKeyFields().elements();
        while (enumeration2.hasMoreElements()) {
            databaseField = (DatabaseField)enumeration2.nextElement();
            DatabaseField databaseField3 = (DatabaseField)enumeration3.nextElement();
            expression4 = expression5.getField(databaseField);
            expression3 = expressionBuilder.getParameter(databaseField3);
            expression2 = expression4.equal(expression3);
            expression = this.getSelectionCriteria();
            expression = expression == null ? expression2 : expression2.and(expression);
            this.setSelectionCriteria(expression);
        }
    }

    protected void initializeSourceKeys(Session session) {
        Enumeration enumeration = this.getSourceKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            this.getDescriptor().buildField((DatabaseField)enumeration.nextElement());
        }
    }

    protected void initializeSourceKeysWithDefaults(Session session) {
        List list = this.getDescriptor().getPrimaryKeyFields();
        for (int i = 0; i < list.size(); ++i) {
            this.getSourceKeyFields().addElement(list.get(i));
        }
    }

    protected void initializeSourceRelationKeys(Session session) throws DescriptorException {
        if (this.getSourceRelationKeyFields().size() == 0) {
            throw DescriptorException.noSourceRelationKeysSpecified(this);
        }
        Enumeration enumeration = this.getSourceRelationKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
            if (databaseField.hasTableName() && !databaseField.getTableName().equals(this.getRelationTable().getName())) {
                throw DescriptorException.relationKeyFieldNotProperlySpecified(databaseField, this);
            }
            databaseField.setTable(this.getRelationTable());
        }
    }

    protected void initializeTargetKeys(Session session) {
        Enumeration enumeration = this.getTargetKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            this.getReferenceDescriptor().buildField((DatabaseField)enumeration.nextElement());
        }
    }

    protected void initializeTargetKeysWithDefaults(Session session) {
        List list = this.getReferenceDescriptor().getPrimaryKeyFields();
        for (int i = 0; i < list.size(); ++i) {
            this.getTargetKeyFields().addElement(list.get(i));
        }
    }

    protected void initializeTargetRelationKeys(Session session) {
        if (this.getTargetRelationKeyFields().size() == 0) {
            throw DescriptorException.noTargetRelationKeysSpecified(this);
        }
        Enumeration enumeration = this.getTargetRelationKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
            if (databaseField.hasTableName() && !databaseField.getTableName().equals(this.getRelationTable().getName())) {
                throw DescriptorException.relationKeyFieldNotProperlySpecified(databaseField, this);
            }
            databaseField.setTable(this.getRelationTable());
        }
    }

    protected void insertAddedObjectEntry(ObjectLevelModifyQuery objectLevelModifyQuery, Object object) throws DatabaseException, OptimisticLockException {
        Object object2;
        DatabaseField databaseField;
        DatabaseField databaseField2;
        int n;
        this.prepareTranslationRow(objectLevelModifyQuery.getTranslationRow(), objectLevelModifyQuery.getObject(), objectLevelModifyQuery.getSession());
        DatabaseRecord databaseRecord = new DatabaseRecord();
        for (n = 0; n < this.getSourceRelationKeyFields().size(); ++n) {
            databaseField2 = (DatabaseField)this.getSourceRelationKeyFields().elementAt(n);
            databaseField = (DatabaseField)this.getSourceKeyFields().elementAt(n);
            object2 = objectLevelModifyQuery.getTranslationRow().get(databaseField);
            databaseRecord.put(databaseField2, object2);
        }
        for (n = 0; n < this.getTargetRelationKeyFields().size(); ++n) {
            databaseField2 = (DatabaseField)this.getTargetRelationKeyFields().elementAt(n);
            databaseField = (DatabaseField)this.getTargetKeyFields().elementAt(n);
            object2 = this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(object, databaseField, objectLevelModifyQuery.getSession());
            databaseRecord.put(databaseField2, object2);
        }
        objectLevelModifyQuery.getSession().executeQuery((DatabaseQuery)this.getInsertQuery(), databaseRecord);
        if (this.getHistoryPolicy() != null && this.getHistoryPolicy().shouldHandleWrites()) {
            this.getHistoryPolicy().mappingLogicalInsert(this.getInsertQuery(), databaseRecord, objectLevelModifyQuery.getSession());
        }
    }

    public void insertIntoRelationTable(WriteObjectQuery writeObjectQuery) throws DatabaseException {
        Object object;
        Object object2;
        Object object3;
        if (this.isReadOnly()) {
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (containerPolicy.isEmpty(object3 = this.getRealCollectionAttributeValueFromObject(writeObjectQuery.getObject(), writeObjectQuery.getSession()))) {
            return;
        }
        this.prepareTranslationRow(writeObjectQuery.getTranslationRow(), writeObjectQuery.getObject(), writeObjectQuery.getSession());
        DatabaseRecord databaseRecord = new DatabaseRecord();
        for (int i = 0; i < this.getSourceRelationKeyFields().size(); ++i) {
            object2 = (DatabaseField)this.getSourceRelationKeyFields().elementAt(i);
            DatabaseField databaseField = (DatabaseField)this.getSourceKeyFields().elementAt(i);
            object = writeObjectQuery.getTranslationRow().get(databaseField);
            databaseRecord.put((DatabaseField)object2, object);
        }
        Object object4 = containerPolicy.iteratorFor(object3);
        while (containerPolicy.hasNext(object4)) {
            object2 = containerPolicy.next(object4, writeObjectQuery.getSession());
            for (int i = 0; i < this.getTargetRelationKeyFields().size(); ++i) {
                object = (DatabaseField)this.getTargetRelationKeyFields().elementAt(i);
                DatabaseField databaseField = (DatabaseField)this.getTargetKeyFields().elementAt(i);
                Object object5 = this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(object2, databaseField, writeObjectQuery.getSession());
                databaseRecord.put((DatabaseField)object, object5);
            }
            writeObjectQuery.getSession().executeQuery((DatabaseQuery)this.getInsertQuery(), databaseRecord);
            if (this.getHistoryPolicy() == null || !this.getHistoryPolicy().shouldHandleWrites()) continue;
            this.getHistoryPolicy().mappingLogicalInsert(this.getInsertQuery(), databaseRecord, writeObjectQuery.getSession());
        }
    }

    public void insertTargetObjects(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(writeObjectQuery)) {
            return;
        }
        if (writeObjectQuery.shouldCascadeOnlyDependentParts()) {
            return;
        }
        Object object = this.getRealCollectionAttributeValueFromObject(writeObjectQuery.getObject(), writeObjectQuery.getSession());
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (containerPolicy.isEmpty(object)) {
            return;
        }
        Object object2 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object2)) {
            Serializable serializable;
            Object object3 = containerPolicy.next(object2, writeObjectQuery.getSession());
            if (this.isPrivateOwned()) {
                serializable = new InsertObjectQuery();
                serializable.setIsExecutionClone(true);
                serializable.setObject(object3);
                serializable.setCascadePolicy(writeObjectQuery.getCascadePolicy());
                writeObjectQuery.getSession().executeQuery((DatabaseQuery)serializable);
                continue;
            }
            serializable = null;
            UnitOfWorkChangeSet unitOfWorkChangeSet = null;
            if (writeObjectQuery.getSession().isUnitOfWork() && ((UnitOfWork)writeObjectQuery.getSession()).getUnitOfWorkChangeSet() != null) {
                unitOfWorkChangeSet = (UnitOfWorkChangeSet)((UnitOfWork)writeObjectQuery.getSession()).getUnitOfWorkChangeSet();
                serializable = (ObjectChangeSet)unitOfWorkChangeSet.getObjectChangeSetForClone(object3);
            }
            WriteObjectQuery writeObjectQuery2 = new WriteObjectQuery();
            writeObjectQuery2.setIsExecutionClone(true);
            writeObjectQuery2.setObject(object3);
            writeObjectQuery2.setObjectChangeSet((ObjectChangeSet)serializable);
            writeObjectQuery2.setCascadePolicy(writeObjectQuery.getCascadePolicy());
            writeObjectQuery.getSession().executeQuery(writeObjectQuery2);
        }
    }

    public boolean isManyToManyMapping() {
        return true;
    }

    protected boolean isSingleSourceRelationKeySpecified() {
        return this.getSourceKeyFields().isEmpty();
    }

    protected boolean isSingleTargetRelationKeySpecified() {
        return this.getTargetKeyFields().isEmpty();
    }

    protected void objectAddedDuringUpdate(ObjectLevelModifyQuery objectLevelModifyQuery, Object object, ObjectChangeSet objectChangeSet) throws DatabaseException, OptimisticLockException {
        super.objectAddedDuringUpdate(objectLevelModifyQuery, object, objectChangeSet);
        if (objectLevelModifyQuery.shouldCascadeOnlyDependentParts()) {
            Object[] objectArray = new Object[]{ObjectAdded, objectLevelModifyQuery, object};
            objectLevelModifyQuery.getSession().getCommitManager().addDataModificationEvent(this, objectArray);
        } else {
            this.insertAddedObjectEntry(objectLevelModifyQuery, object);
        }
    }

    protected void objectRemovedDuringUpdate(ObjectLevelModifyQuery objectLevelModifyQuery, Object object) throws DatabaseException, OptimisticLockException {
        Object object2;
        DatabaseField databaseField;
        DatabaseField databaseField2;
        int n;
        DatabaseRecord databaseRecord = new DatabaseRecord();
        for (n = 0; n < this.getSourceRelationKeyFields().size(); ++n) {
            databaseField2 = (DatabaseField)this.getSourceRelationKeyFields().elementAt(n);
            databaseField = (DatabaseField)this.getSourceKeyFields().elementAt(n);
            object2 = objectLevelModifyQuery.getTranslationRow().get(databaseField);
            databaseRecord.put(databaseField2, object2);
        }
        for (n = 0; n < this.getTargetRelationKeyFields().size(); ++n) {
            databaseField2 = (DatabaseField)this.getTargetRelationKeyFields().elementAt(n);
            databaseField = (DatabaseField)this.getTargetKeyFields().elementAt(n);
            object2 = this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(object, databaseField, objectLevelModifyQuery.getSession());
            databaseRecord.put(databaseField2, object2);
        }
        if (objectLevelModifyQuery.shouldCascadeOnlyDependentParts()) {
            Object[] objectArray = new Object[]{ObjectRemoved, this.getDeleteQuery(), databaseRecord};
            objectLevelModifyQuery.getSession().getCommitManager().addDataModificationEvent(this, objectArray);
        } else {
            objectLevelModifyQuery.getSession().executeQuery((DatabaseQuery)this.getDeleteQuery(), databaseRecord);
            if (this.getHistoryPolicy() != null && this.getHistoryPolicy().shouldHandleWrites()) {
                this.getHistoryPolicy().mappingLogicalDelete(this.getDeleteQuery(), databaseRecord, objectLevelModifyQuery.getSession());
            }
        }
        super.objectRemovedDuringUpdate(objectLevelModifyQuery, object);
    }

    public void performDataModificationEvent(Object[] objectArray, Session session) throws DatabaseException, DescriptorException {
        if (objectArray[0] == PostInsert) {
            this.insertIntoRelationTable((WriteObjectQuery)objectArray[1]);
        } else if (objectArray[0] == ObjectRemoved) {
            session.executeQuery((DatabaseQuery)((DataModifyQuery)objectArray[1]), (DatabaseRow)objectArray[2]);
            if (this.getHistoryPolicy() != null && this.getHistoryPolicy().shouldHandleWrites()) {
                this.getHistoryPolicy().mappingLogicalDelete((DataModifyQuery)objectArray[1], (DatabaseRow)objectArray[2], session);
            }
        } else if (objectArray[0] == ObjectAdded) {
            this.insertAddedObjectEntry((WriteObjectQuery)objectArray[1], objectArray[2]);
        } else {
            throw DescriptorException.invalidDataModificationEventCode(objectArray[0], this);
        }
    }

    public void postInsert(WriteObjectQuery writeObjectQuery) throws DatabaseException {
        this.insertTargetObjects(writeObjectQuery);
        if (writeObjectQuery.shouldCascadeOnlyDependentParts()) {
            Object[] objectArray = new Object[]{PostInsert, writeObjectQuery};
            writeObjectQuery.getSession().getCommitManager().addDataModificationEvent(this, objectArray);
        } else {
            this.insertIntoRelationTable(writeObjectQuery);
        }
    }

    public void postUpdate(WriteObjectQuery writeObjectQuery) throws DatabaseException {
        if (this.isReadOnly()) {
            return;
        }
        if (!this.isAttributeValueInstantiatedOrChanged(writeObjectQuery.getObject())) {
            return;
        }
        Object object = this.getRealCollectionAttributeValueFromObject(writeObjectQuery.getObject(), writeObjectQuery.getSession());
        Object object2 = this.readPrivateOwnedForObject(writeObjectQuery);
        if (object2 == null) {
            object2 = this.getContainerPolicy().containerInstance(1);
        }
        this.compareObjectsAndWrite(object2, object, writeObjectQuery);
    }

    public void preDelete(DeleteObjectQuery deleteObjectQuery) throws DatabaseException {
        Object object = null;
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (this.isReadOnly()) {
            return;
        }
        Object object2 = this.getRealCollectionAttributeValueFromObject(deleteObjectQuery.getObject(), deleteObjectQuery.getSession());
        if (this.shouldObjectModifyCascadeToParts(deleteObjectQuery)) {
            object = containerPolicy.iteratorFor(object2);
        }
        this.prepareTranslationRow(deleteObjectQuery.getTranslationRow(), deleteObjectQuery.getObject(), deleteObjectQuery.getSession());
        deleteObjectQuery.getSession().executeQuery((DatabaseQuery)this.getDeleteAllQuery(), deleteObjectQuery.getTranslationRow());
        if (this.getHistoryPolicy() != null && this.getHistoryPolicy().shouldHandleWrites()) {
            this.getHistoryPolicy().mappingLogicalDelete(this.getDeleteAllQuery(), deleteObjectQuery.getTranslationRow(), deleteObjectQuery.getSession());
        }
        if (this.shouldObjectModifyCascadeToParts(deleteObjectQuery) && object2 != null) {
            while (containerPolicy.hasNext(object)) {
                DeleteObjectQuery deleteObjectQuery2 = new DeleteObjectQuery();
                deleteObjectQuery2.setIsExecutionClone(true);
                deleteObjectQuery2.setObject(containerPolicy.next(object, deleteObjectQuery.getSession()));
                deleteObjectQuery2.setCascadePolicy(deleteObjectQuery.getCascadePolicy());
                deleteObjectQuery.getSession().executeQuery(deleteObjectQuery2);
            }
        }
    }

    protected void prepareTranslationRow(DatabaseRow databaseRow, Object object, Session session) {
        Enumeration enumeration = this.getSourceKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
            if (databaseRow.containsKey(databaseField)) continue;
            Object object2 = this.getDescriptor().getObjectBuilder().extractValueFromObjectForField(object, databaseField, session);
            databaseRow.put(databaseField, object2);
        }
    }

    public void setCustomDeleteQuery(DataModifyQuery dataModifyQuery) {
        this.setDeleteQuery(dataModifyQuery);
        this.setHasCustomDeleteQuery(true);
    }

    public void setCustomInsertQuery(DataModifyQuery dataModifyQuery) {
        this.setInsertQuery(dataModifyQuery);
        this.setHasCustomInsertQuery(true);
    }

    protected void setDeleteQuery(DataModifyQuery dataModifyQuery) {
        this.deleteQuery = dataModifyQuery;
    }

    public void setDeleteSQLString(String string) {
        DataModifyQuery dataModifyQuery = new DataModifyQuery();
        dataModifyQuery.setSQLString(string);
        this.setCustomDeleteQuery(dataModifyQuery);
    }

    public void setDeleteCall(Call call) {
        DataModifyQuery dataModifyQuery = new DataModifyQuery();
        dataModifyQuery.setCall(call);
        this.setCustomDeleteQuery(dataModifyQuery);
    }

    protected void setHasCustomDeleteQuery(boolean bl) {
        this.hasCustomDeleteQuery = bl;
    }

    protected void setHasCustomInsertQuery(boolean bl) {
        this.hasCustomInsertQuery = bl;
    }

    protected void setInsertQuery(DataModifyQuery dataModifyQuery) {
        this.insertQuery = dataModifyQuery;
    }

    public void setInsertSQLString(String string) {
        DataModifyQuery dataModifyQuery = new DataModifyQuery();
        dataModifyQuery.setSQLString(string);
        this.setCustomInsertQuery(dataModifyQuery);
    }

    public void setInsertCall(Call call) {
        DataModifyQuery dataModifyQuery = new DataModifyQuery();
        dataModifyQuery.setCall(call);
        this.setCustomInsertQuery(dataModifyQuery);
    }

    public void setHistoryPolicy(HistoryPolicy historyPolicy) {
        this.historyPolicy = historyPolicy;
        if (historyPolicy != null) {
            historyPolicy.setMapping(this);
        }
    }

    public void setRelationTableName(String string) {
        this.relationTable = new DatabaseTable(string);
    }

    public void setSessionName(String string) {
        super.setSessionName(string);
        this.getInsertQuery().setSessionName(string);
        this.getDeleteQuery().setSessionName(string);
    }

    public void setSourceKeyFieldNames(Vector vector) {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((Vector)nonSynchronizedVector).addElement(new DatabaseField((String)enumeration.nextElement()));
        }
        this.setSourceKeyFields(nonSynchronizedVector);
    }

    public void setSourceKeyFields(Vector vector) {
        this.sourceKeyFields = vector;
    }

    public void setSourceRelationKeyFieldName(String string) {
        this.getSourceRelationKeyFields().addElement(new DatabaseField(string));
    }

    public void setSourceRelationKeyFieldNames(Vector vector) {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((Vector)nonSynchronizedVector).addElement(new DatabaseField((String)enumeration.nextElement()));
        }
        this.setSourceRelationKeyFields(nonSynchronizedVector);
    }

    public void setSourceRelationKeyFields(Vector vector) {
        this.sourceRelationKeyFields = vector;
    }

    public void setTargetKeyFieldNames(Vector vector) {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((Vector)nonSynchronizedVector).addElement(new DatabaseField((String)enumeration.nextElement()));
        }
        this.setTargetKeyFields(nonSynchronizedVector);
    }

    public void setTargetKeyFields(Vector vector) {
        this.targetKeyFields = vector;
    }

    public void setTargetRelationKeyFieldName(String string) {
        this.getTargetRelationKeyFields().addElement(new DatabaseField(string));
    }

    public void setTargetRelationKeyFieldNames(Vector vector) {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((Vector)nonSynchronizedVector).addElement(new DatabaseField((String)enumeration.nextElement()));
        }
        this.setTargetRelationKeyFields(nonSynchronizedVector);
    }

    public void setTargetRelationKeyFields(Vector vector) {
        this.targetRelationKeyFields = vector;
    }

    protected ReadQuery prepareHistoricalQuery(ReadQuery readQuery, ObjectLevelReadQuery objectLevelReadQuery, Session session) {
        if (this.getHistoryPolicy() != null) {
            if (readQuery == this.getSelectionQuery()) {
                readQuery = (ObjectLevelReadQuery)readQuery.clone();
                readQuery.setIsExecutionClone(true);
            }
            if (readQuery.getSelectionCriteria() == this.getSelectionQuery().getSelectionCriteria()) {
                readQuery.setSelectionCriteria((Expression)readQuery.getSelectionCriteria().clone());
            }
            if (objectLevelReadQuery.getSession().getAsOfClause() != null) {
                ((ObjectLevelReadQuery)readQuery).setAsOfClause(objectLevelReadQuery.getSession().getAsOfClause());
            } else if (((ObjectLevelReadQuery)readQuery).getAsOfClause() == null) {
                ((ObjectLevelReadQuery)readQuery).setAsOfClause(AsOfClause.NO_CLAUSE);
            }
            Expression expression = this.getHistoryPolicy().additionalHistoryExpression(readQuery.getSelectionCriteria().getBuilder());
            readQuery.setSelectionCriteria(readQuery.getSelectionCriteria().and(expression));
        }
        return readQuery;
    }
}

