/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.sessions;

import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.databaseaccess.Accessor;
import oracle.toplink.internal.sessions.IsolatedClientSession;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.Call;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.threetier.ConnectionPolicy;
import oracle.toplink.threetier.ServerSession;

public class ExclusiveIsolatedClientSession
extends IsolatedClientSession {
    public ExclusiveIsolatedClientSession(ServerSession serverSession, ConnectionPolicy connectionPolicy) {
        super(serverSession, connectionPolicy);
        this.accessor = null;
    }

    public void basicBeginTransaction() {
        if (this.getWriteConnection() != null && this.getLogin().shouldUseExternalConnectionPooling()) {
            this.getEventManager().preReleaseExclusiveConnection(this, this.getWriteConnection());
            this.getWriteConnection().decrementCallCount();
            this.getWriteConnection().incrementCallCount(this);
            this.getEventManager().postAcquireExclusiveConnection(this, this.getWriteConnection());
        }
        super.basicBeginTransaction();
    }

    public void basicCommitTransaction() {
        if (this.getWriteConnection() != null && this.getLogin().shouldUseExternalConnectionPooling()) {
            this.getEventManager().preReleaseExclusiveConnection(this, this.getWriteConnection());
            this.getWriteConnection().decrementCallCount();
            this.getWriteConnection().incrementCallCount(this);
            this.getEventManager().postAcquireExclusiveConnection(this, this.getWriteConnection());
        }
        super.basicCommitTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeCall(Call call, DatabaseRow databaseRow, DatabaseQuery databaseQuery) throws DatabaseException {
        if (databaseQuery.getAccessor() == null) {
            databaseQuery.setAccessor(this.getAccessor());
        }
        try {
            Object object = databaseQuery.getAccessor().executeCall(call, databaseRow, this);
            return object;
        }
        finally {
            if (call.isFinished()) {
                databaseQuery.setAccessor(null);
            }
        }
    }

    public Session getExecutionSession(DatabaseQuery databaseQuery) {
        Session session = super.getExecutionSession(databaseQuery);
        if (session != this) {
            return session;
        }
        if (!this.isActive()) {
            throw ValidationException.excusiveConnectionIsNoLongerAvailable(databaseQuery, this);
        }
        if (this.getAccessor() == null) {
            this.getParent().acquireClientConnection(this);
        }
        return this;
    }

    public Accessor getAccessor() {
        return this.accessor;
    }

    public Accessor getWriteConnection() {
        return this.accessor;
    }

    protected void releaseWriteConnection() {
    }

    public void setWriteConnection(Accessor accessor) {
        if (this.getLogin().shouldUseExternalConnectionPooling()) {
            if (accessor != null) {
                accessor.incrementCallCount(this);
            } else {
                this.accessor.decrementCallCount();
            }
        }
        this.accessor = accessor;
    }
}

