/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.remote;

import oracle.toplink.internal.remote.SimpleFunctionCall;
import oracle.toplink.publicinterface.Session;

public class SequencingFunctionCall {

    public static class GetNextValue
    extends SimpleFunctionCall {
        protected Class cls;

        public GetNextValue(Class clazz) {
            this.cls = clazz;
        }

        protected Object execute(Session session) {
            return session.getSequencing().getNextValue(this.cls);
        }
    }

    public static class ShouldOverrideExistingValue
    extends SimpleFunctionCall {
        protected Class cls;
        protected Object existingValue;

        public ShouldOverrideExistingValue(Class clazz, Object object) {
            this.cls = clazz;
            this.existingValue = object;
        }

        protected Object execute(Session session) {
            return new Boolean(session.getSequencing().shouldOverrideExistingValue(this.cls, this.existingValue));
        }
    }

    public static class ShouldAcquireValueAfterInsert
    extends SimpleFunctionCall {
        protected Class cls;

        public ShouldAcquireValueAfterInsert(Class clazz) {
            this.cls = clazz;
        }

        protected Object execute(Session session) {
            return new Boolean(session.getSequencing().shouldAcquireValueAfterInsert(this.cls));
        }
    }

    public static class WhenShouldAcquireValueForAll
    extends SimpleFunctionCall {
        protected Object execute(Session session) {
            return new Integer(session.getSequencing().whenShouldAcquireValueForAll());
        }
    }

    public static class DoesExist
    extends SimpleFunctionCall {
        protected Object execute(Session session) {
            return new Boolean(session.getSequencing() != null);
        }
    }
}

