/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.remote;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.server.ObjID;
import java.util.Vector;
import oracle.toplink.indirection.ValueHolderInterface;
import oracle.toplink.internal.indirection.DatabaseValueHolder;
import oracle.toplink.internal.indirection.UnitOfWorkValueHolder;
import oracle.toplink.internal.remote.RemoveServerSideRemoteValueHolderCommand;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.mappings.ObjectReferenceMapping;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.remote.DistributedSession;
import oracle.toplink.remote.RemoteSession;

public class RemoteValueHolder
extends DatabaseValueHolder
implements Externalizable {
    protected ObjID id = new ObjID();
    protected Vector targetObjectPrimaryKeys;
    protected transient DatabaseMapping mapping;
    protected transient ObjectLevelReadQuery query;
    protected transient ValueHolderInterface wrappedServerValueHolder;
    protected transient Object serverIndirectionObject;

    protected boolean canDoCacheCheck() {
        if (this.getMapping() == null || this.getQuery() == null) {
            return false;
        }
        return this.getTargetObjectPrimaryKeys() != null && !this.getTargetObjectPrimaryKeys().isEmpty() && this.getMapping().isOneToOneMapping() && !this.getQuery().shouldRefreshIdentityMapResult() && !this.getQuery().shouldRefreshRemoteIdentityMapResult() && this.getQuery().shouldMaintainCache();
    }

    public boolean equals(Object object) {
        if (!(object instanceof RemoteValueHolder)) {
            return false;
        }
        return this.getID().equals(((RemoteValueHolder)object).getID());
    }

    public void finalize() {
        if (this.session != null && this.session instanceof RemoteSession && ((RemoteSession)this.session).shouldEnableDistributedIndirectionGarbageCollection()) {
            RemoveServerSideRemoteValueHolderCommand removeServerSideRemoteValueHolderCommand = new RemoveServerSideRemoteValueHolderCommand(this.getID());
            ((DistributedSession)this.getSession()).getRemoteConnection().processCommand(removeServerSideRemoteValueHolderCommand);
        }
    }

    public ObjID getID() {
        return this.id;
    }

    public DatabaseMapping getMapping() {
        return this.mapping;
    }

    protected Object getObjectFromCache() {
        Object object = null;
        if (this.getMapping().isOneToOneMapping()) {
            Descriptor descriptor = ((ObjectReferenceMapping)this.getMapping()).getReferenceDescriptor();
            object = this.getSession().getIdentityMapAccessorInstance().getFromIdentityMap(this.getTargetObjectPrimaryKeys(), descriptor.getJavaClass(), descriptor);
        }
        return object;
    }

    public ObjectLevelReadQuery getQuery() {
        return this.query;
    }

    public Object getServerIndirectionObject() {
        return this.serverIndirectionObject;
    }

    protected Vector getTargetObjectPrimaryKeys() {
        return this.targetObjectPrimaryKeys;
    }

    public ValueHolderInterface getWrappedServerValueHolder() {
        return this.wrappedServerValueHolder;
    }

    public int hashCode() {
        return this.getID().hashCode();
    }

    public synchronized Object instantiate() {
        Object object = null;
        if (this.getWrappedServerValueHolder() != null) {
            object = this.getWrappedServerValueHolder().getValue();
        } else {
            if (this.canDoCacheCheck()) {
                object = this.getObjectFromCache();
            }
            if (object == null) {
                object = ((DistributedSession)this.getSession()).instantiateRemoteValueHolderOnServer(this);
            }
        }
        return object;
    }

    public boolean isEasilyInstantiated() {
        return this.isInstantiated() || this.getWrappedServerValueHolder() != null && this.getWrappedServerValueHolder() instanceof DatabaseValueHolder && ((DatabaseValueHolder)this.getWrappedServerValueHolder()).isEasilyInstantiated();
    }

    public boolean isPessimisticLockingValueHolder() {
        if (this.getWrappedServerValueHolder() != null) {
            return this.getWrappedServerValueHolder() instanceof DatabaseValueHolder && ((DatabaseValueHolder)this.getWrappedServerValueHolder()).isPessimisticLockingValueHolder();
        }
        return this.getQuery() != null && this.getQuery().isLockQuery(this.getSession());
    }

    public Object instantiateForUnitOfWorkValueHolder(UnitOfWorkValueHolder unitOfWorkValueHolder) {
        if (this.getWrappedServerValueHolder() != null && this.getWrappedServerValueHolder() instanceof DatabaseValueHolder) {
            DatabaseValueHolder databaseValueHolder = (DatabaseValueHolder)this.getWrappedServerValueHolder();
            return databaseValueHolder.instantiateForUnitOfWorkValueHolder(unitOfWorkValueHolder);
        }
        return unitOfWorkValueHolder.buildCloneFor(this.getValue());
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.id = (ObjID)objectInput.readObject();
        this.targetObjectPrimaryKeys = (Vector)objectInput.readObject();
        this.row = (DatabaseRow)objectInput.readObject();
        this.isInstantiated = objectInput.readBoolean();
    }

    protected void setID(ObjID objID) {
        this.id = objID;
    }

    public void setMapping(DatabaseMapping databaseMapping) {
        this.mapping = databaseMapping;
    }

    public void setQuery(ObjectLevelReadQuery objectLevelReadQuery) {
        this.query = objectLevelReadQuery;
    }

    public void setServerIndirectionObject(Object object) {
        this.serverIndirectionObject = object;
    }

    public void setTargetObjectPrimaryKeys(Vector vector) {
        this.targetObjectPrimaryKeys = vector;
    }

    public void setValue(Object object) {
        super.setValue(object);
        if (this.getWrappedServerValueHolder() != null) {
            this.getWrappedServerValueHolder().setValue(object);
        }
    }

    public void setWrappedServerValueHolder(ValueHolderInterface valueHolderInterface) {
        this.wrappedServerValueHolder = valueHolderInterface;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.id);
        objectOutput.writeObject(this.targetObjectPrimaryKeys);
        objectOutput.writeObject(this.row);
        objectOutput.writeBoolean(false);
    }
}

