/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.remote;

import java.rmi.server.ObjID;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.IdentityHashtable;
import oracle.toplink.internal.identitymaps.CacheKey;
import oracle.toplink.internal.queryframework.CollectionContainerPolicy;
import oracle.toplink.internal.queryframework.ContainerPolicy;
import oracle.toplink.internal.remote.ObjectDescriptor;
import oracle.toplink.internal.remote.RemoteCommand;
import oracle.toplink.internal.remote.RemoteCursoredStream;
import oracle.toplink.internal.remote.RemoteFunctionCall;
import oracle.toplink.internal.remote.RemoteScrollableCursor;
import oracle.toplink.internal.remote.RemoteUnitOfWork;
import oracle.toplink.internal.remote.RemoteValueHolder;
import oracle.toplink.internal.remote.ReplaceValueHoldersIterator;
import oracle.toplink.internal.remote.Transporter;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.CursorPolicy;
import oracle.toplink.queryframework.CursoredStream;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ScrollableCursor;
import oracle.toplink.remote.CacheSynchronizationManager;

public class RemoteSessionController {
    protected boolean isInTransaction;
    protected Session session;
    protected Hashtable remoteValueHolders;
    protected Hashtable remoteCursors;
    protected CacheSynchronizationManager cacheSynchronizationManager;

    public RemoteSessionController(Session session) {
        this.cacheSynchronizationManager = session.getCacheSynchronizationManager();
        this.initialize(session);
    }

    public Transporter processCommand(Transporter transporter) {
        Transporter transporter2 = new Transporter();
        try {
            ((RemoteCommand)transporter.getObject()).execute(this.getSession(), this);
        }
        catch (RuntimeException runtimeException) {
            transporter2.setException(runtimeException);
        }
        return transporter2;
    }

    public Transporter beginTransaction() {
        if (this.isInTransaction()) {
            this.getSession().getTransactionMutex().setActiveThread(Thread.currentThread());
        }
        Transporter transporter = new Transporter();
        try {
            this.getSession().beginTransaction();
            if (this.isInTransaction()) {
                this.getSession().getTransactionMutex().setActiveThread(Thread.currentThread());
            }
            if (this.getSession().isInTransaction()) {
                this.setIsInTransaction(true);
            }
        }
        catch (RuntimeException runtimeException) {
            transporter.setException(runtimeException);
        }
        return transporter;
    }

    protected ObjectDescriptor buildObjectDescriptor(Object object) {
        ObjectDescriptor objectDescriptor = new ObjectDescriptor();
        Descriptor descriptor = this.getSession().getDescriptor(object);
        Vector vector = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, this.getSession());
        objectDescriptor.setKey(vector);
        objectDescriptor.setWriteLockValue(this.getSession().getIdentityMapAccessorInstance().getWriteLockValue(vector, object.getClass(), descriptor));
        objectDescriptor.setObject(object);
        CacheKey cacheKey = this.getSession().getIdentityMapAccessorInstance().getCacheKeyForObject(vector, object.getClass(), descriptor);
        if (cacheKey != null) {
            objectDescriptor.setReadTime(cacheKey.getReadTime());
        }
        return objectDescriptor;
    }

    public Transporter closeScrollableCursor(ObjID objID) {
        Transporter transporter = new Transporter();
        try {
            ScrollableCursor scrollableCursor = (ScrollableCursor)this.getRemoteCursors().get(objID);
            if (scrollableCursor != null) {
                scrollableCursor.close();
            }
            this.getRemoteCursors().remove(objID);
        }
        catch (RuntimeException runtimeException) {
            transporter.setException(runtimeException);
        }
        return transporter;
    }

    public Transporter commitRootUnitOfWork(Transporter transporter) {
        if (this.isInTransaction()) {
            this.getSession().getTransactionMutex().setActiveThread(Thread.currentThread());
        }
        RemoteUnitOfWork remoteUnitOfWork = (RemoteUnitOfWork)transporter.getObject();
        remoteUnitOfWork.reinitializeForSession(this.getSession(), this);
        Transporter transporter2 = new Transporter();
        try {
            remoteUnitOfWork.commitRootUnitOfWork();
            transporter2.setObject(remoteUnitOfWork);
        }
        catch (RuntimeException runtimeException) {
            transporter2.setException(runtimeException);
        }
        return transporter2;
    }

    public Transporter commitTransaction() {
        Transporter transporter = new Transporter();
        try {
            this.getSession().commitTransaction();
            if (!this.getSession().isInTransaction()) {
                this.setIsInTransaction(false);
            }
        }
        catch (RuntimeException runtimeException) {
            transporter.setException(runtimeException);
        }
        return transporter;
    }

    public Transporter cursoredStreamClose(Transporter transporter) {
        Transporter transporter2 = new Transporter();
        try {
            CursoredStream cursoredStream = (CursoredStream)this.getRemoteCursors().get(transporter.getObject());
            if (cursoredStream != null) {
                cursoredStream.close();
            }
            this.getRemoteCursors().remove(transporter);
        }
        catch (RuntimeException runtimeException) {
            transporter2.setException(runtimeException);
        }
        return transporter2;
    }

    public Transporter cursoredStreamNextpage(Transporter transporter, int n) {
        Transporter transporter2 = new Transporter();
        Vector vector = null;
        IdentityHashtable identityHashtable = new IdentityHashtable(n);
        try {
            CursoredStream cursoredStream = (CursoredStream)this.getRemoteCursors().get(transporter.getObject());
            if (cursoredStream != null) {
                Object e;
                vector = cursoredStream.nextElements(n);
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements() && (e = enumeration.nextElement()) != null) {
                    if (!cursoredStream.getQuery().isReadAllQuery() || cursoredStream.getQuery().isReportQuery()) continue;
                    this.replaceValueHoldersIn(e, identityHashtable);
                }
            } else {
                vector = new Vector(0);
            }
        }
        catch (RuntimeException runtimeException) {
            transporter2.setException(runtimeException);
        }
        transporter2.setObjectDescriptors(identityHashtable);
        transporter2.setObject(vector);
        return transporter2;
    }

    public Transporter cursoredStreamSize(Transporter transporter) {
        Transporter transporter2 = new Transporter();
        try {
            CursoredStream cursoredStream = (CursoredStream)this.getRemoteCursors().get(transporter.getObject());
            if (cursoredStream != null) {
                transporter2.setObject(new Integer(cursoredStream.size()));
            } else {
                transporter2.setObject(new Integer(0));
            }
        }
        catch (RuntimeException runtimeException) {
            transporter2.setException(runtimeException);
        }
        return transporter2;
    }

    public Transporter cursorSelectObjects(Transporter transporter) {
        Transporter transporter2 = new Transporter();
        try {
            CursorPolicy cursorPolicy = (CursorPolicy)transporter.getObject();
            if (this.isInTransaction()) {
                cursorPolicy.getQuery().setAccessor(this.getSession().getAccessor());
            }
            if (cursorPolicy.isCursoredStreamPolicy()) {
                CursoredStream cursoredStream = (CursoredStream)this.getSession().executeQuery(cursorPolicy.getQuery());
                RemoteCursoredStream remoteCursoredStream = new RemoteCursoredStream(cursoredStream);
                remoteCursoredStream.setObjectCollection(cursoredStream.nextElements(cursoredStream.getObjectCollection().size()));
                this.getRemoteCursors().put(remoteCursoredStream.getID(), cursoredStream);
                if (cursoredStream.getQuery().isReadAllQuery() && !cursoredStream.getQuery().isReportQuery()) {
                    transporter2.setObjectDescriptors(this.replaceValueHoldersInAll(remoteCursoredStream.getObjectCollection(), new CollectionContainerPolicy(ClassConstants.Vector_class)));
                }
                transporter2.setObject(remoteCursoredStream);
            } else if (cursorPolicy.isScrollableCursorPolicy()) {
                ScrollableCursor scrollableCursor = (ScrollableCursor)this.getSession().executeQuery(cursorPolicy.getQuery());
                RemoteScrollableCursor remoteScrollableCursor = new RemoteScrollableCursor(scrollableCursor);
                this.getRemoteCursors().put(remoteScrollableCursor.getID(), scrollableCursor);
                transporter2.setObject(remoteScrollableCursor);
            }
        }
        catch (RuntimeException runtimeException) {
            transporter2.setException(runtimeException);
        }
        return transporter2;
    }

    public Transporter executeNamedQuery(Transporter transporter, Transporter transporter2, Transporter transporter3) {
        Transporter transporter4 = new Transporter();
        try {
            DatabaseQuery databaseQuery;
            Object object;
            if (transporter2.getObject() == null) {
                object = this.getSession().executeQuery((String)transporter.getObject(), (Vector)transporter3.getObject());
                databaseQuery = this.getSession().getQuery((String)transporter.getObject());
            } else {
                object = this.getSession().executeQuery((String)transporter.getObject(), (Class)transporter2.getObject(), (Vector)transporter3.getObject());
                databaseQuery = this.getSession().getDescriptor((Class)transporter2.getObject()).getQueryManager().getQuery((String)transporter.getObject());
            }
            transporter4.setQuery(databaseQuery);
            transporter4.setObjectDescriptors(databaseQuery.replaceValueHoldersIn(object, this));
            transporter4.setObject(object);
        }
        catch (RuntimeException runtimeException) {
            transporter4.setException(runtimeException);
        }
        return transporter4;
    }

    public Transporter executeQuery(Transporter transporter) {
        DatabaseQuery databaseQuery = (DatabaseQuery)transporter.getObject();
        Transporter transporter2 = new Transporter();
        try {
            DatabaseRow databaseRow = databaseQuery.getTranslationRow();
            databaseQuery.setTranslationRow(null);
            if (this.isInTransaction()) {
                databaseQuery.setAccessor(this.getSession().getAccessor());
            }
            Object object = databaseRow == null ? this.getSession().executeQuery(databaseQuery) : this.getSession().executeQuery(databaseQuery, databaseRow);
            transporter2.setObjectDescriptors(databaseQuery.replaceValueHoldersIn(object, this));
            transporter2.setObject(object);
        }
        catch (RuntimeException runtimeException) {
            transporter2.setException(runtimeException);
        }
        return transporter2;
    }

    public CacheSynchronizationManager getCacheSynchronizationManager() {
        return this.cacheSynchronizationManager;
    }

    public Transporter getDefaultReadOnlyClasses() {
        Transporter transporter = new Transporter();
        try {
            transporter.setObject(this.getSession().getDefaultReadOnlyClasses());
        }
        catch (RuntimeException runtimeException) {
            transporter.setException(runtimeException);
        }
        return transporter;
    }

    public Transporter getDescriptor(Transporter transporter) {
        Class clazz = (Class)transporter.getObject();
        Transporter transporter2 = new Transporter();
        try {
            Descriptor descriptor = this.getSession().getDescriptor(clazz);
            transporter2.setObject(descriptor);
        }
        catch (RuntimeException runtimeException) {
            transporter2.setException(runtimeException);
        }
        return transporter2;
    }

    public Transporter getLogin() {
        Transporter transporter = new Transporter();
        try {
            transporter.setObject(this.getSession().getDatasourceLogin());
        }
        catch (RuntimeException runtimeException) {
            transporter.setException(runtimeException);
        }
        return transporter;
    }

    protected Hashtable getRemoteCursors() {
        return this.remoteCursors;
    }

    public Hashtable getRemoteValueHolders() {
        return this.remoteValueHolders;
    }

    public Transporter getSequenceNumberNamed(Transporter transporter) {
        Transporter transporter2 = new Transporter();
        Object object = null;
        try {
            RemoteFunctionCall remoteFunctionCall = (RemoteFunctionCall)transporter.getObject();
            object = remoteFunctionCall.execute(this.session, this);
        }
        catch (RuntimeException runtimeException) {
            transporter2.setException(runtimeException);
        }
        transporter2.setObject(object);
        return transporter2;
    }

    public Session getSession() {
        return this.session;
    }

    protected void initialize(Session session) {
        this.setSession(session);
        this.setRemoteValueHolders(new Hashtable(3));
        this.setRemoteCursors(new Hashtable(3));
        this.setIsInTransaction(false);
    }

    public Transporter initializeIdentityMapsOnServerSession() {
        Transporter transporter = new Transporter();
        try {
            this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        }
        catch (RuntimeException runtimeException) {
            transporter.setException(runtimeException);
        }
        return transporter;
    }

    public Transporter instantiateRemoteValueHolderOnServer(Transporter transporter) {
        RemoteValueHolder remoteValueHolder = (RemoteValueHolder)transporter.getObject();
        RemoteValueHolder remoteValueHolder2 = (RemoteValueHolder)this.getRemoteValueHolders().get(remoteValueHolder.getID());
        Transporter transporter2 = new Transporter();
        try {
            Object object = remoteValueHolder2.getMapping().getValueFromRemoteValueHolder(remoteValueHolder2);
            transporter2.setObjectDescriptors(remoteValueHolder2.getMapping().replaceValueHoldersIn(object, this));
            if (object != null) {
                object.hashCode();
            }
            transporter2.setObject(object);
        }
        catch (RuntimeException runtimeException) {
            transporter2.setException(runtimeException);
        }
        return transporter2;
    }

    protected boolean isInTransaction() {
        return this.isInTransaction;
    }

    public IdentityHashtable replaceValueHoldersIn(Object object) {
        IdentityHashtable identityHashtable = new IdentityHashtable();
        this.replaceValueHoldersIn(object, identityHashtable);
        return identityHashtable;
    }

    public void replaceValueHoldersIn(Object object, IdentityHashtable identityHashtable) {
        if (object == null) {
            return;
        }
        ReplaceValueHoldersIterator replaceValueHoldersIterator = new ReplaceValueHoldersIterator(this);
        replaceValueHoldersIterator.setResult(identityHashtable);
        replaceValueHoldersIterator.setSession(this.getSession());
        replaceValueHoldersIterator.setShouldIterateOnIndirectionObjects(true);
        replaceValueHoldersIterator.setShouldIterateOverIndirectionObjects(false);
        replaceValueHoldersIterator.startIterationOn(object);
    }

    public IdentityHashtable replaceValueHoldersInAll(Object object, ContainerPolicy containerPolicy) {
        IdentityHashtable identityHashtable = new IdentityHashtable();
        Object object2 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object2)) {
            this.replaceValueHoldersIn(containerPolicy.next(object2, this.getSession()), identityHashtable);
        }
        return identityHashtable;
    }

    public Transporter rollbackTransaction() {
        Transporter transporter = new Transporter();
        try {
            this.getSession().rollbackTransaction();
            if (!this.getSession().isInTransaction()) {
                this.setIsInTransaction(false);
            }
        }
        catch (RuntimeException runtimeException) {
            transporter.setException(runtimeException);
        }
        return transporter;
    }

    public void saveRemoteValueHolder(RemoteValueHolder remoteValueHolder) {
        this.getRemoteValueHolders().put(remoteValueHolder.getID(), remoteValueHolder);
    }

    public Transporter scrollableCursorAbsolute(Transporter transporter, int n) {
        Transporter transporter2 = new Transporter();
        try {
            ScrollableCursor scrollableCursor = (ScrollableCursor)this.getRemoteCursors().get(transporter.getObject());
            if (scrollableCursor != null) {
                transporter2.setObject(new Boolean(scrollableCursor.absolute(n)));
            } else {
                transporter2.setObject(new Boolean(false));
            }
        }
        catch (RuntimeException runtimeException) {
            transporter2.setException(runtimeException);
        }
        return transporter2;
    }

    public Transporter scrollableCursorAfterLast(Transporter transporter) {
        Transporter transporter2 = new Transporter();
        try {
            ScrollableCursor scrollableCursor = (ScrollableCursor)this.getRemoteCursors().get(transporter.getObject());
            if (scrollableCursor != null) {
                scrollableCursor.afterLast();
            }
        }
        catch (RuntimeException runtimeException) {
            transporter2.setException(runtimeException);
        }
        return transporter2;
    }

    public Transporter scrollableCursorBeforeFirst(Transporter transporter) {
        Transporter transporter2 = new Transporter();
        try {
            ScrollableCursor scrollableCursor = (ScrollableCursor)this.getRemoteCursors().get(transporter.getObject());
            if (scrollableCursor != null) {
                scrollableCursor.beforeFirst();
            }
        }
        catch (RuntimeException runtimeException) {
            transporter2.setException(runtimeException);
        }
        return transporter2;
    }

    public Transporter scrollableCursorClose(Transporter transporter) {
        Transporter transporter2 = new Transporter();
        try {
            ScrollableCursor scrollableCursor = (ScrollableCursor)this.getRemoteCursors().get(transporter.getObject());
            if (scrollableCursor != null) {
                scrollableCursor.close();
            }
            this.getRemoteCursors().remove(transporter.getObject());
        }
        catch (RuntimeException runtimeException) {
            transporter2.setException(runtimeException);
        }
        return transporter2;
    }

    public Transporter scrollableCursorCurrentIndex(Transporter transporter) {
        Transporter transporter2 = new Transporter();
        try {
            ScrollableCursor scrollableCursor = (ScrollableCursor)this.getRemoteCursors().get(transporter.getObject());
            if (scrollableCursor != null) {
                transporter2.setObject(new Integer(scrollableCursor.currentIndex()));
            } else {
                transporter2.setObject(new Integer(0));
            }
        }
        catch (RuntimeException runtimeException) {
            transporter2.setException(runtimeException);
        }
        return transporter2;
    }

    public Transporter scrollableCursorFirst(Transporter transporter) {
        Transporter transporter2 = new Transporter();
        try {
            ScrollableCursor scrollableCursor = (ScrollableCursor)this.getRemoteCursors().get(transporter.getObject());
            if (scrollableCursor != null) {
                transporter2.setObject(new Boolean(scrollableCursor.first()));
            } else {
                transporter2.setObject(new Boolean(false));
            }
        }
        catch (RuntimeException runtimeException) {
            transporter2.setException(runtimeException);
        }
        return transporter2;
    }

    public Transporter scrollableCursorIsAfterLast(Transporter transporter) {
        Transporter transporter2 = new Transporter();
        try {
            ScrollableCursor scrollableCursor = (ScrollableCursor)this.getRemoteCursors().get(transporter.getObject());
            if (scrollableCursor != null) {
                transporter2.setObject(new Boolean(scrollableCursor.isAfterLast()));
            } else {
                transporter2.setObject(new Boolean(false));
            }
        }
        catch (RuntimeException runtimeException) {
            transporter2.setException(runtimeException);
        }
        return transporter2;
    }

    public Transporter scrollableCursorIsBeforeFirst(Transporter transporter) {
        Transporter transporter2 = new Transporter();
        try {
            ScrollableCursor scrollableCursor = (ScrollableCursor)this.getRemoteCursors().get(transporter.getObject());
            if (scrollableCursor != null) {
                transporter2.setObject(new Boolean(scrollableCursor.isBeforeFirst()));
            } else {
                transporter2.setObject(new Boolean(false));
            }
        }
        catch (RuntimeException runtimeException) {
            transporter2.setException(runtimeException);
        }
        return transporter2;
    }

    public Transporter scrollableCursorIsFirst(Transporter transporter) {
        Transporter transporter2 = new Transporter();
        try {
            ScrollableCursor scrollableCursor = (ScrollableCursor)this.getRemoteCursors().get(transporter.getObject());
            if (scrollableCursor != null) {
                transporter2.setObject(new Boolean(scrollableCursor.isFirst()));
            } else {
                transporter2.setObject(new Boolean(false));
            }
        }
        catch (RuntimeException runtimeException) {
            transporter2.setException(runtimeException);
        }
        return transporter2;
    }

    public Transporter scrollableCursorIsLast(Transporter transporter) {
        Transporter transporter2 = new Transporter();
        try {
            ScrollableCursor scrollableCursor = (ScrollableCursor)this.getRemoteCursors().get(transporter.getObject());
            if (scrollableCursor != null) {
                transporter2.setObject(new Boolean(scrollableCursor.isLast()));
            } else {
                transporter2.setObject(new Boolean(false));
            }
        }
        catch (RuntimeException runtimeException) {
            transporter2.setException(runtimeException);
        }
        return transporter2;
    }

    public Transporter scrollableCursorLast(Transporter transporter) {
        Transporter transporter2 = new Transporter();
        try {
            ScrollableCursor scrollableCursor = (ScrollableCursor)this.getRemoteCursors().get(transporter.getObject());
            if (scrollableCursor != null) {
                transporter2.setObject(new Boolean(scrollableCursor.last()));
            } else {
                transporter2.setObject(new Boolean(false));
            }
        }
        catch (RuntimeException runtimeException) {
            transporter2.setException(runtimeException);
        }
        return transporter2;
    }

    public Transporter scrollableCursorNextObject(Transporter transporter) {
        Transporter transporter2 = new Transporter();
        try {
            ScrollableCursor scrollableCursor = (ScrollableCursor)this.getRemoteCursors().get(transporter.getObject());
            if (scrollableCursor != null) {
                Object object = null;
                if (scrollableCursor.hasNext()) {
                    object = scrollableCursor.next();
                }
                if (object == null) {
                    transporter2.setObjectDescriptors(new IdentityHashtable());
                } else if (scrollableCursor.getQuery().isReadAllQuery() && !scrollableCursor.getQuery().isReportQuery()) {
                    transporter2.setObjectDescriptors(this.replaceValueHoldersIn(object));
                }
                transporter2.setObject(object);
            }
        }
        catch (RuntimeException runtimeException) {
            transporter2.setException(runtimeException);
        }
        return transporter2;
    }

    public Transporter scrollableCursorPreviousObject(Transporter transporter) {
        Transporter transporter2 = new Transporter();
        try {
            ScrollableCursor scrollableCursor = (ScrollableCursor)this.getRemoteCursors().get(transporter.getObject());
            if (scrollableCursor != null) {
                Object object = null;
                if (scrollableCursor.hasPrevious()) {
                    object = scrollableCursor.previous();
                }
                if (object == null) {
                    transporter2.setObjectDescriptors(new IdentityHashtable());
                } else if (scrollableCursor.getQuery().isReadAllQuery() && !scrollableCursor.getQuery().isReportQuery()) {
                    transporter2.setObjectDescriptors(this.replaceValueHoldersIn(object));
                }
                transporter2.setObject(object);
            }
        }
        catch (RuntimeException runtimeException) {
            transporter2.setException(runtimeException);
        }
        return transporter2;
    }

    public Transporter scrollableCursorRelative(Transporter transporter, int n) {
        Transporter transporter2 = new Transporter();
        try {
            ScrollableCursor scrollableCursor = (ScrollableCursor)this.getRemoteCursors().get(transporter.getObject());
            if (scrollableCursor != null) {
                transporter2.setObject(new Boolean(scrollableCursor.relative(n)));
            } else {
                transporter2.setObject(new Boolean(false));
            }
        }
        catch (RuntimeException runtimeException) {
            transporter2.setException(runtimeException);
        }
        return transporter2;
    }

    public Transporter scrollableCursorSize(Transporter transporter) {
        Transporter transporter2 = new Transporter();
        try {
            ScrollableCursor scrollableCursor = (ScrollableCursor)this.getRemoteCursors().get(transporter.getObject());
            if (scrollableCursor != null) {
                transporter2.setObject(new Integer(scrollableCursor.size()));
            } else {
                transporter2.setObject(new Integer(0));
            }
        }
        catch (RuntimeException runtimeException) {
            transporter2.setException(runtimeException);
        }
        return transporter2;
    }

    protected void setIsInTransaction(boolean bl) {
        this.isInTransaction = bl;
    }

    protected void setRemoteCursors(Hashtable hashtable) {
        this.remoteCursors = hashtable;
    }

    protected void setRemoteValueHolders(Hashtable hashtable) {
        this.remoteValueHolders = hashtable;
    }

    protected void setSession(Session session) {
        this.session = session;
    }
}

