/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.remote;

import java.util.Enumeration;
import oracle.toplink.internal.remote.RemoteCommand;
import oracle.toplink.internal.remote.RemoteConnection;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.remote.CacheSynchronizationManager;

public class ChangeSetPropagator
extends Thread {
    protected CacheSynchronizationManager cacheSynchronizationManager;
    protected RemoteCommand command;
    protected RemoteConnection connection;

    public ChangeSetPropagator(CacheSynchronizationManager cacheSynchronizationManager, RemoteCommand remoteCommand) {
        this.cacheSynchronizationManager = cacheSynchronizationManager;
        this.command = remoteCommand;
    }

    public ChangeSetPropagator(CacheSynchronizationManager cacheSynchronizationManager, RemoteCommand remoteCommand, RemoteConnection remoteConnection) {
        this.cacheSynchronizationManager = cacheSynchronizationManager;
        this.command = remoteCommand;
        this.connection = remoteConnection;
    }

    protected CacheSynchronizationManager getCacheSynchronizationManager() {
        return this.cacheSynchronizationManager;
    }

    protected RemoteCommand getRemoteCommand() {
        return this.command;
    }

    public void run() {
        Enumeration enumeration = this.getCacheSynchronizationManager().getRemoteConnections().elements();
        while (enumeration.hasMoreElements()) {
            RemoteConnection remoteConnection = (RemoteConnection)enumeration.nextElement();
            ChangeSetPropagator changeSetPropagator = new ChangeSetPropagator(this.getCacheSynchronizationManager(), this.command, remoteConnection){

                public void run() {
                    try {
                        this.connection.processCommand(this.getRemoteCommand());
                    }
                    catch (RuntimeException runtimeException) {
                        if (this.getCacheSynchronizationManager().shouldRemoveConnectionOnError()) {
                            this.getCacheSynchronizationManager().removeRemoteConnection(this.connection);
                        }
                        try {
                            this.getCacheSynchronizationManager().getSession().handleException(runtimeException);
                        }
                        catch (RuntimeException runtimeException2) {
                            ((Session)this.getCacheSynchronizationManager().getSession()).log(6, "propagation", "failed_to_propogate_to", this.connection.getServiceName(), runtimeException2);
                        }
                    }
                }
            };
            changeSetPropagator.start();
        }
    }

    protected void setCacheSynchronizationManager(CacheSynchronizationManager cacheSynchronizationManager) {
        this.cacheSynchronizationManager = cacheSynchronizationManager;
    }

    protected void setRemoteCommand(RemoteCommand remoteCommand) {
        this.command = remoteCommand;
    }
}

