/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.queryframework;

import oracle.toplink.exceptions.QueryException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.internal.helper.IdentityHashtable;
import oracle.toplink.internal.queryframework.ExpressionQueryMechanism;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.queryframework.QueryByExamplePolicy;

public class QueryByExampleMechanism
extends ExpressionQueryMechanism {
    protected boolean isParsed = false;
    protected Object exampleObject;
    protected QueryByExamplePolicy queryByExamplePolicy;

    public QueryByExampleMechanism(DatabaseQuery databaseQuery) {
        super(databaseQuery);
    }

    public QueryByExampleMechanism(DatabaseQuery databaseQuery, Expression expression) {
        super(databaseQuery, expression);
    }

    public void buildSelectionCriteria(Session session) {
        if (this.isParsed() || this.getExampleObject() == null) {
            return;
        }
        ObjectLevelReadQuery objectLevelReadQuery = (ObjectLevelReadQuery)this.getQuery();
        objectLevelReadQuery.checkDescriptor(session);
        QueryByExamplePolicy queryByExamplePolicy = this.getQueryByExamplePolicy();
        if (queryByExamplePolicy == null) {
            queryByExamplePolicy = new QueryByExamplePolicy();
        }
        if (objectLevelReadQuery.getReferenceClass().isInstance(this.getExampleObject())) {
            Expression expression = objectLevelReadQuery.getDescriptor().getObjectBuilder().buildExpressionFromExample(this.getExampleObject(), queryByExamplePolicy, objectLevelReadQuery.getExpressionBuilder(), new IdentityHashtable(), session);
            if (this.getSelectionCriteria() != null) {
                this.setSelectionCriteria(this.getSelectionCriteria().and(expression));
            } else {
                this.setSelectionCriteria(expression);
            }
        } else {
            throw QueryException.exampleAndReferenceObjectClassMismatch(this.getExampleObject().getClass(), objectLevelReadQuery.getReferenceClass(), objectLevelReadQuery);
        }
        this.setIsParsed(true);
    }

    public Object getExampleObject() {
        return this.exampleObject;
    }

    public QueryByExamplePolicy getQueryByExamplePolicy() {
        return this.queryByExamplePolicy;
    }

    public boolean isParsed() {
        return this.isParsed;
    }

    public boolean isQueryByExampleMechanism() {
        return true;
    }

    public void setExampleObject(Object object) {
        this.exampleObject = object;
    }

    public void setIsParsed(boolean bl) {
        this.isParsed = bl;
    }

    public void setQueryByExamplePolicy(QueryByExamplePolicy queryByExamplePolicy) {
        this.queryByExamplePolicy = queryByExamplePolicy;
    }
}

