/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.queryframework;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.internal.queryframework.CollectionContainerPolicy;
import oracle.toplink.internal.sessions.CollectionChangeRecord;
import oracle.toplink.internal.sessions.ObjectChangeSet;
import oracle.toplink.publicinterface.Session;

public class ListContainerPolicy
extends CollectionContainerPolicy {
    public ListContainerPolicy() {
    }

    public ListContainerPolicy(Class clazz) {
        super(clazz);
    }

    public ListContainerPolicy(String string) {
        super(string);
    }

    public boolean isValidContainer(Object object) {
        return object instanceof List;
    }

    public void addIntoWithOrder(Integer n, Object object, Object object2, Session session) {
        try {
            if (n > this.sizeFor(object2) - 1) {
                ((List)object2).add(object);
            } else {
                ((List)object2).set(n, object);
            }
        }
        catch (ClassCastException classCastException) {
            throw QueryException.cannotAddElement(object, object2, classCastException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw QueryException.cannotAddElement(object, object2, illegalArgumentException);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw QueryException.cannotAddElement(object, object2, unsupportedOperationException);
        }
    }

    public void addIntoWithOrder(Vector vector, Hashtable hashtable, Object object, Session session) {
        Object object2 = null;
        try {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Integer n = (Integer)enumeration.nextElement();
                object2 = hashtable.get(n);
                if (this.hasElementDescriptor()) {
                    object2 = this.getElementDescriptor().getObjectBuilder().wrapObject(object2, session);
                }
                if (n > this.sizeFor(object) - 1) {
                    ((List)object).add(object2);
                    continue;
                }
                ((List)object).set(n, object2);
            }
        }
        catch (ClassCastException classCastException) {
            throw QueryException.cannotAddElement(object2, object, classCastException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw QueryException.cannotAddElement(object2, object, illegalArgumentException);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw QueryException.cannotAddElement(object2, object, unsupportedOperationException);
        }
    }

    public boolean hasOrder() {
        return true;
    }

    public boolean isListPolicy() {
        return true;
    }

    public void recordAddToCollectionInChangeRecord(ObjectChangeSet objectChangeSet, CollectionChangeRecord collectionChangeRecord) {
        if (collectionChangeRecord.getRemoveObjectList().containsKey(objectChangeSet)) {
            collectionChangeRecord.getRemoveObjectList().remove(objectChangeSet);
        } else if (collectionChangeRecord.getAddObjectList().contains(objectChangeSet)) {
            collectionChangeRecord.getAddOverFlow().add(objectChangeSet);
        } else {
            collectionChangeRecord.getAddObjectList().put(objectChangeSet, objectChangeSet);
        }
    }

    public void recordRemoveFromCollectionInChangeRecord(ObjectChangeSet objectChangeSet, CollectionChangeRecord collectionChangeRecord) {
        if (collectionChangeRecord.getAddObjectList().containsKey(objectChangeSet)) {
            if (collectionChangeRecord.getAddOverFlow().contains(objectChangeSet)) {
                collectionChangeRecord.getAddOverFlow().remove(objectChangeSet);
            } else {
                collectionChangeRecord.getAddObjectList().remove(objectChangeSet);
            }
        } else {
            collectionChangeRecord.getRemoveObjectList().put(objectChangeSet, objectChangeSet);
        }
    }

    public void removeFromWithOrder(int n, Object object) {
        int n2;
        try {
            for (n2 = this.sizeFor(object) - 1; n2 >= n; --n2) {
                ((List)object).remove(n2);
            }
        }
        catch (ClassCastException classCastException) {
            throw QueryException.cannotRemoveFromContainer(new Integer(n2), object, this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw QueryException.cannotRemoveFromContainer(new Integer(n2), object, this);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw QueryException.cannotRemoveFromContainer(new Integer(n2), object, this);
        }
    }
}

