/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.queryframework;

import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.internal.databaseaccess.DatabaseCall;
import oracle.toplink.internal.expressions.SQLUpdateStatement;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.DatabaseTable;
import oracle.toplink.internal.helper.NonSynchronizedVector;
import oracle.toplink.internal.queryframework.ContainerPolicy;
import oracle.toplink.internal.queryframework.DatasourceCallQueryMechanism;
import oracle.toplink.internal.queryframework.StatementQueryMechanism;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.DataReadQuery;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.queryframework.ReadAllQuery;
import oracle.toplink.queryframework.ReadQuery;
import oracle.toplink.queryframework.SQLCall;
import oracle.toplink.queryframework.ScrollableCursorPolicy;
import oracle.toplink.queryframework.WriteObjectQuery;

public class CallQueryMechanism
extends DatasourceCallQueryMechanism {
    public CallQueryMechanism(DatabaseQuery databaseQuery) {
        super(databaseQuery);
    }

    public CallQueryMechanism(DatabaseQuery databaseQuery, DatabaseCall databaseCall) {
        super(databaseQuery, databaseCall);
        databaseCall.setIsFieldMatchingRequired(true);
    }

    public DatabaseCall getDatabaseCall() {
        return (DatabaseCall)this.call;
    }

    public void prepareCall() throws QueryException {
        DatabaseQuery databaseQuery = this.getQuery();
        Session session = databaseQuery.getExecutionSession();
        if (this.hasMultipleCalls()) {
            Enumeration enumeration = this.getCalls().elements();
            while (enumeration.hasMoreElements()) {
                DatabaseCall databaseCall = (DatabaseCall)enumeration.nextElement();
                if (!databaseQuery.shouldIgnoreBindAllParameters()) {
                    databaseCall.setUsesBinding(databaseQuery.shouldBindAllParameters());
                }
                if (!databaseQuery.shouldIgnoreCacheStatement()) {
                    databaseCall.setShouldCacheStatement(databaseQuery.shouldCacheStatement());
                }
                databaseCall.setQueryTimeout(databaseQuery.getQueryTimeout());
                if (databaseQuery.isReadQuery()) {
                    ReadQuery readQuery = (ReadQuery)databaseQuery;
                    databaseCall.setMaxRows(readQuery.getMaxRows());
                    if (readQuery.getFirstResult() != 0) {
                        databaseCall.setFirstResult(readQuery.getFirstResult());
                        databaseCall.setIsResultSetScrollable(true);
                        databaseCall.setResultSetType(1004);
                        databaseCall.setResultSetConcurrency(1007);
                    }
                    databaseCall.setResultSetFetchSize(readQuery.getFetchSize());
                }
                databaseCall.prepare(session);
            }
        } else if (this.getCall() != null) {
            DatabaseCall databaseCall = this.getDatabaseCall();
            if (!databaseQuery.shouldIgnoreBindAllParameters()) {
                databaseCall.setUsesBinding(databaseQuery.shouldBindAllParameters());
            }
            if (!databaseQuery.shouldIgnoreCacheStatement()) {
                databaseCall.setShouldCacheStatement(databaseQuery.shouldCacheStatement());
            }
            databaseCall.setQueryTimeout(databaseQuery.getQueryTimeout());
            if (databaseQuery.isReadQuery()) {
                ReadQuery readQuery = (ReadQuery)databaseQuery;
                databaseCall.setMaxRows(readQuery.getMaxRows());
                if (readQuery.getFirstResult() != 0) {
                    databaseCall.setFirstResult(readQuery.getFirstResult());
                    databaseCall.setIsResultSetScrollable(true);
                    databaseCall.setResultSetType(1004);
                    databaseCall.setResultSetConcurrency(1007);
                }
                databaseCall.setResultSetFetchSize(((ReadQuery)databaseQuery).getFetchSize());
            }
            databaseCall.prepare(session);
        }
    }

    public void prepareCursorSelectAllRows() throws QueryException {
        this.getCall().returnCursor();
        DatabaseQuery databaseQuery = this.getQuery();
        ContainerPolicy containerPolicy = databaseQuery.isReadAllQuery() ? ((ReadAllQuery)databaseQuery).getContainerPolicy() : ((DataReadQuery)databaseQuery).getContainerPolicy();
        if (containerPolicy.isScrollableCursorPolicy()) {
            ScrollableCursorPolicy scrollableCursorPolicy = (ScrollableCursorPolicy)containerPolicy;
            DatabaseCall databaseCall = this.getDatabaseCall();
            databaseCall.setIsResultSetScrollable(true);
            databaseCall.setResultSetType(scrollableCursorPolicy.getResultSetType());
            databaseCall.setResultSetConcurrency(scrollableCursorPolicy.getResultSetConcurrency());
            if (((ReadQuery)this.getQuery()).getFetchSize() == 0) {
                databaseCall.setResultSetFetchSize(scrollableCursorPolicy.getPageSize());
            }
        }
        this.prepareCall();
    }

    public void prepareDeleteAll() {
        if (this.hasMultipleCalls()) {
            Enumeration enumeration = this.getCalls().elements();
            while (enumeration.hasMoreElements()) {
                DatabaseCall databaseCall = (DatabaseCall)enumeration.nextElement();
                databaseCall.returnNothing();
                if (!this.getQuery().getDescriptor().usesOptimisticLocking()) continue;
                databaseCall.setHasOptimisticLock(true);
            }
        } else {
            this.getCall().returnNothing();
            if (this.getQuery().getDescriptor().usesOptimisticLocking()) {
                this.getDatabaseCall().setHasOptimisticLock(true);
            }
        }
        this.prepareCall();
    }

    public void prepareDeleteObject() {
        if (this.hasMultipleCalls()) {
            Enumeration enumeration = this.getCalls().elements();
            while (enumeration.hasMoreElements()) {
                DatabaseCall databaseCall = (DatabaseCall)enumeration.nextElement();
                databaseCall.returnNothing();
                if (!this.getQuery().getDescriptor().usesOptimisticLocking()) continue;
                databaseCall.setHasOptimisticLock(true);
            }
        } else {
            this.getCall().returnNothing();
            if (this.getQuery().getDescriptor().usesOptimisticLocking()) {
                this.getDatabaseCall().setHasOptimisticLock(true);
            }
        }
        this.prepareCall();
    }

    public void prepareDoesExist(DatabaseField databaseField) {
        this.getCall().returnOneRow();
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(1);
        ((Vector)nonSynchronizedVector).addElement(databaseField);
        this.getDatabaseCall().setFields(nonSynchronizedVector);
        this.prepareCall();
    }

    public void prepareExecuteSelect() {
        if (this.hasMultipleCalls()) {
            Enumeration enumeration = this.getCalls().elements();
            while (enumeration.hasMoreElements()) {
                DatabaseCall databaseCall = (DatabaseCall)enumeration.nextElement();
                databaseCall.returnManyRows();
                databaseCall.setIsFieldMatchingRequired(this.isCallQueryMechanism());
            }
        } else {
            DatabaseCall databaseCall = this.getDatabaseCall();
            databaseCall.returnManyRows();
            databaseCall.setIsFieldMatchingRequired(this.isCallQueryMechanism());
        }
        this.prepareCall();
    }

    public void prepareSelectAllRows() {
        if (this.hasMultipleCalls()) {
            Enumeration enumeration = this.getCalls().elements();
            while (enumeration.hasMoreElements()) {
                DatabaseCall databaseCall = (DatabaseCall)enumeration.nextElement();
                databaseCall.returnManyRows();
                if (!this.isCallQueryMechanism()) continue;
                databaseCall.setIsFieldMatchingRequired(true);
                databaseCall.setFields(((ObjectLevelReadQuery)this.getQuery()).getSelectionFields());
                ((ObjectLevelReadQuery)this.getQuery()).computeJoiningMappingIndexes(true);
            }
        } else {
            this.getCall().returnManyRows();
            if (this.isCallQueryMechanism()) {
                DatabaseCall databaseCall = this.getDatabaseCall();
                databaseCall.setIsFieldMatchingRequired(true);
                databaseCall.setFields(((ObjectLevelReadQuery)this.getQuery()).getSelectionFields());
                ((ObjectLevelReadQuery)this.getQuery()).computeJoiningMappingIndexes(true);
            }
        }
        this.prepareCall();
    }

    public void prepareSelectOneRow() {
        if (this.hasMultipleCalls()) {
            Enumeration enumeration = this.getCalls().elements();
            while (enumeration.hasMoreElements()) {
                DatabaseCall databaseCall = (DatabaseCall)enumeration.nextElement();
                databaseCall.returnOneRow();
                if (!this.isCallQueryMechanism()) continue;
                databaseCall.setIsFieldMatchingRequired(true);
                databaseCall.setFields(((ObjectLevelReadQuery)this.getQuery()).getSelectionFields());
                ((ObjectLevelReadQuery)this.getQuery()).computeJoiningMappingIndexes(true);
            }
        } else {
            this.getCall().returnOneRow();
            if (this.isCallQueryMechanism()) {
                DatabaseCall databaseCall = this.getDatabaseCall();
                databaseCall.setIsFieldMatchingRequired(true);
                databaseCall.setFields(((ObjectLevelReadQuery)this.getQuery()).getSelectionFields());
                ((ObjectLevelReadQuery)this.getQuery()).computeJoiningMappingIndexes(true);
            }
        }
        this.prepareCall();
    }

    public void prepareUpdateObject() {
        if (this.hasMultipleCalls()) {
            Enumeration enumeration = this.getCalls().elements();
            while (enumeration.hasMoreElements()) {
                DatabaseCall databaseCall = (DatabaseCall)enumeration.nextElement();
                databaseCall.returnNothing();
                if (!this.getQuery().getDescriptor().usesOptimisticLocking()) continue;
                databaseCall.setHasOptimisticLock(true);
            }
        } else if (this.getCall() != null) {
            this.getCall().returnNothing();
            if (this.getQuery().getDescriptor().usesOptimisticLocking()) {
                this.getDatabaseCall().setHasOptimisticLock(true);
            }
        }
        this.prepareCall();
    }

    public void setCallHasCustomSQLArguments() {
        if (this.hasMultipleCalls()) {
            Enumeration enumeration = this.getCalls().elements();
            while (enumeration.hasMoreElements()) {
                DatabaseCall databaseCall = (DatabaseCall)enumeration.nextElement();
                if (!databaseCall.isSQLCall()) continue;
                ((SQLCall)databaseCall).setHasCustomSQLArguments(true);
            }
        } else if (this.getCall().isSQLCall()) {
            ((SQLCall)this.getCall()).setHasCustomSQLArguments(true);
        }
    }

    protected void updateForeignKeyFieldAfterInsert(WriteObjectQuery writeObjectQuery) {
        Enumeration enumeration = this.getDescriptor().getTables().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseTable databaseTable = (DatabaseTable)enumeration.nextElement();
            SQLUpdateStatement sQLUpdateStatement = new SQLUpdateStatement();
            sQLUpdateStatement.setModifyRow(this.getDescriptor().getObjectBuilder().buildRowForUpdate(writeObjectQuery));
            sQLUpdateStatement.setTranslationRow(this.getTranslationRow());
            sQLUpdateStatement.setTable(databaseTable);
            sQLUpdateStatement.setWhereClause(this.getDescriptor().getObjectBuilder().buildPrimaryKeyExpression(databaseTable));
            StatementQueryMechanism statementQueryMechanism = new StatementQueryMechanism((DatabaseQuery)writeObjectQuery, sQLUpdateStatement);
            writeObjectQuery.setModifyRow(sQLUpdateStatement.getModifyRow());
            statementQueryMechanism.updateObject();
        }
    }
}

