/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.parsing;

import oracle.toplink.expressions.Expression;
import oracle.toplink.expressions.ExpressionBuilder;
import oracle.toplink.internal.parsing.BinaryOperatorNode;
import oracle.toplink.internal.parsing.GenerationContext;
import oracle.toplink.internal.parsing.Node;
import oracle.toplink.internal.parsing.VariableNode;

public class MemberOfNode
extends BinaryOperatorNode {
    private boolean notIndicated = false;
    private Expression leftExpression = null;

    public void makeNodeOneToMany(Node node) {
        Node node2 = node;
        while (true) {
            if (!node2.hasRight()) {
                ((VariableNode)node2).setIsOneToManyAttribute(true);
                return;
            }
            node2 = node2.getRight();
        }
    }

    public Expression generateExpression(GenerationContext generationContext) {
        if (this.getLeft().isVariableNode() && ((VariableNode)this.getLeft()).isAlias(generationContext)) {
            VariableNode variableNode = (VariableNode)this.getLeft();
            this.makeNodeOneToMany(this.getRight());
            return this.getRight().generateExpression(generationContext).equal(new ExpressionBuilder(variableNode.resolveClass(generationContext)));
        }
        if (this.getRight().isParameterNode()) {
            this.makeNodeOneToMany(this.getLeft());
        } else {
            this.makeNodeOneToMany(this.getRight());
        }
        if (this.notIndicated()) {
            Expression expression = null;
            generationContext.setMemberOfNode(this);
            this.setLeftExpression(this.getLeft().generateExpression(generationContext));
            expression = this.getRight().generateExpression(generationContext);
            generationContext.setMemberOfNode(null);
            this.setLeftExpression(null);
            return expression;
        }
        return this.getRight().generateExpression(generationContext).equal(this.getLeft().generateExpression(generationContext));
    }

    public void indicateNot() {
        this.notIndicated = true;
    }

    public boolean notIndicated() {
        return this.notIndicated;
    }

    public void setLeftExpression(Expression expression) {
        this.leftExpression = expression;
    }

    public Expression getLeftExpression() {
        return this.leftExpression;
    }
}

